/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.frameworks;

import com.intellij.facet.frameworks.LibrariesDownloadConnectionService;
import com.intellij.facet.frameworks.beans.Artifact;
import com.intellij.facet.frameworks.beans.ArtifactItem;
import com.intellij.facet.frameworks.beans.Artifacts;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.SerializationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibrariesDownloadAssistant {
    private static final Logger LOG = Logger.getInstance(LibrariesDownloadAssistant.class);

    private LibrariesDownloadAssistant() {
    }

    public static Artifact @NotNull [] getVersions(@NotNull String groupId, URL ... localUrls) {
        if (groupId == null) {
            LibrariesDownloadAssistant.$$$reportNull$$$0(0);
        }
        if (localUrls == null) {
            LibrariesDownloadAssistant.$$$reportNull$$$0(1);
        }
        Artifact[] versions = !ApplicationManager.getApplication().isUnitTestMode() ? LibrariesDownloadAssistant.getDownloadServiceVersions(groupId) : null;
        Artifact[] artifactArray = versions == null ? LibrariesDownloadAssistant.getVersions(localUrls) : versions;
        if (artifactArray == null) {
            LibrariesDownloadAssistant.$$$reportNull$$$0(2);
        }
        return artifactArray;
    }

    private static Artifact @Nullable [] getDownloadServiceVersions(@NotNull String id) {
        URL url;
        if (id == null) {
            LibrariesDownloadAssistant.$$$reportNull$$$0(3);
        }
        if ((url = LibrariesDownloadAssistant.createVersionsUrl(id)) == null) {
            return null;
        }
        Artifacts allArtifacts = LibrariesDownloadAssistant.deserialize(url);
        return allArtifacts == null ? null : allArtifacts.getArtifacts();
    }

    @Nullable
    private static URL createVersionsUrl(@NotNull String id) {
        String serviceUrl;
        if (id == null) {
            LibrariesDownloadAssistant.$$$reportNull$$$0(4);
        }
        if (StringUtil.isNotEmpty((String)(serviceUrl = LibrariesDownloadConnectionService.getInstance().getServiceUrl()))) {
            try {
                String url = serviceUrl + "/" + id + "/";
                HttpConfigurable.getInstance().prepareURL(url);
                return new URL(url);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Artifact @NotNull [] getVersions(URL ... urls) {
        if (urls == null) {
            LibrariesDownloadAssistant.$$$reportNull$$$0(5);
        }
        HashSet<Artifact> versions = new HashSet<Artifact>();
        for (URL url : urls) {
            Artifact[] vers;
            Artifacts allArtifacts = LibrariesDownloadAssistant.deserialize(url);
            if (allArtifacts == null || (vers = allArtifacts.getArtifacts()) == null) continue;
            versions.addAll(Arrays.asList(vers));
        }
        Artifact[] artifactArray = versions.toArray(Artifact.EMPTY_ARRAY);
        if (artifactArray == null) {
            LibrariesDownloadAssistant.$$$reportNull$$$0(6);
        }
        return artifactArray;
    }

    @Nullable
    private static Artifacts deserialize(@Nullable URL url) {
        Artifacts allArtifacts;
        block3: {
            if (url == null) {
                return null;
            }
            allArtifacts = null;
            try {
                allArtifacts = (Artifacts)XmlSerializer.deserialize((URL)url, Artifacts.class);
            }
            catch (SerializationException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) break block3;
                LOG.error((Throwable)e);
            }
        }
        return allArtifacts;
    }

    @Nullable
    public static Artifact findVersion(@NotNull String versionId, URL ... urls) {
        if (versionId == null) {
            LibrariesDownloadAssistant.$$$reportNull$$$0(7);
        }
        if (urls == null) {
            LibrariesDownloadAssistant.$$$reportNull$$$0(8);
        }
        return LibrariesDownloadAssistant.findVersion(LibrariesDownloadAssistant.getVersions(urls), versionId);
    }

    @Nullable
    private static Artifact findVersion(Artifact @Nullable [] versions, @NotNull String versionId) {
        if (versionId == null) {
            LibrariesDownloadAssistant.$$$reportNull$$$0(9);
        }
        return versions == null ? null : (Artifact)ContainerUtil.find((Object[])versions, springVersion -> versionId.equals(springVersion.getVersion()));
    }

    public static LibraryInfo @NotNull [] getLibraryInfos(@NotNull URL url, @NotNull String versionId) {
        Artifact version;
        if (url == null) {
            LibrariesDownloadAssistant.$$$reportNull$$$0(10);
        }
        if (versionId == null) {
            LibrariesDownloadAssistant.$$$reportNull$$$0(11);
        }
        LibraryInfo[] libraryInfoArray = (version = LibrariesDownloadAssistant.findVersion(LibrariesDownloadAssistant.getVersions(url), versionId)) != null ? LibrariesDownloadAssistant.getLibraryInfos(version) : LibraryInfo.EMPTY_ARRAY;
        if (libraryInfoArray == null) {
            LibrariesDownloadAssistant.$$$reportNull$$$0(12);
        }
        return libraryInfoArray;
    }

    public static LibraryInfo @NotNull [] getLibraryInfos(@Nullable Artifact version) {
        if (version == null) {
            if (LibraryInfo.EMPTY_ARRAY == null) {
                LibrariesDownloadAssistant.$$$reportNull$$$0(13);
            }
            return LibraryInfo.EMPTY_ARRAY;
        }
        List<LibraryInfo> infos = LibrariesDownloadAssistant.convert(version.getUrlPrefix(), version.getItems());
        LibraryInfo[] libraryInfoArray = infos.toArray(LibraryInfo.EMPTY_ARRAY);
        if (libraryInfoArray == null) {
            LibrariesDownloadAssistant.$$$reportNull$$$0(14);
        }
        return libraryInfoArray;
    }

    @NotNull
    private static List<LibraryInfo> convert(String urlPrefix, ArtifactItem @NotNull [] jars) {
        if (jars == null) {
            LibrariesDownloadAssistant.$$$reportNull$$$0(15);
        }
        List list = ContainerUtil.mapNotNull((Object[])jars, artifactItem -> {
            String downloadUrl = artifactItem.getUrl();
            if (urlPrefix != null) {
                if (downloadUrl == null) {
                    downloadUrl = artifactItem.getName();
                }
                if (!downloadUrl.startsWith("http://")) {
                    downloadUrl = urlPrefix + downloadUrl;
                }
            }
            return new LibraryInfo(artifactItem.getName(), downloadUrl, downloadUrl, artifactItem.getMD5(), artifactItem.getRequiredClasses());
        });
        if (list == null) {
            LibrariesDownloadAssistant.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localUrls";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/frameworks/LibrariesDownloadAssistant";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/frameworks/LibrariesDownloadAssistant";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersions";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryInfos";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVersions";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDownloadServiceVersions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createVersionsUrl";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findVersion";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryInfos";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

