/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public final class TargetedCommandLine {
    @NotNull
    private final TargetValue<String> myExePath;
    @NotNull
    private final TargetValue<String> myWorkingDirectory;
    @NotNull
    private final TargetValue<String> myInputFilePath;
    @NotNull
    private final Charset myCharset;
    @NotNull
    private final List<TargetValue<String>> myParameters;
    @NotNull
    private final Map<String, TargetValue<String>> myEnvironment;

    public TargetedCommandLine(@NotNull TargetValue<String> exePath, @NotNull TargetValue<String> workingDirectory, @NotNull TargetValue<String> inputFilePath, @NotNull Charset charset, @NotNull List<TargetValue<String>> parameters, @NotNull Map<String, TargetValue<String>> environment) {
        if (exePath == null) {
            TargetedCommandLine.$$$reportNull$$$0(0);
        }
        if (workingDirectory == null) {
            TargetedCommandLine.$$$reportNull$$$0(1);
        }
        if (inputFilePath == null) {
            TargetedCommandLine.$$$reportNull$$$0(2);
        }
        if (charset == null) {
            TargetedCommandLine.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            TargetedCommandLine.$$$reportNull$$$0(4);
        }
        if (environment == null) {
            TargetedCommandLine.$$$reportNull$$$0(5);
        }
        this.myExePath = exePath;
        this.myWorkingDirectory = workingDirectory;
        this.myInputFilePath = inputFilePath;
        this.myCharset = charset;
        this.myParameters = parameters;
        this.myEnvironment = environment;
    }

    public String getCommandPresentation(@NotNull TargetEnvironment target) throws ExecutionException {
        String exePath;
        if (target == null) {
            TargetedCommandLine.$$$reportNull$$$0(6);
        }
        if ((exePath = TargetedCommandLine.resolvePromise(this.myExePath.getTargetValue(), "exe path")) == null) {
            throw new ExecutionException("Resolved value for exe path is null");
        }
        ArrayList<String> parameters = new ArrayList<String>();
        for (TargetValue<String> parameter : this.myParameters) {
            parameters.add(TargetedCommandLine.resolvePromise(parameter.getTargetValue(), "parameter"));
        }
        return StringUtil.join((Collection)CommandLineUtil.toCommandLine((String)ParametersListUtil.escape((CharSequence)exePath), parameters, (Platform)target.getRemotePlatform().getPlatform()), (String)" ");
    }

    public List<String> collectCommandsSynchronously() throws ExecutionException {
        String command = TargetedCommandLine.resolvePromise(this.myExePath.getTargetValue(), "exe path");
        if (command == null) {
            throw new ExecutionException("Resolved value for exe path is null");
        }
        ArrayList<String> commandLine = new ArrayList<String>(this.myParameters.size() + 1);
        commandLine.add(command);
        for (TargetValue<String> parameter : this.myParameters) {
            commandLine.add(TargetedCommandLine.resolvePromise(parameter.getTargetValue(), "parameter"));
        }
        return commandLine;
    }

    @Nullable
    public String getWorkingDirectory() throws ExecutionException {
        return TargetedCommandLine.resolvePromise(this.myWorkingDirectory.getTargetValue(), "working directory");
    }

    @Nullable
    public String getInputFilePath() throws ExecutionException {
        return TargetedCommandLine.resolvePromise(this.myInputFilePath.getTargetValue(), "input file path");
    }

    @NotNull
    public Map<String, String> getEnvironmentVariables() throws ExecutionException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, TargetValue<String>> e : this.myEnvironment.entrySet()) {
            result.put(e.getKey(), TargetedCommandLine.resolvePromise(e.getValue().getTargetValue(), "environment variable " + e.getKey()));
        }
        LinkedHashMap<String, String> linkedHashMap = result;
        if (linkedHashMap == null) {
            TargetedCommandLine.$$$reportNull$$$0(7);
        }
        return linkedHashMap;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myCharset;
        if (charset == null) {
            TargetedCommandLine.$$$reportNull$$$0(8);
        }
        return charset;
    }

    @Nullable
    private static String resolvePromise(@NotNull Promise<String> promise2, @NotNull String debugName) throws ExecutionException {
        if (promise2 == null) {
            TargetedCommandLine.$$$reportNull$$$0(9);
        }
        if (debugName == null) {
            TargetedCommandLine.$$$reportNull$$$0(10);
        }
        try {
            return promise2.blockingGet(0);
        }
        catch (java.util.concurrent.ExecutionException | TimeoutException e) {
            throw new ExecutionException("Couldn't resolve promise for " + debugName, (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputFilePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/target/TargetedCommandLine";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/target/TargetedCommandLine";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironmentVariables";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCommandPresentation";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolvePromise";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

