/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.IconManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.ColorIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightDisplayLevel {
    private static final Map<HighlightSeverity, HighlightDisplayLevel> ourMap = new HashMap<HighlightSeverity, HighlightDisplayLevel>();
    public static final HighlightDisplayLevel GENERIC_SERVER_ERROR_OR_WARNING = new HighlightDisplayLevel(HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING, HighlightDisplayLevel.createIconByKey(CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING));
    public static final HighlightDisplayLevel ERROR = new HighlightDisplayLevel(HighlightSeverity.ERROR, HighlightDisplayLevel.createErrorIcon());
    public static final HighlightDisplayLevel WARNING = new HighlightDisplayLevel(HighlightSeverity.WARNING, HighlightDisplayLevel.createIconByKey(CodeInsightColors.WARNINGS_ATTRIBUTES));
    private static final TextAttributesKey DO_NOT_SHOW_KEY = TextAttributesKey.createTextAttributesKey("DO_NOT_SHOW");
    public static final HighlightDisplayLevel DO_NOT_SHOW = new HighlightDisplayLevel(HighlightSeverity.INFORMATION, HighlightDisplayLevel.createIconByMask((Color)JBColor.gray));
    @Deprecated
    public static final HighlightDisplayLevel INFO = new HighlightDisplayLevel(HighlightSeverity.INFO, HighlightDisplayLevel.createIconByKey(DO_NOT_SHOW_KEY));
    public static final HighlightDisplayLevel WEAK_WARNING = new HighlightDisplayLevel(HighlightSeverity.WEAK_WARNING, HighlightDisplayLevel.createIconByKey(CodeInsightColors.WEAK_WARNING_ATTRIBUTES));
    public static final HighlightDisplayLevel NON_SWITCHABLE_ERROR = new HighlightDisplayLevel(HighlightSeverity.ERROR){

        @Override
        public boolean isNonSwitchable() {
            return true;
        }
    };
    public static final HighlightDisplayLevel NON_SWITCHABLE_WARNING = new HighlightDisplayLevel(HighlightSeverity.WARNING){

        @Override
        public boolean isNonSwitchable() {
            return true;
        }
    };
    private Icon myIcon;
    private final HighlightSeverity mySeverity;

    @NotNull
    private static Icon createErrorIcon() {
        return new SingleColorIcon(CodeInsightColors.ERRORS_ATTRIBUTES){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                IconManager.getInstance().colorize((Graphics2D)g, AllIcons.General.InspectionsError, this.getColor()).paintIcon(c, g, x, y);
            }
        };
    }

    @Nullable
    public static HighlightDisplayLevel find(String name) {
        for (Map.Entry<HighlightSeverity, HighlightDisplayLevel> entry : ourMap.entrySet()) {
            HighlightSeverity severity = entry.getKey();
            HighlightDisplayLevel displayLevel = entry.getValue();
            if (!Comparing.strEqual((String)severity.getName(), (String)name)) continue;
            return displayLevel;
        }
        return null;
    }

    public static HighlightDisplayLevel find(HighlightSeverity severity) {
        return ourMap.get(severity);
    }

    public HighlightDisplayLevel(@NotNull HighlightSeverity severity, @NotNull Icon icon) {
        if (severity == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(0);
        }
        if (icon == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(1);
        }
        this(severity);
        this.myIcon = icon;
        ourMap.put(this.mySeverity, this);
    }

    public HighlightDisplayLevel(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(2);
        }
        this.mySeverity = severity;
    }

    public String toString() {
        return this.mySeverity.toString();
    }

    @NotNull
    public String getName() {
        String string = this.mySeverity.getName();
        if (string == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(3);
        }
        return string;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = this.mySeverity;
        if (highlightSeverity == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(4);
        }
        return highlightSeverity;
    }

    public boolean isNonSwitchable() {
        return false;
    }

    public static void registerSeverity(@NotNull HighlightSeverity severity, @NotNull TextAttributesKey key, @Nullable Icon icon) {
        if (severity == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(5);
        }
        if (key == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(6);
        }
        Icon severityIcon = icon != null ? icon : HighlightDisplayLevel.createIconByKey(key);
        HighlightDisplayLevel level = ourMap.get(severity);
        if (level == null) {
            new HighlightDisplayLevel(severity, severityIcon);
        } else {
            level.myIcon = severityIcon;
        }
    }

    public static int getEmptyIconDim() {
        return JBUIScale.scale((int)14);
    }

    public static Icon createIconByKey(@NotNull TextAttributesKey key) {
        if (key == null) {
            HighlightDisplayLevel.$$$reportNull$$$0(7);
        }
        return new SingleColorIcon(key);
    }

    @NotNull
    public static Icon createIconByMask(Color renderColor) {
        return new MyColorIcon(HighlightDisplayLevel.getEmptyIconDim(), renderColor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeHighlighting/HighlightDisplayLevel";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeHighlighting/HighlightDisplayLevel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerSeverity";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createIconByKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SingleColorIcon
    implements Icon,
    ColoredIcon {
        private final TextAttributesKey myKey;

        private SingleColorIcon(@NotNull TextAttributesKey key) {
            if (key == null) {
                SingleColorIcon.$$$reportNull$$$0(0);
            }
            this.myKey = key;
        }

        @Override
        @NotNull
        public Color getColor() {
            Color color = (Color)ObjectUtils.notNull((Object)this.getColorInner(), (Object)JBColor.GRAY);
            if (color == null) {
                SingleColorIcon.$$$reportNull$$$0(1);
            }
            return color;
        }

        @Nullable
        private Color getColorInner() {
            EditorColorsManager manager = EditorColorsManager.getInstance();
            if (manager != null) {
                Color stripe;
                TextAttributes attributes = manager.getGlobalScheme().getAttributes(this.myKey);
                Color color = stripe = attributes == null ? null : attributes.getErrorStripeColor();
                if (stripe != null) {
                    return stripe;
                }
                if (attributes != null) {
                    Color effectColor = attributes.getEffectColor();
                    if (effectColor != null) {
                        return effectColor;
                    }
                    Color foregroundColor = attributes.getForegroundColor();
                    if (foregroundColor != null) {
                        return foregroundColor;
                    }
                    return attributes.getBackgroundColor();
                }
                return null;
            }
            TextAttributes defaultAttributes = this.myKey.getDefaultAttributes();
            if (defaultAttributes == null) {
                defaultAttributes = TextAttributes.ERASE_MARKER;
            }
            return defaultAttributes.getErrorStripeColor();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.getColor());
            int shift = JBUIScale.scale((int)2);
            int size = JBUIScale.scale((int)10);
            g.fillRect(x + shift, y + shift, size, size);
        }

        @Override
        public int getIconWidth() {
            return HighlightDisplayLevel.getEmptyIconDim();
        }

        @Override
        public int getIconHeight() {
            return HighlightDisplayLevel.getEmptyIconDim();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeHighlighting/HighlightDisplayLevel$SingleColorIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeHighlighting/HighlightDisplayLevel$SingleColorIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ColoredIcon {
        public Color getColor();
    }

    private static class MyColorIcon
    extends ColorIcon
    implements ColoredIcon {
        MyColorIcon(int size, @NotNull Color color) {
            if (color == null) {
                MyColorIcon.$$$reportNull$$$0(0);
            }
            super(size, color);
        }

        @Override
        public Color getColor() {
            return this.getIconColor();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/codeHighlighting/HighlightDisplayLevel$MyColorIcon", "<init>"));
        }
    }
}

