/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.editor;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AlwaysVisibleActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.messages.MessageBusConnection;
import icons.PythonJupyterIcons;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterRunAllAction;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterShowQuickListAction;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterCellUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterInterruptKernelAction;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterKernelManagementAction;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterRestartKernelAction;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterServerChooserAction;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterTextEditorWithPreview$$special$;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterPreviewFileEditor;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterSettingsChangeListener;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterSettingsChangeListenerKt;
import org.jetbrains.plugins.notebooks.jupyter.settings.JupyterSettings;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0001 B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0014J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0012H\u0016J\u0006\u0010\u001b\u001a\u00020\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0002J\u000e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterTextEditorWithPreview;", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview;", "Lcom/intellij/openapi/fileEditor/TextEditor;", "sourceEditor", "previewFileEditor", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/preview/JupyterPreviewFileEditor;", "editorName", "", "(Lcom/intellij/openapi/fileEditor/TextEditor;Lorg/jetbrains/plugins/notebooks/jupyter/editor/preview/JupyterPreviewFileEditor;Ljava/lang/String;)V", "kernelComboBoxAction", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterKernelManagementAction;", "canNavigateTo", "", "navigatable", "Lcom/intellij/pom/Navigatable;", "clearJupyterData", "", "originalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "createLeftToolbarActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "createRightToolbarActionGroup", "createScrollingSyncActionGroup", "dispose", "getEditor", "Lcom/intellij/openapi/editor/Editor;", "getFile", "getSourceEditor", "navigateTo", "settingsChanged", "showErrorBalloonForKernelComboBoxAction", "text", "JupyterKernelActionGroup", "intellij.python.jupyter"})
public final class JupyterTextEditorWithPreview
extends TextEditorWithPreview
implements TextEditor {
    private final JupyterKernelManagementAction kernelComboBoxAction;
    private final TextEditor sourceEditor;

    public final void showErrorBalloonForKernelComboBoxAction(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.kernelComboBoxAction.showWarning(text);
    }

    @Nullable
    protected ActionGroup createLeftToolbarActionGroup() {
        AnAction anAction = ActionManager.getInstance().getAction("JupyterFileActions");
        if (anAction == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        }
        AnAction[] anActionArray = ((ActionGroup)anAction).getChildren(null);
        Intrinsics.checkExpressionValueIsNotNull((Object)anActionArray, (String)"(ActionManager.getInstan\u2026nGroup).getChildren(null)");
        AnAction[] jupyterFileActions = anActionArray;
        SpreadBuilder spreadBuilder = new SpreadBuilder(7);
        spreadBuilder.add((Object)((AnAction)new JupyterServerChooserAction()));
        spreadBuilder.add((Object)((AnAction)this.kernelComboBoxAction));
        spreadBuilder.add((Object)new JupyterRunAllAction());
        spreadBuilder.add((Object)((AnAction)new JupyterKernelActionGroup()));
        spreadBuilder.add((Object)((AnAction)Separator.create()));
        spreadBuilder.add((Object)((AnAction)new JupyterShowQuickListAction()));
        spreadBuilder.addSpread((Object)jupyterFileActions);
        return (ActionGroup)new DefaultActionGroup((AnAction[])spreadBuilder.toArray((Object[])new AnAction[spreadBuilder.size()]));
    }

    private final ActionGroup createScrollingSyncActionGroup() {
        return (ActionGroup)new DefaultActionGroup(new AnAction[]{(AnAction)new ToggleAction(this, null, "Autoscroll from Source", AllIcons.General.AutoscrollFromSource){
            final /* synthetic */ JupyterTextEditorWithPreview this$0;

            public boolean isSelected(@NotNull AnActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                return JupyterSettings.Companion.getInstance().getAutoscrollFromSource();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                JupyterSettings.Companion.getInstance().setAutoscrollFromSource(state);
                JupyterTextEditorWithPreview.access$settingsChanged(this.this$0);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        }, (AnAction)new ToggleAction(this, null, "Autoscroll to Source", AllIcons.General.AutoscrollToSource){
            final /* synthetic */ JupyterTextEditorWithPreview this$0;

            public boolean isSelected(@NotNull AnActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                return JupyterSettings.Companion.getInstance().getAutoscrollToSource();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                JupyterSettings.Companion.getInstance().setAutoscrollToSource(state);
                JupyterTextEditorWithPreview.access$settingsChanged(this.this$0);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        }, (AnAction)new ToggleAction(this, null, "Show Sources in Preview", AllIcons.Actions.ShowCode){
            final /* synthetic */ JupyterTextEditorWithPreview this$0;

            public boolean isSelected(@NotNull AnActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                return JupyterSettings.Companion.getInstance().getShowSourcesInPreview();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                JupyterSettings.Companion.getInstance().setShowSourcesInPreview(state);
                JupyterTextEditorWithPreview.access$settingsChanged(this.this$0);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        }});
    }

    @Nullable
    protected ActionGroup createRightToolbarActionGroup() {
        return this.createScrollingSyncActionGroup();
    }

    private final void settingsChanged() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        ((JupyterSettingsChangeListener)application.getMessageBus().syncPublisher(JupyterSettingsChangeListenerKt.getJUPYTER_SETTINGS_TOPIC())).settingsChanged(JupyterSettings.Companion.getInstance());
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        Intrinsics.checkParameterIsNotNull((Object)navigatable, (String)"navigatable");
        return this.sourceEditor.canNavigateTo(navigatable);
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        Intrinsics.checkParameterIsNotNull((Object)navigatable, (String)"navigatable");
        this.sourceEditor.navigateTo(navigatable);
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.sourceEditor.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"sourceEditor.editor");
        return editor;
    }

    @Nullable
    public VirtualFile getFile() {
        return this.sourceEditor.getFile();
    }

    @NotNull
    public final TextEditor getSourceEditor() {
        return this.sourceEditor;
    }

    private final void clearJupyterData(VirtualFile originalFile) {
        if (originalFile.getUserData(JupyterCellUtilKt.getJUPYTER_EDITOR_KEY()) != null) {
            originalFile.putUserData(JupyterCellUtilKt.getJUPYTER_EDITOR_KEY(), null);
            originalFile.putUserData(JupyterCellUtilKt.getJUPYTER_VIRTUAL_FILE_KEY(), null);
        }
    }

    public void dispose() {
        VirtualFile virtualFile2 = this.sourceEditor.getFile();
        if (virtualFile2 instanceof JupyterVirtualFile) {
            this.clearJupyterData(((JupyterVirtualFile)virtualFile2).getOriginalFile());
        }
        super.dispose();
    }

    public JupyterTextEditorWithPreview(@NotNull TextEditor sourceEditor, @NotNull JupyterPreviewFileEditor previewFileEditor, @NotNull String editorName) {
        Intrinsics.checkParameterIsNotNull((Object)sourceEditor, (String)"sourceEditor");
        Intrinsics.checkParameterIsNotNull((Object)previewFileEditor, (String)"previewFileEditor");
        Intrinsics.checkParameterIsNotNull((Object)editorName, (String)"editorName");
        super(sourceEditor, (FileEditor)previewFileEditor, editorName);
        this.sourceEditor = sourceEditor;
        this.kernelComboBoxAction = new JupyterKernelManagementAction();
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        MessageBusConnection messageBusConnection = application.getMessageBus().connect((Disposable)this);
        boolean bl = false;
        boolean bl2 = false;
        MessageBusConnection $this$apply = messageBusConnection;
        boolean bl3 = false;
        $this$apply.subscribe(JupyterSettingsChangeListenerKt.getJUPYTER_SETTINGS_TOPIC(), (Object)new JupyterSettingsChangeListener(this){
            final /* synthetic */ JupyterTextEditorWithPreview this$0;
            {
                this.this$0 = jupyterTextEditorWithPreview;
            }

            public void settingsChanged(@NotNull JupyterSettings jupyterSettings) {
                Intrinsics.checkParameterIsNotNull((Object)jupyterSettings, (String)"jupyterSettings");
                WriteAction.run((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<E>(this){
                    final /* synthetic */ $special$$inlined$apply$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run() {
                        Editor editor = JupyterTextEditorWithPreview.access$getSourceEditor$p(this.this$0.this$0).getEditor();
                        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"sourceEditor.editor");
                        Editor editor2 = editor;
                        VirtualFile virtualFile2 = JupyterTextEditorWithPreview.access$getSourceEditor$p(this.this$0.this$0).getFile();
                        if (!(virtualFile2 instanceof JupyterVirtualFile)) {
                            virtualFile2 = null;
                        }
                        JupyterVirtualFile jupyterVirtualFile = (JupyterVirtualFile)virtualFile2;
                        if (jupyterVirtualFile == null) {
                            return;
                        }
                        JupyterVirtualFile jupyterFile = jupyterVirtualFile;
                        editor2.getDocument().setText(jupyterFile.getNotebook().asSource());
                    }
                }));
            }
        });
    }

    public static final /* synthetic */ void access$settingsChanged(JupyterTextEditorWithPreview $this) {
        $this.settingsChanged();
    }

    public static final /* synthetic */ TextEditor access$getSourceEditor$p(JupyterTextEditorWithPreview $this) {
        return $this.sourceEditor;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterTextEditorWithPreview$JupyterKernelActionGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/actionSystem/AlwaysVisibleActionGroup;", "()V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "isPopup", "", "intellij.python.jupyter"})
    private static final class JupyterKernelActionGroup
    extends ActionGroup
    implements AlwaysVisibleActionGroup {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            return new AnAction[]{new JupyterInterruptKernelAction(), new JupyterRestartKernelAction()};
        }

        public boolean isPopup() {
            return true;
        }

        public JupyterKernelActionGroup() {
            super("Jupyter Kernel Actions", "Jupyter Kernel Actions", PythonJupyterIcons.Kernel);
        }
    }
}

