/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.execution.core;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterWebSocketClient;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterCellExecutionCallback;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterCellExecutionCallbackAdapter;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterKernelClient$WhenMappings;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterServer;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterExecuteRequestMessageBuilder;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterInputRequestMessage;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterMessage;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterMessageBase;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterMessageHeader;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterProtocolSchema;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterProtocolSchemaFactory;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterStatusMessage;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterStreamOutput;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 '2\u00020\u0001:\u0001'B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J:\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u0013H\u0002J\u0006\u0010\u001e\u001a\u00020\u0015J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0005H\u0002J\u0006\u0010!\u001a\u00020\u0015J\u0018\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\nH\u0007J\u000e\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u0005R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterKernelClient;", "Lcom/intellij/openapi/Disposable;", "jupyterServer", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterServer;", "kernelId", "", "sessionId", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterServer;Ljava/lang/String;Ljava/lang/String;)V", "callbacks", "", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterCellExecutionCallback;", "<set-?>", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterStatusMessage$JupyterExecutionState;", "executionState", "getExecutionState", "()Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterStatusMessage$JupyterExecutionState;", "lock", "", "webSocketClient", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterWebSocketClient;", "dispose", "", "execute", "code", "onMessageCreated", "Lkotlin/Function1;", "callback", "silent", "", "getOrConnectWebSocketClient", "interrupt", "processWebSocketRawMessage", "content", "restart", "sendMessage", "message", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterMessage;", "stopListeningMessageReply", "messageId", "Companion", "intellij.python.jupyter"})
public final class JupyterKernelClient
implements Disposable {
    private Object lock;
    private JupyterWebSocketClient webSocketClient;
    private final Map<String, JupyterCellExecutionCallback> callbacks;
    @Nullable
    private volatile JupyterStatusMessage.JupyterExecutionState executionState;
    private final JupyterServer jupyterServer;
    private final String kernelId;
    private final String sessionId;
    private static final Logger LOG;
    public static final Companion Companion;

    @Nullable
    public final JupyterStatusMessage.JupyterExecutionState getExecutionState() {
        return this.executionState;
    }

    public final void execute(@NotNull String code, @NotNull String sessionId, @NotNull Function1<? super String, Unit> onMessageCreated, @NotNull JupyterCellExecutionCallback callback, boolean silent) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
        Intrinsics.checkParameterIsNotNull(onMessageCreated, (String)"onMessageCreated");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        JupyterMessage message = new JupyterExecuteRequestMessageBuilder(code, sessionId, null, silent, 4, null).build();
        onMessageCreated.invoke((Object)message.getHeader().getMessageId());
        this.callbacks.put(message.getHeader().getMessageId(), callback);
        this.getOrConnectWebSocketClient().send(message.toString());
    }

    public final void stopListeningMessageReply(@NotNull String messageId) {
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        this.callbacks.put(messageId, JupyterCellExecutionCallbackAdapter.Companion.getINSTANCE());
    }

    @Deprecated(message="Should be encapsulated")
    public final void sendMessage(@NotNull JupyterMessage message, @NotNull JupyterCellExecutionCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        this.callbacks.put(message.getHeader().getMessageId(), callback);
        this.getOrConnectWebSocketClient().send(message.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JupyterWebSocketClient getOrConnectWebSocketClient() {
        JupyterWebSocketClient jupyterWebSocketClient;
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            JupyterWebSocketClient jupyterWebSocketClient2 = this.webSocketClient;
            if (jupyterWebSocketClient2 == null) {
                JupyterWebSocketClient jupyterWebSocketClient3 = this.jupyterServer.getClient().createWebSocketClientForKernel(this.kernelId, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
                    final /* synthetic */ JupyterKernelClient this$0;
                    {
                        this.this$0 = jupyterKernelClient;
                        super(1);
                    }

                    public final void invoke(@NotNull String content) {
                        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
                        JupyterKernelClient.access$processWebSocketRawMessage(this.this$0, content);
                    }
                }));
                boolean bl4 = false;
                boolean bl5 = false;
                JupyterWebSocketClient it = jupyterWebSocketClient3;
                boolean bl6 = false;
                this.webSocketClient = it;
                jupyterWebSocketClient2 = jupyterWebSocketClient3;
            }
            jupyterWebSocketClient = jupyterWebSocketClient2;
        }
        return jupyterWebSocketClient;
    }

    private final void processWebSocketRawMessage(String content) {
        String parentMessageId;
        JupyterProtocolSchema protocolSchema = JupyterProtocolSchemaFactory.createSchema$default(JupyterProtocolSchemaFactory.INSTANCE, null, 1, null);
        JupyterMessage message = JupyterMessageBase.Companion.parse(content, protocolSchema);
        JupyterMessageHeader jupyterMessageHeader = message.getParentHeader();
        String string = parentMessageId = jupyterMessageHeader != null ? jupyterMessageHeader.getMessageId() : null;
        if (parentMessageId == null) {
            LOG.info("Jupyter message arrived, but not processed because parent message id is absent: " + message);
        }
        Map<String, JupyterCellExecutionCallback> map = this.callbacks;
        boolean bl = false;
        JupyterCellExecutionCallback callback = map.get(parentMessageId);
        if (callback == null) {
            LOG.info("Jupyter message arrived, but not processed because callback for parent message id is absent: " + message);
        }
        switch (JupyterKernelClient$WhenMappings.$EnumSwitchMapping$0[message.getHeader().getMessageType().ordinal()]) {
            case 1: {
                JupyterStatusMessage statusMessage = new JupyterStatusMessage(message);
                this.executionState = statusMessage.getExecutionState();
                JupyterCellExecutionCallback jupyterCellExecutionCallback = callback;
                if (jupyterCellExecutionCallback != null) {
                    jupyterCellExecutionCallback.onStatus(statusMessage);
                }
                break;
            }
            case 2: {
                JupyterCellExecutionCallback jupyterCellExecutionCallback = callback;
                if (jupyterCellExecutionCallback != null) {
                    jupyterCellExecutionCallback.onExecuteInput(message);
                }
                break;
            }
            case 3: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CollectionsKt.joinToString$default((Iterable)JupyterStreamOutput.Companion.fromMessage(message).getText(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                }
                JupyterCellExecutionCallback jupyterCellExecutionCallback = callback;
                if (jupyterCellExecutionCallback != null) {
                    jupyterCellExecutionCallback.onUpdateOutput(message);
                }
                break;
            }
            case 4: {
                JupyterCellExecutionCallback jupyterCellExecutionCallback = callback;
                if (jupyterCellExecutionCallback != null) {
                    jupyterCellExecutionCallback.onUpdateOutput(message);
                }
                break;
            }
            case 5: {
                JupyterCellExecutionCallback jupyterCellExecutionCallback = callback;
                if (jupyterCellExecutionCallback != null) {
                    jupyterCellExecutionCallback.onExecuteReply(message);
                }
                break;
            }
            case 6: {
                JupyterCellExecutionCallback jupyterCellExecutionCallback = callback;
                if (jupyterCellExecutionCallback != null) {
                    jupyterCellExecutionCallback.onDisplayData(message);
                }
                break;
            }
            case 7: {
                JupyterCellExecutionCallback jupyterCellExecutionCallback = callback;
                if (jupyterCellExecutionCallback != null) {
                    jupyterCellExecutionCallback.onInputRequest(new JupyterInputRequestMessage(message));
                }
                break;
            }
            case 8: {
                JupyterCellExecutionCallback jupyterCellExecutionCallback = callback;
                if (jupyterCellExecutionCallback != null) {
                    jupyterCellExecutionCallback.onUpdateOutput(message);
                }
                break;
            }
            case 9: {
                JupyterCellExecutionCallback jupyterCellExecutionCallback = callback;
                if (jupyterCellExecutionCallback != null) {
                    jupyterCellExecutionCallback.onClearOutput(message);
                }
                break;
            }
            case 10: {
                JupyterCellExecutionCallback jupyterCellExecutionCallback = callback;
                if (jupyterCellExecutionCallback != null) {
                    jupyterCellExecutionCallback.onInspectReply(message);
                }
                break;
            }
            default: {
                LOG.info("Jupyter message arrived, but not processed: " + message);
            }
        }
    }

    public final void interrupt() {
        this.jupyterServer.getClient().interrupt(this.kernelId);
    }

    public final void restart() {
        this.jupyterServer.getClient().restart(this.kernelId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        block8: {
            JupyterWebSocketClient jupyterWebSocketClient;
            this.callbacks.clear();
            Object object = this.lock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                JupyterWebSocketClient jupyterWebSocketClient2 = this.webSocketClient;
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                jupyterWebSocketClient = jupyterWebSocketClient2;
            }
            if (jupyterWebSocketClient != null) {
                jupyterWebSocketClient.close();
            }
            try {
                this.jupyterServer.getClient().deleteSession(this.sessionId);
            }
            catch (Exception e) {
                boolean bl4;
                Logger $this$debugOrInfoIfTestMode$iv = LOG;
                boolean $i$f$debugOrInfoIfTestMode = false;
                Application application = ApplicationManager.getApplication();
                if (application != null) {
                    if (application.isUnitTestMode()) {
                        Logger logger2 = $this$debugOrInfoIfTestMode$iv;
                        bl4 = false;
                        String string = "Error occurred on deleting Jupyter session " + this.sessionId;
                        logger2.info(string);
                    }
                }
                Logger $this$debug$iv$iv = $this$debugOrInfoIfTestMode$iv;
                boolean $i$f$debug = false;
                if (!$this$debug$iv$iv.isDebugEnabled()) break block8;
                Logger logger3 = $this$debug$iv$iv;
                bl4 = false;
                String string = "Error occurred on deleting Jupyter session " + this.sessionId;
                logger3.debug(string, (Throwable)e);
            }
        }
    }

    public JupyterKernelClient(@NotNull JupyterServer jupyterServer, @NotNull String kernelId, @NotNull String sessionId) {
        Intrinsics.checkParameterIsNotNull((Object)jupyterServer, (String)"jupyterServer");
        Intrinsics.checkParameterIsNotNull((Object)kernelId, (String)"kernelId");
        Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
        this.jupyterServer = jupyterServer;
        this.kernelId = kernelId;
        this.sessionId = sessionId;
        this.lock = new Object();
        this.callbacks = new ConcurrentHashMap();
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(JupyterKernelClient.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(Jupyt\u2026KernelClient::class.java)");
        LOG = logger2;
    }

    public static final /* synthetic */ void access$processWebSocketRawMessage(JupyterKernelClient $this, String content) {
        $this.processWebSocketRawMessage(content);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterKernelClient$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.jupyter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

