/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler.callgraph;

import com.intellij.diagram.DataProviderFactory;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.view.BackgroundRenderer;
import com.intellij.openapi.graph.view.DefaultBackgroundRenderer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.profiler.FunctionStat;
import com.jetbrains.python.profiler.ProfileStats;
import com.jetbrains.python.profiler.callgraph.CallGraphBuilder;
import com.jetbrains.python.profiler.callgraph.CallGraphDiagramModel;
import com.jetbrains.python.profiler.callgraph.CallGraphPresentationModel;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\t"}, d2={"createCallGraphBuilder", "Lcom/jetbrains/python/profiler/callgraph/CallGraphBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "profilerStat", "Lcom/jetbrains/python/profiler/ProfileStats;", "functionsStats", "", "Lcom/jetbrains/python/profiler/FunctionStat;", "intellij.python.profiler"})
public final class CallGraphViewKt {
    @NotNull
    public static final CallGraphBuilder createCallGraphBuilder(@NotNull Project project, @NotNull ProfileStats profilerStat, @NotNull List<? extends FunctionStat> functionsStats) {
        DefaultBackgroundRenderer renderer;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)profilerStat, (String)"profilerStat");
        Intrinsics.checkParameterIsNotNull(functionsStats, (String)"functionsStats");
        Graph2D graph = GraphManager.getGraphManager().createGraph2D();
        Graph2DView view = GraphManager.getGraphManager().createGraph2DView(graph);
        DefaultBackgroundRenderer defaultBackgroundRenderer = renderer = GraphManager.getGraphManager().createDefaultBackgroundRenderer(view);
        Intrinsics.checkExpressionValueIsNotNull((Object)defaultBackgroundRenderer, (String)"renderer");
        defaultBackgroundRenderer.setColor(UIUtil.getListBackground());
        Graph2DView graph2DView = view;
        Intrinsics.checkExpressionValueIsNotNull((Object)graph2DView, (String)"view");
        graph2DView.setBackgroundRenderer((BackgroundRenderer)renderer);
        Graph2D graph2D = graph;
        Intrinsics.checkExpressionValueIsNotNull((Object)graph2D, (String)"graph");
        CallGraphPresentationModel presentationModel = new CallGraphPresentationModel(project, (Graph)graph2D, profilerStat);
        CallGraphDiagramModel model = new CallGraphDiagramModel(project, profilerStat, functionsStats);
        CallGraphBuilder builder = new CallGraphBuilder(project, graph, view, model, presentationModel);
        graph.addDataProvider((Object)"PROJECT", DataProviderFactory.create((Object)project));
        graph.addDataProvider((Object)"GRAPH_BUILDER", DataProviderFactory.create((Object)((Object)builder)));
        return builder;
    }
}

