/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Version
implements Comparable<Version>,
Serializable {
    private static final Map<String, Integer> SPECIAL_VALUES = ContainerUtil.immutableMapBuilder().put((Object)"alpha", (Object)-30).put((Object)"beta", (Object)-20).put((Object)"rc", (Object)-10).build();
    @NotNull
    private final int[] myElements;
    public static final Version ZERO = Version.of(0);
    public static final Version INFINITY = Version.of(Integer.MAX_VALUE);

    @NotNull
    public static Version of(@NotNull String string) {
        String[] elements;
        if (string == null) {
            Version.$$$reportNull$$$0(0);
        }
        ArrayList<Integer> res = new ArrayList<Integer>(5);
        for (String element : elements = string.split("[.,\\-_ ]|(?<=\\d)(?!\\d)|(?<!\\d)(?=\\d)")) {
            String e = StringUtil.toLowerCase((String)element.trim());
            if (e.isEmpty()) continue;
            Integer value = SPECIAL_VALUES.get(e);
            if (value == null) {
                try {
                    value = Integer.parseInt(e);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Failed to parse version \"" + string + "\"", nfe);
                }
            }
            res.add(value);
        }
        if (res.isEmpty()) {
            throw new IllegalArgumentException("Failed to parse version \"" + string + "\"");
        }
        Version version = new Version(ArrayUtil.toIntArray(res));
        if (version == null) {
            Version.$$$reportNull$$$0(1);
        }
        return version;
    }

    @Nullable
    public static Version parse(@Nullable String string) {
        try {
            return string == null ? null : Version.of(string);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static Version of(int ... elements) {
        if (elements == null) {
            Version.$$$reportNull$$$0(2);
        }
        return new Version(elements);
    }

    private Version(@NotNull int[] elements) {
        if (elements == null) {
            Version.$$$reportNull$$$0(3);
        }
        this.myElements = elements;
    }

    public int get(int index) {
        return index < this.myElements.length ? this.myElements[index] : 0;
    }

    public int size() {
        return this.myElements.length;
    }

    public boolean eqCoarse(int ... elements) {
        if (elements == null) {
            Version.$$$reportNull$$$0(4);
        }
        return this.truncate(elements.length).compareTo(elements) == 0;
    }

    public boolean eqCoarse(@NotNull Version v) {
        if (v == null) {
            Version.$$$reportNull$$$0(5);
        }
        return this.eqCoarse(v.myElements);
    }

    @NotNull
    public Version truncate(int n) {
        if (this.myElements.length <= n) {
            Version version = this;
            if (version == null) {
                Version.$$$reportNull$$$0(6);
            }
            return version;
        }
        if (n < 0) {
            throw new IllegalArgumentException("Negative desired size: " + n);
        }
        int[] newElements = new int[n];
        System.arraycopy(this.myElements, 0, newElements, 0, n);
        Version version = new Version(newElements);
        if (version == null) {
            Version.$$$reportNull$$$0(7);
        }
        return version;
    }

    @NotNull
    public Version truncateNegatives() {
        int n = this.myElements.length;
        for (int k = 0; k < n; ++k) {
            if (this.myElements[k] >= 0) continue;
            Version version = this.truncate(k);
            if (version == null) {
                Version.$$$reportNull$$$0(8);
            }
            return version;
        }
        Version version = this;
        if (version == null) {
            Version.$$$reportNull$$$0(9);
        }
        return version;
    }

    @NotNull
    public Version decStep() {
        int len = this.myElements.length;
        int[] newElements = new int[len + 1];
        System.arraycopy(this.myElements, 0, newElements, 0, len);
        newElements[len] = Integer.MIN_VALUE;
        Version version = Version.of(newElements);
        if (version == null) {
            Version.$$$reportNull$$$0(10);
        }
        return version;
    }

    @NotNull
    public Version incStep() {
        int len = this.myElements.length;
        int[] newElements = new int[len + 4];
        System.arraycopy(this.myElements, 0, newElements, 0, len);
        newElements[len] = 0;
        newElements[len + 1] = 0;
        newElements[len + 2] = 0;
        newElements[len + 3] = 1;
        Version version = Version.of(newElements);
        if (version == null) {
            Version.$$$reportNull$$$0(11);
        }
        return version;
    }

    @Override
    public int compareTo(@NotNull Version that) {
        if (that == null) {
            Version.$$$reportNull$$$0(12);
        }
        if (this == that) {
            return 0;
        }
        return this.compareTo(that.myElements);
    }

    @Override
    public int compareTo(int ... that) {
        int res = 0;
        int tLen = that.length;
        int e = Math.max(this.size(), tLen);
        for (int i = 0; i < e && res == 0; ++i) {
            res = Comparing.compare((int)this.get(i), (int)(i >= tLen ? 0 : that[i]));
        }
        return res;
    }

    public boolean isOrGreater(int ... than) {
        return this.compareTo(than) >= 0;
    }

    public boolean isOrGreater(@NotNull Version than) {
        if (than == null) {
            Version.$$$reportNull$$$0(13);
        }
        return this.compareTo(than) >= 0;
    }

    public boolean less(int ... than) {
        return this.compareTo(than) < 0;
    }

    public boolean less(@NotNull Version than) {
        if (than == null) {
            Version.$$$reportNull$$$0(14);
        }
        return this.compareTo(than) < 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.myElements, ((Version)o).myElements);
    }

    public int hashCode() {
        return Arrays.hashCode(this.myElements);
    }

    @NotNull
    public String toString() {
        if (this == INFINITY) {
            if ("\u221e" == null) {
                Version.$$$reportNull$$$0(15);
            }
            return "\u221e";
        }
        String string = this.toString(2, 100);
        if (string == null) {
            Version.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public String toString(int from, int to) {
        int n = Math.min(Math.max(this.myElements.length, from), to);
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                b.append('.');
            }
            b.append(this.get(i));
        }
        String string = b.toString();
        if (string == null) {
            Version.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/Version";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "than";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/Version";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "truncate";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "truncateNegatives";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "decStep";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "incStep";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "eqCoarse";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isOrGreater";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "less";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

