/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.util.treeView.FileNameComparator;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.HierarchicalFilePathComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class ChangesComparator {
    private static final Comparator<VirtualFile> VIRTUAL_FILE_FLAT = new VirtualFileComparator(true);
    private static final Comparator<VirtualFile> VIRTUAL_FILE_TREE = new VirtualFileComparator(false);
    private static final Comparator<Change> CHANGE_FLAT = new ChangeComparator(true);
    private static final Comparator<Change> CHANGE_TREE = new ChangeComparator(false);

    @NotNull
    public static Comparator<Change> getInstance(boolean flattened) {
        Comparator<Change> comparator = flattened ? CHANGE_FLAT : CHANGE_TREE;
        if (comparator == null) {
            ChangesComparator.$$$reportNull$$$0(0);
        }
        return comparator;
    }

    @NotNull
    public static Comparator<VirtualFile> getVirtualFileComparator(boolean flattened) {
        Comparator<VirtualFile> comparator = flattened ? VIRTUAL_FILE_FLAT : VIRTUAL_FILE_TREE;
        if (comparator == null) {
            ChangesComparator.$$$reportNull$$$0(1);
        }
        return comparator;
    }

    private static int comparePaths(@NotNull FilePath filePath1, @NotNull FilePath filePath2, boolean flattened) {
        int delta;
        if (filePath1 == null) {
            ChangesComparator.$$$reportNull$$$0(2);
        }
        if (filePath2 == null) {
            ChangesComparator.$$$reportNull$$$0(3);
        }
        if (flattened && (delta = FileNameComparator.INSTANCE.compare(filePath1.getName(), filePath2.getName())) != 0) {
            return delta;
        }
        return HierarchicalFilePathComparator.NATURAL.compare(filePath1, filePath2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesComparator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFileComparator";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesComparator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "comparePaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChangeComparator
    implements Comparator<Change> {
        private final boolean myFlattened;

        ChangeComparator(boolean flattened) {
            this.myFlattened = flattened;
        }

        @Override
        public int compare(Change o1, Change o2) {
            int delta = ChangesComparator.comparePaths(ChangesUtil.getFilePath((Change)o1), ChangesUtil.getFilePath((Change)o2), this.myFlattened);
            if (delta != 0) {
                return delta;
            }
            if (o1 instanceof ChangeListChange || o2 instanceof ChangeListChange) {
                if (o1 instanceof ChangeListChange && o2 instanceof ChangeListChange) {
                    String changeList1 = ((ChangeListChange)o1).getChangeListName();
                    String changeList2 = ((ChangeListChange)o2).getChangeListName();
                    return changeList1.compareToIgnoreCase(changeList2);
                }
                return o1 instanceof ChangeListChange ? 1 : -1;
            }
            return 0;
        }
    }

    private static class VirtualFileComparator
    implements Comparator<VirtualFile> {
        private final boolean myFlattened;

        VirtualFileComparator(boolean flattened) {
            this.myFlattened = flattened;
        }

        @Override
        public int compare(VirtualFile o1, VirtualFile o2) {
            return ChangesComparator.comparePaths(VcsUtil.getFilePath((VirtualFile)o1), VcsUtil.getFilePath((VirtualFile)o2), this.myFlattened);
        }
    }
}

