/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.MoveChangesDialog;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesCommitExecutor;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashSet;

public enum ChangelistConflictResolution {
    SHELVE{

        @Override
        public boolean resolveConflict(Project project, Collection<? extends Change> changes2, VirtualFile selected) {
            LocalChangeList changeList = ChangelistConflictResolution.getManager(project).getChangeList(changes2.iterator().next());
            return CommitChangeListDialog.commitChanges(project, changes2, changeList, (CommitExecutor)new ShelveChangesCommitExecutor(project), null);
        }
    }
    ,
    MOVE{

        @Override
        public boolean resolveConflict(Project project, Collection<? extends Change> changes2, VirtualFile selected) {
            ChangeListManagerImpl manager = ChangelistConflictResolution.getManager(project);
            HashSet<ChangeList> changeLists = new HashSet<ChangeList>();
            for (Change change : changes2) {
                LocalChangeList list = manager.getChangeList(change);
                if (list == null) continue;
                changeLists.add((ChangeList)list);
            }
            if (changeLists.isEmpty()) {
                Messages.showInfoMessage((Project)project, (String)"The conflict seems to be resolved", (String)"No Conflict Found");
                return true;
            }
            MoveChangesDialog dialog = new MoveChangesDialog(project, changes2, changeLists, selected);
            if (dialog.showAndGet()) {
                manager.moveChangesTo(manager.getDefaultChangeList(), dialog.getIncludedChanges().toArray(new Change[0]));
                return true;
            }
            return false;
        }
    }
    ,
    SWITCH{

        @Override
        public boolean resolveConflict(Project project, Collection<? extends Change> changes2, VirtualFile selected) {
            LocalChangeList changeList = ChangelistConflictResolution.getManager(project).getChangeList(changes2.iterator().next());
            assert (changeList != null);
            ChangelistConflictResolution.getManager(project).setDefaultChangeList(changeList);
            return true;
        }
    }
    ,
    IGNORE{

        @Override
        public boolean resolveConflict(Project project, Collection<? extends Change> changes2, VirtualFile selected) {
            ChangeListManagerImpl manager = ChangelistConflictResolution.getManager(project);
            for (Change change : changes2) {
                VirtualFile file = change.getVirtualFile();
                if (file == null) continue;
                manager.getConflictTracker().ignoreConflict(file, true);
            }
            return true;
        }
    };


    public abstract boolean resolveConflict(Project var1, Collection<? extends Change> var2, VirtualFile var3);

    private static ChangeListManagerImpl getManager(Project project) {
        return ChangeListManagerImpl.getInstanceImpl(project);
    }
}

