/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.ui.CommitNode;
import com.intellij.dvcs.push.ui.CustomRenderedTreeNode;
import com.intellij.dvcs.push.ui.EditableTreeNode;
import com.intellij.dvcs.push.ui.PushLogTreeUtil;
import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.dvcs.push.ui.RepositoryWithBranchPanel;
import com.intellij.dvcs.push.ui.TooltipNode;
import com.intellij.dvcs.push.ui.VcsBranchEditorListener;
import com.intellij.dvcs.push.ui.VcsCommitInfoBalloon;
import com.intellij.dvcs.push.ui.VcsEditableComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.ui.EditSourceForDialogAction;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesBrowser;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeHelper;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import com.intellij.vcs.log.Hash;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PushLog
extends JPanel
implements DataProvider {
    private static final String CONTEXT_MENU = "Vcs.Push.ContextMenu";
    private static final String START_EDITING = "startEditing";
    private static final String SPLITTER_PROPORTION = "Vcs.Push.Splitter.Proportion";
    private final SimpleChangesBrowser myChangesBrowser;
    private final CheckboxTree myTree;
    private final MyTreeCellRenderer myTreeCellRenderer;
    private final JScrollPane myScrollPane;
    private final VcsCommitInfoBalloon myBalloon;
    private boolean myShouldRepaint = false;
    private boolean mySyncStrategy;
    @Nullable
    private String mySyncRenderedText;
    private final boolean myAllowSyncStrategy;

    public PushLog(Project project, final CheckedTreeNode root, boolean allowSyncStrategy) {
        this.myAllowSyncStrategy = allowSyncStrategy;
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)root);
        treeModel.nodeStructureChanged((TreeNode)root);
        final AnAction quickDocAction = ActionManager.getInstance().getAction("QuickJavaDoc");
        this.myTreeCellRenderer = new MyTreeCellRenderer();
        this.myTree = new CheckboxTree(this.myTreeCellRenderer, root){

            protected boolean shouldShowBusyIconIfNeeded() {
                return true;
            }

            public boolean isPathEditable(TreePath path) {
                return this.isEditable() && path.getLastPathComponent() instanceof DefaultMutableTreeNode;
            }

            protected void onNodeStateChanged(CheckedTreeNode node) {
                if (node instanceof EditableTreeNode) {
                    ((EditableTreeNode)node).fireOnSelectionChange(node.isChecked());
                }
            }

            public String getToolTipText(MouseEvent event) {
                TreePath path = PushLog.this.myTree.getPathForLocation(event.getX(), event.getY());
                if (path == null) {
                    return "";
                }
                Object node = path.getLastPathComponent();
                if (!(node instanceof DefaultMutableTreeNode)) {
                    return "";
                }
                if (node instanceof TooltipNode) {
                    return KeymapUtil.createTooltipText((String)(((TooltipNode)node).getTooltip() + "<p style='font-style:italic;color:gray;'>Show commit details"), (AnAction)quickDocAction) + "</p>";
                }
                return "";
            }

            public boolean stopEditing() {
                JComponent editedComponent;
                InputVerifier verifier;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node instanceof EditableTreeNode && (verifier = (editedComponent = (JComponent)node.getUserObject()).getInputVerifier()) != null && !verifier.verify(editedComponent)) {
                    return false;
                }
                boolean result2 = super.stopEditing();
                if (PushLog.this.myShouldRepaint) {
                    PushLog.this.refreshNode((DefaultMutableTreeNode)root);
                }
                PushLog.this.restoreSelection(node);
                return result2;
            }

            public void cancelEditing() {
                DefaultMutableTreeNode lastSelectedPathComponent = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                super.cancelEditing();
                if (PushLog.this.myShouldRepaint) {
                    PushLog.this.refreshNode((DefaultMutableTreeNode)root);
                }
                PushLog.this.restoreSelection(lastSelectedPathComponent);
            }

            protected void installSpeedSearch() {
                new TreeSpeedSearch((Tree)this, path -> {
                    Object pathComponent = path.getLastPathComponent();
                    if (pathComponent instanceof RepositoryNode) {
                        return ((RepositoryNode)pathComponent).getRepositoryName();
                    }
                    return pathComponent.toString();
                });
            }
        };
        this.myTree.setUI((TreeUI)((Object)new MyTreeUi()));
        this.myTree.setBorder((Border)new EmptyBorder(2, 0, 0, 0));
        this.myTree.setEditable(true);
        this.myTree.setShowsRootHandles(root.getChildCount() > 1);
        MyTreeCellEditor treeCellEditor = new MyTreeCellEditor();
        this.myTree.setCellEditor((TreeCellEditor)treeCellEditor);
        treeCellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node instanceof EditableTreeNode) {
                    JComponent editedComponent = (JComponent)node.getUserObject();
                    InputVerifier verifier = editedComponent.getInputVerifier();
                    if (verifier != null && !verifier.verify(editedComponent)) {
                        ((EditableTreeNode)((Object)node)).fireOnCancel();
                    } else if (PushLog.this.mySyncStrategy) {
                        PushLog.this.resetEditSync();
                        ContainerUtil.process((List)PushLog.getChildNodesByType((DefaultMutableTreeNode)root, RepositoryNode.class, false), node1 -> {
                            node1.fireOnChange();
                            return true;
                        });
                    } else {
                        ((EditableTreeNode)((Object)node)).fireOnChange();
                    }
                }
                PushLog.this.myTree.firePropertyChange("tree.edit.mode", true, false);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node instanceof EditableTreeNode) {
                    ((EditableTreeNode)((Object)node)).fireOnCancel();
                }
                PushLog.this.resetEditSync();
                PushLog.this.myTree.firePropertyChange("tree.edit.mode", true, false);
            }
        });
        this.myTree.setInvokesStopCellEditing(true);
        this.myTree.setRootVisible(false);
        TreeUtil.collapseAll((JTree)this.myTree, (int)1);
        VcsBranchEditorListener linkMouseListener = new VcsBranchEditorListener(this.myTreeCellRenderer);
        linkMouseListener.installOn((Component)this.myTree);
        this.myBalloon = new VcsCommitInfoBalloon((JTree)this.myTree);
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PushLog.this.updateChangesView();
                PushLog.this.myBalloon.updateCommitDetails();
            }
        });
        this.myTree.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node instanceof RepositoryNode && PushLog.this.myTree.isEditing()) {
                    PushLog.this.myTree.getCellEditor().getTreeCellEditorComponent((JTree)PushLog.this.myTree, node, true, false, false, PushLog.this.myTree.getRowForPath(TreeUtil.getPathFromRoot((TreeNode)node)));
                }
            }
        });
        this.myTree.getInputMap().put(KeyStroke.getKeyStroke(113, 0), START_EDITING);
        this.myTree.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "");
        MyShowCommitInfoAction showCommitInfoAction = new MyShowCommitInfoAction();
        showCommitInfoAction.registerCustomShortcutSet(quickDocAction.getShortcutSet(), (JComponent)this.myTree);
        ExpandAllAction expandAllAction = new ExpandAllAction((JTree)this.myTree);
        expandAllAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExpandAll").getShortcutSet(), (JComponent)this.myTree);
        CollapseAllAction collapseAll = new CollapseAllAction((JTree)this.myTree);
        collapseAll.registerCustomShortcutSet(ActionManager.getInstance().getAction("CollapseAll").getShortcutSet(), (JComponent)this.myTree);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        PopupHandler.installPopupHandler((JComponent)this.myTree, (String)"Vcs.Log.ContextMenu", (String)CONTEXT_MENU);
        this.myChangesBrowser = new SimpleChangesBrowser(project, false, false);
        this.myChangesBrowser.getDiffAction().registerCustomShortcutSet(this.myChangesBrowser.getDiffAction().getShortcutSet(), (JComponent)this.myTree);
        EditSourceForDialogAction editSourceAction = new EditSourceForDialogAction(this.myChangesBrowser);
        editSourceAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this.myChangesBrowser);
        this.myChangesBrowser.addToolbarAction((AnAction)editSourceAction);
        this.myChangesBrowser.setMinimumSize(new Dimension(JBUIScale.scale((int)200), this.myChangesBrowser.getPreferredSize().height));
        this.setDefaultEmptyText();
        JBSplitter splitter = new JBSplitter(SPLITTER_PROPORTION, 0.7f);
        final JComponent syncStrategyPanel = this.myAllowSyncStrategy ? this.createStrategyPanel() : null;
        this.myScrollPane = new JBScrollPane((Component)this.myTree){

            public void layout() {
                super.layout();
                if (syncStrategyPanel != null) {
                    Rectangle bounds = this.getViewport().getBounds();
                    int height = bounds.height - syncStrategyPanel.getPreferredSize().height;
                    this.getViewport().setBounds(bounds.x, bounds.y, bounds.width, height);
                    syncStrategyPanel.setBounds(bounds.x, bounds.y + height, bounds.width, syncStrategyPanel.getPreferredSize().height);
                }
            }
        };
        if (syncStrategyPanel != null) {
            this.myScrollPane.setViewport((JViewport)((Object)new MyTreeViewPort((Component)this.myTree, syncStrategyPanel.getPreferredSize().height)));
        }
        this.myScrollPane.getViewport().setScrollMode(0);
        this.myScrollPane.setOpaque(false);
        if (syncStrategyPanel != null) {
            this.myScrollPane.add(syncStrategyPanel);
        }
        splitter.setFirstComponent((JComponent)this.myScrollPane);
        splitter.setSecondComponent((JComponent)this.myChangesBrowser);
        this.setLayout(new BorderLayout());
        this.add((Component)splitter);
        this.myTree.setMinimumSize(new Dimension(JBUIScale.scale((int)400), this.myTree.getPreferredSize().height));
        this.myTree.setRowHeight(0);
        this.myScrollPane.setMinimumSize(new Dimension(this.myTree.getMinimumSize().width, this.myScrollPane.getPreferredSize().height));
    }

    public void highlightNodeOrFirst(@Nullable RepositoryNode repositoryNode, boolean shouldScrollTo) {
        TreePath selectionPath = repositoryNode != null ? TreeUtil.getPathFromRoot((TreeNode)((Object)repositoryNode)) : TreeUtil.getFirstNodePath((JTree)this.myTree);
        this.myTree.setSelectionPath(selectionPath);
        if (shouldScrollTo) {
            this.myTree.scrollPathToVisible(selectionPath);
        }
    }

    private void restoreSelection(@Nullable DefaultMutableTreeNode node) {
        if (node != null) {
            TreeUtil.selectNode((JTree)this.myTree, (TreeNode)node);
        }
    }

    private JComponent createStrategyPanel() {
        JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.setBackground(this.myTree.getBackground());
        final LinkLabel linkLabel = new LinkLabel("Edit all targets", null);
        linkLabel.setBorder((Border)new EmptyBorder(2, 2, 2, 2));
        linkLabel.setListener((LinkListener)new LinkListener<String>(){

            public void linkSelected(LinkLabel aSource, String aLinkData) {
                if (linkLabel.isEnabled()) {
                    PushLog.this.startSyncEditing();
                }
            }
        }, null);
        this.myTree.addPropertyChangeListener("tree.edit.mode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean editMode = (Boolean)evt.getNewValue();
                linkLabel.setEnabled(editMode == false);
                linkLabel.setPaintUnderline(editMode == false);
                linkLabel.repaint();
            }
        });
        labelPanel.add((Component)linkLabel, "East");
        return labelPanel;
    }

    private void startSyncEditing() {
        this.mySyncStrategy = true;
        DefaultMutableTreeNode nodeToEdit = this.getFirstNodeToEdit();
        if (nodeToEdit != null) {
            this.myTree.startEditingAtPath(TreeUtil.getPathFromRoot((TreeNode)nodeToEdit));
        }
    }

    @NotNull
    private static List<Change> collectAllChanges(@NotNull List<? extends CommitNode> commitNodes) {
        if (commitNodes == null) {
            PushLog.$$$reportNull$$$0(0);
        }
        List<Change> list = CommittedChangesTreeBrowser.zipChanges(PushLog.collectChanges(commitNodes));
        if (list == null) {
            PushLog.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    private static List<CommitNode> collectSelectedCommitNodes(@NotNull List<DefaultMutableTreeNode> selectedNodes) {
        if (selectedNodes == null) {
            PushLog.$$$reportNull$$$0(2);
        }
        List nodes = StreamEx.of(selectedNodes).select(RepositoryNode.class).toFlatList(node -> PushLog.getChildNodesByType((DefaultMutableTreeNode)((Object)node), CommitNode.class, true));
        nodes.addAll(((StreamEx)StreamEx.of(selectedNodes).select(CommitNode.class).filter(node -> !nodes.contains(node))).toList());
        List list = nodes;
        if (list == null) {
            PushLog.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static List<Change> collectChanges(@NotNull List<? extends CommitNode> commitNodes) {
        if (commitNodes == null) {
            PushLog.$$$reportNull$$$0(4);
        }
        ArrayList<Change> changes2 = new ArrayList<Change>();
        for (CommitNode commitNode : commitNodes) {
            changes2.addAll(commitNode.getUserObject().getChanges());
        }
        ArrayList<Change> arrayList = changes2;
        if (arrayList == null) {
            PushLog.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static <T> List<T> getChildNodesByType(@NotNull DefaultMutableTreeNode node, Class<T> type, boolean reverseOrder) {
        if (node == null) {
            PushLog.$$$reportNull$$$0(6);
        }
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        if (node.getChildCount() < 1) {
            ArrayList<DefaultMutableTreeNode> arrayList = nodes;
            if (arrayList == null) {
                PushLog.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getFirstChild();
        while (childNode != null) {
            if (type.isInstance(childNode)) {
                DefaultMutableTreeNode nodeT = childNode;
                if (reverseOrder) {
                    nodes.add(0, nodeT);
                } else {
                    nodes.add(nodeT);
                }
            }
            childNode = (DefaultMutableTreeNode)node.getChildAfter(childNode);
        }
        ArrayList<DefaultMutableTreeNode> arrayList = nodes;
        if (arrayList == null) {
            PushLog.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private static List<Integer> getSortedRows(@NotNull int[] rows) {
        if (rows == null) {
            PushLog.$$$reportNull$$$0(9);
        }
        ArrayList<Integer> sorted = new ArrayList<Integer>();
        for (int row2 : rows) {
            sorted.add(row2);
        }
        Collections.sort(sorted, Collections.reverseOrder());
        ArrayList<Integer> arrayList = sorted;
        if (arrayList == null) {
            PushLog.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private void updateChangesView() {
        List<CommitNode> commitNodes = this.getSelectedCommitNodes();
        if (!commitNodes.isEmpty()) {
            this.myChangesBrowser.getViewer().setEmptyText("No differences");
        } else {
            this.setDefaultEmptyText();
        }
        this.myChangesBrowser.setChangesToDisplay(PushLog.collectAllChanges(commitNodes));
    }

    private void setDefaultEmptyText() {
        this.myChangesBrowser.getViewer().setEmptyText("No commits selected");
    }

    @Nullable
    public Object getData(@NotNull String id) {
        if (id == null) {
            PushLog.$$$reportNull$$$0(11);
        }
        if (VcsDataKeys.CHANGES.is(id)) {
            List<CommitNode> commitNodes = this.getSelectedCommitNodes();
            return PushLog.collectAllChanges(commitNodes).toArray(new Change[0]);
        }
        if (VcsDataKeys.VCS_REVISION_NUMBERS.is(id)) {
            List<CommitNode> commitNodes = this.getSelectedCommitNodes();
            return ContainerUtil.map2Array(commitNodes, VcsRevisionNumber.class, commitNode -> {
                Hash hash = (Hash)commitNode.getUserObject().getId();
                return new TextRevisionNumber(hash.asString(), hash.toShortString());
            });
        }
        return null;
    }

    @NotNull
    private List<CommitNode> getSelectedCommitNodes() {
        List<DefaultMutableTreeNode> selectedNodes = this.getSelectedTreeNodes();
        List<Object> list = selectedNodes.isEmpty() ? Collections.emptyList() : PushLog.collectSelectedCommitNodes(selectedNodes);
        if (list == null) {
            PushLog.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    private List<DefaultMutableTreeNode> getSelectedTreeNodes() {
        int[] rows = this.myTree.getSelectionRows();
        List<DefaultMutableTreeNode> list = rows != null && rows.length != 0 ? this.getNodesForRows(PushLog.getSortedRows(rows)) : ContainerUtil.emptyList();
        if (list == null) {
            PushLog.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    private List<DefaultMutableTreeNode> getNodesForRows(@NotNull List<Integer> rows) {
        if (rows == null) {
            PushLog.$$$reportNull$$$0(14);
        }
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        for (Integer row2 : rows) {
            TreePath path = this.myTree.getPathForRow(row2.intValue());
            Object pathComponent = path == null ? null : path.getLastPathComponent();
            if (!(pathComponent instanceof DefaultMutableTreeNode)) continue;
            nodes.add((DefaultMutableTreeNode)pathComponent);
        }
        ArrayList<DefaultMutableTreeNode> arrayList = nodes;
        if (arrayList == null) {
            PushLog.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.getKeyCode() == 10 && this.myTree.isEditing() && e.getModifiers() == 0 && pressed) {
            this.myTree.stopEditing();
            return true;
        }
        if (this.myAllowSyncStrategy && e.getKeyCode() == 113 && e.getModifiers() == 8 && pressed) {
            this.startSyncEditing();
            return true;
        }
        if (CheckboxTreeHelper.isToggleEvent((KeyEvent)e, (JComponent)this.myTree) && pressed) {
            this.toggleRepositoriesFromCommits();
            return true;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    private void toggleRepositoriesFromCommits() {
        LinkedHashSet checkedNodes = (LinkedHashSet)((StreamEx)StreamEx.of(this.getSelectedTreeNodes()).map(n -> n instanceof CommitNode ? n.getParent() : n).select(CheckedTreeNode.class).filter(CheckedTreeNode::isEnabled)).toCollection(LinkedHashSet::new);
        if (checkedNodes.isEmpty()) {
            return;
        }
        boolean newState = !((CheckedTreeNode)checkedNodes.iterator().next()).isChecked();
        checkedNodes.forEach(n -> this.myTree.setNodeState(n, newState));
    }

    @Nullable
    private DefaultMutableTreeNode getFirstNodeToEdit() {
        RepositoryNode selectedNode;
        if (this.myTree.getLastSelectedPathComponent() instanceof RepositoryNode && (selectedNode = (RepositoryNode)this.myTree.getLastSelectedPathComponent()).isEditableNow()) {
            return selectedNode;
        }
        List<RepositoryNode> repositoryNodes = PushLog.getChildNodesByType((DefaultMutableTreeNode)this.myTree.getModel().getRoot(), RepositoryNode.class, false);
        RepositoryNode editableNode = (RepositoryNode)ContainerUtil.find(repositoryNodes, repositoryNode -> repositoryNode.isEditableNow());
        if (editableNode != null) {
            TreeUtil.selectNode((JTree)this.myTree, (TreeNode)((Object)editableNode));
        }
        return editableNode;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    @NotNull
    public CheckboxTree getTree() {
        CheckboxTree checkboxTree = this.myTree;
        if (checkboxTree == null) {
            PushLog.$$$reportNull$$$0(16);
        }
        return checkboxTree;
    }

    public void selectIfNothingSelected(@NotNull TreeNode node) {
        if (node == null) {
            PushLog.$$$reportNull$$$0(17);
        }
        if (this.myTree.isSelectionEmpty()) {
            this.myTree.setSelectionPath(TreeUtil.getPathFromRoot((TreeNode)node));
        }
    }

    public void setChildren(@NotNull DefaultMutableTreeNode parentNode, @NotNull Collection<? extends DefaultMutableTreeNode> childrenNodes) {
        if (parentNode == null) {
            PushLog.$$$reportNull$$$0(18);
        }
        if (childrenNodes == null) {
            PushLog.$$$reportNull$$$0(19);
        }
        parentNode.removeAllChildren();
        for (DefaultMutableTreeNode defaultMutableTreeNode : childrenNodes) {
            parentNode.add(defaultMutableTreeNode);
        }
        if (!this.myTree.isEditing()) {
            this.refreshNode(parentNode);
            TreePath path = TreeUtil.getPathFromRoot((TreeNode)parentNode);
            if (this.myTree.getSelectionModel().isPathSelected(path)) {
                this.updateChangesView();
            }
        } else {
            this.myShouldRepaint = true;
        }
    }

    private void refreshNode(@NotNull DefaultMutableTreeNode parentNode) {
        if (parentNode == null) {
            PushLog.$$$reportNull$$$0(20);
        }
        DefaultTreeModel model = (DefaultTreeModel)this.myTree.getModel();
        model.nodeStructureChanged(parentNode);
        this.autoExpandChecked(parentNode);
        this.myShouldRepaint = false;
    }

    private void autoExpandChecked(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            PushLog.$$$reportNull$$$0(21);
        }
        if (node.getChildCount() <= 0) {
            return;
        }
        if (node instanceof RepositoryNode) {
            this.expandIfChecked((RepositoryNode)((Object)node));
            return;
        }
        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getFirstChild();
        while (childNode != null) {
            if (!(childNode instanceof RepositoryNode)) {
                return;
            }
            this.expandIfChecked((RepositoryNode)((Object)childNode));
            childNode = (DefaultMutableTreeNode)node.getChildAfter(childNode);
        }
    }

    private void expandIfChecked(@NotNull RepositoryNode node) {
        if (node == null) {
            PushLog.$$$reportNull$$$0(22);
        }
        if (node.isChecked()) {
            TreePath path = TreeUtil.getPathFromRoot((TreeNode)((Object)node));
            this.myTree.expandPath(path);
        }
    }

    private void setSyncText(String value) {
        this.mySyncRenderedText = value;
    }

    public void fireEditorUpdated(@NotNull String currentText) {
        if (currentText == null) {
            PushLog.$$$reportNull$$$0(23);
        }
        if (this.mySyncStrategy) {
            List<RepositoryNode> repositoryNodes = PushLog.getChildNodesByType((DefaultMutableTreeNode)this.myTree.getModel().getRoot(), RepositoryNode.class, false);
            for (RepositoryNode node : repositoryNodes) {
                if (!node.isEditableNow()) continue;
                node.forceUpdateUiModelWithTypedText(currentText);
            }
            this.setSyncText(currentText);
            this.myTree.repaint();
        }
    }

    private void resetEditSync() {
        if (this.mySyncStrategy) {
            this.mySyncStrategy = false;
            this.mySyncRenderedText = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitNodes";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/push/ui/PushLog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedNodes";
                break;
            }
            case 6: 
            case 17: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenNodes";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/push/ui/PushLog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllChanges";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSelectedCommitNodes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectChanges";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildNodesByType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedRows";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedCommitNodes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedTreeNodes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodesForRows";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectAllChanges";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectSelectedCommitNodes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectChanges";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChildNodesByType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSortedRows";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNodesForRows";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "selectIfNothingSelected";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setChildren";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "refreshNode";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "autoExpandChecked";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "expandIfChecked";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fireEditorUpdated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyTreeViewPort
    extends JBViewport {
        final int myHeightToReduce;

        MyTreeViewPort(@Nullable Component view, int heightToReduce) {
            this.setView(view);
            this.myHeightToReduce = heightToReduce;
        }

        public Dimension getExtentSize() {
            Dimension defaultSize = super.getExtentSize();
            return new Dimension(defaultSize.width, defaultSize.height - this.myHeightToReduce);
        }
    }

    private class MyTreeUi
    extends WideSelectionTreeUI {
        private final ComponentListener myTreeSizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MyTreeUi.this.updateSizes();
            }
        };
        private final AncestorListener myTreeAncestorListener = new AncestorListenerAdapter(){

            public void ancestorMoved(AncestorEvent event) {
                super.ancestorMoved(event);
                MyTreeUi.this.updateSizes();
            }
        };

        private MyTreeUi() {
        }

        private void updateSizes() {
            this.treeState.invalidateSizes();
            this.tree.repaint();
        }

        protected void installListeners() {
            super.installListeners();
            this.tree.addComponentListener(this.myTreeSizeListener);
            this.tree.addAncestorListener(this.myTreeAncestorListener);
        }

        protected void uninstallListeners() {
            this.tree.removeComponentListener(this.myTreeSizeListener);
            this.tree.removeAncestorListener(this.myTreeAncestorListener);
            super.uninstallListeners();
        }

        protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
            return new BasicTreeUI.NodeDimensionsHandler(){

                @Override
                public Rectangle getNodeDimensions(Object value, int row2, int depth, boolean expanded, Rectangle size) {
                    Rectangle dimensions = super.getNodeDimensions(value, row2, depth, expanded, size);
                    dimensions.width = Math.max(PushLog.this.myScrollPane != null ? PushLog.this.myScrollPane.getViewport().getWidth() - this.getRowX(row2, depth) : ((PushLog)PushLog.this).myTree.getMinimumSize().width, dimensions.width);
                    return dimensions;
                }
            };
        }
    }

    private class MyTreeCellEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private RepositoryWithBranchPanel myValue;

        private MyTreeCellEditor() {
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row2) {
            RepositoryWithBranchPanel panel2;
            this.myValue = panel2 = (RepositoryWithBranchPanel)((Object)((DefaultMutableTreeNode)value).getUserObject());
            PushLog.this.myTree.firePropertyChange("tree.edit.mode", false, true);
            return panel2.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row2, true);
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)anEvent;
                TreePath path = PushLog.this.myTree.getClosestPathForLocation(me.getX(), me.getY());
                int row2 = PushLog.this.myTree.getRowForLocation(me.getX(), me.getY());
                PushLog.this.myTree.getCellRenderer().getTreeCellRendererComponent((JTree)PushLog.this.myTree, path.getLastPathComponent(), false, false, true, row2, true);
                Object tag = me.getClickCount() >= 1 ? PushLogTreeUtil.getTagAtForRenderer(PushLog.this.myTreeCellRenderer, me) : null;
                return tag instanceof VcsEditableComponent;
            }
            TreePath treePath = PushLog.this.myTree.getAnchorSelectionPath();
            if (treePath == null) {
                return true;
            }
            Object treeNode = treePath.getLastPathComponent();
            return treeNode instanceof EditableTreeNode && ((EditableTreeNode)treeNode).isEditableNow();
        }

        @Override
        public Object getCellEditorValue() {
            return this.myValue;
        }
    }

    private class MyTreeCellRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            if (!(value instanceof DefaultMutableTreeNode)) {
                return;
            }
            this.myCheckbox.setBorder(null);
            if (value instanceof RepositoryNode) {
                RepositoryNode valueNode = (RepositoryNode)value;
                this.myCheckbox.setVisible(valueNode.isCheckboxVisible());
                if (valueNode.isChecked() && valueNode.isLoading()) {
                    this.myCheckbox.setState(ThreeStateCheckBox.State.DONT_CARE);
                } else {
                    this.myCheckbox.setSelected(valueNode.isChecked());
                }
            }
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            ColoredTreeCellRenderer renderer = this.getTextRenderer();
            if (value instanceof CustomRenderedTreeNode) {
                if (tree.isEditing() && PushLog.this.mySyncStrategy && value instanceof RepositoryNode) {
                    ((RepositoryNode)value).render(renderer, PushLog.this.mySyncRenderedText);
                } else {
                    ((CustomRenderedTreeNode)value).render(renderer);
                }
            } else {
                renderer.append(userObject == null ? "" : userObject.toString());
            }
        }
    }

    private class MyShowCommitInfoAction
    extends DumbAwareAction {
        private MyShowCommitInfoAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowCommitInfoAction.$$$reportNull$$$0(0);
            }
            PushLog.this.myBalloon.showCommitDetails();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowCommitInfoAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(PushLog.this.getSelectedCommitNodes().size() == 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/dvcs/push/ui/PushLog$MyShowCommitInfoAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

