/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.uml;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.ERDiagramModel;
import com.jetbrains.ERDummyModelInit;
import com.jetbrains.ERUmlElementManager;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.model.DjangoModel;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class DjangoUmlElementManager
extends ERUmlElementManager {
    @Override
    @Nullable
    protected Module getModule(DataContext context) {
        Project project;
        Module module = (Module)LangDataKeys.MODULE.getData(context);
        if (module == null && (project = (Project)CommonDataKeys.PROJECT.getData(context)) != null) {
            module = DjangoUtil.getDjangoModule((Project)project);
        }
        return module;
    }

    @Override
    protected List<Map.Entry<String, String>> getElements(PyClass aClass) {
        ArrayList<Map.Entry<String, String>> elements = new ArrayList<Map.Entry<String, String>>();
        elements.addAll(DjangoModel.getFields((PyClass)aClass).entrySet());
        List superClasses = aClass.getSuperClassTypes(TypeEvalContext.userInitiated((Project)aClass.getProject(), (PsiFile)aClass.getContainingFile()));
        for (PyClassLikeType superClass : superClasses) {
            PyClass pyClass;
            boolean insideDjango;
            if (!(superClass instanceof PyClassType) || (insideDjango = DjangoUtil.isInsideDjango((VirtualFile)(pyClass = ((PyClassType)superClass).getPyClass()).getContainingFile().getVirtualFile(), null))) continue;
            elements.addAll(DjangoModel.getFields((PyClass)pyClass).entrySet());
        }
        if (ERDiagramModel.ourAdditionalFields.containsKey(aClass)) {
            elements.add(ERDiagramModel.ourAdditionalFields.get(aClass));
        }
        return elements;
    }

    public boolean isAcceptableAsNode(Object element) {
        Module module = null;
        if (element instanceof ERDummyModelInit) {
            module = ((ERDummyModelInit)element).getModule();
        } else if (element instanceof PyClass) {
            module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PyClass)element));
        }
        if (module != null) {
            Sdk sdk = PythonSdkType.findPythonSdk((Module)module);
            return sdk != null && DjangoFacet.isPresent((Module)module);
        }
        return false;
    }
}

