/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.impl.YAMLMappingImpl;

public class YAMLBlockMappingImpl
extends YAMLMappingImpl {
    public static final String EMPTY_MAP_MESSAGE = "YAML map without any key-value";
    private static final long a = c.a(-648131019834122480L, -8223173998700491970L, MethodHandles.lookup().lookupClass()).a(248183481425902L);

    public YAMLBlockMappingImpl(@NotNull ASTNode node) {
        if (node == null) {
            YAMLBlockMappingImpl.e(0);
        }
        super(node);
    }

    @NotNull
    public YAMLKeyValue getFirstKeyValue() {
        long l2 = a ^ 0x50F748EC6E7EL;
        YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)this.findChildByType(YAMLElementTypes.KEY_VALUE_PAIR);
        if (yAMLKeyValue == null) {
            throw new IllegalStateException(EMPTY_MAP_MESSAGE);
        }
        YAMLKeyValue yAMLKeyValue2 = yAMLKeyValue;
        if (yAMLKeyValue2 == null) {
            YAMLBlockMappingImpl.e(1);
        }
        return yAMLKeyValue2;
    }

    @Override
    protected void addNewKey(@NotNull YAMLKeyValue key) {
        if (key == null) {
            YAMLBlockMappingImpl.e(2);
        }
        int n2 = YAMLUtil.getIndentToThisElement((PsiElement)this);
        YAMLElementGenerator yAMLElementGenerator = YAMLElementGenerator.getInstance(this.getProject());
        IElementType iElementType = PsiUtilCore.getElementType((PsiElement)this.getLastChild());
        if (n2 == 0) {
            if (iElementType != YAMLTokenTypes.EOL) {
                this.add(yAMLElementGenerator.createEol());
            }
        } else if (iElementType != YAMLTokenTypes.INDENT || this.getLastChild().getTextLength() != n2) {
            this.add(yAMLElementGenerator.createEol());
            this.add(yAMLElementGenerator.createIndent(n2));
        }
        this.add((PsiElement)key);
    }

    public void insertKeyValueAtOffset(@NotNull YAMLKeyValue keyValue, int offset) {
        PsiElement psiElement;
        if (keyValue == null) {
            YAMLBlockMappingImpl.e(3);
        }
        int n2 = YAMLUtil.getIndentToThisElement((PsiElement)this);
        if (offset < this.getTextRange().getStartOffset()) {
            offset = this.getTextRange().getStartOffset();
        }
        YAMLElementGenerator yAMLElementGenerator = YAMLElementGenerator.getInstance(this.getProject());
        if (offset == this.getTextRange().getStartOffset()) {
            boolean bl2 = PsiUtilCore.getElementType((PsiElement)this.getPrevSibling()) == YAMLTokenTypes.INDENT && PsiUtilCore.getElementType((PsiElement)this.getFirstChild()) == YAMLTokenTypes.EOL;
            PsiElement psiElement2 = this.addBefore((PsiElement)keyValue, this.getFirstChild());
            if (!bl2) {
                psiElement2 = this.addAfter(yAMLElementGenerator.createEol(), psiElement2);
                this.addAfter(yAMLElementGenerator.createIndent(n2), psiElement2);
            }
            return;
        }
        if (offset == this.getTextRange().getEndOffset()) {
            this.addNewKey(keyValue);
            return;
        }
        if (offset > this.getTextRange().getEndOffset()) {
            PsiElement psiElement3 = PsiTreeUtil.nextLeaf((PsiElement)this);
            SmartList smartList = new SmartList();
            while (YAMLElementTypes.SPACE_ELEMENTS.contains(PsiUtilCore.getElementType((PsiElement)psiElement3))) {
                if (offset >= psiElement3.getTextRange().getStartOffset()) {
                    smartList.add(psiElement3);
                }
                psiElement3 = PsiTreeUtil.nextLeaf((PsiElement)psiElement3);
            }
            for (PsiElement psiElement4 : smartList) {
                this.add(psiElement4);
            }
            for (PsiElement psiElement4 : smartList) {
                psiElement4.delete();
            }
            this.addNewKey(keyValue);
            return;
        }
        for (psiElement = this.getFirstChild(); psiElement != null; psiElement = psiElement.getNextSibling()) {
            if (PsiUtilCore.getElementType((PsiElement)psiElement) == YAMLTokenTypes.INDENT && offset <= psiElement.getTextRange().getEndOffset()) {
                if (PsiUtilCore.getElementType((PsiElement)psiElement.getNextSibling()) == YAMLTokenTypes.EOL) {
                    this.addAfter((PsiElement)keyValue, psiElement);
                    return;
                }
                PsiElement psiElement5 = this.addBefore(yAMLElementGenerator.createIndent(n2), psiElement);
                psiElement5 = this.addAfter((PsiElement)keyValue, psiElement5);
                this.addAfter(yAMLElementGenerator.createEol(), psiElement5);
                return;
            }
            if (offset <= psiElement.getTextRange().getEndOffset()) break;
        }
        while (psiElement != null) {
            if (PsiUtilCore.getElementType((PsiElement)psiElement) == YAMLTokenTypes.EOL) {
                PsiElement psiElement6 = psiElement;
                if (n2 != 0) {
                    psiElement6 = this.addAfter(yAMLElementGenerator.createIndent(n2), psiElement6);
                }
                psiElement6 = this.addAfter((PsiElement)keyValue, psiElement6);
                if (PsiUtilCore.getElementType((PsiElement)psiElement) != YAMLTokenTypes.EOL) {
                    this.addAfter(yAMLElementGenerator.createEol(), psiElement6);
                }
                return;
            }
            psiElement = psiElement.getNextSibling();
        }
        this.addNewKey(keyValue);
    }

    @Nullable
    public YAMLKeyValue getOrCreateKeySequence(@NotNull List<String> keyComponents, int preferableOffset) {
        long l2 = a ^ 0x31B6B6F7FF08L;
        if (keyComponents == null) {
            YAMLBlockMappingImpl.e(4);
        }
        if (keyComponents.isEmpty()) {
            return null;
        }
        String string = keyComponents.iterator().next();
        List list2 = ContainerUtil.subList(keyComponents, (int)1);
        YAMLKeyValue yAMLKeyValue = this.getKeyValueByKey(string);
        if (yAMLKeyValue == null) {
            int n2 = YAMLUtil.getIndentToThisElement((PsiElement)this);
            String string2 = YAMLElementGenerator.createChainedKey(keyComponents, n2);
            YAMLElementGenerator yAMLElementGenerator = YAMLElementGenerator.getInstance(this.getProject());
            Collection collection = PsiTreeUtil.collectElementsOfType((PsiElement)yAMLElementGenerator.createDummyYamlWithText(string2), (Class[])new Class[]{YAMLKeyValue.class});
            if (collection.isEmpty()) {
                Logger.getInstance(YAMLBlockMappingImpl.class).error("No one key-value created: input sequence = " + keyComponents + " generated text = '" + string2 + "'");
                return null;
            }
            YAMLKeyValue yAMLKeyValue2 = (YAMLKeyValue)collection.iterator().next();
            this.insertKeyValueAtOffset(yAMLKeyValue2, preferableOffset);
            yAMLKeyValue = this.getKeyValueByKey(string);
            assert (yAMLKeyValue != null);
        }
        if (keyComponents.size() == 1) {
            return yAMLKeyValue;
        }
        if (yAMLKeyValue.getValue() instanceof YAMLBlockMappingImpl) {
            return ((YAMLBlockMappingImpl)yAMLKeyValue.getValue()).getOrCreateKeySequence(list2, preferableOffset);
        }
        return null;
    }

    private static /* synthetic */ void e(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x4E2A4ADE304EL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/psi/impl/YAMLBlockMappingImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyComponents";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/psi/impl/YAMLBlockMappingImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstKeyValue";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addNewKey";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "insertKeyValueAtOffset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateKeySequence";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

