/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.formatter.YAMLCodeStyleSettings;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

class YAMLFormattingContext {
    private static final Indent i;
    private static final Indent d;
    private static final Indent e;
    @NotNull
    public final CodeStyleSettings mySettings;
    @NotNull
    private final PsiFile c;
    @NotNull
    private final SpacingBuilder l;
    @NotNull
    private final Map<ASTNode, Alignment> g;
    @NotNull
    private final Map<ASTNode, Alignment> f;
    private final boolean h;
    private final boolean b;
    private final boolean j;
    private final int a;
    @Nullable
    private String k;
    private static final long m;

    YAMLFormattingContext(@NotNull CodeStyleSettings settings, @NotNull PsiFile file) {
        if (settings == null) {
            YAMLFormattingContext.a(0);
        }
        if (file == null) {
            YAMLFormattingContext.a(1);
        }
        this.g = FactoryMap.create(aSTNode -> Alignment.createAlignment((boolean)true));
        this.f = FactoryMap.create(aSTNode -> Alignment.createAlignment((boolean)true));
        this.k = null;
        this.mySettings = settings;
        this.c = file;
        this.l = new SpacingBuilder(this.mySettings, (Language)YAMLLanguage.INSTANCE).before((IElementType)YAMLTokenTypes.COLON).spaces(0);
        this.h = ((YAMLCodeStyleSettings)this.mySettings.getCustomSettings(YAMLCodeStyleSettings.class)).INDENT_SEQUENCE_VALUE;
        this.b = !((YAMLCodeStyleSettings)this.mySettings.getCustomSettings(YAMLCodeStyleSettings.class)).SEQUENCE_ON_NEW_LINE;
        this.j = !((YAMLCodeStyleSettings)this.mySettings.getCustomSettings(YAMLCodeStyleSettings.class)).BLOCK_MAPPING_ON_NEW_LINE;
        this.a = ((YAMLCodeStyleSettings)this.mySettings.getCustomSettings(YAMLCodeStyleSettings.class)).ALIGN_VALUES_PROPERTIES;
    }

    @Nullable
    Spacing computeSpacing(@NotNull Block parent, @Nullable Block child1, @NotNull Block child2) {
        Spacing spacing;
        if (parent == null) {
            YAMLFormattingContext.a(2);
        }
        if (child2 == null) {
            YAMLFormattingContext.a(3);
        }
        if ((spacing = this.l.getSpacing(parent, child1, child2)) != null) {
            return spacing;
        }
        if (!(child1 instanceof ASTBlock) || !(child2 instanceof ASTBlock)) {
            return null;
        }
        ASTNode aSTNode = ((ASTBlock)child1).getNode();
        ASTNode aSTNode2 = ((ASTBlock)child2).getNode();
        if (PsiUtilCore.getElementType((ASTNode)aSTNode) != YAMLTokenTypes.SEQUENCE_MARKER) {
            return null;
        }
        IElementType iElementType = PsiUtilCore.getElementType((ASTNode)aSTNode2);
        int n2 = this.mySettings.getIndentSize((FileType)YAMLFileType.YML);
        if (n2 < 2) {
            n2 = 2;
        }
        int n3 = 1;
        int n4 = 0;
        if (iElementType == YAMLElementTypes.SEQUENCE_ITEM) {
            if (this.b) {
                n3 = n2 - 1;
            } else {
                n4 = 1;
            }
        } else if (iElementType == YAMLElementTypes.KEY_VALUE_PAIR) {
            if (this.j) {
                n3 = n2 - 1;
            } else {
                n4 = 1;
            }
        }
        return Spacing.createSpacing((int)n3, (int)n3, (int)n4, (boolean)false, (int)0);
    }

    @Nullable
    Alignment computeAlignment(@NotNull ASTNode node) {
        ASTNode aSTNode;
        IElementType iElementType;
        if (node == null) {
            YAMLFormattingContext.a(4);
        }
        if ((iElementType = PsiUtilCore.getElementType((ASTNode)node)) == YAMLElementTypes.SEQUENCE_ITEM) {
            return this.g.get(node.getTreeParent());
        }
        if (iElementType == YAMLElementTypes.KEY_VALUE_PAIR) {
            return this.g.get(node.getTreeParent());
        }
        if (this.a == 2) {
            if (iElementType == YAMLTokenTypes.COLON) {
                return this.f.get(node.getTreeParent().getTreeParent());
            }
        } else if (this.a == 1 && YAMLElementTypes.SCALAR_ITEMS.contains(iElementType) && PsiUtilCore.getElementType((ASTNode)(aSTNode = YAMLFormattingContext.a(node.getTreeParent()))) == YAMLTokenTypes.COLON) {
            return this.f.get(aSTNode.getTreeParent().getTreeParent());
        }
        return null;
    }

    @Nullable
    Indent computeBlockIndent(@NotNull ASTNode node) {
        boolean bl2;
        long l2 = m ^ 0x480907010404L;
        if (node == null) {
            YAMLFormattingContext.a(5);
        }
        IElementType iElementType = PsiUtilCore.getElementType((ASTNode)node);
        IElementType iElementType2 = PsiUtilCore.getElementType((ASTNode)node.getTreeParent());
        IElementType iElementType3 = iElementType2 == null ? null : PsiUtilCore.getElementType((ASTNode)node.getTreeParent().getTreeParent());
        boolean bl3 = bl2 = iElementType3 == YAMLElementTypes.DOCUMENT;
        assert (iElementType != YAMLElementTypes.SEQUENCE) : "Sequence should be inlined!";
        assert (iElementType != YAMLElementTypes.MAPPING) : "Mapping should be inlined!";
        assert (iElementType != YAMLElementTypes.DOCUMENT) : "Document should be inlined!";
        if (YAMLElementTypes.DOCUMENT_BRACKETS.contains(iElementType)) {
            return d;
        }
        if (YAMLElementTypes.BRACKETS.contains(iElementType)) {
            return e;
        }
        if (iElementType == YAMLTokenTypes.TEXT) {
            return bl2 ? d : i;
        }
        if (iElementType == YAMLElementTypes.FILE) {
            return d;
        }
        if (YAMLElementTypes.SCALAR_VALUES.contains(iElementType)) {
            return i;
        }
        if (iElementType == YAMLElementTypes.SEQUENCE_ITEM) {
            return this.e(node);
        }
        if (iElementType == YAMLElementTypes.KEY_VALUE_PAIR) {
            return YAMLFormattingContext.c(node);
        }
        if (iElementType == YAMLTokenTypes.COMMENT) {
            if (iElementType2 == YAMLElementTypes.SEQUENCE) {
                return this.e(node);
            }
            if (iElementType2 == YAMLElementTypes.MAPPING) {
                return YAMLFormattingContext.c(node);
            }
        }
        return YAMLElementTypes.TOP_LEVEL.contains(iElementType2) ? d : null;
    }

    @Nullable
    Indent computeNewChildIndent(@NotNull ASTNode node) {
        if (node == null) {
            YAMLFormattingContext.a(6);
        }
        return YAMLElementTypes.TOP_LEVEL.contains(PsiUtilCore.getElementType((ASTNode)node)) ? d : i;
    }

    public boolean isIncomplete(@NotNull ASTNode node) {
        YAMLValue yAMLValue2;
        YAMLValue yAMLValue3;
        if (node == null) {
            YAMLFormattingContext.a(7);
        }
        Predicate<YAMLValue> predicate = yAMLValue -> yAMLValue == null || YAMLElementTypes.INCOMPLETE_BLOCKS.contains(PsiUtilCore.getElementType((PsiElement)yAMLValue));
        if (PsiUtilCore.getElementType((ASTNode)node) == YAMLElementTypes.KEY_VALUE_PAIR ? predicate.test(yAMLValue3 = ((YAMLKeyValue)node.getPsi()).getValue()) : PsiUtilCore.getElementType((ASTNode)node) == YAMLElementTypes.SEQUENCE_ITEM && predicate.test(yAMLValue2 = ((YAMLSequenceItem)node.getPsi()).getValue())) {
            return true;
        }
        return FormatterUtil.isIncomplete((ASTNode)node);
    }

    @NotNull
    public String getFullText() {
        if (this.k == null) {
            this.k = this.c.getText();
        }
        String string = this.k;
        if (string == null) {
            YAMLFormattingContext.a(8);
        }
        return string;
    }

    @Nullable
    private static Indent c(@NotNull ASTNode aSTNode) {
        boolean bl2;
        IElementType iElementType;
        if (aSTNode == null) {
            YAMLFormattingContext.a(9);
        }
        IElementType iElementType2 = (iElementType = PsiUtilCore.getElementType((ASTNode)aSTNode.getTreeParent())) == null ? null : PsiUtilCore.getElementType((ASTNode)aSTNode.getTreeParent().getTreeParent());
        boolean bl3 = bl2 = iElementType2 == YAMLElementTypes.DOCUMENT;
        if (iElementType == YAMLElementTypes.HASH) {
            return Indent.getNormalIndent();
        }
        if (bl2) {
            return d;
        }
        if (iElementType == YAMLElementTypes.SEQUENCE_ITEM) {
            return Indent.getNormalIndent();
        }
        return i;
    }

    @NotNull
    private Indent e(@NotNull ASTNode aSTNode) {
        boolean bl2;
        IElementType iElementType;
        if (aSTNode == null) {
            YAMLFormattingContext.a(10);
        }
        IElementType iElementType2 = (iElementType = PsiUtilCore.getElementType((ASTNode)aSTNode.getTreeParent())) == null ? null : PsiUtilCore.getElementType((ASTNode)aSTNode.getTreeParent().getTreeParent());
        boolean bl3 = bl2 = iElementType2 == YAMLElementTypes.DOCUMENT;
        if (iElementType == YAMLElementTypes.ARRAY) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                YAMLFormattingContext.a(11);
            }
            return indent;
        }
        if (iElementType2 == YAMLElementTypes.KEY_VALUE_PAIR) {
            if (this.h) {
                Indent indent = i;
                if (indent == null) {
                    YAMLFormattingContext.a(12);
                }
                return indent;
            }
            Indent indent = d;
            if (indent == null) {
                YAMLFormattingContext.a(13);
            }
            return indent;
        }
        if (bl2) {
            Indent indent = d;
            if (indent == null) {
                YAMLFormattingContext.a(14);
            }
            return indent;
        }
        Indent indent = i;
        if (indent == null) {
            YAMLFormattingContext.a(15);
        }
        return indent;
    }

    @Nullable
    private static ASTNode a(ASTNode aSTNode) {
        do {
            if (YAMLElementTypes.BLANK_ELEMENTS.contains(PsiUtilCore.getElementType((ASTNode)(aSTNode = TreeUtil.prevLeaf((ASTNode)aSTNode))))) continue;
            return aSTNode;
        } while (aSTNode != null);
        return null;
    }

    static {
        m = com.jetbrains.python.psi.c.a(2907766841589458104L, -8514051474844361071L, MethodHandles.lookup().lookupClass()).a(143120572826520L);
        i = Indent.getNormalIndent((boolean)true);
        d = Indent.getSpaceIndent((int)0, (boolean)true);
        e = Indent.getSpaceIndent((int)0);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = m ^ 0x424248EA0F30L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/formatter/YAMLFormattingContext";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/formatter/YAMLFormattingContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullText";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSequenceItemIndent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeSpacing";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeAlignment";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeBlockIndent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeNewChildIndent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isIncomplete";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeKeyValuePairIndent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeSequenceItemIndent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

