/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

public abstract class YamlKeyCompletionInsertHandler<T extends LookupElement>
implements InsertHandler<T> {
    private static final long a = c.a(4858014431109490070L, -4580215860398567162L, MethodHandles.lookup().lookupClass()).a(230669359031798L);

    @NotNull
    protected abstract YAMLKeyValue createNewEntry(@NotNull YAMLDocument var1, T var2);

    public void handleInsert(@NotNull InsertionContext context, @NotNull T item) {
        long l2 = a ^ 0x3EA93B165E19L;
        if (context == null) {
            YamlKeyCompletionInsertHandler.a(0);
        }
        if (item == null) {
            YamlKeyCompletionInsertHandler.a(1);
        }
        PsiElement psiElement = context.getFile().findElementAt(context.getStartOffset());
        assert (psiElement != null) : "no element at " + context.getStartOffset();
        YAMLDocument yAMLDocument = (YAMLDocument)PsiTreeUtil.getParentOfType((PsiElement)psiElement, YAMLDocument.class);
        assert (yAMLDocument != null);
        YAMLValue yAMLValue = yAMLDocument.getTopLevelValue() instanceof YAMLMapping ? this.deleteLookupTextAndRetrieveOldValue(context, psiElement) : null;
        YAMLKeyValue yAMLKeyValue = this.createNewEntry(yAMLDocument, item);
        context.getEditor().getCaretModel().moveToOffset(yAMLKeyValue.getTextRange().getEndOffset());
        if (yAMLValue != null) {
            WriteCommandAction.runWriteCommandAction((Project)context.getProject(), () -> yAMLKeyValue.setValue(yAMLValue));
        }
        PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(context.getDocument());
        if (!YamlKeyCompletionInsertHandler.isCharAtCaret(context.getEditor(), ' ')) {
            EditorModificationUtil.insertStringAtCaret((Editor)context.getEditor(), (String)" ");
        } else {
            context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, true);
        }
    }

    @Nullable
    protected YAMLValue deleteLookupTextAndRetrieveOldValue(InsertionContext context, @NotNull PsiElement elementAtCaret) {
        YAMLValue yAMLValue;
        long l2 = a ^ 0x111C64702548L;
        if (elementAtCaret == null) {
            YamlKeyCompletionInsertHandler.a(2);
        }
        if (elementAtCaret.getNode().getElementType() != YAMLTokenTypes.SCALAR_KEY) {
            YamlKeyCompletionInsertHandler.a(context);
            return null;
        }
        YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, YAMLKeyValue.class);
        assert (yAMLKeyValue != null);
        assert (yAMLKeyValue.getParentMapping() != null);
        Document document = context.getDocument();
        String string = document.getText(TextRange.create((int)context.getStartOffset(), (int)context.getTailOffset()));
        if (!yAMLKeyValue.getKeyText().equals(string)) {
            document.deleteString(context.getStartOffset(), context.getTailOffset());
            context.commitDocument();
            return null;
        }
        context.commitDocument();
        if (yAMLKeyValue.getValue() != null) {
            YAMLKeyValue yAMLKeyValue2 = YAMLElementGenerator.getInstance(context.getProject()).createYamlKeyValue("foo", "b");
            yAMLKeyValue2.setValue(yAMLKeyValue.getValue());
            yAMLValue = yAMLKeyValue2.getValue();
        } else {
            yAMLValue = null;
        }
        context.setTailOffset(yAMLKeyValue.getTextRange().getEndOffset());
        WriteCommandAction.runWriteCommandAction((Project)context.getProject(), () -> yAMLKeyValue.getParentMapping().deleteKeyValue(yAMLKeyValue));
        return yAMLValue;
    }

    private static void a(InsertionContext insertionContext) {
        int n2;
        Document document = insertionContext.getDocument();
        CharSequence charSequence = document.getCharsSequence();
        for (n2 = insertionContext.getStartOffset() - 1; n2 >= 0; --n2) {
            char c10 = charSequence.charAt(n2);
            if (c10 == ' ' || c10 == '\t') continue;
            if (c10 == '\n') {
                --n2;
                break;
            }
            n2 = insertionContext.getStartOffset() - 1;
            break;
        }
        document.deleteString(n2 + 1, insertionContext.getTailOffset());
        insertionContext.commitDocument();
    }

    public static boolean isCharAtCaret(Editor editor2, char ch2) {
        int n2 = editor2.getCaretModel().getOffset();
        Document document = editor2.getDocument();
        return document.getTextLength() > n2 && document.getCharsSequence().charAt(n2) == ch2;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x6D93297EBD88L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAtCaret";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/yaml/completion/YamlKeyCompletionInsertHandler";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteLookupTextAndRetrieveOldValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

