/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rsa;

import com.jetbrains.python.psi.c;
import java.math.BigInteger;

public class RSAEncoder {
    private final BigInteger e;
    private final BigInteger g;
    private final int d;
    private final int f;
    private int c = 0;
    private final BigInteger a;
    private final boolean b;
    private static final long h = com.jetbrains.python.psi.c.a(-4975089784652695323L, 689837826188116991L, null).a(217997973781209L);

    public RSAEncoder(BigInteger privateExponent, BigInteger privateModulus, int alphabetSize, boolean addDashes) {
        this.e = privateExponent;
        this.g = privateModulus;
        this.b = addDashes;
        int n2 = privateModulus.bitLength();
        this.a = new BigInteger(String.valueOf(alphabetSize));
        int n3 = (int)Math.ceil((double)n2 / Math.log(alphabetSize) * Math.log(2.0));
        if (n3 % 5 != 0) {
            n3 = (n3 / 5 + 1) * 5;
        }
        this.f = n3;
        this.d = n2 / 8 - 1;
    }

    public String encode(byte[] data) {
        byte[] byArray;
        long l2 = h ^ 0x552D3199629L;
        long l3 = l2 ^ 0x3F9CECCC5172L;
        int n2 = (int)(l3 >>> 32);
        int n3 = (int)(l3 << 32 >>> 48);
        int n4 = (int)(l3 << 48 >>> 48);
        int n5 = data.length % this.d;
        if (n5 == 0) {
            byArray = data;
        } else {
            byArray = new byte[data.length + this.d - n5];
            System.arraycopy(data, 0, byArray, this.d - n5, data.length);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i10 = 0; i10 < byArray.length; i10 += this.d) {
            this.a(n2, byArray, n3, stringBuilder, (short)n4, i10, this.d);
        }
        return stringBuilder.toString();
    }

    private void a(int n2, byte[] byArray, int n3, StringBuilder stringBuilder, short s2, int n4, int n5) {
        long l2 = ((long)n2 << 32 | (long)n3 << 48 >>> 32 | (long)s2 << 48 >>> 48) ^ h;
        if (n5 == 0) {
            return;
        }
        byte[] byArray2 = new byte[this.d];
        System.arraycopy(byArray, n4, byArray2, 0, n5);
        BigInteger bigInteger = new BigInteger(1, byArray2);
        if (bigInteger.compareTo(this.g) >= 0) {
            throw new IllegalArgumentException("result is too long");
        }
        BigInteger bigInteger2 = bigInteger.modPow(this.e, this.g);
        this.a(stringBuilder, this.a(bigInteger2));
    }

    private void a(StringBuilder stringBuilder, CharSequence charSequence) {
        for (int i10 = 0; i10 < charSequence.length(); ++i10) {
            this.a(stringBuilder);
            stringBuilder.append(charSequence.charAt(i10));
        }
    }

    private CharSequence a(BigInteger bigInteger) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i10 = 0; i10 < this.f; ++i10) {
            stringBuilder.append(RSAEncoder.b(bigInteger.mod(this.a)));
            bigInteger = bigInteger.divide(this.a);
        }
        return new ReverseCharSequence(stringBuilder);
    }

    private void a(StringBuilder stringBuilder) {
        if (this.c > 0 && this.c % 5 == 0) {
            if (this.c % 30 == 0) {
                stringBuilder.append('\n');
            } else if (this.b) {
                stringBuilder.append('-');
            }
        }
        ++this.c;
    }

    private static char b(BigInteger bigInteger) {
        int n2 = bigInteger.intValue();
        char c10 = n2 < 10 ? (char)(48 + n2) : (n2 < 36 ? (char)(65 + n2 - 10) : (n2 < 62 ? (char)(97 + n2 - 36) : (char)(33 + n2 - 62)));
        return c10;
    }

    private static class ReverseCharSequence
    implements CharSequence {
        private final CharSequence a;

        public ReverseCharSequence(CharSequence sequence) {
            this.a = sequence;
        }

        public int length() {
            return this.a.length();
        }

        public char charAt(int index) {
            return this.a.charAt(this.a.length() - index - 1);
        }

        public CharSequence subSequence(int start2, int end) {
            int n2 = this.a.length();
            return new ReverseCharSequence(this.a.subSequence(n2 - end, n2 - start2));
        }
    }
}

