/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rbenv;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.version.management.RubySdkInfo;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandlerBase;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.ShimsBasedVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.rbenv.RbenvSdkData;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;

public class RbenvVersionManagerHandler
extends RubyVersionManagerHandlerBase<RbenvSdkData>
implements ShimsBasedVersionManagerHandler {
    private static final Logger g;
    @NonNls
    private static final String h = "RBENV_GEMSETS";
    private static final String f = "shims";
    static final String INSTALLATIONS_RELATIVE_PATH = "versions";
    static final List<String> DEFAULT_RBENV_HOMES;
    static final List<String> POSSIBLE_RBENV_PATHS;
    private static final long i;

    @Override
    @NotNull
    protected List<String> getAdditionalPathsToSearch() {
        List<String> list2 = DEFAULT_RBENV_HOMES;
        if (list2 == null) {
            RbenvVersionManagerHandler.c(0);
        }
        return list2;
    }

    @Override
    @NotNull
    public String getVersionManagerExecutableName() {
        long l2 = i ^ 0x6AE1FD5AB946L;
        if ("rbenv" == null) {
            RbenvVersionManagerHandler.c(1);
        }
        return "rbenv";
    }

    @Override
    @NotNull
    protected List<String> patchCommands(@NotNull RubyRunner rubyRunner, @NotNull String versionManagerPath, @NotNull String distributionId, @NotNull List<String> commandsToPatch) {
        long l2 = i ^ 0x1488AFB86501L;
        if (rubyRunner == null) {
            RbenvVersionManagerHandler.c(2);
        }
        if (versionManagerPath == null) {
            RbenvVersionManagerHandler.c(3);
        }
        if (distributionId == null) {
            RbenvVersionManagerHandler.c(4);
        }
        if (commandsToPatch == null) {
            RbenvVersionManagerHandler.c(5);
        }
        if (!commandsToPatch.isEmpty()) {
            commandsToPatch.set(0, Paths.get(commandsToPatch.get(0), new String[0]).getFileName().toString());
        }
        List<String> list2 = rubyRunner.getCommandsSequence(ContainerUtil.concat((List)ContainerUtil.newArrayList((Object[])new String[]{"env", "RBENV_VERSION=" + distributionId, versionManagerPath, "exec"}), commandsToPatch));
        if (list2 == null) {
            RbenvVersionManagerHandler.c(6);
        }
        return list2;
    }

    @Override
    @NotNull
    public Path computeShimsPath(@NotNull Sdk sdk) {
        long l2 = i ^ 0x2E49FF6F5BF6L;
        if (sdk == null) {
            RbenvVersionManagerHandler.c(7);
        }
        Path path = RbenvVersionManagerHandler.a(sdk).resolve(f);
        if (path == null) {
            RbenvVersionManagerHandler.c(8);
        }
        return path;
    }

    private static Path a(@NotNull Sdk sdk) {
        if (sdk == null) {
            RbenvVersionManagerHandler.c(9);
        }
        return RbenvVersionManagerHandler.c(RubySdkAdditionalData.notNullFrom(sdk).getInterpreterPath(sdk));
    }

    @Override
    @NotNull
    protected List<String> getAvailableDistributionsCommands(@NotNull RubyRunner runner, @NotNull String versionManagerPath) {
        long l2 = i ^ 0x1022C522AD10L;
        if (runner == null) {
            RbenvVersionManagerHandler.c(10);
        }
        if (versionManagerPath == null) {
            RbenvVersionManagerHandler.c(11);
        }
        List<String> list2 = Arrays.asList(versionManagerPath, "completions", "shell");
        if (list2 == null) {
            RbenvVersionManagerHandler.c(12);
        }
        return list2;
    }

    @Override
    @NotNull
    protected List<String> processAvailableDistributionsOutput(@NotNull List<String> rawOutput) {
        if (rawOutput == null) {
            RbenvVersionManagerHandler.c(13);
        }
        List list2 = ContainerUtil.filter(rawOutput, string -> {
            long l2 = i ^ 0x5C76A55A797BL;
            return !StringUtil.equals((CharSequence)string, (CharSequence)"system") && !StringUtil.startsWithChar((CharSequence)string, (char)'-');
        });
        if (list2 == null) {
            RbenvVersionManagerHandler.c(14);
        }
        return list2;
    }

    @Override
    @NotNull
    public RbenvSdkData createAdditionalData() {
        RbenvSdkData rbenvSdkData = new RbenvSdkData(this);
        if (rbenvSdkData == null) {
            RbenvVersionManagerHandler.c(15);
        }
        return rbenvSdkData;
    }

    @Override
    @Nullable
    protected RubyVersionManagerSdkData doLoadLegacy(@NotNull Element rootElement, @NotNull String interpreterPath) {
        long l2 = i ^ 0x3510B4F99328L;
        if (rootElement == null) {
            RbenvVersionManagerHandler.c(16);
        }
        if (interpreterPath == null) {
            RbenvVersionManagerHandler.c(17);
        }
        String string = rootElement.getAttributeValue(h);
        if (RbenvGemsetManager.isRbenvSdkPath(interpreterPath) || string != null) {
            return ((RbenvSdkData)this.createAdditionalData().withDistributionId(RbenvVersionManagerHandler.getVersionFromInterpreterPath(interpreterPath))).withGemsetName(string);
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    static String computeRootFor(@Nullable Path pathToRbenv, @NotNull RubyRunner runner) {
        long l2 = i ^ 0x678C36A64FC0L;
        if (runner == null) {
            RbenvVersionManagerHandler.c(18);
        }
        if (pathToRbenv == null) {
            return null;
        }
        try {
            g.debug("Getting rbenv root from " + pathToRbenv.toString());
            ProcessOutput processOutput = runner.execute((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(pathToRbenv.toString(), "root").inSameThread(RubyRunner.DEFAULT_EXECUTION_TIMEOUT, RBundle.message("version.manager.rbenv.fetching.root")));
            assert (processOutput != null);
            if (processOutput.getExitCode() != 0) {
                g.warn("Error getting rbenv root from script, error code " + processOutput.getExitCode() + "; STDOUT: " + processOutput.getStdout() + "; STDERR: " + processOutput.getStderr());
                return null;
            }
            List list2 = processOutput.getStdoutLines();
            String string = list2.isEmpty() ? null : (String)list2.get(0);
            return StringUtil.isEmpty((String)string) ? null : string;
        }
        catch (ExecutionException executionException) {
            g.warn("Error getting rbenv root result", (Throwable)executionException);
            return null;
        }
    }

    @Override
    @NotNull
    public RbenvSdkData createAdditionalData(@NotNull RubySdkInfo sdkInfo) {
        if (sdkInfo == null) {
            RbenvVersionManagerHandler.c(19);
        }
        RbenvSdkData rbenvSdkData = ((RbenvSdkData)super.createAdditionalData(sdkInfo)).withGemsetName(sdkInfo.getGemSet());
        if (rbenvSdkData == null) {
            RbenvVersionManagerHandler.c(20);
        }
        return rbenvSdkData;
    }

    @Contract(pure=true)
    @NotNull
    public static RbenvVersionManagerHandler getInstance() {
        RbenvVersionManagerHandler rbenvVersionManagerHandler = Objects.requireNonNull((RbenvVersionManagerHandler)RubyVersionManagerHandler.findHandler(rubyVersionManagerHandler -> rubyVersionManagerHandler instanceof RbenvVersionManagerHandler));
        if (rbenvVersionManagerHandler == null) {
            RbenvVersionManagerHandler.c(21);
        }
        return rbenvVersionManagerHandler;
    }

    @Override
    public boolean canRunArbitraryCommand() {
        return false;
    }

    @Contract(pure=true)
    @NotNull
    private static Path c(@NotNull String string) {
        long l2 = i ^ 0x5CBC30BEE92CL;
        if (string == null) {
            RbenvVersionManagerHandler.c(22);
        }
        Path path = Paths.get(string, new String[0]);
        for (int i10 = 0; i10 < 4; ++i10) {
            if ((path = path.getParent()) != null) continue;
            throw new NullPointerException("Interpreter path supposed to be valid, e.g: /home/user/.rbenv/versions/2.5.1/bin/ruby");
        }
        Path path2 = path;
        if (path2 == null) {
            RbenvVersionManagerHandler.c(23);
        }
        return path2;
    }

    static {
        i = c.a(-144000742927980718L, 1630629664872507347L, MethodHandles.lookup().lookupClass()).a(235122129678937L);
        long l2 = i ^ 0x148359AE0450L;
        g = Logger.getInstance(RbenvVersionManagerHandler.class);
        DEFAULT_RBENV_HOMES = Collections.singletonList("~/.rbenv/bin");
        POSSIBLE_RBENV_PATHS = ContainerUtil.map(DEFAULT_RBENV_HOMES, string -> {
            long l2 = i ^ 0x75EDB8DC9C0FL;
            return string + "/rbenv";
        });
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = i ^ 0x748CA7FDE105L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rbenv/RbenvVersionManagerHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyRunner";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandsToPatch";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawOutput";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkInfo";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPathsToSearch";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionManagerExecutableName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rbenv/RbenvVersionManagerHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "patchCommands";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeShimsPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDistributionsCommands";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "processAvailableDistributionsOutput";
                break;
            }
            case 15: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalData";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "computeHomeByInterpreterPath";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "patchCommands";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeShimsPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeHomePath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDistributionsCommands";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processAvailableDistributionsOutput";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doLoadLegacy";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "computeRootFor";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalData";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "computeHomeByInterpreterPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

