/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.testunit;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyClassModuleNameIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.presentation.RClassPresentationUtil;
import org.jetbrains.plugins.ruby.testing.testunit.RTestUnitConstants;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;

public class RTestUnitUtil {
    public static final String TEST_METHOD_NAME_PREFIX = "test";
    private static final FQN a;
    private static final FQN b;
    private static final FQN c;
    private static final long d;

    private RTestUnitUtil() {
    }

    private static boolean a(@NotNull Symbol symbol, RClass rClass, @NotNull FQN fQN) {
        Symbol symbol2;
        if (symbol == null) {
            RTestUnitUtil.a(0);
        }
        if (fQN == null) {
            RTestUnitUtil.a(1);
        }
        if (fQN.equals(symbol.getFQNWithNesting())) {
            return true;
        }
        return symbol instanceof ClassModuleSymbol && (symbol2 = ((ClassModuleSymbol)symbol).getSuperClassSymbol((PsiElement)rClass)) != null && !symbol2.equals(symbol) && RTestUnitUtil.a(symbol2, rClass, fQN);
    }

    public static boolean isUnitTestCaseLikeClass(@NotNull RClass rClass) {
        VirtualFile virtualFile;
        if (rClass == null) {
            RTestUnitUtil.a(2);
        }
        if ((virtualFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)rClass.getContainingFile())) == null || !TestUnitUtil.isFileWithValidTestUnitFileName(virtualFile)) {
            return false;
        }
        return RTestUnitUtil.isUnitTestCaseLikeClassWithoutFileNameCheck(rClass);
    }

    public static boolean isUnitTestCaseLikeClassWithoutFileNameCheck(@NotNull RClass rClass) {
        RSuperClass rSuperClass;
        String string;
        long l2 = d ^ 0x3C7AB42E1481L;
        if (rClass == null) {
            RTestUnitUtil.a(3);
        }
        String string2 = string = (rSuperClass = rClass.getPsiSuperClass()) == null ? null : rSuperClass.getText();
        if (string != null) {
            if (RTestUnitConstants.STD_TESTUNIT_TESTCASES.contains(string)) {
                return true;
            }
            if (string.endsWith("::TestCase")) {
                return true;
            }
            if (RTestUnitConstants.STD_MINITEST_TESTCASES.contains(string) || string.startsWith("MiniTest::")) {
                return true;
            }
            if (RTestUnitConstants.STD_MINITEST_5_0_TESTCASES.contains(string) || string.startsWith("Minitest::")) {
                return true;
            }
        }
        return rClass.getName().endsWith("Test");
    }

    public static boolean isUnitTestCaseDescendant(@NotNull RClass rClass) {
        if (rClass == null) {
            RTestUnitUtil.a(4);
        }
        return RTestUnitUtil.a(rClass, c);
    }

    public static boolean isMiniTestCaseDescendant(@NotNull RClass rClass) {
        if (rClass == null) {
            RTestUnitUtil.a(5);
        }
        return RTestUnitUtil.a(rClass, a) || RTestUnitUtil.a(rClass, b);
    }

    private static boolean a(@NotNull RClass rClass, @NotNull FQN fQN) {
        if (rClass == null) {
            RTestUnitUtil.a(6);
        }
        if (fQN == null) {
            RTestUnitUtil.a(7);
        }
        if (!RTestUnitUtil.isUnitTestCaseLikeClass(rClass)) {
            return false;
        }
        Symbol symbol = RTestUnitUtil.getSymbolByContainerRubyTestMode(rClass);
        return symbol != null && RTestUnitUtil.a(symbol, rClass, fQN);
    }

    public static boolean hasValidTestNameAndNotSingleton(@NotNull RMethod method) {
        String string;
        long l2 = d ^ 0x2B7717638D52L;
        if (method == null) {
            RTestUnitUtil.a(8);
        }
        return (string = method.getName()).startsWith(TEST_METHOD_NAME_PREFIX) && string.length() > TEST_METHOD_NAME_PREFIX.length() && !(method instanceof RSingletonMethod);
    }

    public static boolean containsTestCaseLikeClasses(@NotNull RFile file) {
        if (file == null) {
            RTestUnitUtil.a(9);
        }
        return RTestUnitUtil.checkForAnotherTestCaseLikeClasses(null, file);
    }

    public static boolean containsToplevelMinitestExampleGroups(@NotNull RFile file) {
        if (file == null) {
            RTestUnitUtil.a(10);
        }
        List list2 = file.getStatements();
        for (RPsiElement rPsiElement : list2) {
            if (!(rPsiElement instanceof RBlockCall) || !TestUnitUtil.isMiniTestExampleGroupCall((RBlockCall)rPsiElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkForAnotherTestCaseLikeClasses(@Nullable RContainer currentContainer, @NotNull RFile rFile) {
        if (rFile == null) {
            RTestUnitUtil.a(11);
        }
        List<RClass> list2 = RContainerUtil.getTopLevelClasses(rFile);
        for (RClass rClass : list2) {
            if (currentContainer == rClass || rClass == null || !RTestUnitUtil.isUnitTestCaseLikeClass(rClass)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Symbol getSymbolByContainerRubyTestMode(@NotNull RContainer container) {
        RFile rFile;
        if (container == null) {
            RTestUnitUtil.a(12);
        }
        if ((rFile = RubyPsiUtil.getRFile((PsiElement)container)) == null) {
            return null;
        }
        return SymbolUtil.getSymbolByContainer(container);
    }

    @Nullable
    public static RClass getClassByNameInScriptInRubyTestMode(@NotNull String qualifiedClassName, @NotNull Project project, @NotNull VirtualFile scriptFile) {
        if (qualifiedClassName == null) {
            RTestUnitUtil.a(13);
        }
        if (project == null) {
            RTestUnitUtil.a(14);
        }
        if (scriptFile == null) {
            RTestUnitUtil.a(15);
        }
        Ref ref = new Ref(null);
        ApplicationManager.getApplication().runReadAction(() -> {
            boolean bl2;
            boolean bl3 = bl2 = !PsiDocumentManager.getInstance((Project)project).hasUncommitedDocuments();
            if (bl2) {
                ref.set((Object)RTestUnitUtil.a(qualifiedClassName, project, scriptFile));
            }
        });
        return (RClass)ref.get();
    }

    @Nullable
    private static RClass a(@NotNull String string, @NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (string == null) {
            RTestUnitUtil.a(16);
        }
        if (project == null) {
            RTestUnitUtil.a(17);
        }
        if (virtualFile == null) {
            RTestUnitUtil.a(18);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.projectTestScope((Project)project);
        String string2 = RClassPresentationUtil.getNameByQualifiedName(string);
        return (RClass)RubyClassModuleNameIndex.findOne(project, string2, globalSearchScope, rContainer -> {
            if (rContainer instanceof RClass) {
                RClass rClass = (RClass)rContainer;
                if (Comparing.equal((Object)rContainer.getContainingFile().getVirtualFile(), (Object)virtualFile)) {
                    String string2 = RTestUnitUtil.getRuntimeQualifiedNameInRubyTestMode(rClass);
                    return string.equals(string2);
                }
            }
            return false;
        });
    }

    @Nullable
    public static String getRuntimeQualifiedNameInRubyTestMode(@NotNull RClass rClass) {
        Symbol symbol;
        if (rClass == null) {
            RTestUnitUtil.a(19);
        }
        return (symbol = RTestUnitUtil.getSymbolByContainerRubyTestMode(rClass)) != null ? symbol.getFQNWithNesting().getFullPath() : null;
    }

    @Nullable
    public static String getSimpleTestClassQualifiedName(@NotNull RClass rClass) {
        if (rClass == null) {
            RTestUnitUtil.a(20);
        }
        return rClass.getFQNWithNesting().getFullPath();
    }

    static {
        d = com.jetbrains.python.psi.c.a(3643042086737283857L, -5380384341705980837L, MethodHandles.lookup().lookupClass()).a(53290375449257L);
        long l2 = d ^ 0x6FD864EE1022L;
        a = FQN.Builder.fromString("MiniTest::Unit::TestCase");
        b = FQN.Builder.fromString("Minitest::Test");
        c = FQN.Builder.fromString("Test::Unit::TestCase");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = d ^ 0x2A068C438C8FL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rVClassSymbol";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCaseFqn";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedClassName";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/testing/testunit/RTestUnitUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isUserTestCase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnitTestCaseLikeClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnitTestCaseLikeClassWithoutFileNameCheck";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnitTestCaseDescendant";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isMiniTestCaseDescendant";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestCaseDescendant";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "hasValidTestNameAndNotSingleton";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "containsTestCaseLikeClasses";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "containsToplevelMinitestExampleGroups";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForAnotherTestCaseLikeClasses";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getSymbolByContainerRubyTestMode";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassByNameInScriptInRubyTestMode";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "internalGetClassByNameInScriptInRubyTestMode";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "getRuntimeQualifiedNameInRubyTestMode";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "getSimpleTestClassQualifiedName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

