/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.rake;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.settings.SettingsExternalizer;
import org.jetbrains.plugins.ruby.tasks.rake.task.RakeTask;
import org.jetbrains.plugins.ruby.tasks.rake.task.RakeTaskSerializableImpl;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public class RakeTasksExternalizer
extends SettingsExternalizer {
    private static final Logger a;
    @NonNls
    private static final String b = "RakeGroup";
    @NonNls
    private static final String d = "RakeTask";
    @NonNls
    private static final String f = "taksId";
    @NonNls
    private static final String h = "description";
    @NonNls
    private static final String e = "fullCmd";
    @NonNls
    private static final String g = ".rakeTasks";
    @NonNls
    private static final String c = "Settings";
    private static final long i;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public RakeTask loadRakeTasksTree(@NotNull String railsApplicationHomeDirPath) {
        long l2 = i ^ 0x72A17E7702C0L;
        if (railsApplicationHomeDirPath == null) {
            RakeTasksExternalizer.b(0);
        }
        File file = RakeTasksExternalizer.getDataFile(railsApplicationHomeDirPath);
        a.debug("Cached tasks file: ", new Object[]{file});
        try {
            if (file.exists() && RakeTasksExternalizer.a(file, railsApplicationHomeDirPath)) {
                try (FileReader fileReader = null;){
                    fileReader = new FileReader(file);
                    RakeTask rakeTask = this.loadRakeTasksTree(fileReader);
                    a.debug("Loaded tasks: ", new Object[]{rakeTask});
                    RakeTask rakeTask2 = rakeTask;
                    return rakeTask2;
                }
            }
            a.debug("Cache file does not exists: ", new Object[]{file.exists(), " or obsolete"});
            return null;
        }
        catch (IOException iOException) {
            a.warn(iOException.getMessage());
        }
        return null;
    }

    @Override
    @NotNull
    public String getID() {
        if ("" == null) {
            RakeTasksExternalizer.b(1);
        }
        return "";
    }

    @Nullable
    public RakeTask loadRakeTasksTree(Reader reader) {
        long l2 = i ^ 0x5914009EE5E5L;
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            Document document = sAXBuilder.build(reader);
            Element element = document.getRootElement();
            if (c.equals(element.getName())) {
                for (Object e10 : element.getChildren()) {
                    Element element2;
                    if (!(e10 instanceof Element) || !b.equals((element2 = (Element)e10).getName())) continue;
                    List list2 = element.getChildren();
                    assert (list2.size() == 1);
                    return this.readExternal((Element)list2.get(0), null);
                }
            }
        }
        catch (JDOMException jDOMException) {
            a.warn((Throwable)jDOMException);
        }
        catch (IOException iOException) {
            a.warn((Throwable)iOException);
        }
        return null;
    }

    @NotNull
    public static File getDataFile(@NotNull String railsApplicationHomeDirPath) {
        File file;
        long l2 = i ^ 0x5D81C6196AEDL;
        if (railsApplicationHomeDirPath == null) {
            RakeTasksExternalizer.b(2);
        }
        if ((file = new File(railsApplicationHomeDirPath, ".idea")).isDirectory()) {
            File file2 = new File(file, g);
            if (file2 == null) {
                RakeTasksExternalizer.b(3);
            }
            return file2;
        }
        File file3 = new File(railsApplicationHomeDirPath, g);
        if (file3 == null) {
            RakeTasksExternalizer.b(4);
        }
        return file3;
    }

    private static boolean a(@NotNull File file, @NotNull String string) {
        long l2 = i ^ 0x31E032C3D42AL;
        if (file == null) {
            RakeTasksExternalizer.b(5);
        }
        if (string == null) {
            RakeTasksExternalizer.b(6);
        }
        if (!file.exists()) {
            a.debug("Cached tasks file missing: ", new Object[]{file});
            return false;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(string);
        if (virtualFile == null) {
            a.debug("No application home virtual file: ", new Object[]{string});
            return false;
        }
        VirtualFile virtualFile2 = virtualFile.findChild("lib");
        a.debug("Lib directory: ", new Object[]{virtualFile2});
        VirtualFile virtualFile3 = virtualFile2 != null ? virtualFile2.findChild("tasks") : null;
        a.debug("Tasks directory: ", new Object[]{virtualFile3});
        VirtualFile virtualFile4 = virtualFile.findChild("Rakefile");
        a.debug("Rake file: ", new Object[]{virtualFile4});
        VirtualFile virtualFile5 = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (virtualFile5 == null) {
            a.debug("No cached tasks virtual file: ", new Object[]{file});
            return false;
        }
        long l3 = virtualFile5.getTimeStamp();
        if (VirtualFileUtil.existsNewerThanTimeStamp(virtualFile4, l3)) {
            a.debug("Rakefile ", new Object[]{virtualFile4, " is newer than: ", l3});
            return false;
        }
        if (VirtualFileUtil.existsNewerThanTimeStamp(virtualFile3, l3)) {
            a.debug("Found file newer than a timestamp in ", new Object[]{virtualFile3, "; timestamp: ", l3});
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRakeTasksTree(@NotNull RakeTask rootTask, @NotNull String railsApplicHomeDirPath) {
        File file;
        long l2 = i ^ 0x3118CDD15750L;
        if (rootTask == null) {
            RakeTasksExternalizer.b(7);
        }
        if (railsApplicHomeDirPath == null) {
            RakeTasksExternalizer.b(8);
        }
        if ((file = RakeTasksExternalizer.getDataFile(railsApplicHomeDirPath)) == null) {
            return;
        }
        try {
            if (file.exists() && !file.delete()) {
                a.warn(RBundle.message("settings.raketasks.cant.save.message", file.getPath()));
                return;
            }
            try (FileWriter fileWriter = null;){
                fileWriter = new FileWriter(file);
                this.saveRakeTasksTree(rootTask, fileWriter);
            }
        }
        catch (IOException iOException) {
            a.warn((Throwable)iOException);
        }
    }

    public void saveRakeTasksTree(RakeTask rootTask, Writer writer) {
        long l2 = i ^ 0x5331AB6A813AL;
        Element element = this.writeExternal(rootTask, null);
        Element element2 = new Element(c);
        String string = RBundle.message("settings.raketasks.externalizer.info");
        element2.addContent((Content)new Comment(string));
        element2.addContent(element);
        Document document = new Document(element2);
        XMLOutputter xMLOutputter = new XMLOutputter();
        try {
            xMLOutputter.output(document, writer);
        }
        catch (IOException iOException) {
            a.warn((Throwable)iOException);
        }
    }

    @NotNull
    protected RakeTask readExternal(Element element, RakeTaskSerializableImpl parent) {
        long l2 = i ^ 0x5CE8B619824EL;
        List list2 = element.getChildren();
        RakeTaskSerializableImpl rakeTaskSerializableImpl = new RakeTaskSerializableImpl(this.getAttributeFromElement(f, element), this.getAttributeFromElement(h, element), this.getAttributeFromElement(e, element), b.equals(element.getName()), parent);
        for (Object e10 : list2) {
            Element element2;
            if (!(e10 instanceof Element) || !d.equals((element2 = (Element)e10).getName()) && !b.equals(element2.getName())) continue;
            rakeTaskSerializableImpl.addSubTask(this.readExternal(element2, rakeTaskSerializableImpl));
        }
        RakeTaskSerializableImpl rakeTaskSerializableImpl2 = rakeTaskSerializableImpl;
        if (rakeTaskSerializableImpl2 == null) {
            RakeTasksExternalizer.b(9);
        }
        return rakeTaskSerializableImpl2;
    }

    protected Element writeExternal(@NotNull RakeTask rakeTask, @Nullable Element parent) {
        long l2 = i ^ 0x2B24F29E7066L;
        if (rakeTask == null) {
            RakeTasksExternalizer.b(10);
        }
        Element element = new Element(rakeTask.isGroup() ? b : d);
        this.storeAttributeInElement(h, rakeTask.getDescription(), element);
        this.storeAttributeInElement(e, rakeTask.getFullCommand(), element);
        this.storeAttributeInElement(f, rakeTask.getId(), element);
        if (parent != null) {
            parent.addContent(element);
        }
        List<? extends RakeTask> list2 = rakeTask.getSubTasks();
        for (RakeTask rakeTask2 : list2) {
            this.writeExternal(rakeTask2, element);
        }
        return element;
    }

    static {
        i = com.jetbrains.python.psi.c.a(-1336532298960968703L, -7668101392048393666L, MethodHandles.lookup().lookupClass()).a(208291994738966L);
        a = Logger.getInstance(RakeTasksExternalizer.class);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = i ^ 0x416658CD7DCBL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsApplicationHomeDirPath";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/tasks/rake/RakeTasksExternalizer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedTasksFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTask";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsApplicHomeDirPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rakeTask";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/rake/RakeTasksExternalizer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "readExternal";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadRakeTasksTree";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDataFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "saveRakeTasksTree";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

