/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.ui;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.psi.c;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public class RubySdkRenderer
extends SimpleListCellRenderer<Object> {
    public static final String SEPARATOR = "!!!separator!!!";
    private final Component a = new TitledSeparator();
    private final boolean b;
    private final boolean c;
    private static final long d = com.jetbrains.python.psi.c.a(-6080568708358734473L, -1851708208890741846L, MethodHandles.lookup().lookupClass()).a(188701836544397L);

    public RubySdkRenderer(boolean showHomePath, boolean showLanguageLevel) {
        this.b = showHomePath;
        this.c = showLanguageLevel;
    }

    public final Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        long l2 = d ^ 0x28F26DC7B5F1L;
        return SEPARATOR.equals(value) ? this.a : super.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
    }

    public void customize(JList<?> list2, Object value, int index, boolean selected, boolean hasFocus) {
        long l2 = d ^ 0x119A92162FC8L;
        if (value == null) {
            this.setText(RBundle.message("sdk.renderer.no.sdk.chosen"));
            this.setIcon(RubySdkType.getInstance().getIcon());
        } else if (value instanceof Sdk) {
            Sdk sdk = (Sdk)value;
            this.setIcon(((SdkType)sdk.getSdkType()).getIcon());
            this.setText(RubySdkRenderer.getSdkText(sdk, this.b, this.c));
            this.setForeground(RubySdkUtil.isSDKValid(sdk) ? UIUtil.getListForeground() : JBColor.RED);
        } else if (value instanceof LanguageLevel) {
            this.setText(((LanguageLevel)((Object)value)).getShortName());
        } else {
            this.setText(value.toString());
        }
    }

    public static String getSdkText(@Nullable Sdk sdk) {
        return RubySdkRenderer.getSdkText(sdk, true, true);
    }

    public static String getSdkText(@Nullable Sdk sdk, boolean showHomePath, boolean showLanguageLevel) {
        Object object;
        String string;
        long l2 = d ^ 0x7D4866624621L;
        if (sdk == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(sdk.getName().replaceAll("\\s\\(.*\\)", ""));
        if (showHomePath) {
            string = sdk.getHomePath();
            if (string == null) {
                return "";
            }
            if (!RVMSupportUtil.isRVMInterpreter(sdk)) {
                object = string.replaceFirst(Pattern.quote(SystemProperties.getUserHome()), "~");
                stringBuilder.append(" (").append(RubySdkUtil.getRubySdkAdditionalData(sdk).getSdkSystemAccessor().toSystemDependentName((String)object)).append(")");
            }
        }
        if (showLanguageLevel && !RubySdkUtil.isMRISdk(sdk) && (string = sdk.getSdkAdditionalData()) instanceof RubySdkAdditionalData) {
            object = (RubySdkAdditionalData)((Object)string);
            stringBuilder.append(" [").append(((RubySdkAdditionalData)object).getLanguageLevel().getShortName()).append("]");
        }
        return stringBuilder.toString();
    }

    public static void installSdkNameSpeedSearch(JComboBox sdkComboBox) {
        new ComboboxSpeedSearch(sdkComboBox){

            protected String getElementText(Object element) {
                return element instanceof Sdk ? RubySdkRenderer.getSdkText((Sdk)element) : String.valueOf(element);
            }
        }.setComparator(new SpeedSearchComparator(false));
    }
}

