/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.CommonBundle;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.MockSdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.RubyGemsEnvironment;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.nativerb.RubyStubBuilderService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelPusher;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RbConfig;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkInvalidator;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkLoadPathInitializer;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.utils.OSUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.rvm.LocalRvmPathsSettings;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.system.RubySystemVersionManagerHandler;

public final class RubySdkUtil {
    @NonNls
    private static final String c = "/cygdrive/";
    @NonNls
    private static final String e = "/usr/";
    @NonNls
    public static final String RUBYSTUBS_OLD = "rubystubs";
    @NonNls
    private static final String g = "rubystubs18";
    @NonNls
    private static final String n = "rubystubs19";
    @NonNls
    private static final String m = "rubystubs193";
    @NonNls
    private static final String o = "rubystubs20";
    @NonNls
    private static final String b = "rubystubs21";
    @NonNls
    private static final String j = "rubystubs22";
    @NonNls
    private static final String k = "rubystubs23";
    @NonNls
    private static final String l = "rubystubs24";
    @NonNls
    private static final String i = "rubystubs25";
    @NonNls
    private static final String d = "rubystubs26";
    @NonNls
    private static final String f = "rubystubs27";
    private static final Logger a;
    @NonNls
    private static final Pattern h;
    private static final long p;

    private RubySdkUtil() {
    }

    public static boolean isRubySDK(@Nullable Sdk sdk) {
        return sdk != null && RubySdkUtil.isRubySdkType(sdk.getSdkType());
    }

    public static boolean isRubySdkType(@Nullable SdkTypeId sdkTypeId) {
        return sdkTypeId instanceof RubySdkType;
    }

    public static boolean isSDKValid(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubySdkUtil.isRubyInterpreterExist(sdk);
    }

    public static boolean isRubyInterpreterExist(@Nullable Sdk rubySdk) {
        if (rubySdk == null) {
            return false;
        }
        return rubySdk instanceof MockSdk ? ((RubySdkType)rubySdk.getSdkType()).isValidSdkHome(rubySdk.getHomePath(), false) : ((RubySdkType)rubySdk.getSdkType()).isValidSdkHome(rubySdk.getHomePath());
    }

    public static boolean isRubySdkDisposed(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkUtil.a(0);
        }
        return !RubySdkInvalidator.isValid(sdk);
    }

    public static void checkIfRubySdkDisposed(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkUtil.a(1);
        }
        if (RubySdkUtil.isRubySdkDisposed(sdk)) {
            throw new ProcessCanceledException();
        }
    }

    @NotNull
    public static String getGemsBinFolderPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkUtil.a(2);
        }
        String string = RubySdkAdditionalData.notNullFrom(sdk).getGemsBinDirectory();
        if (string == null) {
            RubySdkUtil.a(3);
        }
        return string;
    }

    public static VirtualFile[] getSdkRoots(@NotNull Sdk sdk) {
        SdkAdditionalData sdkAdditionalData;
        long l2 = p ^ 0x27B635547D64L;
        if (sdk == null) {
            RubySdkUtil.a(4);
        }
        if ((sdkAdditionalData = sdk.getSdkAdditionalData()) instanceof RubySdkAdditionalData && !((RubySdkAdditionalData)sdkAdditionalData).myInitializedPaths) {
            if (a.isDebugEnabled()) {
                a.debug("Requesting immediate init for " + sdk + "; isDispatchThread=" + ApplicationManager.getApplication().isDispatchThread());
            }
            if (ApplicationManager.getApplication().isDispatchThread()) {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> RubySdkLoadPathInitializer.INSTANCE.requestInitializationSynchronized(sdk), "Initializing SDK" + sdk.getName(), false, null);
            } else {
                RubySdkLoadPathInitializer.INSTANCE.requestInitializationSynchronized(sdk);
            }
            List<VirtualFile> list2 = ((RubySdkAdditionalData)sdkAdditionalData).myTemporaryRoots;
            if (list2 != null) {
                a.debug("Taken temporary results because modificator is not committed yet");
                return list2.toArray(VirtualFile.EMPTY_ARRAY);
            }
        }
        return sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
    }

    @Deprecated
    @NotNull
    public static RubySdkAdditionalData getRubySdkAdditionalData(@NotNull Sdk sdk) {
        SdkAdditionalData sdkAdditionalData;
        long l2 = p ^ 0x57A7B324152DL;
        if (sdk == null) {
            RubySdkUtil.a(5);
        }
        if (!((sdkAdditionalData = sdk.getSdkAdditionalData()) instanceof RubySdkAdditionalData)) {
            throw new IllegalArgumentException("Unexpected type of sdk (" + sdk + ") addition data - " + sdkAdditionalData);
        }
        RubySdkAdditionalData rubySdkAdditionalData = (RubySdkAdditionalData)sdkAdditionalData;
        if (rubySdkAdditionalData == null) {
            RubySdkUtil.a(6);
        }
        return rubySdkAdditionalData;
    }

    public static PathMappingSettings getDefaultPathMappings(@NotNull Sdk sdk, @Nullable Module module2) {
        if (sdk == null) {
            RubySdkUtil.a(7);
        }
        return RubySdkUtil.getRubySdkAdditionalData(sdk).getRunnerMappings(module2);
    }

    public static VirtualFile[] getSdkRootsWithAllGems(@NotNull Sdk sdk, @Nullable Project project) {
        if (sdk == null) {
            RubySdkUtil.a(8);
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        ContainerUtil.addAll(arrayList, (Object[])RubySdkUtil.getSdkRoots(sdk));
        if (project != null) {
            for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
                for (GemInfo gemInfo : GemManager.getAllGems(module2)) {
                    VirtualFile virtualFile;
                    VirtualFile virtualFile2;
                    VirtualFile virtualFile3 = virtualFile2 = ApplicationManager.getApplication().isUnitTestMode() ? null : RubyStubBuilderService.getInstance().getStubs(gemInfo);
                    if (virtualFile2 != null) {
                        arrayList.add(virtualFile2);
                    }
                    if ((virtualFile = gemInfo.getLibFolder()) == null) continue;
                    arrayList.add(virtualFile);
                }
            }
        }
        return VfsUtilCore.toVirtualFileArray(arrayList);
    }

    public static Sdk findOrCreateMockSdk(SdkType sdkType, String versionName, String interpreterPath, List<String> sdkRoots) {
        List list2 = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)sdkType);
        for (Sdk sdk : list2) {
            if (!sdk.getName().equals(versionName) || !StringUtil.equals((CharSequence)sdk.getHomePath(), (CharSequence)interpreterPath) || !RubySdkUtil.a(sdk, sdkRoots)) continue;
            return sdk;
        }
        return RubySdkUtil.createMockSdk(sdkType, versionName, interpreterPath, sdkRoots);
    }

    private static boolean a(Sdk sdk, List<String> list2) {
        VirtualFile[] virtualFileArray = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
        if (virtualFileArray.length != list2.size()) {
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (VirtualFile virtualFile : virtualFileArray) {
            hashSet.add(virtualFile.getPath());
        }
        for (String string : list2) {
            if (hashSet.contains(string)) continue;
            return false;
        }
        return true;
    }

    public static Sdk createMockSdk(SdkType sdkType, String versionName, String interpreterPath, List<String> sdkRoots) {
        Object object;
        Object object2;
        long l2 = p ^ 0x36697028E693L;
        MultiMap multiMap = MultiMap.create();
        Sdk sdk = new MockSdk(versionName, interpreterPath, versionName, multiMap, (SdkTypeId)sdkType).clone();
        RubyGemsEnvironment.init((MockSdk)sdk);
        SdkModificator sdkModificator = sdk.getSdkModificator();
        sdkModificator.setHomePath(interpreterPath);
        Object object3 = sdkRoots.iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            if (VirtualFileManager.extractProtocol((String)object2) == null) {
                object2 = VfsUtilCore.pathToUrl((String)object2);
            }
            if ((object = VirtualFileManager.getInstance().findFileByUrl((String)object2)) == null) continue;
            if (object.getFileType() == ArchiveFileType.INSTANCE) {
                object = JarFileSystem.getInstance().getJarRootForLocalFile(object);
                RubySdkUtil.addToSourceAndClasses(sdkModificator, object != null ? object.findFileByRelativePath("META-INF/jruby.home/lib/ruby/1.8") : null);
            }
            RubySdkUtil.addToSourceAndClasses(sdkModificator, object);
        }
        if (sdkType instanceof RubySdkType && sdkModificator instanceof Sdk) {
            object3 = new RubySdkAdditionalData();
            if (RVMSupportUtil.isRVMInterpreter(interpreterPath, LocalRvmPathsSettings.getInstance())) {
                ((RubySdkAdditionalData)object3).withVersionManagerSdkAdditionalData((RubyVersionManagerSdkData)RvmVersionManagerHandler.getInstance().createAdditionalData().withDistributionId(Paths.get(interpreterPath, new String[0]).getParent().getParent().getFileName().toString(), null).withVersionManagerPath("mock_rvm_path"));
            } else {
                ((RubySdkAdditionalData)object3).withVersionManagerSdkAdditionalData(RubySystemVersionManagerHandler.getInstance().createAdditionalData());
            }
            RbConfig.initEmpty((RubySdkAdditionalData)object3);
            sdkModificator.setSdkAdditionalData((SdkAdditionalData)object3);
            object2 = sdk.getVersionString();
            ((RubySdkAdditionalData)object3).setNormalizedVersionString((String)object2);
            object = RubyVersionUtil.extractLanguageLevelFromVersion((String)object2);
            ((RubySdkAdditionalData)object3).setLanguageLevel((LanguageLevel)((Object)object));
            ((RubySdkAdditionalData)object3).setGemsBinDirectory(((RubySdkAdditionalData)object3).computeInterpreterDir(interpreterPath));
            ((RubySdkAdditionalData)object3).setGemsRootUrls(Collections.emptyList());
        }
        if ((object3 = sdkModificator.getSdkAdditionalData()) instanceof RubySdkAdditionalData) {
            object2 = RubySdkType.findGemsRoots(sdkModificator);
            ((RubySdkAdditionalData)object3).setGemsRootUrls((List<String>)object2);
        }
        sdkModificator.commitChanges();
        return sdk;
    }

    static void addToSourceAndClasses(@NotNull SdkModificator sdkModificator, @Nullable VirtualFile vFile) {
        if (sdkModificator == null) {
            RubySdkUtil.a(9);
        }
        if (vFile != null) {
            sdkModificator.addRoot(vFile, OrderRootType.CLASSES);
            sdkModificator.addRoot(vFile, OrderRootType.SOURCES);
        }
    }

    @NotNull
    private static List<String> a(@NotNull RubySdkType rubySdkType) {
        if (rubySdkType == null) {
            RubySdkUtil.a(10);
        }
        String string = rubySdkType.getRubyExecutable();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (SystemInfo.isMac) {
            arrayList.addAll(OSUtil.findExecutableInMacOSProfile(string));
        } else if (SystemInfo.isWindows) {
            arrayList.addAll(OSUtil.findExecutableOnWindowsRootAndProgramFiles(string));
        }
        arrayList.addAll(OSUtil.findExecutablesByName(string));
        ArrayList<String> arrayList2 = arrayList;
        if (arrayList2 == null) {
            RubySdkUtil.a(11);
        }
        return arrayList2;
    }

    public static Collection<String> suggestRubyHomePaths(RubySdkType type, String[] winDefaultHomePaths, String[] unixDefaultHomePaths) {
        HashSet<String> hashSet = new HashSet<String>(RubySdkUtil.a(type));
        if (SystemInfo.isWindows) {
            for (String string : winDefaultHomePaths) {
                RubySdkUtil.a(string, hashSet);
            }
        }
        if (SystemInfo.isUnix) {
            for (String string : unixDefaultHomePaths) {
                RubySdkUtil.a(string, hashSet);
            }
        }
        return hashSet;
    }

    private static void a(String string, Set<String> set) {
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            set.add(string);
        }
    }

    public static String unCygwinizePath(@NotNull Sdk sdk, String path) {
        long l2 = p ^ 0x27902309AD61L;
        if (sdk == null) {
            RubySdkUtil.a(12);
        }
        if (!RubySdkUtil.getRubySdkAdditionalData(sdk).getSdkSystemAccessor().isWindows() || !path.contains("/") || JRubySdkUtil.isJRubySDK(sdk)) {
            return path;
        }
        if (path.startsWith(c)) {
            path = path.substring(c.length());
            return path.charAt(0) + ":" + path.substring(1);
        }
        if (path.startsWith(e)) {
            RubySdkType rubySdkType = (RubySdkType)sdk.getSdkType();
            VirtualFile virtualFile = sdk.getHomeDirectory();
            assert (virtualFile != null) : "sdk home directory must not bee null (" + sdk + ")";
            String string = virtualFile.getPath().replace(rubySdkType.getRubyExecutable(), "");
            String string2 = "bin/";
            String string3 = string.endsWith("bin/") ? string.substring(0, string.length() - "bin/".length()) : string;
            path = path.replaceFirst(e, string3);
        }
        return path;
    }

    public static String cygwinizePath(Sdk sdk, String path) {
        long l2 = p ^ 0x469393984E5CL;
        if (sdk == null || !SystemInfo.isWindows || JRubySdkUtil.isJRubySDK(sdk)) {
            return path;
        }
        if (!RubySdkUtil.a(RubySdkType.getPlatform(sdk))) {
            return path;
        }
        Matcher matcher = h.matcher(path);
        if (matcher.matches()) {
            String string = matcher.group(2);
            return path.replace(matcher.group(1), c + string + "/").replace('\\', '/');
        }
        return path;
    }

    public static String getStubsFolder(@NotNull Sdk sdk) {
        long l2 = p ^ 0x2672E380CA66L;
        if (sdk == null) {
            RubySdkUtil.a(13);
        }
        if (RubySdkUtil.a(sdk)) {
            return m;
        }
        return RubySdkUtil.getStubsFolder(RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk));
    }

    private static boolean a(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkUtil.a(14);
        }
        return RubySdkUtil.b(sdk) || JRubySdkUtil.isJRubySDK(sdk) && RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk) == LanguageLevel.RUBY19 && JRubySdkUtil.isJRubyGreaterThan17(sdk);
    }

    private static boolean b(@NotNull Sdk sdk) {
        long l2 = p ^ 0x74C5090B4CC7L;
        if (sdk == null) {
            RubySdkUtil.a(15);
        }
        String string = sdk.getVersionString();
        return RubySdkUtil.isRuby19(sdk) && RubySdkUtil.isMRISdk(sdk) && string != null && string.contains("1.9.3");
    }

    public static String getStubsFolder(LanguageLevel level) {
        long l2 = p ^ 0x597DA406EA39L;
        switch (level) {
            case RUBY27: {
                return f;
            }
            case RUBY26: {
                return d;
            }
            case RUBY25: {
                return i;
            }
            case RUBY24: {
                return l;
            }
            case RUBY23: {
                return k;
            }
            case RUBY22: {
                return j;
            }
            case RUBY21: {
                return b;
            }
            case RUBY20: {
                return o;
            }
            case RUBY19: {
                return n;
            }
            case RUBY18: {
                return g;
            }
        }
        throw new IllegalArgumentException("unexpected language level - " + (Object)((Object)level));
    }

    public static boolean isRuby18(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk) == LanguageLevel.RUBY18;
    }

    public static boolean isRuby19(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk) == LanguageLevel.RUBY19;
    }

    public static boolean isRuby20(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk) == LanguageLevel.RUBY20;
    }

    public static boolean isRuby21(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk) == LanguageLevel.RUBY21;
    }

    public static boolean isRuby22(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk) == LanguageLevel.RUBY22;
    }

    public static boolean isRuby23(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk) == LanguageLevel.RUBY23;
    }

    public static boolean isRuby24(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk) == LanguageLevel.RUBY24;
    }

    public static boolean isRuby25(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk) == LanguageLevel.RUBY25;
    }

    public static boolean isRuby26(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk) == LanguageLevel.RUBY26;
    }

    public static boolean isRuby27(@Nullable Sdk sdk) {
        return RubySdkUtil.isRubySDK(sdk) && RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk) == LanguageLevel.RUBY27;
    }

    public static boolean isNativeRuby19(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby19(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isNativeRuby20(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby20(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isNativeRuby21(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby21(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isNativeRuby22(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby22(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isNativeRuby23(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby23(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isNativeRuby24(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby24(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isNativeRuby25(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby25(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isNativeRuby26(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby26(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isNativeRuby27(@Nullable Sdk sdk) {
        return RubySdkUtil.isRuby27(sdk) && !JRubySdkUtil.isJRubySDK(sdk);
    }

    public static boolean isMRISdk(@Nullable Sdk sdk) {
        long l2 = p ^ 0x4BD5958B2619L;
        if (sdk == null) {
            return false;
        }
        if (RVMSupportUtil.isRVMInterpreter(sdk)) {
            return RVMSupportUtil.isMRIRubyRvmSdk(sdk);
        }
        if (JRubySdkUtil.isJRubySDK(sdk)) {
            return false;
        }
        if (RubySdkUtil.isMacRuby(sdk) || RubySdkUtil.isIronRuby(sdk) || RubySdkUtil.isRubinius(sdk)) {
            return false;
        }
        VirtualFile virtualFile = sdk.getHomeDirectory();
        if (virtualFile != null) {
            String string = virtualFile.getNameWithoutExtension();
            return StringUtil.toLowerCase((String)string).startsWith("ruby");
        }
        String string = sdk.getHomePath();
        if (string == null) {
            return false;
        }
        String string2 = FileUtil.toSystemIndependentName((String)string);
        boolean bl2 = RubySdkUtil.getRubySdkAdditionalData(sdk).getSdkSystemAccessor().isWindows();
        return bl2 ? string2.endsWith("/ruby.exe") || string2.endsWith("/ruby.bat") || string2.endsWith("/ruby.cmd") : string2.endsWith("/ruby");
    }

    public static String getRubySdkIsntSetOrValideErrorText() {
        long l2 = p ^ 0x552E7FD4CA91L;
        return RBundle.message("progress.dialog.generate.common.help.no.sdk.set", PlatformUtils.isRubyMine() ? RBundle.message("progress.dialog.generate.common.help.no.sdk.set.rubymine", CommonBundle.settingsActionPath()) : RBundle.message("progress.dialog.generate.common.help.no.sdk.set.ruby.plugin"));
    }

    public static boolean canChangeLanguageLevel(@Nullable Sdk sdk) {
        long l2 = p ^ 0x132FFEA0427AL;
        if (sdk == null) {
            return false;
        }
        String string = JRubySdkUtil.getJRubyShortVersion(sdk.getVersionString());
        String string2 = RubyVersionUtil.getRubiniusShortVersion(sdk.getVersionString());
        return JRubySdkUtil.isJRubySDK(sdk) && string != null && VersionComparatorUtil.compare((String)string, (String)"9.0.0.0.snapshot") < 0 || RubySdkUtil.isRubinius(sdk) && string2 != null && VersionComparatorUtil.compare((String)string2, (String)"2.0.0pre") <= 0;
    }

    @NotNull
    public static LanguageLevel[] getSupportedLanguageLevels(@Nullable Sdk sdk) {
        if (!RubySdkUtil.canChangeLanguageLevel(sdk)) {
            LanguageLevel[] languageLevelArray = new LanguageLevel[]{RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk)};
            if (languageLevelArray == null) {
                RubySdkUtil.a(16);
            }
            return languageLevelArray;
        }
        if (JRubySdkUtil.isJRubySDK(sdk)) {
            LanguageLevel[] languageLevelArray = JRubySdkUtil.getSupportedLanguageLevels(sdk);
            if (languageLevelArray == null) {
                RubySdkUtil.a(17);
            }
            return languageLevelArray;
        }
        LanguageLevel[] languageLevelArray = new LanguageLevel[]{LanguageLevel.RUBY18, LanguageLevel.RUBY19};
        if (languageLevelArray == null) {
            RubySdkUtil.a(18);
        }
        return languageLevelArray;
    }

    public static boolean isMswin32(@Nullable String platform) {
        long l2 = p ^ 0x502A06E67DE1L;
        return platform != null && platform.contains("mswin32");
    }

    public static boolean isMingw32(@Nullable String platform) {
        long l2 = p ^ 0x3D896C830561L;
        return platform != null && platform.contains("mingw32");
    }

    private static boolean a(@Nullable String string) {
        long l2 = p ^ 0x7FB7C0865D3AL;
        return string != null && string.contains("cygwin");
    }

    public static boolean isWindows(@Nullable String platform) {
        return RubySdkUtil.isMingw32(platform) || RubySdkUtil.isMswin32(platform) || RubySdkUtil.a(platform);
    }

    public static boolean isIronRuby(@Nullable Sdk sdk) {
        return sdk != null && RubyVersionUtil.isIronRuby(sdk.getVersionString());
    }

    public static boolean isMacRuby(@Nullable Sdk sdk) {
        return sdk != null && RubyVersionUtil.isMacRuby(sdk.getVersionString());
    }

    public static boolean isRubinius(@Nullable Sdk sdk) {
        return sdk != null && RubyVersionUtil.isRubinius(sdk.getVersionString());
    }

    public static boolean isMaglev(@Nullable Sdk sdk) {
        return sdk != null && RubyVersionUtil.isMaglev(sdk.getVersionString());
    }

    public static boolean equalSdks(@Nullable Sdk sdk1, @Nullable Sdk sdk2) {
        if (sdk1 == null || sdk2 == null) {
            return sdk1 == sdk2;
        }
        return sdk1.getSdkType() == sdk2.getSdkType() && Objects.equals(sdk1.getSdkAdditionalData(), sdk2.getSdkAdditionalData());
    }

    @Contract(value="null, null -> null")
    @Nullable
    public static Sdk getEffectiveSdk(@Nullable Sdk sdk, @Nullable Module module2) {
        return RubySdkUtil.isRubySDK(sdk) ? sdk : RModuleUtil.getInstance().findRubySdkForModule(module2);
    }

    static {
        p = com.jetbrains.python.psi.c.a(-1347095933863833793L, -8291211015811538294L, MethodHandles.lookup().lookupClass()).a(104280333944752L);
        long l2 = p ^ 0x3DB3654899C0L;
        a = Logger.getInstance(RubySdkUtil.class);
        h = Pattern.compile("(([a-zA-Z]):[\\\\/]).*");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = p ^ 0x37238F6FF955L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsBinFolderPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRubySdkAdditionalData";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findInterpreters";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedLanguageLevels";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isRubySdkDisposed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkIfRubySdkDisposed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getGemsBinFolderPath";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSdkRoots";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRubySdkAdditionalData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPathMappings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSdkRootsWithAllGems";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addToSourceAndClasses";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findInterpreters";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "unCygwinizePath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStubsFolder";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "use193Stubs";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isMRI193";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

