/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.ValidatableSdkAdditionalData;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.LocalRubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RbConfig;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.b;
import org.jetbrains.plugins.ruby.ruby.sdk.implementation.RubyImplementationHandler;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.rvm.LocalRvmPathsSettings;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSettings;

public class RubySdkAdditionalData
implements ValidatableSdkAdditionalData {
    @NonNls
    private static final String i = "PLATFORM";
    @NonNls
    private static final String m = "GEMS_BIN_DIR_PATH";
    @NonNls
    private static final String f = "GEMS_ROOTS_URLS_ROOT";
    @NonNls
    private static final String j = "GEMS_ROOTS_URL";
    @NonNls
    private static final String b = "NORMALIZED_VERSION_STRING";
    private static final RubySdkAdditionalData c;
    protected static final Logger LOG;
    volatile transient boolean myIsInitialized;
    volatile transient boolean myInitializedPaths;
    @Nullable
    volatile transient List<VirtualFile> myTemporaryRoots;
    @Nullable
    private String g;
    private List<String> h;
    private LanguageLevel e;
    private String d;
    @Nullable
    private RubyVersionManagerSdkData l;
    @Nullable
    private RbConfig a;
    @Nullable
    private String k;
    private static final long x;

    protected RubySdkAdditionalData() {
        this.myIsInitialized = false;
        this.myInitializedPaths = true;
        this.myTemporaryRoots = null;
    }

    public RubySdkAdditionalData(@NotNull RubySdkAdditionalData original) {
        if (original == null) {
            RubySdkAdditionalData.a(0);
        }
        this.myIsInitialized = false;
        this.myInitializedPaths = true;
        this.myTemporaryRoots = null;
        this.myIsInitialized = original.myIsInitialized;
        this.myInitializedPaths = original.myInitializedPaths;
        this.myTemporaryRoots = RubySdkAdditionalData.a(original.myTemporaryRoots);
        this.g = original.g;
        this.h = RubySdkAdditionalData.a(original.h);
        this.e = original.e;
        this.d = original.d;
        this.l = Objects.requireNonNull(original.l).copy();
        this.k = original.k;
        this.a = original.a;
    }

    @Contract(pure=true, value="null->null; !null -> !null")
    @Nullable
    private static <T> List<T> a(@Nullable List<T> list2) {
        return list2 == null ? null : new ArrayList<T>(list2);
    }

    @NotNull
    public RubyVersionManagerSdkData getVersionManagerSdkAdditionalData() {
        long l2 = x ^ 0x1D3F06C64C86L;
        RubyVersionManagerSdkData rubyVersionManagerSdkData = Objects.requireNonNull(this.l, "Attempt to fetch data before initialization");
        if (rubyVersionManagerSdkData == null) {
            RubySdkAdditionalData.a(1);
        }
        return rubyVersionManagerSdkData;
    }

    @NotNull
    public RbConfig getRbConfig() {
        RbConfig rbConfig = Objects.requireNonNull(this.a);
        if (rbConfig == null) {
            RubySdkAdditionalData.a(2);
        }
        return rbConfig;
    }

    public void setRbConfig(@NotNull RbConfig rbConfig) {
        if (rbConfig == null) {
            RubySdkAdditionalData.a(3);
        }
        this.a = rbConfig;
    }

    @NotNull
    public RubySdkAdditionalData withVersionManagerSdkAdditionalData(@NotNull RubyVersionManagerSdkData versionManagerSdkAdditionalData) {
        if (versionManagerSdkAdditionalData == null) {
            RubySdkAdditionalData.a(4);
        }
        this.l = versionManagerSdkAdditionalData;
        RubySdkAdditionalData rubySdkAdditionalData = this;
        if (rubySdkAdditionalData == null) {
            RubySdkAdditionalData.a(5);
        }
        return rubySdkAdditionalData;
    }

    @NotNull
    public String getGemsBinDirectory() {
        long l2 = x ^ 0x2E6695774649L;
        String string = Objects.requireNonNull(this.g, "Attempt to fetch data before initialization");
        if (string == null) {
            RubySdkAdditionalData.a(6);
        }
        return string;
    }

    public void setGemsBinDirectory(@NotNull String path) {
        if (path == null) {
            RubySdkAdditionalData.a(7);
        }
        this.g = path;
    }

    @Contract(pure=true)
    public boolean hasGemsBinDirectory() {
        return this.g != null;
    }

    public List<? extends String> getGemsRootUrls() {
        return this.h;
    }

    public void setGemsRootUrls(@NotNull List<String> urls) {
        if (urls == null) {
            RubySdkAdditionalData.a(8);
        }
        this.h = Collections.unmodifiableList(urls);
    }

    public void checkValid(SdkModel sdkModel) throws ConfigurationException {
        long l2 = x ^ 0x38EC1F5E0AB0L;
        File file = new File(this.getGemsBinDirectory());
        if (!file.exists()) {
            throw new ConfigurationException(RBundle.message("sdk.error.gems.bindir.doesnt.exist"));
        }
        if (!file.isDirectory()) {
            throw new ConfigurationException(RBundle.message("sdk.error.gems.bindir.isnt.directory"));
        }
    }

    public void save(@NotNull Element rootElement) {
        long l2 = x ^ 0x10ED6B9985EAL;
        if (rootElement == null) {
            RubySdkAdditionalData.a(9);
        }
        if (this.k != null) {
            rootElement.setAttribute(b, this.k);
        }
        if (this.getPlatform() != null) {
            rootElement.setAttribute(i, this.getPlatform());
        }
        assert (this.l != null);
        this.l.save(rootElement);
        this.getRbConfig().save(rootElement);
        rootElement.setAttribute(m, this.getGemsBinDirectory());
        for (String string : this.h) {
            Element element = new Element(f);
            element.setAttribute(j, string);
            rootElement.addContent(element);
        }
    }

    @NotNull
    public String getInterpreterPath(@NotNull Sdk sdk) {
        long l2 = x ^ 0x16A32BE18F62L;
        if (sdk == null) {
            RubySdkAdditionalData.a(10);
        }
        if (!this.equals(sdk.getSdkAdditionalData())) {
            throw new IllegalArgumentException("Wrong sdk - " + sdk);
        }
        String string = sdk.getHomePath();
        assert (string != null);
        String string2 = string;
        if (string2 == null) {
            RubySdkAdditionalData.a(11);
        }
        return string2;
    }

    @NotNull
    public static String getInterpreterPathFor(@NotNull Sdk rubySdk) {
        if (rubySdk == null) {
            RubySdkAdditionalData.a(12);
        }
        String string = RubySdkAdditionalData.notNullFrom(rubySdk).getInterpreterPath(rubySdk);
        if (string == null) {
            RubySdkAdditionalData.a(13);
        }
        return string;
    }

    public LanguageLevel getLanguageLevel() {
        return this.e;
    }

    public void setLanguageLevel(LanguageLevel languageLevel) {
        this.e = languageLevel;
    }

    public String getPlatform() {
        return this.d;
    }

    public void setPlatform(String platform) {
        this.d = platform;
    }

    @NotNull
    public RubyRunner getRunner(@Nullable Module module2) {
        RubyLocalRunner rubyLocalRunner = RubyLocalRunner.getRunner(module2);
        if (rubyLocalRunner == null) {
            RubySdkAdditionalData.a(14);
        }
        return rubyLocalRunner;
    }

    @NotNull
    public PathMappingSettings getRunnerMappings(@Nullable Module module2) {
        PathMappingSettings pathMappingSettings = this.getRunnerMappings(module2, null);
        if (pathMappingSettings == null) {
            RubySdkAdditionalData.a(15);
        }
        return pathMappingSettings;
    }

    @NotNull
    public PathMappingSettings getRunnerMappings(@NotNull AbstractRubyRunConfiguration configurationParams) {
        if (configurationParams == null) {
            RubySdkAdditionalData.a(16);
        }
        PathMappingSettings pathMappingSettings = this.getRunnerMappings(configurationParams.getModule(), configurationParams.getMappingSettings());
        if (pathMappingSettings == null) {
            RubySdkAdditionalData.a(17);
        }
        return pathMappingSettings;
    }

    @NotNull
    public PathMappingSettings getRunnerMappings(@Nullable Module module2, @Nullable PathMappingSettings baseMappings) {
        PathMappingSettings pathMappingSettings = this.getRunner(module2).addDefaultMappings(baseMappings);
        if (pathMappingSettings == null) {
            RubySdkAdditionalData.a(18);
        }
        return pathMappingSettings;
    }

    @NotNull
    public RubySdkSystemAccessor getSdkSystemAccessor() {
        LocalRubySdkSystemAccessor localRubySdkSystemAccessor = LocalRubySdkSystemAccessor.getInstance();
        if (localRubySdkSystemAccessor == null) {
            RubySdkAdditionalData.a(19);
        }
        return localRubySdkSystemAccessor;
    }

    @NotNull
    public RvmSettings getRvmSettings() {
        LocalRvmPathsSettings localRvmPathsSettings = LocalRvmPathsSettings.getInstance();
        if (localRvmPathsSettings == null) {
            RubySdkAdditionalData.a(20);
        }
        return localRvmPathsSettings;
    }

    @NotNull
    public String getConnectionCredentialId() {
        if ("" == null) {
            RubySdkAdditionalData.a(21);
        }
        return "";
    }

    @Nullable
    public String getNormalizedVersionString() {
        return this.k;
    }

    public void setNormalizedVersionString(@Nullable String normalizedVersionString) {
        this.k = normalizedVersionString;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        return this.fieldsEqual((RubySdkAdditionalData)o2);
    }

    protected boolean fieldsEqual(@NotNull RubySdkAdditionalData data) {
        if (data == null) {
            RubySdkAdditionalData.a(22);
        }
        if (this.g != null ? !this.g.equals(data.g) : data.g != null) {
            return false;
        }
        if (this.d != null ? !this.d.equals(data.d) : data.d != null) {
            return false;
        }
        return !(this.l != null ? !this.l.equals(data.l) : data.l != null);
    }

    @NotNull
    protected final String computeInterpreterDir(@NotNull String interpreterPath) {
        String string;
        long l2 = x ^ 0x38D73BCAD90BL;
        if (interpreterPath == null) {
            RubySdkAdditionalData.a(23);
        }
        if ((string = new File(interpreterPath).getParent()) == null) {
            throw new IllegalArgumentException("Incorrect interpreter path: " + interpreterPath);
        }
        String string2 = this.getSdkSystemAccessor().toSystemDependentName(string);
        if (string2 == null) {
            RubySdkAdditionalData.a(24);
        }
        return string2;
    }

    public int hashCode() {
        return this.fieldsHashCode();
    }

    protected void doAddLoadPathMappings(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkAdditionalData.a(25);
        }
    }

    public static void addLoadPathMappings(@Nullable Sdk sdk) {
        RubySdkAdditionalData rubySdkAdditionalData = RubySdkAdditionalData.from(sdk);
        if (rubySdkAdditionalData != null) {
            rubySdkAdditionalData.doAddLoadPathMappings(sdk);
        }
    }

    public Set<String> buildSdkLoadPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkAdditionalData.a(26);
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        RubyImplementationHandler.notNullFrom(sdk).getLoadPath().forEach(string -> linkedHashSet.add(VirtualFileUtil.constructLocalUrl(RubySdkUtil.unCygwinizePath(sdk, string))));
        if (JRubySdkUtil.isJRubySDK(sdk)) {
            linkedHashSet.add(JRubySdkUtil.getSourcesPathInJRubyJarFile(sdk, null));
        }
        RubySdkType.addRubyStubsUrls(linkedHashSet, sdk);
        return linkedHashSet;
    }

    protected int fieldsHashCode() {
        int n2 = this.g != null ? this.g.hashCode() : 0;
        n2 = 31 * n2 + (this.d != null ? this.d.hashCode() : 0);
        n2 = 31 * n2 + (this.l != null ? this.l.hashCode() : 0);
        return n2;
    }

    @NotNull
    public static String getInterpreterDir(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkAdditionalData.a(27);
        }
        RubySdkAdditionalData rubySdkAdditionalData = RubySdkAdditionalData.notNullFrom(sdk);
        String string = rubySdkAdditionalData.computeInterpreterDir(rubySdkAdditionalData.getInterpreterPath(sdk));
        if (string == null) {
            RubySdkAdditionalData.a(28);
        }
        return string;
    }

    @NotNull
    public static <T extends RubySdkAdditionalData> T load(@NotNull T data, @NotNull String interpreterPath, @NotNull Sdk sdk, @NotNull Element element) {
        String string;
        long l2 = x ^ 0x585E29E8811BL;
        if (data == null) {
            RubySdkAdditionalData.a(29);
        }
        if (interpreterPath == null) {
            RubySdkAdditionalData.a(30);
        }
        if (sdk == null) {
            RubySdkAdditionalData.a(31);
        }
        if (element == null) {
            RubySdkAdditionalData.a(32);
        }
        if ((string = element.getAttributeValue(b)) == null) {
            string = sdk.getVersionString();
        }
        data.setNormalizedVersionString(string);
        data.setLanguageLevel(RubyVersionUtil.extractLanguageLevelFromVersion(string));
        data.withVersionManagerSdkAdditionalData(RubyVersionManagerSdkData.load(element, interpreterPath));
        data.setRbConfig(RbConfig.load(element));
        String string2 = element.getAttributeValue(m);
        if (string2 != null) {
            data.setGemsBinDirectory(string2);
        }
        String string3 = element.getAttributeValue(i);
        if (string3 == null && SystemInfo.isWindows && !ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                data.setPlatform(RubyVersionUtil.extractPlatformFromVersion(RubyVersionUtil.getFullVersion(data.getRunner(null), interpreterPath, false)));
            }
            catch (ExecutionException executionException) {
                LOG.error((Throwable)executionException);
            }
        } else {
            data.setPlatform(string3);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        List list2 = element.getChildren(f);
        if (list2.isEmpty()) {
            if (sdk instanceof SdkModificator) {
                linkedList.addAll(RubySdkType.findGemsRoots((SdkModificator)sdk));
            }
        } else {
            for (Element element2 : list2) {
                Attribute attribute = element2.getAttribute(j);
                if (attribute == null) continue;
                linkedList.add(attribute.getValue());
            }
        }
        data.setGemsRootUrls(linkedList);
        T t2 = data;
        if (t2 == null) {
            RubySdkAdditionalData.a(33);
        }
        return t2;
    }

    @Nullable
    @Contract(value="null -> null", pure=true)
    public static RubySdkAdditionalData from(@Nullable Sdk sdk) {
        if (sdk == null) {
            return null;
        }
        SdkAdditionalData sdkAdditionalData = sdk.getSdkAdditionalData();
        return sdkAdditionalData instanceof RubySdkAdditionalData ? (RubySdkAdditionalData)sdkAdditionalData : null;
    }

    @NotNull
    @Contract(value="!null -> !null")
    public static RubySdkAdditionalData notNullFrom(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkAdditionalData.a(34);
        }
        RubySdkAdditionalData rubySdkAdditionalData = Objects.requireNonNull(RubySdkAdditionalData.from(sdk), () -> {
            long l2 = x ^ 0xFF5E48A4723L;
            return "Failed to extract sdk data from " + sdk;
        });
        if (rubySdkAdditionalData == null) {
            RubySdkAdditionalData.a(35);
        }
        return rubySdkAdditionalData;
    }

    @NotNull
    public static RubySdkAdditionalData getEmpty() {
        RubySdkAdditionalData rubySdkAdditionalData = c;
        if (rubySdkAdditionalData == null) {
            RubySdkAdditionalData.a(36);
        }
        return rubySdkAdditionalData;
    }

    public static boolean isEmpty(@NotNull Sdk sdk) {
        RubySdkAdditionalData rubySdkAdditionalData;
        if (sdk == null) {
            RubySdkAdditionalData.a(37);
        }
        return (rubySdkAdditionalData = RubySdkAdditionalData.from(sdk)) == null || rubySdkAdditionalData == c;
    }

    public static boolean areGemsUserLocal(@NotNull Sdk rubySdk) {
        if (rubySdk == null) {
            RubySdkAdditionalData.a(38);
        }
        return RubySdkSystemAccessor.notNullFrom(rubySdk).isWindows() || RubyVersionManagerSdkData.notNullFrom(rubySdk).areGemsUserLocal();
    }

    static {
        x = com.jetbrains.python.psi.c.a(-4786649605059226505L, 8364501739071858775L, MethodHandles.lookup().lookupClass()).a(232915081505505L);
        c = new EmptyAdditionalData(null);
        LOG = Logger.getInstance(RubySdkType.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = x ^ 0x565923BD8430L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 28: 
            case 33: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 28: 
            case 33: 
            case 35: 
            case 36: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 28: 
            case 33: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkAdditionalData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rbConfig";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerSdkAdditionalData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 10: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 12: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubySdk";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationParams";
                break;
            }
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkAdditionalData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionManagerSdkAdditionalData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRbConfig";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withVersionManagerSdkAdditionalData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsBinDirectory";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterPathFor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunner";
                break;
            }
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerMappings";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkSystemAccessor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRvmSettings";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionCredentialId";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInterpreterDir";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterDir";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullFrom";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmpty";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 28: 
            case 33: 
            case 35: 
            case 36: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setRbConfig";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withVersionManagerSdkAdditionalData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setGemsBinDirectory";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setGemsRootUrls";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterPathFor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRunnerMappings";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fieldsEqual";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "computeInterpreterDir";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doAddLoadPathMappings";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "buildSdkLoadPath";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterDir";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "notNullFrom";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isEmpty";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "areGemsUserLocal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 28: 
            case 33: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class EmptyAdditionalData
    extends RubySdkAdditionalData {
        private static final long n = com.jetbrains.python.psi.c.a(6690702062979365183L, -8424623380133475401L, MethodHandles.lookup().lookupClass()).a(122264597631772L);

        private EmptyAdditionalData() {
        }

        @Override
        @NotNull
        public RubyVersionManagerSdkData getVersionManagerSdkAdditionalData() {
            long l2 = n ^ 0x7AEEEE9A91A4L;
            throw new RuntimeException("Not applicable");
        }

        @Override
        @NotNull
        public RubySdkAdditionalData withVersionManagerSdkAdditionalData(@NotNull RubyVersionManagerSdkData versionManagerSdkAdditionalData) {
            long l2 = n ^ 0x59E0868EB15CL;
            if (versionManagerSdkAdditionalData == null) {
                EmptyAdditionalData.b(0);
            }
            throw new RuntimeException("Not applicable");
        }

        @Override
        public void setRbConfig(@NotNull RbConfig rbConfig) {
            long l2 = n ^ 0x21B332009CCEL;
            if (rbConfig == null) {
                EmptyAdditionalData.b(1);
            }
            throw new RuntimeException("Not applicable");
        }

        @Override
        @NotNull
        public String getGemsBinDirectory() {
            long l2 = n ^ 0x49B77D2B9B6BL;
            throw new RuntimeException("Not applicable");
        }

        @Override
        public void setGemsBinDirectory(@NotNull String path) {
            long l2 = n ^ 0x2A19C72D8EDAL;
            if (path == null) {
                EmptyAdditionalData.b(2);
            }
            throw new RuntimeException("Not applicable");
        }

        @Override
        public boolean hasGemsBinDirectory() {
            long l2 = n ^ 0x26CB18863A03L;
            throw new RuntimeException("Not applicable");
        }

        @Override
        public List<? extends String> getGemsRootUrls() {
            long l2 = n ^ 0x63965E6E3B1EL;
            throw new RuntimeException("Not applicable");
        }

        @Override
        public void setGemsRootUrls(@NotNull List<String> urls) {
            long l2 = n ^ 0x39972244CE25L;
            if (urls == null) {
                EmptyAdditionalData.b(3);
            }
            throw new RuntimeException("Not applicable");
        }

        @Override
        public void checkValid(SdkModel sdkModel) throws ConfigurationException {
            long l2 = n ^ 0x513E0FB49C62L;
            throw new RuntimeException("Not applicable");
        }

        @Override
        public void save(@NotNull Element rootElement) {
            long l2 = n ^ 0x773C83C558C8L;
            if (rootElement == null) {
                EmptyAdditionalData.b(4);
            }
            throw new RuntimeException("Not applicable");
        }

        @Override
        @NotNull
        public String getInterpreterPath(@NotNull Sdk sdk) {
            long l2 = n ^ 0x7172C3BD5240L;
            if (sdk == null) {
                EmptyAdditionalData.b(5);
            }
            throw new RuntimeException("Not applicable");
        }

        @Override
        public LanguageLevel getLanguageLevel() {
            long l2 = n ^ 0x4982C8173C62L;
            throw new RuntimeException("Not applicable");
        }

        @Override
        public void setLanguageLevel(LanguageLevel languageLevel) {
            long l2 = n ^ 0x40BC8935C848L;
            throw new RuntimeException("Not applicable");
        }

        @Override
        public String getPlatform() {
            long l2 = n ^ 0x2B4A45FD08BL;
            throw new RuntimeException("Not applicable");
        }

        @Override
        public void setPlatform(String platform) {
            long l2 = n ^ 0x4E6FB9EAC2F8L;
            throw new RuntimeException("Not applicable");
        }

        @Override
        @NotNull
        public RubyRunner getRunner(@Nullable Module module2) {
            long l2 = n ^ 0x66E3DFD5609BL;
            throw new RuntimeException("Not applicable");
        }

        @Override
        @NotNull
        public PathMappingSettings getRunnerMappings(@Nullable Module module2) {
            long l2 = n ^ 0x1AB1A0FCB88AL;
            throw new RuntimeException("Not applicable");
        }

        @Override
        @NotNull
        public PathMappingSettings getRunnerMappings(@NotNull AbstractRubyRunConfiguration configurationParams) {
            long l2 = n ^ 0x1B7401B7C4E6L;
            if (configurationParams == null) {
                EmptyAdditionalData.b(6);
            }
            throw new RuntimeException("Not applicable");
        }

        @Override
        @NotNull
        public PathMappingSettings getRunnerMappings(@Nullable Module module2, @Nullable PathMappingSettings baseMappings) {
            long l2 = n ^ 0x6B48CDB9FADDL;
            throw new RuntimeException("Not applicable");
        }

        @Override
        @NotNull
        public RubySdkSystemAccessor getSdkSystemAccessor() {
            long l2 = n ^ 0x667BAD7616A6L;
            throw new RuntimeException("Not applicable");
        }

        @Override
        @NotNull
        public RvmSettings getRvmSettings() {
            long l2 = n ^ 0x372A6F5867CL;
            throw new RuntimeException("Not applicable");
        }

        @Override
        @NotNull
        public String getConnectionCredentialId() {
            long l2 = n ^ 0x1DFA8C288545L;
            throw new RuntimeException("Not applicable");
        }

        @Override
        @Nullable
        public String getNormalizedVersionString() {
            long l2 = n ^ 0x2791BA743D06L;
            throw new RuntimeException("Not applicable");
        }

        @Override
        public void setNormalizedVersionString(@Nullable String normalizedVersionString) {
            long l2 = n ^ 0x1B0528724FB6L;
            throw new RuntimeException("Not applicable");
        }

        @Override
        protected boolean fieldsEqual(@NotNull RubySdkAdditionalData data) {
            long l2 = n ^ 0x472349315CBAL;
            if (data == null) {
                EmptyAdditionalData.b(7);
            }
            throw new RuntimeException("Not applicable");
        }

        @Override
        protected int fieldsHashCode() {
            long l2 = n ^ 0x535C7BDCC143L;
            throw new RuntimeException("Not applicable");
        }

        /* synthetic */ EmptyAdditionalData(b x0) {
            this();
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = n ^ 0x5B8F780DF3C3L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "versionManagerSdkAdditionalData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rbConfig";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urls";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurationParams";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkAdditionalData$EmptyAdditionalData";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withVersionManagerSdkAdditionalData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setRbConfig";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setGemsBinDirectory";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setGemsRootUrls";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInterpreterPath";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRunnerMappings";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fieldsEqual";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

