/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.MockSdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.XMap;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.a;

public class RbConfig {
    private static final Logger a;
    private static Map<String, String> b;
    static final RbConfig EMPTY_CONFIG;
    private boolean d;
    @NotNull
    private final Map<String, String> c;
    private static final long e;

    private RbConfig(@NotNull MyBean bean) {
        long l2 = e ^ 0x50DCADC8AF55L;
        if (bean == null) {
            RbConfig.a(0);
        }
        this(bean.config);
        if (!bean.a()) {
            throw new RuntimeException("Invalid or legacy bean should not be used");
        }
    }

    private RbConfig(@NotNull Map<String, String> config) {
        if (config == null) {
            RbConfig.a(1);
        }
        this.d = false;
        this.c = Collections.unmodifiableMap(ContainerUtil.filter(config, string -> StringUtil.isNotEmpty((String)((String)config.get(string)))));
    }

    @NotNull
    public Map<String, String> getConfig() {
        Map<String, String> map2 = this.c;
        if (map2 == null) {
            RbConfig.a(2);
        }
        return map2;
    }

    @Contract(value="null -> null")
    @Nullable
    public String get(@Nullable String key) {
        long l2 = e ^ 0x5057F3C871C9L;
        if (b != null) {
            return b.get(key);
        }
        Application application = ApplicationManager.getApplication();
        if (!this.d && !application.isUnitTestMode() && this.isEmpty()) {
            this.d = true;
            a.warn("Accessing empty environment");
        }
        return this.getConfig().get(key);
    }

    @Nullable
    public String getRubyVersion() {
        long l2 = e ^ 0x3DA119C2AE54L;
        return this.get("ruby_version");
    }

    @Nullable
    public String getRubyLibPrefix() {
        long l2 = e ^ 0x6DB0D2A2279EL;
        return this.get("rubylibprefix");
    }

    @Nullable
    public String getLibDir() {
        long l2 = e ^ 0x4B187A077766L;
        return this.get("libdir");
    }

    @NotNull
    public List<String> get(@Nullable List<String> keys) {
        List<String> list2 = keys == null || keys.isEmpty() ? Collections.emptyList() : keys.stream().map(this::get).filter(StringUtil::isNotEmpty).collect(Collectors.toList());
        if (list2 == null) {
            RbConfig.a(3);
        }
        return list2;
    }

    public boolean isEmpty() {
        return (b == null || b.isEmpty()) && this.c.isEmpty();
    }

    public void save(@NotNull Element parentElement) {
        if (parentElement == null) {
            RbConfig.a(4);
        }
        XmlSerializer.serializeObjectInto((Object)new MyBean(this.c, null), (Element)parentElement);
    }

    public static void initIfNecessary(@NotNull Sdk sdk) {
        if (sdk == null) {
            RbConfig.a(5);
        }
        if (sdk instanceof MockSdk) {
            return;
        }
        RubySdkAdditionalData rubySdkAdditionalData = RubySdkAdditionalData.from(sdk);
        if (rubySdkAdditionalData == null || !rubySdkAdditionalData.getRbConfig().isEmpty()) {
            return;
        }
        RbConfig.init(rubySdkAdditionalData, rubySdkAdditionalData.getInterpreterPath(sdk));
        RubySdkAdditionalData.addLoadPathMappings(sdk);
    }

    public static void init(@NotNull RubySdkAdditionalData sdkAdditionalData, @NotNull String interpreterPath) {
        ProcessOutput processOutput;
        long l2 = e ^ 0x3B5ADC596F47L;
        if (sdkAdditionalData == null) {
            RbConfig.a(6);
        }
        if (interpreterPath == null) {
            RbConfig.a(7);
        }
        a.debug("Getting RBConfig from " + interpreterPath);
        long l3 = System.currentTimeMillis();
        String string = "START-" + RbConfig.class + l3;
        String string2 = "END-" + RbConfig.class + l3;
        try {
            processOutput = sdkAdditionalData.getRunner(null).execute((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(interpreterPath, "-r", "rbconfig", "-e", "print %q<" + string + ">;RbConfig::CONFIG.each{|k,v| print %Q<#{k}=#{v}\\0>};print %q<" + string2 + ">;").inSameThread(RubyRunner.DEFAULT_EXECUTION_TIMEOUT, RBundle.message("rbconfig.fetching.progress", interpreterPath)));
        }
        catch (ExecutionException executionException) {
            sdkAdditionalData.setRbConfig(EMPTY_CONFIG);
            a.warn("Error loading RBConfig for " + interpreterPath, (Throwable)executionException);
            return;
        }
        assert (processOutput != null);
        String string3 = processOutput.getStdout();
        if (processOutput.getExitCode() != 0 || StringUtil.isEmpty((String)string3)) {
            sdkAdditionalData.setRbConfig(EMPTY_CONFIG);
            a.warn("Error getting RbConfig from " + interpreterPath + ", error code " + processOutput.getExitCode() + "; STDOUT: " + string3 + "; STDERR: " + processOutput.getStderr());
            return;
        }
        int n2 = string3.indexOf(string);
        int n3 = n2 + string.length();
        int n4 = string3.indexOf(string2, n3);
        if (n3 == -1 || n4 == -1) {
            sdkAdditionalData.setRbConfig(EMPTY_CONFIG);
            a.warn("Missing start or end marker: startMarker=" + string + "; startMarkerOffset=" + n2 + "; endMarker=" + string2 + "; endMarkerOffset=" + n4 + "; text=" + string3);
            return;
        }
        try {
            MyBean myBean = new MyBean(EnvironmentUtil.parseEnv((String[])string3.substring(n3, n4).split("\u0000")), null);
            myBean.version = 1;
            sdkAdditionalData.setRbConfig(new RbConfig(myBean));
        }
        catch (Exception exception) {
            sdkAdditionalData.setRbConfig(EMPTY_CONFIG);
            a.warn("Error parsing RbConfig output from " + interpreterPath + ":\n" + string3, (Throwable)exception);
        }
    }

    public static void initEmpty(@NotNull RubySdkAdditionalData sdkAdditionalData) {
        if (sdkAdditionalData == null) {
            RbConfig.a(8);
        }
        sdkAdditionalData.setRbConfig(EMPTY_CONFIG);
    }

    @NotNull
    public static RbConfig load(@NotNull Element rootElement) {
        MyBean myBean;
        if (rootElement == null) {
            RbConfig.a(9);
        }
        if ((myBean = (MyBean)XmlSerializer.deserialize((Element)rootElement, MyBean.class)) != null && myBean.a()) {
            RbConfig rbConfig = new RbConfig(myBean.config);
            if (rbConfig == null) {
                RbConfig.a(10);
            }
            return rbConfig;
        }
        RbConfig rbConfig = EMPTY_CONFIG;
        if (rbConfig == null) {
            RbConfig.a(11);
        }
        return rbConfig;
    }

    @Contract(value="null -> null")
    @Nullable
    public static RbConfig from(@Nullable Sdk sdk) {
        return (RbConfig)ObjectUtils.doIfNotNull((Object)RubySdkAdditionalData.from(sdk), RubySdkAdditionalData::getRbConfig);
    }

    @NotNull
    public static RbConfig notNullFrom(@NotNull Sdk sdk) {
        if (sdk == null) {
            RbConfig.a(12);
        }
        RbConfig rbConfig = Objects.requireNonNull(RbConfig.from(sdk));
        if (rbConfig == null) {
            RbConfig.a(13);
        }
        return rbConfig;
    }

    public static void doWithMockConfig(@NotNull Map<String, String> mockMap, @NotNull Runnable runnable) {
        long l2 = e ^ 0x4196EEE0DAFEL;
        if (mockMap == null) {
            RbConfig.a(14);
        }
        if (runnable == null) {
            RbConfig.a(15);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException("For tests only");
        }
        b = mockMap;
        try {
            runnable.run();
        }
        finally {
            b = null;
        }
    }

    static {
        e = com.jetbrains.python.psi.c.a(-1783204585453778264L, -884824750944635656L, MethodHandles.lookup().lookupClass()).a(101328685474787L);
        a = Logger.getInstance(RbConfig.class);
        b = null;
        EMPTY_CONFIG = new RbConfig(Collections.emptyMap());
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x1F4C7417BF1L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 13: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/RbConfig";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAdditionalData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mockMap";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RbConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullFrom";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initIfNecessary";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "initEmpty";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "notNullFrom";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doWithMockConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyBean {
        private static final int a = 1;
        @XMap(propertyElementName="RbConfig", entryTagName="item")
        public Map<String, String> config;
        @Attribute(value="version")
        public int version;
        private static final long b = com.jetbrains.python.psi.c.a(-8663771797521019328L, -5694131633096964219L, MethodHandles.lookup().lookupClass()).a(4219371827177L);

        private MyBean() {
        }

        private boolean b() {
            return this.config != null;
        }

        private boolean a() {
            return this.b() && this.version >= 1;
        }

        private MyBean(@NotNull Map<String, String> config) {
            if (config == null) {
                MyBean.a(0);
            }
            this.version = 1;
            this.config = config;
        }

        /* synthetic */ MyBean(Map x0, a x1) {
            this(x0);
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x6ED03C2F21C4L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/plugins/ruby/ruby/sdk/RbConfig$MyBean", "<init>"));
        }
    }
}

