/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration.nailgun;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.OSProcessManager;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.nailgun.JRubyRunNailgunServerAction;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public class JRubyNailgunUtil {
    private static final Logger b;
    public static final int DEFAULT_PORT = 2113;
    private static final int c = 150;
    private static final int g = 3;
    private static final String f = "--nailgun-port";
    private static final String e = "--ng";
    private static final NotificationGroup a;
    private static final NotificationGroup d;
    private static final long h;

    public static void patchCmdLineForNailGunServer(@NotNull AbstractRubyRunConfiguration configuration, String runnerId, GeneralCommandLine cmdLine) {
        long l2 = h ^ 0x5BDCE5245349L;
        if (configuration == null) {
            JRubyNailgunUtil.b(0);
        }
        Sdk sdk = configuration.getSdk();
        Project project = configuration.getProject();
        String string = cmdLine.getCommandLineString();
        if (RubyAbstractCommandLineState.isInRubyDebugMode(runnerId)) {
            JRubyNailgunUtil.a(cmdLine);
            JRubyNailgunUtil.a(RBundle.message("nailgun.server.in.debug"), NotificationType.WARNING, project, d);
            return;
        }
        assert (JRubySdkUtil.isJRubySDK(sdk));
        Pair<NailgunServerAnalysisResult, Integer> pair = JRubyNailgunUtil.a(sdk, string);
        NailgunServerAnalysisResult nailgunServerAnalysisResult = (NailgunServerAnalysisResult)((Object)pair.getFirst());
        int n2 = (Integer)pair.getSecond();
        switch (nailgunServerAnalysisResult) {
            case SUITABLE_SERVER: {
                JRubyNailgunUtil.b(cmdLine);
                break;
            }
            case NO_SUITABLE_SERVER: {
                JRubyNailgunUtil.b(cmdLine);
                JRubyNailgunUtil.a(cmdLine, configuration);
                break;
            }
            case GOOD_GEMSET_WRONG_PORT: {
                JRubyNailgunUtil.b(cmdLine);
                JRubyNailgunUtil.a(cmdLine, n2);
                JRubyNailgunUtil.a(RBundle.message("nailgun.server.fail.port"), NotificationType.WARNING, project, a);
                break;
            }
            case WRONG_GEMSET_GOOD_PORT: {
                JRubyNailgunUtil.a(RBundle.message("nailgun.server.fail.gemset"), NotificationType.WARNING, project, a);
            }
        }
    }

    private static void a(String string, NotificationType notificationType, Project project, NotificationGroup notificationGroup) {
        notificationGroup.createNotification(string, notificationType).notify(project);
    }

    private static void a(GeneralCommandLine generalCommandLine) {
        long l2 = h ^ 0x41ECF06B7CB2L;
        ParametersList parametersList = generalCommandLine.getParametersList();
        List list2 = parametersList.getParameters();
        parametersList.replaceOrAppend(e, "");
        int n2 = list2.indexOf(f);
        if (n2 != -1) {
            parametersList.replaceOrAppend(parametersList.get(n2 + 1), "");
            parametersList.replaceOrAppend(parametersList.get(n2), "");
        }
    }

    private static void b(GeneralCommandLine generalCommandLine) {
        long l2 = h ^ 0x242EDDF48F85L;
        generalCommandLine.getParametersList().replaceOrPrepend(e, e);
    }

    private static void a(GeneralCommandLine generalCommandLine, int n2) {
        long l2 = h ^ 0x6E2013F8C0BBL;
        ParametersList parametersList = generalCommandLine.getParametersList();
        int n3 = parametersList.getParameters().indexOf(f);
        if (n3 == -1) {
            parametersList.add(f, String.valueOf(n2));
            return;
        }
        try {
            String string = parametersList.get(n3 + 1);
            Integer.parseInt(string);
            parametersList.set(n3 + 1, String.valueOf(n2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void a(GeneralCommandLine generalCommandLine, @NotNull AbstractRubyRunConfiguration abstractRubyRunConfiguration) {
        long l2 = h ^ 0x799C857B7FABL;
        if (abstractRubyRunConfiguration == null) {
            JRubyNailgunUtil.b(1);
        }
        AnAction anAction = ActionManager.getInstance().getAction("org.jetbrains.plugins.ruby.ruby.run.configuration.nailgun.JRubyRunNailgunServerAction");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Module module2 = abstractRubyRunConfiguration.getModule();
        assert (module2 != null);
        hashMap.put(LangDataKeys.MODULE.getName(), module2);
        hashMap.put(CommonDataKeys.PROJECT.getName(), abstractRubyRunConfiguration.getProject());
        AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)anAction, null, (String)"unknown", (DataContext)SimpleDataContext.getSimpleContext(hashMap, null));
        anAction.beforeActionPerformedUpdate(anActionEvent);
        anAction.update(anActionEvent);
        if (anActionEvent.getPresentation().isEnabled() && anActionEvent.getPresentation().isVisible()) {
            anAction.actionPerformed(anActionEvent);
            Ref ref = (Ref)module2.getUserData(JRubyRunNailgunServerAction.NAILGUN_PORT);
            if (ref != null) {
                Integer n2 = (Integer)ref.get();
                JRubyNailgunUtil.a(generalCommandLine, n2);
                JRubyNailgunUtil.a(n2);
            }
        }
    }

    private static void a(int n2) {
        Socket socket = new Socket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), n2);
        for (int i10 = 0; i10 < 3; ++i10) {
            try {
                socket.connect(inetSocketAddress, 150);
                break;
            }
            catch (Exception exception) {
                DebugUtil.sleep((long)150L);
                continue;
            }
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Pair<NailgunServerAnalysisResult, Integer> a(Sdk sdk, String string) {
        long l2 = h ^ 0x680D24762A41L;
        if (SystemInfo.isWindows) {
            NailgunServerAnalysisResult nailgunServerAnalysisResult = NailgunServerAnalysisResult.NO_SUITABLE_SERVER;
            List list2 = OSProcessManager.getInstance().getCommandLinesOfRunningProcesses();
            if (list2 != null) {
                for (String string2 : list2) {
                    if (!string2.contains("NGServer") && !string2.contains("--ng-server")) continue;
                    nailgunServerAnalysisResult = NailgunServerAnalysisResult.SUITABLE_SERVER;
                    break;
                }
            }
            return new Pair((Object)nailgunServerAnalysisResult, (Object)JRubyNailgunUtil.c(string));
        }
        Map<Integer, Boolean> map2 = JRubyNailgunUtil.a(sdk);
        if (map2.isEmpty()) {
            return new Pair((Object)NailgunServerAnalysisResult.NO_SUITABLE_SERVER, (Object)JRubyNailgunUtil.c(string));
        }
        Set<Integer> set = map2.keySet();
        Map<Integer, Integer> map3 = JRubyNailgunUtil.b(set);
        int n2 = JRubyNailgunUtil.c(string);
        NailgunServerAnalysisResult nailgunServerAnalysisResult = null;
        int n3 = n2;
        for (Integer n4 : set) {
            Boolean bl2 = map2.get(n4);
            Integer n5 = map3.get(n4);
            if (bl2.booleanValue() && n5 == n2) {
                return new Pair((Object)NailgunServerAnalysisResult.SUITABLE_SERVER, (Object)n2);
            }
            if (bl2.booleanValue()) {
                nailgunServerAnalysisResult = NailgunServerAnalysisResult.GOOD_GEMSET_WRONG_PORT;
                n3 = n5;
                continue;
            }
            if (n5 == n2) {
                if (nailgunServerAnalysisResult == NailgunServerAnalysisResult.GOOD_GEMSET_WRONG_PORT) continue;
                nailgunServerAnalysisResult = NailgunServerAnalysisResult.WRONG_GEMSET_GOOD_PORT;
                n3 = n2;
                continue;
            }
            if (nailgunServerAnalysisResult == NailgunServerAnalysisResult.GOOD_GEMSET_WRONG_PORT || nailgunServerAnalysisResult == NailgunServerAnalysisResult.WRONG_GEMSET_GOOD_PORT) continue;
            nailgunServerAnalysisResult = NailgunServerAnalysisResult.NO_SUITABLE_SERVER;
        }
        return new Pair(nailgunServerAnalysisResult, (Object)n3);
    }

    private static Map<Integer, Integer> b(Set<Integer> set) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        List<String> list2 = JRubyNailgunUtil.a(set);
        UnixProcessManager.processPSOutput((String[])ArrayUtilRt.toStringArray(list2), string -> {
            long l2 = h ^ 0xAB73C4E2FDBL;
            String[] stringArray = string.split("\\s+", 3);
            int n2 = -1;
            try {
                n2 = Integer.parseInt(stringArray[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n3 = string.indexOf("*:");
            String string2 = string.substring(n3 + 2);
            int n4 = -1;
            try {
                n4 = Integer.parseInt(string2.substring(0, string2.indexOf(" ")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n2 != -1 && n4 != -1) {
                hashMap.put(n2, n4);
            }
            return true;
        });
        return hashMap;
    }

    private static List<String> a(Set<Integer> set) {
        long l2 = h ^ 0x66CB0A4EC5A4L;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "usr/bin/lsof";
        if (!new File(string).isFile()) {
            string = "lsof";
        }
        arrayList.add(string);
        arrayList.add("-Pan");
        for (Integer n2 : set) {
            arrayList.add("+p");
            arrayList.add(String.valueOf(n2));
        }
        arrayList.add("-i");
        arrayList.add("tcp");
        return arrayList;
    }

    private static Map<Integer, Boolean> a(Sdk sdk) {
        long l2 = h ^ 0x1E3D60AE3CBL;
        String string2 = "/bin/ps";
        if (!new File(string2).isFile()) {
            string2 = "ps";
        }
        HashMap<Integer, Boolean> hashMap = new HashMap<Integer, Boolean>();
        UnixProcessManager.processPSOutput((String[])new String[]{string2, "xe"}, string -> {
            long l2 = h ^ 0x535C8696DF4AL;
            if (string.contains("NGServer")) {
                int n2 = JRubyNailgunUtil.a(string.trim());
                if (n2 == -1) {
                    return false;
                }
                String string2 = JRubyNailgunUtil.b(string);
                if (string2 == null) {
                    return false;
                }
                String string3 = RVMSupportUtil.getGemsetPresentableName(sdk);
                if ("[default]".equals(string3)) {
                    hashMap.put(n2, true);
                    return true;
                }
                Collection<String> collection = GemManager.getInstance().getGemRootUrlsForSDK(sdk);
                for (String string4 : collection) {
                    if (string4.length() <= 7) {
                        b.warn("Unexpected ps output format (" + string4 + ")");
                        continue;
                    }
                    String string5 = string4.substring(7, string4.indexOf("@") + 1) + string3;
                    if (!string2.equals(string5)) continue;
                    hashMap.put(n2, true);
                    return true;
                }
                hashMap.put(n2, false);
            }
            return true;
        });
        return hashMap;
    }

    private static int a(String string) {
        String string2 = string.substring(0, string.indexOf(" "));
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    @Nullable
    private static String b(String string) {
        long l2 = h ^ 0x1E04AA5C66DAL;
        int n2 = string.indexOf("GEM_HOME");
        if (n2 == -1) {
            return null;
        }
        String string2 = string.substring(n2 + 9);
        int n3 = string2.indexOf("@");
        if (n3 == -1) {
            return string2.substring(0, string2.indexOf(" "));
        }
        int n4 = string2.substring(n3).indexOf(" ");
        string2 = string2.substring(0, n3 + n4);
        return string2;
    }

    private static int c(String string) {
        long l2 = h ^ 0x56D5EC6C5D4BL;
        int n2 = string.indexOf(f);
        if (n2 == -1) {
            return 2113;
        }
        String[] stringArray = string.substring(n2).split(" ");
        if (stringArray.length < 2) {
            return 2113;
        }
        String string2 = stringArray[1];
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return 2113;
        }
    }

    static {
        h = com.jetbrains.python.psi.c.a(166551342659777394L, 5122488005566180891L, MethodHandles.lookup().lookupClass()).a(1799522220316L);
        long l2 = h ^ 0x2B15F6C4FAF9L;
        b = Logger.getInstance(JRubyNailgunUtil.class);
        a = NotificationGroup.toolWindowGroup((String)RBundle.message("nailgun.server.name"), (String)ToolWindowId.RUN);
        d = NotificationGroup.toolWindowGroup((String)RBundle.message("nailgun.server.name"), (String)ToolWindowId.DEBUG);
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        long l2 = h ^ 0x30130EE324D4L;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "configuration";
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/nailgun/JRubyNailgunUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "patchCmdLineForNailGunServer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runNailgunServer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class NailgunServerAnalysisResult
    extends Enum<NailgunServerAnalysisResult> {
        public static final /* enum */ NailgunServerAnalysisResult NO_SUITABLE_SERVER;
        public static final /* enum */ NailgunServerAnalysisResult SUITABLE_SERVER;
        public static final /* enum */ NailgunServerAnalysisResult WRONG_GEMSET_GOOD_PORT;
        public static final /* enum */ NailgunServerAnalysisResult GOOD_GEMSET_WRONG_PORT;
        private static final /* synthetic */ NailgunServerAnalysisResult[] a;

        public static NailgunServerAnalysisResult[] values() {
            return (NailgunServerAnalysisResult[])a.clone();
        }

        public static NailgunServerAnalysisResult valueOf(String name) {
            return Enum.valueOf(NailgunServerAnalysisResult.class, name);
        }

        static {
            long l2 = com.jetbrains.python.psi.c.a(-5527986912170541668L, 128470111274341549L, MethodHandles.lookup().lookupClass()).a(257970607536567L) ^ 0x43C96239F2C8L;
            NO_SUITABLE_SERVER = new NailgunServerAnalysisResult();
            SUITABLE_SERVER = new NailgunServerAnalysisResult();
            WRONG_GEMSET_GOOD_PORT = new NailgunServerAnalysisResult();
            GOOD_GEMSET_WRONG_PORT = new NailgunServerAnalysisResult();
            a = new NailgunServerAnalysisResult[]{NO_SUITABLE_SERVER, SUITABLE_SERVER, WRONG_GEMSET_GOOD_PORT, GOOD_GEMSET_WRONG_PORT};
        }
    }
}

