/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.ArgumentFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyResolutionIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.AnonymousDefiningCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.ClassNewCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.EmptyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.ModuleNewCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyAliasCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyAttrCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyAutoLoadCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyAutoLoadUnderCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyFileCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyIncludeExtendCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyIncludeExtendCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubySymbolDefiningCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyVisibilityCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.StructNewCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.RStubNamespaceElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.calls.RPossibleCallStub;
import org.jetbrains.plugins.ruby.ruby.presentation.RFieldAttrPresentationUtil;
import org.jetbrains.plugins.ruby.ruby.presentation.RMethodPresentationUtil;

public class RubyCallTypes {
    @NonNls
    public static final String REQUIRE_COMMAND = "require";
    @NonNls
    public static final String REQUIRE_RELATIVE_COMMAND = "require_relative";
    @NonNls
    public static final String PRIVATE_COMMAND = "private";
    @NonNls
    public static final String PUBLIC_COMMAND = "public";
    @NonNls
    public static final String PROTECTED_COMMAND = "protected";
    @NonNls
    public static final String KIND_OF = "kind_of?";
    @NonNls
    public static final String IS_A = "is_a?";
    @NonNls
    public static final String RESPOND_TO = "respond_to?";
    public static final RubyCallType<List<String>> REQUIRE_CALL;
    public static final RubyCallType<List<String>> REQUIRE_RELATIVE_CALL;
    public static final RubyCallType<List<String>> LOAD_CALL;
    public static final RubyCallType<List<String>> AUTOLOAD_CALL;
    public static final RubyCallType<List<String>> AUTOLOAD_AT_CALL;
    public static final RubyCallType<List<String>> AUTOLOAD_UNDER_CALL;
    public static final RubyCallType<List<FQN>> CLASS_EVAL;
    public static final RubyCallType<List<FQN>> MODULE_EVAL;
    public static final RubyCallType<List<FQN>> INSTANCE_EVAL;
    public static final StructNewCallType STRUCT_NEW;
    public static final ClassNewCallType CLASS_NEW;
    public static final ModuleNewCallType MODULE_NEW;
    public static final RubyCallType<List<FQN>> INCLUDED_DO;
    public static final RubyCallType<List<Pair<String, SerializableType>>> ATTR_READER_CALL;
    public static final RubyCallType<List<Pair<String, SerializableType>>> ATTR_CALL;
    public static final RubyCallType<List<Pair<String, SerializableType>>> ATTR_WRITER_CALL;
    public static final RubyCallType<List<Pair<String, SerializableType>>> ATTR_ACCESSOR_CALL;
    public static final RubyCallType<List<String>> DEFINE_METHOD_CALL;
    public static final RubyCallType<List<String>> DEFINE_SINGLETON_METHOD_CALL;
    public static final RubyCallType<List<String>> PRIVATE_CALL;
    public static final RubyCallType<List<String>> PROTECTED_CALL;
    public static final RubyCallType<List<String>> PUBLIC_CALL;
    public static final List<RubyCallType<?>> VISIBILITY_MODIFIER_CALLS;
    public static final RubyCallType<List<String>> ALIAS_METHOD_CALL;
    public static final RubyCallType<Void> RAISE_CALL;
    public static final RubyCallType<Void> FAIL_CALL;
    public static final RubyCallType<List<FQN>> SEND_CALL;
    public static final RubyCallType<Void> UNKNOWN;
    public static final RubyCallType<List<FQN>>[] INCLUDE_EXTEND_CALLS;
    private static final long a;

    private RubyCallTypes() {
    }

    public static boolean isIgnoredIncludeExtendArgument(RPossibleCall rCall, FQN qualifiedName) {
        long l2 = a ^ 0x484433D9D5FL;
        return rCall.getCallType() == SEND_CALL && ("include".equals(qualifiedName.getShortName()) || "extend".equals(qualifiedName.getShortName()));
    }

    public static boolean isExtendCall(RPossibleCall call) {
        long l2 = a ^ 0x780CC26FEA8CL;
        RubyCallType<?> rubyCallType = call.getCallType();
        if (rubyCallType == RubyIncludeExtendCallTypes.EXTEND_CALL) {
            return true;
        }
        if (rubyCallType != SEND_CALL) {
            return false;
        }
        List list2 = (List)call.getData(SEND_CALL);
        return list2.size() > 1 && "extend".equals(((FQN)list2.get(0)).getShortName());
    }

    public static boolean isIncludeCall(RPossibleCall call) {
        long l2 = a ^ 0x1A15ECEBD5C5L;
        RubyCallType<?> rubyCallType = call.getCallType();
        if (rubyCallType == RubyIncludeExtendCallTypes.INCLUDE_CALL || rubyCallType == RubyIncludeExtendCallTypes.PREPEND_CALL) {
            return true;
        }
        if (rubyCallType != SEND_CALL) {
            return false;
        }
        List list2 = (List)call.getData(SEND_CALL);
        return list2.size() > 1 && ("include".equals(((FQN)list2.get(0)).getShortName()) || "prepend".equals(((FQN)list2.get(0)).getShortName()));
    }

    public static boolean isRaiseCall(@NotNull RPossibleCall call) {
        RubyCallType<?> rubyCallType;
        if (call == null) {
            RubyCallTypes.a(0);
        }
        return (rubyCallType = call.getCallType()) == RAISE_CALL || rubyCallType == FAIL_CALL;
    }

    public static boolean isFieldConstructor(@NotNull RCall call) {
        RubyCallType<?> rubyCallType;
        if (call == null) {
            RubyCallTypes.a(1);
        }
        return (rubyCallType = call.getCallType()) instanceof RubyAttrCallType || rubyCallType instanceof StructNewCallType;
    }

    @Contract(value="null -> null")
    @Nullable
    public static String getDefinedAttributeName(@Nullable PsiElement parameter) {
        if (parameter instanceof ArgumentFakePsiElement) {
            ArgumentFakePsiElement argumentFakePsiElement = (ArgumentFakePsiElement)parameter;
            if (RubyCallTypes.isFieldConstructor(argumentFakePsiElement.getCall())) {
                return argumentFakePsiElement.getName();
            }
            return null;
        }
        if (!(parameter instanceof RPsiElement)) {
            return null;
        }
        RCall rCall = RCallNavigator.getByRArgument(parameter);
        if (rCall == null) {
            return null;
        }
        if (!RubyCallTypes.isFieldConstructor(rCall)) {
            return null;
        }
        if (parameter instanceof RSymbol) {
            return ((RSymbol)parameter).getName();
        }
        if (parameter instanceof RStringLiteral && rCall.getCallType() instanceof RubyAttrCallType) {
            RStringLiteral rStringLiteral = (RStringLiteral)parameter;
            if (rStringLiteral.hasExpressionSubstitutions()) {
                return null;
            }
            return rStringLiteral.getContent();
        }
        return null;
    }

    public static boolean processSymbolsAtArgument(@NotNull RCall call, @NotNull PsiElement argument, @Nullable PsiElement invocationPoint, @NotNull Processor<? super Symbol> processor2) {
        Symbol symbol2;
        if (call == null) {
            RubyCallTypes.a(2);
        }
        if (argument == null) {
            RubyCallTypes.a(3);
        }
        if (processor2 == null) {
            RubyCallTypes.a(4);
        }
        if ((symbol2 = SymbolUtil.getScopeContextWithCaching((PsiElement)call)) == null) {
            return true;
        }
        PsiManager psiManager = call.getManager();
        FilteringProcessor filteringProcessor = new FilteringProcessor(symbol -> psiManager.areElementsEquivalent(argument, symbol.getPsiElement()), processor2);
        return call.getCallType().process((Processor<Symbol>)filteringProcessor, symbol2, call, invocationPoint);
    }

    static {
        a = c.a(-2061696272859181233L, 9002450064442185685L, MethodHandles.lookup().lookupClass()).a(185549146241090L);
        long l2 = a ^ 0x2B26F858018BL;
        REQUIRE_CALL = new RubyFileCallType(REQUIRE_COMMAND).withIcon(AllIcons.Nodes.Aspect);
        REQUIRE_RELATIVE_CALL = new RubyFileCallType(REQUIRE_RELATIVE_COMMAND).withIcon(AllIcons.Nodes.Aspect);
        LOAD_CALL = new RubyFileCallType("load").withIcon(AllIcons.Nodes.Aspect);
        AUTOLOAD_CALL = new RubyAutoLoadCallType("autoload");
        AUTOLOAD_AT_CALL = new RubyFileCallType("autoload_at");
        AUTOLOAD_UNDER_CALL = new RubyAutoLoadUnderCallType("autoload_under");
        CLASS_EVAL = new AnonymousDefiningCallType("class_eval");
        MODULE_EVAL = new AnonymousDefiningCallType("module_eval");
        INSTANCE_EVAL = new AnonymousDefiningCallType("instance_eval");
        STRUCT_NEW = new StructNewCallType();
        CLASS_NEW = new ClassNewCallType();
        MODULE_NEW = new ModuleNewCallType();
        INCLUDED_DO = new AnonymousDefiningCallType("included");
        ATTR_READER_CALL = new RubyAttrCallType("attr_reader", true, false).withIcon((Icon)RFieldAttrPresentationUtil.ATTR_READER_ICON);
        ATTR_CALL = new RubyAttrCallType("attr", true, false).withIcon((Icon)RFieldAttrPresentationUtil.ATTR_READER_ICON);
        ATTR_WRITER_CALL = new RubyAttrCallType("attr_writer", false, true).withIcon((Icon)RFieldAttrPresentationUtil.ATTR_WRITER_ICON);
        ATTR_ACCESSOR_CALL = new RubyAttrCallType("attr_accessor", true, true).withIcon((Icon)RFieldAttrPresentationUtil.ATTR_ACCESSOR_ICON);
        DEFINE_METHOD_CALL = new RubySymbolDefiningCallType("define_method", Type.INSTANCE_METHOD).withIcon(RMethodPresentationUtil.getIcon(null));
        DEFINE_SINGLETON_METHOD_CALL = new RubySymbolDefiningCallType("define_singleton_method", Type.CLASS_METHOD){
            private static final long d = c.a(-2026294171079249011L, -7981438432308820431L, MethodHandles.lookup().lookupClass()).a(164725846110935L);

            @Override
            protected void indexArgument(RPossibleCallStub<?> stub, IndexSink sink, @NotNull String arg) {
                if (arg == null) {
                    1.a(0);
                }
                RubyResolutionIndex.sink(RStubNamespaceElement.getFQNForStub(stub, arg, true), sink);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = d ^ 0x2743DDB01D01L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/RubyCallTypes$1", "indexArgument"));
            }
        }.withIcon(RMethodPresentationUtil.getIcon(null));
        PRIVATE_CALL = new RubyVisibilityCallType(PRIVATE_COMMAND, Visibility.PRIVATE);
        PROTECTED_CALL = new RubyVisibilityCallType(PROTECTED_COMMAND, Visibility.PROTECTED);
        PUBLIC_CALL = new RubyVisibilityCallType(PUBLIC_COMMAND, Visibility.PUBLIC);
        VISIBILITY_MODIFIER_CALLS = Arrays.asList(PRIVATE_CALL, PROTECTED_CALL, PUBLIC_CALL);
        ALIAS_METHOD_CALL = new RubyAliasCallType("alias_method");
        RAISE_CALL = new EmptyCallType("raise");
        FAIL_CALL = new EmptyCallType("fail");
        SEND_CALL = new RubyIncludeExtendCallType("send"){
            private static final long e = c.a(5561507672229026901L, -7705217468353553360L, MethodHandles.lookup().lookupClass()).a(25017648597930L);

            @Override
            public void indexStub(RPossibleCallStub<?> stub, IndexSink sink) {
                String string;
                long l2 = e ^ 0x5DA4E4C996D8L;
                List<FQN> list2 = stub.getCallData().getData(this, new RubyCallType[0]);
                if (list2.size() > 0 && ("include".equals(string = list2.get(0).getShortName()) || "prepend".equals(string) || "extend".equals(string))) {
                    RubyIncludeExtendCallType.indexIncludeExtend(stub, sink, "extend".equals(string));
                }
            }
        };
        UNKNOWN = RubyCallType.UNKNOWN;
        INCLUDE_EXTEND_CALLS = new RubyCallType[]{RubyIncludeExtendCallTypes.INCLUDE_CALL, RubyIncludeExtendCallTypes.PREPEND_CALL, RubyIncludeExtendCallTypes.EXTEND_CALL, SEND_CALL};
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0xE9852265328L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/RubyCallTypes";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isRaiseCall";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isFieldConstructor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processSymbolsAtArgument";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

