/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi;

import com.google.common.collect.ImmutableSet;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.IndexingDataKeys;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.RubyDataKeys;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RNamespace;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyLexer;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsingUtils.RBuilder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RFloatConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RIntegerConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RExpressionSubstitution;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocValue;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RBlockStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RConditionalStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RLoopStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUnlessStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUntilStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RWhileStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RIfModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RModifierStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RUnlessModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RUntilModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RWhileModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RSelfAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RUnaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyExpressionCodeFragmentImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelPusher;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.RAliasStatementImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.classes.RClassImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RMethodImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RSingletonMethodImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.arguments.RNamedArgumentNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.arguments.RPredefinedArgumentNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.modules.RModuleImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.names.RNameImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.names.RNameNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RSelfAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.StructNewCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RTopConstReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RVariable;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.templates.TemplateIntegrationUtils;

public class RubyPsiUtil {
    private static final Logger a;
    public static final Key<Pair<RPsiElement, TextRange>> SELECTION_BREAKS_AST_NODE;
    private static final TokenSet d;
    @NonNls
    private static final String c = "loop";
    @NonNls
    private static final Set<String> b;
    private static final long e;

    private RubyPsiUtil() {
    }

    @NotNull
    public static List<PsiElement> getChildrenByFilter(@NotNull PsiElement element, @NotNull TokenSet filter) {
        if (element == null) {
            RubyPsiUtil.a(0);
        }
        if (filter == null) {
            RubyPsiUtil.a(1);
        }
        LinkedList linkedList = new LinkedList();
        ASTNode aSTNode = element.getNode();
        if (aSTNode != null) {
            for (ASTNode aSTNode2 : aSTNode.getChildren(filter)) {
                linkedList.add(aSTNode2.getPsi());
            }
        }
        List<Object> list2 = linkedList.isEmpty() ? Collections.emptyList() : linkedList;
        if (list2 == null) {
            RubyPsiUtil.a(2);
        }
        return list2;
    }

    @NotNull
    public static List<PsiElement> getChildrenByFilter(@NotNull PsiElement element, IElementType filter) {
        if (element == null) {
            RubyPsiUtil.a(3);
        }
        List<PsiElement> list2 = RubyPsiUtil.getChildrenByFilter(element, TokenSet.create((IElementType[])new IElementType[]{filter}));
        if (list2 == null) {
            RubyPsiUtil.a(4);
        }
        return list2;
    }

    @Nullable
    @Contract(value="null -> null")
    public static VirtualFile getVirtualFileFromElement(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return null;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile != null) {
            return virtualFile;
        }
        VirtualFile virtualFile2 = (VirtualFile)psiFile.getUserData(IndexingDataKeys.VIRTUAL_FILE);
        if (virtualFile2 != null) {
            return virtualFile2;
        }
        PsiFile psiFile2 = psiFile.getOriginalFile();
        return psiFile2 != psiFile ? psiFile2.getVirtualFile() : null;
    }

    @Nullable
    public static PsiElement getChildByFilter(@NotNull PsiElement element, @NotNull TokenSet filter, int number) {
        ASTNode aSTNode;
        if (element == null) {
            RubyPsiUtil.a(5);
        }
        if (filter == null) {
            RubyPsiUtil.a(6);
        }
        if ((aSTNode = element.getNode()) != null) {
            ASTNode[] aSTNodeArray = aSTNode.getChildren(filter);
            return 0 <= number && number < aSTNodeArray.length ? aSTNodeArray[number].getPsi() : null;
        }
        return null;
    }

    @Nullable
    public static PsiElement getChildByFilter(@NotNull PsiElement element, IElementType filter, int number) {
        if (element == null) {
            RubyPsiUtil.a(7);
        }
        return RubyPsiUtil.getChildByFilter(element, TokenSet.create((IElementType[])new IElementType[]{filter}), number);
    }

    @Nullable
    public static <T extends PsiElement> T getElementToLeftWithSameParent(@NotNull PsiElement element, Class<T> c10) {
        PsiElement psiElement;
        if (element == null) {
            RubyPsiUtil.a(8);
        }
        for (psiElement = element.getPrevSibling(); psiElement != null && !c10.isInstance(psiElement); psiElement = psiElement.getPrevSibling()) {
        }
        return (T)(psiElement != null ? psiElement : null);
    }

    @NotNull
    public static <T extends PsiElement> List<T> getChildrenByFilter(PsiElement psiElement, Class<T> c10) {
        LinkedList linkedList = new LinkedList();
        for (PsiElement psiElement2 : psiElement.getChildren()) {
            if (!c10.isInstance(psiElement2)) continue;
            linkedList.add(psiElement2);
        }
        List list2 = linkedList.isEmpty() ? Collections.emptyList() : linkedList;
        if (list2 == null) {
            RubyPsiUtil.a(9);
        }
        return list2;
    }

    public static boolean isBefore(@NotNull PsiElement element, @NotNull PsiElement element2) {
        if (element == null) {
            RubyPsiUtil.a(10);
        }
        if (element2 == null) {
            RubyPsiUtil.a(11);
        }
        return element.getTextOffset() <= element2.getTextOffset();
    }

    @Nullable
    public static RFile getRFile(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtil.a(12);
        }
        if (!element.isValid()) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        return psiFile instanceof RFile ? (RFile)psiFile : null;
    }

    public static void replaceInParent(@NotNull PsiElement oldElement, @NotNull PsiElement newElement) {
        if (oldElement == null) {
            RubyPsiUtil.a(13);
        }
        if (newElement == null) {
            RubyPsiUtil.a(14);
        }
        RubyPsiUtilBase.replaceInParent(oldElement, newElement);
    }

    public static void addToEnd(@NotNull PsiElement psiElement, PsiElement ... newElements) {
        ASTNode aSTNode;
        if (psiElement == null) {
            RubyPsiUtil.a(15);
        }
        if (newElements == null) {
            RubyPsiUtil.a(16);
        }
        a.assertTrue((aSTNode = psiElement.getNode()) != null);
        for (PsiElement psiElement2 : newElements) {
            aSTNode.addChild(psiElement2.getNode());
        }
    }

    public static void addBeforeInParent(@NotNull PsiElement anchor, PsiElement ... newElements) {
        PsiElement psiElement;
        if (anchor == null) {
            RubyPsiUtil.a(17);
        }
        if (newElements == null) {
            RubyPsiUtil.a(18);
        }
        a.assertTrue((psiElement = anchor.getParent()) != null);
        ASTNode aSTNode = psiElement.getNode();
        ASTNode aSTNode2 = anchor.getNode();
        a.assertTrue(aSTNode != null);
        a.assertTrue(aSTNode2 != null);
        for (PsiElement psiElement2 : newElements) {
            aSTNode.addChild(psiElement2.getNode(), aSTNode2);
        }
    }

    public static void removeElements(PsiElement ... elements) {
        ASTNode aSTNode;
        if (elements == null) {
            RubyPsiUtil.a(19);
        }
        a.assertTrue((aSTNode = elements[0].getParent().getNode()) != null);
        for (PsiElement psiElement : elements) {
            aSTNode.removeChild(psiElement.getNode());
        }
    }

    @Nullable
    public static RPsiElement getCoveringRPsiElement(@Nullable PsiElement psiElement) {
        return (RPsiElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{RPsiElement.class});
    }

    public static boolean isRClassName(@Nullable PsiElement element) {
        PsiElement psiElement;
        if (!(element instanceof RConstant)) {
            return false;
        }
        PsiElement psiElement2 = element.getParent();
        if (psiElement2 == null) {
            return false;
        }
        PsiElement psiElement3 = null;
        if (psiElement2 instanceof RNameImpl) {
            psiElement3 = psiElement2;
        } else if ((psiElement2 instanceof RColonReference && PsiTreeUtil.getDeepestLast((PsiElement)psiElement2) == element || psiElement2 instanceof RTopConstReference && ((RTopConstReference)psiElement2).getConstant() == element) && (psiElement = psiElement2.getParent()) instanceof RNameImpl) {
            psiElement3 = psiElement;
        }
        if (psiElement3 == null) {
            return false;
        }
        psiElement = psiElement3.getParent();
        return psiElement instanceof RClass || psiElement instanceof RModule;
    }

    @Nullable
    public static RCall getCoveringRCall(@Nullable PsiElement psiElement) {
        return (RCall)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{RCall.class});
    }

    @Nullable
    public static RExpression getCoveringExpression(@Nullable PsiElement psiElement) {
        RExpression rExpression;
        RExpression rExpression2 = rExpression = psiElement instanceof RExpression ? (RExpression)psiElement : (RExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, RExpression.class);
        if (rExpression != null && rExpression.isValid()) {
            RBlockCall rBlockCall;
            RCall rCall;
            RExpression rExpression3 = RReferenceNavigator.getRRefenceOrTopReference((PsiElement)rExpression);
            if (rExpression3 != null) {
                rExpression = rExpression3;
            }
            if ((rCall = RCallNavigator.getByCommand((PsiElement)rExpression)) != null) {
                rExpression = rCall;
            }
            if ((rBlockCall = RBlockCallNavigator.getByCall(rExpression)) != null) {
                rExpression = rBlockCall;
            }
        }
        return rExpression;
    }

    @Nullable
    public static RClass getContainingUpperRClass(@NotNull RContainer rContainer) {
        if (rContainer == null) {
            RubyPsiUtil.a(20);
        }
        RClass rClass = rContainer instanceof RClass ? (RClass)rContainer : null;
        RClass rClass2 = RubyPsiUtil.getContainingRClassByContainer(rContainer);
        while (rClass2 != null) {
            rClass = rClass2;
            rClass2 = RubyPsiUtil.getContainingRClassByContainer(rClass2);
        }
        return rClass;
    }

    @Nullable
    public static RClass getContainingRClassByContainer(@NotNull RContainer rContainer) {
        if (rContainer == null) {
            RubyPsiUtil.a(21);
        }
        for (RContainer rContainer2 = rContainer.getParentContainer(); rContainer2 != null; rContainer2 = rContainer2.getParentContainer()) {
            if (!(rContainer2 instanceof RClass)) continue;
            return (RClass)rContainer2;
        }
        return null;
    }

    @Nullable
    public static RModule getContainingRModule(@NotNull PsiElement psiElement) {
        RContainer rContainer;
        RPsiElement rPsiElement;
        if (psiElement == null) {
            RubyPsiUtil.a(22);
        }
        if (psiElement instanceof RPsiElement) {
            rPsiElement = (RPsiElement)psiElement;
        } else {
            rPsiElement = (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, RPsiElement.class);
            if (rPsiElement == null) {
                return null;
            }
            if (rPsiElement instanceof RModule) {
                return (RModule)rPsiElement;
            }
        }
        for (rContainer = rPsiElement.getParentContainer(); rContainer != null && !(rContainer instanceof RModule); rContainer = rContainer.getParentContainer()) {
        }
        return (RModule)rContainer;
    }

    @Nullable
    public static RContainer getContainingRClassOrModule(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RubyPsiUtil.a(23);
        }
        for (RContainer rContainer = RubyPsiUtil.getParentContainerOrSelf(psiElement); rContainer != null; rContainer = rContainer.getParentContainer()) {
            if (!(rContainer instanceof RClass) && !(rContainer instanceof RModule)) continue;
            return rContainer;
        }
        return null;
    }

    @Nullable
    public static RClass getContainingRClass(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RubyPsiUtil.a(24);
        }
        for (RContainer rContainer = RubyPsiUtil.getParentContainerOrSelf(psiElement); rContainer != null; rContainer = rContainer.getParentContainer()) {
            if (!(rContainer instanceof RClass)) continue;
            return (RClass)rContainer;
        }
        return null;
    }

    @Nullable
    public static RMethod getContainingRMethod(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RubyPsiUtil.a(25);
        }
        for (RContainer rContainer = RubyPsiUtil.getParentContainerOrSelf(psiElement); rContainer != null; rContainer = rContainer.getParentContainer()) {
            if (!(rContainer instanceof RMethod)) continue;
            return (RMethod)rContainer;
        }
        return null;
    }

    @Nullable
    public static RBlockCall getContainingRBlockCall(@Nullable PsiElement element) {
        RCodeBlock rCodeBlock = (RCodeBlock)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, RCodeBlock.class);
        return (RBlockCall)ObjectUtils.doIfNotNull((Object)rCodeBlock, RCodeBlock::getBlockCall);
    }

    @Nullable
    public static RCompoundStatement getCompoundStatement(PsiElement element) {
        RCompoundStatement rCompoundStatement = (RCompoundStatement)PsiTreeUtil.getParentOfType((PsiElement)element, RCompoundStatement.class);
        while (rCompoundStatement != null && (rCompoundStatement.getParent() instanceof RGroupedExpression || rCompoundStatement.getParent() instanceof RExpressionSubstitution)) {
            rCompoundStatement = (RCompoundStatement)PsiTreeUtil.getParentOfType((PsiElement)rCompoundStatement, RCompoundStatement.class);
        }
        return rCompoundStatement;
    }

    @Nullable
    public static RPsiElement getStatement(PsiElement element) {
        RCompoundStatement rCompoundStatement = RubyPsiUtil.getCompoundStatement(element);
        return rCompoundStatement != null ? RubyPsiUtil.getStatement(rCompoundStatement, element) : null;
    }

    @Nullable
    public static RPsiElement getStatement(@NotNull RCompoundStatement compoundStatement, @Nullable PsiElement element) {
        PsiElement psiElement;
        if (compoundStatement == null) {
            RubyPsiUtil.a(26);
        }
        return (psiElement = RubyPsiUtil.getCompoundStatementChild(compoundStatement, element)) instanceof RPsiElement ? (RPsiElement)psiElement : null;
    }

    @Nullable
    public static PsiElement getCompoundStatementChild(RCompoundStatement compoundStatement, PsiElement element) {
        while (element != null) {
            if (element instanceof RHeredocValue) {
                element = ((RHeredocValue)element).getIdElement();
            }
            if (element.getParent() == compoundStatement) break;
            element = element.getParent();
        }
        return element;
    }

    @Nullable
    public static String getElementText(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtil.a(27);
        }
        return RubyPsiUtilBase.getElementText(element);
    }

    @Nullable
    public static RBlockCall getParentBlockCall(@NotNull PsiElement element, @NotNull Predicate<? super RBlockCall> predicate) {
        if (element == null) {
            RubyPsiUtil.a(28);
        }
        if (predicate == null) {
            RubyPsiUtil.a(29);
        }
        RBlockCall rBlockCall = RubyPsiUtil.getContainingRBlockCall(element);
        while (rBlockCall != null) {
            if (predicate.test(rBlockCall)) {
                return rBlockCall;
            }
            rBlockCall = RubyPsiUtil.getContainingRBlockCall((PsiElement)rBlockCall);
        }
        return null;
    }

    @Nullable
    public static RBlockCall getParentBlockCallOfType(@NotNull PsiElement element, @NotNull RubyCallType<?> callType) {
        if (element == null) {
            RubyPsiUtil.a(30);
        }
        if (callType == null) {
            RubyPsiUtil.a(31);
        }
        return RubyPsiUtil.getParentBlockCall(element, rBlockCall -> rBlockCall.getCallType() == callType);
    }

    @Nullable
    public static RNamespace getParentNamespace(PsiElement element) {
        return RubyPsiUtilBase.getParentNamespace(element);
    }

    @Nullable
    public static RContainer getParentContainer(PsiElement element) {
        if (element instanceof RPsiElement) {
            return ((RPsiElement)element).getParentContainer();
        }
        return (RContainer)PsiTreeUtil.getParentOfType((PsiElement)element, RContainer.class);
    }

    @Nullable
    public static RContainer getParentContainerOrSelf(PsiElement element) {
        if (element instanceof RContainer) {
            return (RContainer)element;
        }
        return RubyPsiUtil.getParentContainer(element);
    }

    @Nullable
    public static <T extends PsiElement> T getChildByFilter(PsiElement element, Class<T> aClass, int i10) {
        List<T> list2 = RubyPsiUtil.getChildrenByFilter(element, aClass);
        int n2 = list2.size();
        return (T)(i10 >= 0 && i10 < n2 ? (PsiElement)list2.get(i10) : null);
    }

    public static PsiElement setElementName(@NotNull PsiElement namedElement, @NotNull String newName, @Nullable String prefix) {
        if (namedElement == null) {
            RubyPsiUtil.a(32);
        }
        if (newName == null) {
            RubyPsiUtil.a(33);
        }
        String string = prefix != null ? prefix + newName : newName;
        RPsiElement rPsiElement = RubyElementFactory.createElementFromText(namedElement, string);
        RubyPsiUtil.replaceInParent(namedElement, (PsiElement)rPsiElement);
        return rPsiElement;
    }

    @Nullable
    public static RMethod getMethodWithPossibleZeroArgsByName(@NotNull RContainer container, @Nullable String name) {
        if (container == null) {
            RubyPsiUtil.a(34);
        }
        List<RMethod> list2 = RContainerUtil.selectElementsByType(container.getStructureElements(), RMethod.class);
        for (int i10 = list2.size() - 1; i10 >= 0; --i10) {
            RMethod rMethod = list2.get(i10);
            if (!Comparing.equal((String)rMethod.getName(), (String)name) || !rMethod.getArgumentInfos().stream().noneMatch(argumentInfo -> argumentInfo.getType() == ArgumentInfo.Type.SIMPLE)) continue;
            return rMethod;
        }
        return null;
    }

    public static boolean isClassModuleOrMethodName(@NotNull PsiElement element) {
        RName rName;
        if (element == null) {
            RubyPsiUtil.a(35);
        }
        return (rName = RNameNavigator.getRName(element)) != null && !(rName instanceof RSuperClass) && !(rName.getParent() instanceof RAliasStatement);
    }

    public static void markGenerated(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtil.a(36);
        }
        if (element.getNode() != null) {
            ((TreeElement)element.getNode()).acceptTree((TreeElementVisitor)new GeneratedMarkerVisitor());
        }
    }

    public static boolean isDeclaration(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtil.a(37);
        }
        if (element instanceof RVariable) {
            return ((RVariable)element).isDeclaration();
        }
        return RubyPsiUtil.isDeclarationImpl(element);
    }

    public static boolean isDeclarationImpl(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtil.a(38);
        }
        return RAssignmentExpressionNavigator.getAssignmentByLeftPart(element) != null || RAssignmentExpressionNavigator.getQualifiedConstantAssignment(element) != null || RSelfAssignmentExpressionNavigator.getSelfAssignmentByLeftPart(element) != null || RPredefinedArgumentNavigator.getByDeclaredElement(element) != null || RubyCallTypes.getDefinedAttributeName(element) != null || StructNewCallType.isClassName(element) || RNamedArgumentNavigator.getByDeclaredElement(element) != null;
    }

    @Nullable
    public static RPsiElement getDeclaration(@NotNull PsiElement element) {
        RAssignmentExpression rAssignmentExpression;
        if (element == null) {
            RubyPsiUtil.a(39);
        }
        if ((rAssignmentExpression = RAssignmentExpressionNavigator.getAssignmentByLeftPart(element)) != null) {
            return rAssignmentExpression;
        }
        rAssignmentExpression = RAssignmentExpressionNavigator.getQualifiedConstantAssignment(element);
        if (rAssignmentExpression != null) {
            return rAssignmentExpression;
        }
        RSelfAssignmentExpression rSelfAssignmentExpression = RSelfAssignmentExpressionNavigator.getSelfAssignmentByLeftPart(element);
        if (rSelfAssignmentExpression != null) {
            return rSelfAssignmentExpression;
        }
        RArgument rArgument = RPredefinedArgumentNavigator.getByDeclaredElement(element);
        if (rArgument != null) {
            return rArgument;
        }
        return RNamedArgumentNavigator.getByDeclaredElement(element);
    }

    @Nullable
    public static RPsiElement getRealContext(@NotNull RPsiElement element) {
        long l2 = e ^ 0x1AA8872C8C9FL;
        if (element == null) {
            RubyPsiUtil.a(40);
        }
        if (!element.isValid()) {
            if (a.isDebugEnabled()) {
                a.debug("RubyPsiUtil.getRealContext(" + element + ") called. Returned null. Element in invalid");
            }
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        RPsiElement rPsiElement = (RPsiElement)psiFile.getCopyableUserData(RubyDataKeys.RUBY_CONSOLE_CONTEXT_KEY);
        if (rPsiElement != null) {
            if (a.isDebugEnabled()) {
                a.debug("RubyPsiUtil.getRealContext(" + element + ") is called. Returned " + rPsiElement + ". Element inside console");
            }
            return rPsiElement;
        }
        if (psiFile instanceof RubyExpressionCodeFragmentImpl) {
            PsiElement psiElement = psiFile.getContext();
            if (a.isDebugEnabled()) {
                a.debug("RubyPsiUtil.getRealContext(" + element + ") is called. Returned " + psiElement + ". Element inside code fragment");
            }
            return (RPsiElement)psiElement;
        }
        if (a.isDebugEnabled()) {
            a.debug("RubyPsiUtil.getRealContext(" + element + ") is called. Returned " + element + ".");
        }
        return element;
    }

    @NotNull
    public static SearchScope restrictScopeToRubyFiles(@NotNull SearchScope originalScope) {
        if (originalScope == null) {
            RubyPsiUtil.a(41);
        }
        SearchScope searchScope = PsiSearchScopeUtil.restrictScopeTo((SearchScope)originalScope, (FileType[])TemplateIntegrationUtils.getInstance().allKnownFileTypes(new FileType[]{RubyFileType.RUBY}));
        if (searchScope == null) {
            RubyPsiUtil.a(42);
        }
        return searchScope;
    }

    public static int getOriginalTextOffset(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtil.a(43);
        }
        if (element instanceof RAliasStatementImpl) {
            return ((RAliasStatementImpl)element).getOriginalTextOffset();
        }
        if (element instanceof RClassImpl) {
            return ((RClassImpl)element).getOriginalTextOffset();
        }
        if (element instanceof RModuleImpl) {
            return ((RModuleImpl)element).getOriginalTextOffset();
        }
        if (element instanceof RSingletonMethodImpl) {
            return ((RSingletonMethodImpl)element).getOriginalTextOffset();
        }
        if (element instanceof RMethodImpl) {
            return ((RMethodImpl)element).getOriginalTextOffset();
        }
        return element.getTextOffset();
    }

    @Nullable
    public static PsiElement getSignificantLeafToTheLeft(PsiElement leaf) {
        return RubyPsiUtil.getSignificantLeafToTheLeft(leaf, d);
    }

    @Nullable
    public static PsiElement getSignificantLeafToTheLeft(PsiElement leaf, @NotNull TokenSet insignificantTokens) {
        if (insignificantTokens == null) {
            RubyPsiUtil.a(44);
        }
        while (leaf != null && (leaf instanceof PsiWhiteSpace || insignificantTokens.contains(leaf.getNode().getElementType()))) {
            leaf = PsiTreeUtil.prevLeaf((PsiElement)leaf);
        }
        return leaf;
    }

    @Nullable
    public static PsiElement getPrevSignificantLeaf(PsiElement command) {
        return RubyPsiUtil.getSignificantLeafToTheLeft(PsiTreeUtil.prevLeaf((PsiElement)command));
    }

    @Nullable
    public static PsiElement getSignificantLeafToTheRight(PsiElement leaf) {
        while (leaf != null && (leaf instanceof PsiWhiteSpace || d.contains(leaf.getNode().getElementType()))) {
            leaf = PsiTreeUtil.nextLeaf((PsiElement)leaf);
        }
        return leaf;
    }

    @Nullable
    public static PsiElement getPrevSignificantSibling(PsiElement element) {
        return RubyPsiUtil.getSignificantSiblingToTheLeft(element.getPrevSibling());
    }

    @Nullable
    public static PsiElement getSignificantSiblingToTheLeft(PsiElement element) {
        while (element != null && (element instanceof PsiWhiteSpace || element instanceof PsiErrorElement || TokenBNF.tWHITESPACES_OR_COMMENTS.contains(element.getNode().getElementType()))) {
            element = element.getPrevSibling();
        }
        return element;
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(@NotNull PsiElement element) {
        LanguageLevel languageLevel;
        if (element == null) {
            RubyPsiUtil.a(45);
        }
        LanguageLevel languageLevel2 = (languageLevel = RubyLanguageLevelPusher.getInstance().getLanguageLevelByElement(element)) != null ? languageLevel : LanguageLevel.DEFAULT;
        if (languageLevel2 == null) {
            RubyPsiUtil.a(46);
        }
        return languageLevel2;
    }

    public static boolean isExplicitCall(RPsiElement identifierOrConstant) {
        return RReferenceNavigator.getReferenceByRightPart((PsiElement)identifierOrConstant) != null || RCallNavigator.getByCommand((PsiElement)identifierOrConstant) != null || RBlockCallNavigator.getByCall(identifierOrConstant) != null;
    }

    public static <T> List<T> collectNotNull(Collection<? extends T> collection) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t2 : collection) {
            if (t2 == null) continue;
            arrayList.add(t2);
        }
        return arrayList;
    }

    public static boolean isInRaiseCall(PsiElement element) {
        PsiElement psiElement = element;
        while ((psiElement = PsiTreeUtil.getParentOfType((PsiElement)psiElement, (Class[])new Class[]{RContainer.class, RCodeBlock.class, RCall.class})) != null) {
            if (!(psiElement instanceof RCall)) {
                return false;
            }
            if (!RubyCallTypes.isRaiseCall((RCall)psiElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInBlockCall(@NotNull PsiElement element, @NotNull Predicate<? super RBlockCall> predicate) {
        if (element == null) {
            RubyPsiUtil.a(47);
        }
        if (predicate == null) {
            RubyPsiUtil.a(48);
        }
        return RubyPsiUtil.getParentBlockCall(element, predicate) != null;
    }

    public static boolean isCallOfType(@Nullable PsiElement element, @NotNull Predicate<? super RubyCallType<?>> predicate) {
        if (predicate == null) {
            RubyPsiUtil.a(49);
        }
        return element instanceof RPossibleCall && predicate.test(((RPossibleCall)element).getCallType());
    }

    public static boolean isCallWithCommand(@Nullable PsiElement element, @NotNull Predicate<? super String> predicate) {
        if (predicate == null) {
            RubyPsiUtil.a(50);
        }
        if (!(element instanceof RPossibleCall)) {
            return false;
        }
        RPossibleCall rPossibleCall = (RPossibleCall)element;
        PsiElement psiElement = rPossibleCall.getPsiCommand();
        String string = psiElement instanceof RPossibleCall ? ((RPossibleCall)psiElement).getCommand() : rPossibleCall.getCommand();
        return string != null && predicate.test(string);
    }

    public static void addIncludeFQNCall(RContainer container, String fqn) {
        long l2 = e ^ 0x3A0D294826ADL;
        RExpression rExpression = RubyElementFactory.createExpressionFromText((PsiElement)container, "include " + fqn);
        List<RPsiElement> list2 = container.getStatements();
        if (list2.isEmpty()) {
            RCompoundStatement rCompoundStatement = container.getCompoundStatement();
            rCompoundStatement.getParent().addBefore((PsiElement)rExpression, (PsiElement)rCompoundStatement);
        } else {
            RPsiElement rPsiElement2;
            for (RPsiElement rPsiElement2 : list2) {
                if (!RubyPsiUtil.a(rPsiElement2)) continue;
                for (RPsiElement rPsiElement3 : ((RCall)rPsiElement2).getArguments()) {
                    if (!fqn.equals(rPsiElement3.getText())) continue;
                    return;
                }
            }
            boolean bl2 = false;
            rPsiElement2 = null;
            for (RPsiElement rPsiElement3 : list2) {
                boolean bl3 = RubyPsiUtil.a(rPsiElement3);
                if (bl2 && !bl3) {
                    rPsiElement2.getParent().addAfter((PsiElement)rExpression, (PsiElement)rPsiElement2);
                    return;
                }
                if (!bl2) {
                    bl2 = bl3;
                }
                rPsiElement2 = rPsiElement3;
            }
            if (!bl2) {
                RPsiElement rPsiElement4 = list2.get(0);
                rPsiElement4.getParent().addBefore((PsiElement)rExpression, (PsiElement)rPsiElement4);
            }
        }
    }

    private static boolean a(RPsiElement rPsiElement) {
        return rPsiElement instanceof RCall && RubyCallTypes.isIncludeCall((RCall)rPsiElement);
    }

    public static boolean isConstantValue(PsiElement value) {
        if (value == null || value instanceof RStringLiteral || value instanceof RFloatConstant || value instanceof RIntegerConstant || value instanceof RPseudoConstant || value instanceof RConstant || value instanceof RColonReference || value instanceof RTopConstReference || value instanceof RIdentifier && (((RIdentifier)value).isParameter() || ((RIdentifier)value).isLocalVariable())) {
            return true;
        }
        if (value instanceof RUnaryExpression) {
            return RubyPsiUtil.isConstantValue((PsiElement)((RUnaryExpression)value).getElement());
        }
        if (value instanceof RBinaryExpression) {
            return RubyPsiUtil.isConstantValue((PsiElement)((RBinaryExpression)value).getLeftOperand()) && RubyPsiUtil.isConstantValue((PsiElement)((RBinaryExpression)value).getRightOperand());
        }
        return false;
    }

    @NotNull
    public static String deparenthesize(@NotNull RGroupedExpression element) {
        RPsiElement rPsiElement;
        if (element == null) {
            RubyPsiUtil.a(51);
        }
        if ((rPsiElement = element.getExpression()) != null) {
            String string = StringUtil.notNullize((String)rPsiElement.getText());
            if (string == null) {
                RubyPsiUtil.a(52);
            }
            return string;
        }
        if ("" == null) {
            RubyPsiUtil.a(53);
        }
        return "";
    }

    public static boolean isInParentheses(RPsiElement element) {
        String string = element.getText();
        return string.startsWith("(") && string.endsWith(")");
    }

    public static int getBeginEndBalance(@NotNull CharSequence textToCheck) {
        IElementType iElementType;
        if (textToCheck == null) {
            RubyPsiUtil.a(54);
        }
        RubyLexer rubyLexer = new RubyLexer(LanguageLevel.DEFAULT);
        rubyLexer.start(textToCheck);
        TokenSet tokenSet = RubyPsiUtil.getOpeningTokens();
        int n2 = 0;
        while ((iElementType = rubyLexer.getTokenType()) != null) {
            ProgressManager.checkCanceled();
            if (iElementType == RubyTokenTypes.kEND) {
                if (--n2 < 0) {
                    return n2;
                }
            } else if (tokenSet.contains(iElementType)) {
                ++n2;
            }
            rubyLexer.advance();
        }
        return n2;
    }

    public static boolean passTokensUntilBalanceIsNegative(@NotNull RBuilder builder) {
        IElementType iElementType;
        if (builder == null) {
            RubyPsiUtil.a(55);
        }
        TokenSet tokenSet = RubyPsiUtil.getOpeningTokens();
        boolean bl2 = false;
        int n2 = 0;
        while ((iElementType = builder.getNotEolTokenType()) != null) {
            if (iElementType == RubyTokenTypes.kEND) {
                if (--n2 < 0) {
                    break;
                }
            } else if (tokenSet.contains(iElementType)) {
                ++n2;
            }
            if (builder.passEOLs()) {
                bl2 = false;
            }
            builder.advanceLexer();
            if (iElementType != RubyTokenTypes.kRESCUE) continue;
            bl2 = true;
        }
        if (bl2) {
            builder.passEOLs();
            builder.passWhiteSpacesAndComments();
        }
        return bl2;
    }

    @NotNull
    public static TokenSet getOpeningTokens() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{RubyTokenTypes.kDEF, RubyTokenTypes.kIF, RubyTokenTypes.kUNLESS, RubyTokenTypes.kWHILE, RubyTokenTypes.kUNTIL, RubyTokenTypes.kFOR, RubyTokenTypes.kMODULE, RubyTokenTypes.kCLASS, RubyTokenTypes.kCASE, RubyTokenTypes.kDO, RubyTokenTypes.kBEGIN});
        if (tokenSet == null) {
            RubyPsiUtil.a(56);
        }
        return tokenSet;
    }

    @Nullable
    public static IElementType getNegativeKeyword(@NotNull RConditionalStatement conditional) {
        if (conditional == null) {
            RubyPsiUtil.a(57);
        }
        if (conditional instanceof RBlockStatement) {
            if (conditional instanceof RIfStatement) {
                return RubyTokenTypes.kUNLESS;
            }
            if (conditional instanceof RUnlessStatement) {
                return RubyTokenTypes.kIF;
            }
            if (conditional instanceof RWhileStatement) {
                return RubyTokenTypes.kUNTIL;
            }
            if (conditional instanceof RUntilStatement) {
                return RubyTokenTypes.kWHILE;
            }
        } else if (conditional instanceof RModifierStatement) {
            if (conditional instanceof RIfModStatement) {
                return RubyTokenTypes.kUNLESS;
            }
            if (conditional instanceof RUnlessModStatement) {
                return RubyTokenTypes.kIF;
            }
            if (conditional instanceof RWhileModStatement) {
                return RubyTokenTypes.kUNTIL;
            }
            if (conditional instanceof RUntilModStatement) {
                return RubyTokenTypes.kWHILE;
            }
        }
        return null;
    }

    public static Comparator<PsiElement> getRelativePositionComparator() {
        return RelativePositionComparator.a;
    }

    public static boolean isNotIdentifierAssocKey(@NotNull RPsiElement element) {
        if (element == null) {
            RubyPsiUtil.a(58);
        }
        if (!(element instanceof RIdentifier)) {
            return false;
        }
        PsiElement psiElement = element.getParent();
        if (!(psiElement instanceof RAssocKey)) {
            return false;
        }
        PsiElement psiElement2 = psiElement.getParent();
        return !(psiElement2 instanceof RAssoc) || ((RAssoc)psiElement2).getValue() != null;
    }

    public static boolean isPsiAfterNumberLiteral(@NotNull PsiElement element) {
        PsiElement psiElement;
        if (element == null) {
            RubyPsiUtil.a(59);
        }
        if ((psiElement = PsiTreeUtil.prevLeaf((PsiElement)element, (boolean)true)) == null) {
            return false;
        }
        return TokenBNF.tNUMBERS.contains(psiElement.getNode().getElementType());
    }

    public static boolean isPsiInStringLiteral(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtil.a(60);
        }
        ASTNode aSTNode = element.getNode();
        return TokenBNF.tSTRING_LIKE_CONTENTS.contains(aSTNode.getElementType());
    }

    public static boolean isInArgumentDeclaration(@NotNull PsiElement element) {
        RArgument rArgument;
        if (element == null) {
            RubyPsiUtil.a(61);
        }
        if ((rArgument = (RArgument)PsiTreeUtil.getParentOfType((PsiElement)element, RArgument.class)) == null) {
            return false;
        }
        if (rArgument.getType() != ArgumentInfo.Type.PREDEFINED && rArgument.getType() != ArgumentInfo.Type.NAMED) {
            return true;
        }
        RPsiElement rPsiElement = rArgument.getValue();
        return !PsiTreeUtil.isAncestor((PsiElement)rPsiElement, (PsiElement)element, (boolean)false);
    }

    public static boolean isInfiniteLoop(@NotNull RLoopStatement element) {
        long l2 = e ^ 0x7521A14E939DL;
        if (element == null) {
            RubyPsiUtil.a(62);
        }
        if (element instanceof RBlockCall) {
            RPossibleCall rPossibleCall = ((RBlockCall)element).getCall();
            if (!(rPossibleCall instanceof RIdentifier)) {
                return false;
            }
            PsiElement psiElement = rPossibleCall.getPsiCommand();
            if (!(psiElement instanceof PsiNamedElement)) {
                return false;
            }
            return c.equals(((PsiNamedElement)psiElement).getName());
        }
        return false;
    }

    public static boolean isExit(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtil.a(63);
        }
        String string = null;
        if (element instanceof RPossibleCall) {
            string = ((RPossibleCall)element).getCommand();
        }
        if (element instanceof RIdentifier) {
            string = element.getText();
        }
        return b.contains(string);
    }

    public static boolean isSignaturesSame(@NotNull RMethod method1, @NotNull RMethod method2) {
        if (method1 == null) {
            RubyPsiUtil.a(64);
        }
        if (method2 == null) {
            RubyPsiUtil.a(65);
        }
        List<ArgumentInfo> list2 = method1.getArgumentInfos();
        List<ArgumentInfo> list3 = method2.getArgumentInfos();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        if (list2.size() != list3.size()) {
            return false;
        }
        BiPredicate<ArgumentInfo, Map> biPredicate = (argumentInfo, map2) -> {
            if (argumentInfo.getType() == ArgumentInfo.Type.NAMED || argumentInfo.getType() == ArgumentInfo.Type.KEYREQ) {
                map2.put(argumentInfo.getName(), argumentInfo.getType() == ArgumentInfo.Type.NAMED);
                return true;
            }
            return false;
        };
        list2.removeIf(argumentInfo -> biPredicate.test((ArgumentInfo)argumentInfo, hashMap));
        list3.removeIf(argumentInfo -> biPredicate.test((ArgumentInfo)argumentInfo, hashMap2));
        if (list2.size() != list3.size()) {
            return false;
        }
        if (!hashMap.equals(hashMap2)) {
            return false;
        }
        for (int i10 = 0; i10 < list2.size(); ++i10) {
            if (list2.get(i10).getType() == list3.get(i10).getType()) continue;
            return false;
        }
        return true;
    }

    public static boolean canInsertArgumentOfType(@NotNull RMethod method, @NotNull ArgumentInfo.Type type) {
        if (method == null) {
            RubyPsiUtil.a(66);
        }
        if (type == null) {
            RubyPsiUtil.a(67);
        }
        switch (type) {
            case PREDEFINED: {
                return RubyPsiUtil.b(method);
            }
            case NAMED: {
                return RubyPsiUtil.getLanguageLevel((PsiElement)method).isGreaterThan(LanguageLevel.RUBY19);
            }
            case SIMPLE: {
                return true;
            }
            case KEYREQ: {
                return RubyPsiUtil.getLanguageLevel((PsiElement)method).isGreaterThan(LanguageLevel.RUBY20);
            }
            case ARRAY: {
                return RubyPsiUtil.a(method);
            }
        }
        return false;
    }

    private static boolean b(@NotNull RMethod rMethod) {
        if (rMethod == null) {
            RubyPsiUtil.a(68);
        }
        List<RArgument> list2 = rMethod.getArguments();
        for (RArgument rArgument : list2) {
            if (rArgument.getType() != ArgumentInfo.Type.ARRAY) continue;
            return false;
        }
        return true;
    }

    private static boolean a(@NotNull RMethod rMethod) {
        if (rMethod == null) {
            RubyPsiUtil.a(69);
        }
        List<RArgument> list2 = rMethod.getArguments();
        for (RArgument rArgument : list2) {
            if (rArgument.getType() != ArgumentInfo.Type.ARRAY && rArgument.getType() != ArgumentInfo.Type.PREDEFINED) continue;
            return false;
        }
        return true;
    }

    public static boolean isNil(@NotNull RPsiElement element) {
        ASTNode aSTNode;
        if (element == null) {
            RubyPsiUtil.a(70);
        }
        if ((aSTNode = element.getNode()) instanceof CompositeElement) {
            aSTNode = aSTNode.getFirstChildNode();
        }
        return aSTNode.getElementType() == RubyTokenTypes.kNIL;
    }

    @Nullable
    public static RAssignmentExpression getAnyAssignmentByLeftPart(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtil.a(71);
        }
        RAssignmentExpression rAssignmentExpression = RAssignmentExpressionNavigator.getAssignmentByLeftPart(element);
        RSelfAssignmentExpression rSelfAssignmentExpression = RSelfAssignmentExpressionNavigator.getSelfAssignmentByLeftPart(element);
        return rAssignmentExpression != null ? rAssignmentExpression : rSelfAssignmentExpression;
    }

    static {
        e = com.jetbrains.python.psi.c.a(4428767423985867658L, 2808351989251499384L, MethodHandles.lookup().lookupClass()).a(10674635553366L);
        long l2 = e ^ 0x3BCAB30092F5L;
        a = Logger.getInstance(RubyPsiUtil.class);
        SELECTION_BREAKS_AST_NODE = new Key("ruby.selection.breaks.ast.node");
        d = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenBNF.tWHITESPACES_OR_COMMENTS, TokenSet.create((IElementType[])new IElementType[]{RubyTokenTypes.tEOL})});
        b = ImmutableSet.of((Object)"abort", (Object)"exit", (Object)"exit!");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x644F5D7F1D26L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 42: 
            case 46: 
            case 52: 
            case 53: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 42: 
            case 46: 
            case 52: 
            case 53: 
            case 56: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 42: 
            case 46: 
            case 52: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/RubyPsiUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElements";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rContainer";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compoundStatement";
                break;
            }
            case 29: 
            case 48: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callType";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalScope";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insignificantTokens";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToCheck";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditional";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method1";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method2";
                break;
            }
            case 66: 
            case 68: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/RubyPsiUtil";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenByFilter";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "restrictScopeToRubyFiles";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "deparenthesize";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpeningTokens";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenByFilter";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 42: 
            case 46: 
            case 52: 
            case 53: 
            case 56: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getChildByFilter";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementToLeftWithSameParent";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isBefore";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "replaceInParent";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addToEnd";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addBeforeInParent";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeElements";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getContainingUpperRClass";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getContainingRClassByContainer";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getContainingRModule";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getContainingRClassOrModule";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getContainingRClass";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getContainingRMethod";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getStatement";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getElementText";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getParentBlockCall";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getParentBlockCallOfType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setElementName";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getMethodWithPossibleZeroArgsByName";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isClassModuleOrMethodName";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "markGenerated";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaration";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isDeclarationImpl";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaration";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getRealContext";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "restrictScopeToRubyFiles";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalTextOffset";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getSignificantLeafToTheLeft";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isInBlockCall";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isCallOfType";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isCallWithCommand";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "deparenthesize";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getBeginEndBalance";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "passTokensUntilBalanceIsNegative";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getNegativeKeyword";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isNotIdentifierAssocKey";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isPsiAfterNumberLiteral";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isPsiInStringLiteral";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isInArgumentDeclaration";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isInfiniteLoop";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isExit";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isSignaturesSame";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "canInsertArgumentOfType";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "canInsertPredefinedArgument";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "canInsertArrayArgument";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isNil";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getAnyAssignmentByLeftPart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 42: 
            case 46: 
            case 52: 
            case 53: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RelativePositionComparator
    implements Comparator<PsiElement> {
        private static final RelativePositionComparator a = new RelativePositionComparator();

        private RelativePositionComparator() {
        }

        @Override
        public int compare(PsiElement o1, PsiElement o2) {
            if (o1 instanceof StubBasedPsiElementBase && o2 instanceof StubBasedPsiElementBase) {
                StubElement stubElement = ((StubBasedPsiElementBase)o1).getGreenStub();
                StubElement stubElement2 = ((StubBasedPsiElementBase)o2).getGreenStub();
                if (stubElement != null && stubElement2 != null) {
                    return -((StubBase)stubElement).compareByOrderWith((ObjectStubBase)((StubBase)stubElement2));
                }
            }
            return o2.getTextRange().getEndOffset() - o1.getTextRange().getEndOffset();
        }
    }
}

