/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.formatter;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.a;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.managers.HeredocsManager;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocId;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocValue;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.heredocs.RHeredocValueImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

final class RubyHeredocPostFormatter
implements PostFormatProcessor {
    private static final long a = c.a(8584657693142280537L, -3971140149644969773L, MethodHandles.lookup().lookupClass()).a(164276371143707L);

    RubyHeredocPostFormatter() {
    }

    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            RubyHeredocPostFormatter.a(0);
        }
        if (settings == null) {
            RubyHeredocPostFormatter.a(1);
        }
        if (!RubyHeredocPostFormatter.a(source)) {
            PsiElement psiElement = source;
            if (psiElement == null) {
                RubyHeredocPostFormatter.a(2);
            }
            return psiElement;
        }
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)source.getProject()).createSmartPsiElementPointer(source);
        PsiFile psiFile = source.getContainingFile();
        TextRange textRange = this.processText(psiFile, source.getTextRange(), settings);
        if (smartPsiElementPointer.getElement() != null) {
            PsiElement psiElement = smartPsiElementPointer.getElement();
            if (psiElement == null) {
                RubyHeredocPostFormatter.a(3);
            }
            return psiElement;
        }
        PsiElement psiElement = psiFile.findElementAt(textRange.getStartOffset());
        PsiElement psiElement2 = psiFile.findElementAt(textRange.getEndOffset());
        if (psiElement == null || psiElement2 == null) {
            PsiFile psiFile2 = psiFile;
            if (psiFile2 == null) {
                RubyHeredocPostFormatter.a(4);
            }
            return psiFile2;
        }
        PsiElement psiElement3 = (PsiElement)ObjectUtils.notNull((Object)PsiTreeUtil.findCommonParent((PsiElement)psiElement, (PsiElement)psiElement2), (Object)psiFile);
        if (psiElement3 == null) {
            RubyHeredocPostFormatter.a(5);
        }
        return psiElement3;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            RubyHeredocPostFormatter.a(6);
        }
        if (rangeToReformat == null) {
            RubyHeredocPostFormatter.a(7);
        }
        if (settings == null) {
            RubyHeredocPostFormatter.a(8);
        }
        if (!RubyHeredocPostFormatter.a((PsiElement)source)) {
            TextRange textRange = rangeToReformat;
            if (textRange == null) {
                RubyHeredocPostFormatter.a(9);
            }
            return textRange;
        }
        Document document = PsiDocumentManager.getInstance((Project)source.getProject()).getDocument(source);
        if (document == null) {
            TextRange textRange = rangeToReformat;
            if (textRange == null) {
                RubyHeredocPostFormatter.a(10);
            }
            return textRange;
        }
        Project project = source.getProject();
        Visitor visitor2 = new Visitor(project, document, null, null);
        visitor2.visitElement((PsiElement)source);
        List<Pair<TextRange, CharSequence>> list2 = visitor2.getReplacements();
        int n2 = 0;
        for (int i10 = list2.size() - 1; i10 >= 0; --i10) {
            Pair<TextRange, CharSequence> pair = list2.get(i10);
            TextRange textRange = (TextRange)pair.getFirst();
            CharSequence charSequence = (CharSequence)pair.getSecond();
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), charSequence);
            n2 += charSequence.length() - textRange.getLength();
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        TextRange textRange = TextRange.from((int)rangeToReformat.getStartOffset(), (int)Math.max(0, rangeToReformat.getLength() + n2));
        if (textRange == null) {
            RubyHeredocPostFormatter.a(11);
        }
        return textRange;
    }

    private static boolean a(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RubyHeredocPostFormatter.a(12);
        }
        return psiElement.getLanguage() == RubyLanguage.INSTANCE && !RubyPsiUtil.getLanguageLevel(psiElement).isLessThan(LanguageLevel.RUBY23);
    }

    @NotNull
    private static String a(@NotNull String string, int n2, boolean bl2) {
        int n3;
        if (string == null) {
            RubyHeredocPostFormatter.a(13);
        }
        if (!bl2) {
            String string2 = string + StringUtil.repeatSymbol((char)' ', (int)n2);
            if (string2 == null) {
                RubyHeredocPostFormatter.a(14);
            }
            return string2;
        }
        for (n3 = 0; n3 < string.length() && string.charAt(string.length() - n3 - 1) == ' '; ++n3) {
        }
        String string3 = string.substring(0, string.length() - n3) + StringUtil.repeatSymbol((char)'\t', (int)((n2 + n3) / 8)) + StringUtil.repeatSymbol((char)' ', (int)((n2 + n3) % 8));
        if (string3 == null) {
            RubyHeredocPostFormatter.a(15);
        }
        return string3;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x7D83484E62CFL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/RubyHeredocPostFormatter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToReformat";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/RubyHeredocPostFormatter";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "processElement";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "processText";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewIndent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkIsRuby23";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createNewIndent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends RubyRecursiveElementVisitor {
        @NotNull
        private final Document a;
        @Nullable
        private final TextRange b;
        @NotNull
        private final CodeStyleFacade c;
        @NotNull
        private final List<Pair<TextRange, CharSequence>> d;
        private static final long e = com.jetbrains.python.psi.c.a(307096863510713504L, 947563940124616763L, MethodHandles.lookup().lookupClass()).a(164293550492230L);

        private Visitor(@NotNull Project project, @NotNull Document document, @Nullable TextRange range) {
            if (project == null) {
                Visitor.b(0);
            }
            if (document == null) {
                Visitor.b(1);
            }
            this.d = new ArrayList<Pair<TextRange, CharSequence>>();
            this.a = document;
            this.b = range;
            this.c = CodeStyleFacade.getInstance((Project)project);
        }

        @Override
        public void visitElement(PsiElement element) {
            if (this.b != null && !element.getTextRange().intersects(this.b)) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitRHeredocValue(RHeredocValue heredocValue) {
            RHeredocId rHeredocId = heredocValue.getIdElement();
            if (!HeredocsManager.isSquiggly(rHeredocId.getIdPrefix())) {
                return;
            }
            int n2 = this.c.getIndentSize((FileType)RubyFileType.RUBY);
            int n3 = rHeredocId.getTextRange().getStartOffset();
            int n4 = this.a.getLineStartOffset(this.a.getLineNumber(n3));
            String string = StringUtil.notNullize((String)CodeStyleManager.getInstance((Project)heredocValue.getProject()).getLineIndent(this.a, n4));
            if (RHeredocValueImpl.getLineIndent(string) + n2 == heredocValue.getIndent()) {
                return;
            }
            boolean bl2 = this.c.useTabCharacter((FileType)RubyFileType.RUBY);
            String string2 = RubyHeredocPostFormatter.a(string, n2, bl2);
            List<CharSequence> list2 = heredocValue.getContentLines();
            List list3 = ContainerUtil.map(list2, charSequence -> {
                if (charSequence.length() == 0) {
                    return charSequence.toString();
                }
                return string2 + charSequence;
            });
            String string3 = StringUtil.join((Collection)list3, (String)"\n");
            this.d.add((Pair<TextRange, CharSequence>)Pair.create((Object)heredocValue.getTextRange(), (Object)string3));
        }

        @NotNull
        public List<Pair<TextRange, CharSequence>> getReplacements() {
            List<Pair<TextRange, CharSequence>> list2 = this.d;
            if (list2 == null) {
                Visitor.b(2);
            }
            return list2;
        }

        /* synthetic */ Visitor(Project x0, Document x1, TextRange x2, a x3) {
            this(x0, x1, x2);
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = e ^ 0x3D2E01B62F5DL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/RubyHeredocPostFormatter$Visitor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/RubyHeredocPostFormatter$Visitor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReplacements";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

