/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.documentation;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.motion.RubyMotionUtil;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDTag;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDUtil;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.MethodNameFakePsiElement;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDOptionTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDOverloadDirective;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDParamTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDReturnTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDYieldparamTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.base.YARDSubMethodDirective;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.MethodAnnotationData;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RPsiPolyVariantReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.SymbolResolveResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.ArgumentFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.CallableSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.DelegateProducedSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.MultiSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.TypedSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.AnonymousClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SingletonClassSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolContainerUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RubyTypeProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.TypeInferenceContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.lang.RubyElementNameAndDescriptionProvider;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyDocumentationMarkupUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfoPresentation;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RNumberedParameter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.FieldType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;

public class RubyHelpUtil {
    private static final Logger g;
    @NonNls
    static final String ELEMENT = "ELEMENT";
    @NonNls
    static final String COMMA = ",";
    private static final String e = "[undefined]";
    private static final String f = "&nbsp;\u2192&nbsp;";
    private static final String i = "&nbsp;\u2190&nbsp;";
    private static final String k = "    ";
    private static final String c = "Params:";
    private static final String h = "Options:";
    private static final String b = "Yields:";
    private static final String j = "Returns:";
    private static final List<String> a;
    private static final Pattern d;
    private static final long l;

    private RubyHelpUtil() {
    }

    @Nullable
    public static String getSimpleInfo(@Nullable RPsiElement targetElement, boolean forNavigateInfo) {
        Symbol symbol;
        long l2 = l ^ 0x6DF01CA7A77AL;
        if (targetElement == null || targetElement instanceof PsiFile) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Symbol symbol2 = symbol = targetElement instanceof RContainer ? SymbolUtil.getSymbolByContainer((RContainer)targetElement) : null;
        if (symbol != null) {
            RubyHelpUtil.a(symbol, stringBuilder, targetElement);
            RubyHelpUtil.a(targetElement, symbol, stringBuilder);
            RubyHelpUtil.a(symbol, stringBuilder, !forNavigateInfo);
        } else {
            RubyHelpUtil.a(targetElement, symbol, stringBuilder);
            String string = RubyHelpUtil.c(targetElement);
            if (string != null) {
                stringBuilder.append(string).append(forNavigateInfo ? " " : "&nbsp;");
            }
        }
        RubyHelpUtil.a((PsiElement)targetElement, symbol, stringBuilder, !forNavigateInfo);
        if (symbol != null) {
            RubyHelpUtil.a(symbol, stringBuilder, !forNavigateInfo, (PsiElement)targetElement);
        }
        RubyHelpUtil.a(targetElement, symbol, stringBuilder, !forNavigateInfo);
        if (!forNavigateInfo) {
            RubyHelpUtil.a(null, targetElement, null, stringBuilder);
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    @Nullable
    public static String getHelpByElement(@Nullable PsiElement elementAtCursor, @Nullable RPsiElement rPsiElementAtCursor, @NotNull RPsiElement targetElement) {
        Object object;
        long l2 = l ^ 0x4A6DB576476FL;
        if (targetElement == null) {
            RubyHelpUtil.a(0);
        }
        if (targetElement instanceof RFile) {
            g.info("No documentation: target is file");
            return null;
        }
        if (rPsiElementAtCursor != null) {
            object = RubyHelpUtil.a(elementAtCursor, rPsiElementAtCursor, targetElement);
            if (object != null) {
                return object;
            }
        } else {
            g.info("no original RPsiElement");
        }
        if (targetElement instanceof RContainer) {
            object = (RContainer)targetElement;
            Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)object);
            if (symbol != null) {
                return RubyHelpUtil.a(symbol, rPsiElementAtCursor, targetElement);
            }
            g.info("No documentation: no symbol for container");
            return null;
        }
        if (RubyHelpUtil.a(targetElement) || targetElement instanceof RConstant || targetElement instanceof RField || targetElement instanceof RGlobalVariable || targetElement instanceof RAliasStatement || targetElement instanceof RCall || targetElement instanceof RBlockCall) {
            object = RubyHelpUtil.a(elementAtCursor, rPsiElementAtCursor, targetElement);
            if (object != null) {
                return object;
            }
            return RubyHelpUtil.d(targetElement);
        }
        g.info("No documentation: unknown target element type " + targetElement.getClass().getName());
        return null;
    }

    @Nullable
    private static String c(@NotNull RPsiElement rPsiElement) {
        RVariable rVariable;
        long l2 = l ^ 0x1EF60B90E26FL;
        if (rPsiElement == null) {
            RubyHelpUtil.a(1);
        }
        if (rPsiElement instanceof RIdentifier) {
            RIdentifier rIdentifier = (RIdentifier)rPsiElement;
            if (rIdentifier.isParameter()) {
                return RBundle.message("parameter");
            }
            if (rIdentifier.isLocalVariable()) {
                return RBundle.message("local.variable");
            }
            return null;
        }
        if (rPsiElement instanceof RNumberedParameter) {
            return RBundle.message("numbered.parameter");
        }
        if (rPsiElement instanceof RConstant && RubyPsiUtil.isDeclaration((PsiElement)(rVariable = (RConstant)rPsiElement))) {
            return RBundle.message("constant");
        }
        if (rPsiElement instanceof RField) {
            rVariable = (RField)rPsiElement;
            return rVariable.getFieldType() == FieldType.CLASS_VARIABLE ? RBundle.message("class.variable") : RBundle.message("instance.variable");
        }
        if (rPsiElement instanceof RGlobalVariable && RubyPsiUtil.isDeclaration((PsiElement)(rVariable = (RGlobalVariable)rPsiElement))) {
            return RBundle.message("global.variable");
        }
        if (rPsiElement instanceof RMethod) {
            return RBundle.message("method");
        }
        if (rPsiElement instanceof RClass) {
            return RBundle.message("class");
        }
        if (rPsiElement instanceof RModule) {
            return RBundle.message("module");
        }
        if (rPsiElement instanceof ArgumentFakePsiElement) {
            return ((ArgumentFakePsiElement)rPsiElement).getTypeName();
        }
        return null;
    }

    @Nullable
    private static String a(@NotNull RType rType, @NotNull RPsiElement rPsiElement) {
        String string;
        if (rType == null) {
            RubyHelpUtil.a(2);
        }
        if (rPsiElement == null) {
            RubyHelpUtil.a(3);
        }
        return (string = rType.getPresentableName()) == null ? null : RubyHelpUtil.linkinize(rPsiElement.getProject(), string, (PsiElement)rPsiElement);
    }

    static String createRefText(Symbol symbol, String linkLabel) {
        String string;
        long l2 = l ^ 0x5B7A66F91BA8L;
        StringBuilder stringBuilder = new StringBuilder();
        PsiElement psiElement = symbol.getPsiElement();
        PsiFile psiFile = psiElement != null ? psiElement.getContainingFile() : null;
        VirtualFile virtualFile = psiFile != null ? psiFile.getVirtualFile() : null;
        String string2 = string = virtualFile != null ? virtualFile.getPath() + "::" + psiElement.getTextRange().getStartOffset() : null;
        if (string != null) {
            DocumentationManager.createHyperlink((StringBuilder)stringBuilder, string, (String)linkLabel, (boolean)true);
        } else {
            stringBuilder.append(linkLabel);
        }
        return stringBuilder.toString();
    }

    @NotNull
    static String linkinize(Project project, @NotNull String typeName, @Nullable PsiElement anchor) {
        long l2 = l ^ 0x26E92EA7763FL;
        if (typeName == null) {
            RubyHelpUtil.a(4);
        }
        String string = "<>, -";
        StringTokenizer stringTokenizer = new StringTokenizer(typeName, string, true);
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 1 && string.contains(string2) || string2.equals("or") || string2.equals("and")) {
                stringBuilder.append(RubyHelpUtil.a(string2));
                continue;
            }
            Symbol symbol = SymbolUtil.findConstantByFQN(project, FQN.of(string2), anchor);
            if (symbol == null) {
                stringBuilder.append(string2);
                continue;
            }
            stringBuilder.append(RubyHelpUtil.createRefText(symbol, string2));
        }
        String string3 = stringBuilder.toString();
        if (string3 == null) {
            RubyHelpUtil.a(5);
        }
        return string3;
    }

    public static PsiElement getElementByLink(String link, PsiManager psiManager) {
        long l2 = l ^ 0x2EB3CEC8C1FAL;
        if (link.contains("::")) {
            String[] stringArray = link.split("::", 2);
            try {
                PsiElement psiElement;
                PsiFile psiFile;
                int n2 = Integer.parseInt(stringArray[1]);
                VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)stringArray[0]));
                if (virtualFile != null && (psiFile = psiManager.findFile(virtualFile)) != null && (psiElement = psiFile.findElementAt(n2)) != null) {
                    return PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiNamedElement.class);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private static RType a(RMethod rMethod) {
        Symbol symbol = SymbolUtil.getSymbolByContainer(rMethod);
        if (symbol == null) {
            return null;
        }
        RType rType = RubyTypeProvider.createTypeBySymbolFromProviders(symbol, Context.INSTANCE);
        if (rType != null) {
            return rType;
        }
        rType = rMethod.getReturnTypeFromComment();
        if (rType != null) {
            return rType;
        }
        return TypeInferenceContext.getInstance(rMethod.getProject()).inferControlFlowBasedReturnType(rMethod);
    }

    private static void a(@NotNull PsiElement psiElement, @Nullable Symbol symbol, boolean bl2, @NotNull StringBuilder stringBuilder) {
        long l2 = l ^ 0x2C6DB66A6239L;
        if (psiElement == null) {
            RubyHelpUtil.a(6);
        }
        if (stringBuilder == null) {
            RubyHelpUtil.a(7);
        }
        if (symbol instanceof RMethodSymbol) {
            RubyHelpUtil.a((RMethodSymbol)symbol, bl2, stringBuilder);
            return;
        }
        if (symbol instanceof DelegateProducedSymbol) {
            RubyHelpUtil.a((DelegateProducedSymbol)symbol, bl2, stringBuilder);
            return;
        }
        if (psiElement instanceof RContainer) {
            FQN fQN = ((RContainer)psiElement).getFQNWithNesting();
            String string = fQN.getShortName();
            if (string.equals("$$SINGLETON$$") && fQN.getCallerFQN() != FQN.INVALID) {
                string = fQN.getCallerFQN().getShortName() + "::" + string;
            }
            stringBuilder.append(RContainerPresentationUtil.getHumanizedFQN(FQN.of(string)));
            return;
        }
        for (RubyElementNameAndDescriptionProvider rubyElementNameAndDescriptionProvider : RubyElementNameAndDescriptionProvider.EXTENSION_POINT_NAME.getExtensionList()) {
            String string = rubyElementNameAndDescriptionProvider.getPresentableName(psiElement);
            if (string == null) continue;
            stringBuilder.append(string);
            return;
        }
        stringBuilder.append(psiElement.getText());
    }

    private static void a(@NotNull RMethodSymbol rMethodSymbol, boolean bl2, @NotNull StringBuilder stringBuilder) {
        int n2;
        int n3;
        String string;
        long l2 = l ^ 0x1286E249AC9BL;
        if (rMethodSymbol == null) {
            RubyHelpUtil.a(8);
        }
        if (stringBuilder == null) {
            RubyHelpUtil.a(9);
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        String string2 = rMethodSymbol.getFQNWithNesting().getShortName();
        stringBuilder2.append(string2);
        ArrayList<ArgumentInfo> arrayList = new ArrayList<ArgumentInfo>();
        Optional.ofNullable(rMethodSymbol.getArgumentInfos(true)).ifPresent(arrayList::addAll);
        MethodAnnotationData methodAnnotationData = rMethodSymbol.getAnnotationData();
        if (methodAnnotationData != null && methodAnnotationData.getBlockParameterType(null) != null) {
            arrayList.add(new ArgumentInfo("blk", ArgumentInfo.Type.BLOCK));
        }
        if (arrayList.isEmpty()) {
            stringBuilder.append((CharSequence)stringBuilder2);
            return;
        }
        stringBuilder2.append('(');
        if (bl2 && stringBuilder2.length() > 30) {
            string = k;
            stringBuilder2.append("\n").append(string);
        } else {
            string = StringUtil.repeatSymbol((char)' ', (int)stringBuilder2.length());
        }
        if (stringBuilder.lastIndexOf("<pre>") != -1) {
            int n4 = stringBuilder.lastIndexOf("<pre>");
            n3 = stringBuilder.lastIndexOf("\n");
            n2 = stringBuilder.length() - (n3 != -1 ? n3 + 1 : n4 + "<pre>".length());
            string = StringUtil.repeatSymbol((char)' ', (int)n2) + string;
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            ArgumentInfo argumentInfo = (ArgumentInfo)arrayList.get(n3);
            String string3 = ArgumentInfoPresentation.getPresentableString(rMethodSymbol.getProject(), argumentInfo, bl2 ? ArgumentInfoPresentation.FULL : ArgumentInfoPresentation.SHORT);
            SerializableType serializableType = null;
            if (methodAnnotationData != null) {
                serializableType = argumentInfo.getType() == ArgumentInfo.Type.BLOCK ? methodAnnotationData.getBlockParameterType(argumentInfo.getName()) : methodAnnotationData.getParameterType(argumentInfo.getName());
            }
            stringBuilder2.append(StringUtil.replace((String)string3, (String)"\n", (String)("\n" + string)));
            if (serializableType != null) {
                stringBuilder2.append(i).append(RubyHelpUtil.linkinize(rMethodSymbol.getProject(), serializableType.getPresentableName(), rMethodSymbol.getPsiElement()));
            }
            if (n3 + 1 >= arrayList.size()) continue;
            arrayList2.add(stringBuilder2.length());
            stringBuilder2.append(", ");
        }
        stringBuilder2.append(')');
        if (bl2 && stringBuilder2.length() > 80) {
            Collections.reverse(arrayList2);
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                n2 = (Integer)iterator.next();
                stringBuilder2.replace(n2 + 1, n2 + 2, "\n" + string);
            }
        }
        stringBuilder.append((CharSequence)stringBuilder2);
    }

    private static void a(@NotNull DelegateProducedSymbol delegateProducedSymbol, boolean bl2, @NotNull StringBuilder stringBuilder) {
        Symbol symbol;
        long l2 = l ^ 0x6FF56191D64FL;
        if (delegateProducedSymbol == null) {
            RubyHelpUtil.a(10);
        }
        if (stringBuilder == null) {
            RubyHelpUtil.a(11);
        }
        Symbol symbol2 = (symbol = SymbolUtil.getScopeContextWithCaching(delegateProducedSymbol.getPsiElement())) == null ? null : SymbolUtil.findMethod(symbol, delegateProducedSymbol.getTo(), Types.METHODS_LIKE, Context.INSTANCE, delegateProducedSymbol.getPsiElement());
        String string = symbol2 != null ? RubyHelpUtil.createRefText(symbol2, delegateProducedSymbol.getTo()) : delegateProducedSymbol.getTo();
        stringBuilder.append('#').append(delegateProducedSymbol.getName()).append(" to: :").append(string);
        if (!delegateProducedSymbol.getName().equals(delegateProducedSymbol.getMemberName())) {
            stringBuilder.append('#').append(delegateProducedSymbol.getMemberName());
        }
    }

    @NotNull
    private static String a(String string) {
        long l2 = l ^ 0x5117D4C158F8L;
        String string2 = StringUtil.replace((String)string, Arrays.asList("<", ">"), Arrays.asList("&lt;", "&gt;"));
        if (string2 == null) {
            RubyHelpUtil.a(12);
        }
        return string2;
    }

    private static void a(@Nullable String string, @Nullable String string2, StringBuilder stringBuilder, boolean bl2) {
        String string3;
        long l2 = l ^ 0x3CCB2485CEF2L;
        String string4 = string3 = !StringUtil.isEmpty((String)string) ? string : e;
        if (bl2) {
            RubyDocumentationMarkupUtil.appendBoldCode(stringBuilder, string3);
        } else {
            stringBuilder.append(string3);
        }
        String string5 = !StringUtil.isEmpty((String)string2) ? string2 : e;
        stringBuilder.append("(").append(RBundle.message("ruby.doc.original")).append(": ");
        stringBuilder.append(string5);
        stringBuilder.append(')');
    }

    @Nullable
    private static String a(PsiElement psiElement, @Nullable Symbol symbol) {
        PsiElement psiElement2;
        Object object;
        String string = RubyCommentsUtil.getPsiHelpWithoutYARD(psiElement);
        if (string == null && symbol != null && symbol.getType() == Type.ALIAS && (object = SymbolUtil.getMethodSymbolByAlias(symbol)) != null && (psiElement2 = object.getPsiElement()) != null) {
            string = RubyCommentsUtil.getPsiHelpWithoutYARD(psiElement2);
        }
        if (string != null) {
            string = RubyHelpUtil.b(string);
        }
        if (string != null) {
            string = RubyDocumentationMarkupUtil.processCodeDocumentation(symbol, string);
        }
        object = RubyMotionUtil.getInstance();
        if (string == null && ((RubyMotionUtil)object).isMotionSymbol(symbol)) {
            string = ((RubyMotionUtil)object).getMotionDoc(psiElement, symbol);
        }
        return StringUtil.isEmptyOrSpaces((String)string) ? null : string;
    }

    @Nullable
    private static String b(@NotNull String string) {
        String string2;
        if (string == null) {
            RubyHelpUtil.a(13);
        }
        while ((string2 = d.matcher(string).replaceFirst("")).length() != string.length()) {
            string = string2;
        }
        return StringUtil.isEmptyOrSpaces((String)string) ? null : string;
    }

    @Nullable
    private static String a(PsiElement psiElement, RPsiElement rPsiElement, RPsiElement rPsiElement2) {
        long l2 = l ^ 0x4BD37DDDBEDCL;
        PsiReference psiReference = RubyHelpUtil.a(psiElement);
        if (psiReference instanceof RPsiPolyVariantReference) {
            SymbolResolveResult symbolResolveResult = ((RPsiPolyVariantReference)psiReference).resolveToSymbol();
            Symbol symbol = symbolResolveResult.getSymbol();
            if (symbol == null) {
                return null;
            }
            if (!(symbol instanceof MultiSymbol)) {
                return RubyHelpUtil.a(symbol, rPsiElement, rPsiElement2);
            }
            Symbol[] symbolArray = ((MultiSymbol)symbol).getSymbols();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<h2>").append(RBundle.message("ruby.doc.several.variants")).append(":</h2>");
            for (Symbol symbol2 : symbolArray) {
                String string = RubyHelpUtil.a(symbol2, rPsiElement, rPsiElement2);
                stringBuilder.append("<hr>").append(string);
            }
            return stringBuilder.toString();
        }
        g.info("no help from symbol: no reference found");
        return null;
    }

    @Nullable
    private static PsiReference a(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return null;
        }
        PsiReference psiReference = psiElement.getReference();
        if (psiReference != null) {
            return psiReference;
        }
        return psiElement.getContainingFile().findReferenceAt(psiElement.getTextRange().getStartOffset());
    }

    @Nullable
    private static String d(@NotNull RPsiElement rPsiElement) {
        long l2 = l ^ 0x1B103273843L;
        if (rPsiElement == null) {
            RubyHelpUtil.a(14);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div class='definition'><pre>");
        String string = RubyHelpUtil.getSimpleInfo(rPsiElement, false);
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append("</pre></div>");
        String string2 = RubyHelpUtil.a((PsiElement)rPsiElement, null);
        if (!StringUtil.isEmptyOrSpaces((String)string2)) {
            stringBuilder.append("<div class='content'>");
            stringBuilder.append(string2);
            stringBuilder.append("</div>");
        }
        List<Map<String, String>> list2 = RubyHelpUtil.b(rPsiElement);
        RubyHelpUtil.a(stringBuilder, list2);
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    @NotNull
    private static String a(@NotNull Symbol symbol, @Nullable RPsiElement rPsiElement, @NotNull RPsiElement rPsiElement2) {
        long l2 = l ^ 0xE97FB03D5D9L;
        if (symbol == null) {
            RubyHelpUtil.a(15);
        }
        if (rPsiElement2 == null) {
            RubyHelpUtil.a(16);
        }
        List<PsiElement> list2 = SymbolContainerUtil.siftUpMainDeclarations(symbol.getFQNWithNesting(), SymbolContainerUtil.sortElements(symbol.getAllDeclarations((PsiElement)rPsiElement2), (PsiElement)rPsiElement2));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div class='definition'><pre>");
        RubyHelpUtil.a(symbol, stringBuilder, rPsiElement2);
        RubyHelpUtil.a(rPsiElement2, symbol, stringBuilder);
        RubyHelpUtil.a(symbol, stringBuilder, true);
        RubyHelpUtil.a((PsiElement)rPsiElement2, symbol, stringBuilder, true);
        RubyHelpUtil.a(symbol, stringBuilder, true, (PsiElement)rPsiElement);
        if (!(symbol instanceof ClassModuleSymbol)) {
            RubyHelpUtil.a(rPsiElement, rPsiElement2, symbol, stringBuilder);
        }
        stringBuilder.append("</pre></div>");
        String string = RubyHelpUtil.a(symbol, list2);
        if (string != null) {
            stringBuilder.append(string);
        }
        List<Map<String, String>> list3 = RubyHelpUtil.a(symbol);
        RubyHelpUtil.a(stringBuilder, list3);
        String string2 = stringBuilder.toString();
        if (string2 == null) {
            RubyHelpUtil.a(17);
        }
        return string2;
    }

    private static void a(@NotNull Symbol symbol, @NotNull StringBuilder stringBuilder, RPsiElement rPsiElement) {
        long l2 = l ^ 0xEFBFB374689L;
        if (symbol == null) {
            RubyHelpUtil.a(18);
        }
        if (stringBuilder == null) {
            RubyHelpUtil.a(19);
        }
        if (symbol.getType() == Type.LOCAL_VARIABLE || symbol.getType() == Type.METHOD_PARAMETER) {
            return;
        }
        FQN fQN = symbol.getFQNWithNesting().getCallerFQN();
        if ((symbol.getType() == Type.CLASS_METHOD || symbol.getType() == Type.INSTANCE_METHOD || symbol.getType() == Type.CLASS_FIELD) && fQN.getShortName().equals("$$SINGLETON$$") && (fQN = fQN.getCallerFQN()) == FQN.INVALID) {
            fQN = FQN.of("Object");
        }
        if (fQN == FQN.INVALID) {
            return;
        }
        stringBuilder.append(RubyHelpUtil.linkinize(symbol.getProject(), RContainerPresentationUtil.getHumanizedFQN(fQN, symbol, (PsiElement)rPsiElement), (PsiElement)rPsiElement)).append("\n");
    }

    @Nullable
    private static String a(@NotNull Symbol symbol, @NotNull List<PsiElement> list2) {
        long l2 = l ^ 0x39F16F763133L;
        if (symbol == null) {
            RubyHelpUtil.a(20);
        }
        if (list2 == null) {
            RubyHelpUtil.a(21);
        }
        if (list2.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        PsiElement psiElement2 = (PsiElement)ContainerUtil.getFirstItem(list2);
        Optional.ofNullable(RubyHelpUtil.a(psiElement2, symbol)).ifPresent(string -> {
            long l2 = l ^ 0x5C5B27E20052L;
            stringBuilder.append("<div class='content'>");
            stringBuilder.append((String)string);
            stringBuilder.append("</div>");
        });
        Ref ref = Ref.create((Object)false);
        list2.stream().skip(1L).forEach(psiElement -> {
            long l2 = l ^ 0x569A79F7A339L;
            String string = RubyHelpUtil.a(psiElement, symbol);
            if (string == null) {
                return;
            }
            if (!((Boolean)ref.get()).booleanValue()) {
                stringBuilder.append("<table class='sections'>");
                ref.set((Object)true);
            }
            stringBuilder.append("<tr>").append("<td valign='top'>");
            stringBuilder.append("<br>").append("<h4>").append("<span class='grayed'>");
            stringBuilder.append(psiElement instanceof RContainer ? RBundle.message("ruby.doc.documentation.from.partial", RContainerPresentationUtil.getLocation((RContainer)psiElement)) : RBundle.message("ruby.doc.documentation.from.partial.no.address"));
            stringBuilder.append("</span>").append("</h4><p>");
            stringBuilder.append(string);
            stringBuilder.append("</td>").append("</tr>");
        });
        if (((Boolean)ref.get()).booleanValue()) {
            stringBuilder.append("</table>");
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    private static void a(StringBuilder stringBuilder, List<Map<String, String>> list2) {
        if (list2.isEmpty()) {
            return;
        }
        RubyHelpUtil.a(stringBuilder, list2.get(0));
    }

    private static void a(@NotNull StringBuilder stringBuilder, @NotNull Map<String, String> map2) {
        long l2 = l ^ 0x1327F7A69D38L;
        if (stringBuilder == null) {
            RubyHelpUtil.a(22);
        }
        if (map2 == null) {
            RubyHelpUtil.a(23);
        }
        stringBuilder.append("<table class='sections'>");
        for (String string : a) {
            String string2 = map2.get(string);
            if (string2 == null) continue;
            stringBuilder.append("<tr><td valign='top' class='section'><p>");
            stringBuilder.append(string);
            stringBuilder.append("</td><td valign='top'>");
            stringBuilder.append(string2);
        }
        stringBuilder.append("</table>");
    }

    @NotNull
    private static List<Map<String, String>> a(@NotNull Symbol symbol) {
        if (symbol == null) {
            RubyHelpUtil.a(24);
        }
        if (symbol instanceof RMethodSymbol) {
            PsiElement psiElement = symbol.getPsiElement();
            if (psiElement instanceof RMethod) {
                List<Map<String, String>> list2 = RubyHelpUtil.b((RMethod)psiElement);
                if (list2 == null) {
                    RubyHelpUtil.a(25);
                }
                return list2;
            }
            if (psiElement instanceof MethodNameFakePsiElement) {
                YARDSubMethodDirective yARDSubMethodDirective = YARDUtil.recreateTagByFakeMethodName((MethodNameFakePsiElement)psiElement);
                List<Map<String, String>> list3 = yARDSubMethodDirective != null ? RubyHelpUtil.a(yARDSubMethodDirective.getChildTags()) : Collections.emptyList();
                if (list3 == null) {
                    RubyHelpUtil.a(26);
                }
                return list3;
            }
        }
        List<Map<String, String>> list4 = Collections.emptyList();
        if (list4 == null) {
            RubyHelpUtil.a(27);
        }
        return list4;
    }

    @NotNull
    private static List<Map<String, String>> b(@NotNull RPsiElement rPsiElement) {
        if (rPsiElement == null) {
            RubyHelpUtil.a(28);
        }
        if (rPsiElement instanceof RMethod) {
            List<Map<String, String>> list2 = RubyHelpUtil.a(((RMethod)rPsiElement).getYARDTags());
            if (list2 == null) {
                RubyHelpUtil.a(29);
            }
            return list2;
        }
        List<Map<String, String>> list3 = Collections.emptyList();
        if (list3 == null) {
            RubyHelpUtil.a(30);
        }
        return list3;
    }

    @NotNull
    private static List<Map<String, String>> a(@NotNull List<YARDTag> list2) {
        long l2 = l ^ 0x524164433C02L;
        if (list2 == null) {
            RubyHelpUtil.a(31);
        }
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        arrayList.add(hashMap);
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        for (YARDTag yARDTag : list2) {
            String string;
            if (yARDTag instanceof YARDOverloadDirective) {
                arrayList.addAll(RubyHelpUtil.a(((YARDOverloadDirective)yARDTag).getChildTags()));
                continue;
            }
            if (yARDTag instanceof YARDParamTag) {
                string = ((YARDParamTag)yARDTag).getDescription();
                if (StringUtil.isEmptyOrSpaces((String)string)) continue;
                stringBuilder.append("<p>").append(((YARDParamTag)yARDTag).getName()).append(" &mdash; ").append(string);
                continue;
            }
            if (yARDTag instanceof YARDReturnTag) {
                string = ((YARDReturnTag)yARDTag).getDescription();
                if (StringUtil.isEmptyOrSpaces((String)string)) continue;
                hashMap.put(j, string);
                continue;
            }
            if (yARDTag instanceof YARDOptionTag) {
                if (stringBuilder3.length() == 0) {
                    stringBuilder3.append("<p>For ").append(((YARDOptionTag)yARDTag).getName()).append(":</p>");
                }
                stringBuilder3.append("<p>").append(((YARDOptionTag)yARDTag).getOptionName()).append(" &mdash; ");
                if (((YARDOptionTag)yARDTag).isRequired()) {
                    stringBuilder3.append("(required) ");
                }
                stringBuilder3.append(((YARDOptionTag)yARDTag).getDescription());
                continue;
            }
            if (!(yARDTag instanceof YARDYieldparamTag)) continue;
            string = ((YARDYieldparamTag)yARDTag).getDescription();
            stringBuilder2.append("<p>").append(((YARDYieldparamTag)yARDTag).getName()).append(" &mdash; ").append(string);
        }
        if (stringBuilder.length() > 0) {
            hashMap.put(c, stringBuilder.toString());
        }
        if (stringBuilder3.length() > 0) {
            hashMap.put(h, stringBuilder3.toString());
        }
        if (stringBuilder2.length() > 0) {
            hashMap.put(b, stringBuilder2.toString());
        }
        if (((Map)arrayList.get(0)).isEmpty()) {
            arrayList.remove(0);
        }
        ArrayList<Map<String, String>> arrayList2 = arrayList;
        if (arrayList2 == null) {
            RubyHelpUtil.a(32);
        }
        return arrayList2;
    }

    private static void a(@NotNull PsiElement psiElement, @Nullable Symbol symbol, StringBuilder stringBuilder, boolean bl2) {
        if (psiElement == null) {
            RubyHelpUtil.a(33);
        }
        if (symbol != null && symbol.getType() == Type.ALIAS) {
            if (psiElement instanceof RCall) {
                List<RPsiElement> list2 = ((RCall)psiElement).getArguments();
                if (list2.size() == 2) {
                    RPsiElement rPsiElement = list2.get(0);
                    RPsiElement rPsiElement2 = list2.get(1);
                    RubyHelpUtil.a(rPsiElement != null ? RubyPsiUtil.getElementText((PsiElement)rPsiElement) : null, rPsiElement2 != null ? RubyPsiUtil.getElementText((PsiElement)rPsiElement2) : null, stringBuilder, bl2);
                    return;
                }
            } else if (psiElement instanceof RAliasStatement) {
                RAliasStatement rAliasStatement = (RAliasStatement)psiElement;
                RubyHelpUtil.a(rAliasStatement.getName(), rAliasStatement.getOldName(), stringBuilder, bl2);
                return;
            }
        }
        RubyHelpUtil.a(psiElement, symbol, bl2, stringBuilder);
    }

    private static void a(RPsiElement rPsiElement, @Nullable Symbol symbol, StringBuilder stringBuilder) {
        Symbol symbol2;
        if (rPsiElement instanceof RMethod) {
            String string = ((RMethod)rPsiElement).getVisibility().getPresentableName();
            stringBuilder.append(string).append(' ');
        } else if (symbol != null && symbol.getType() == Type.ALIAS && (symbol2 = SymbolUtil.getMethodSymbolByAlias(symbol)) != null && symbol2 instanceof RMethodSymbol) {
            String string = ((RMethodSymbol)symbol2).getVisibility().getPresentableName();
            stringBuilder.append(string).append(' ');
        }
    }

    private static void a(RPsiElement rPsiElement, @Nullable Symbol symbol, StringBuilder stringBuilder, boolean bl2) {
        String string;
        long l2 = l ^ 0x1BAC4CC46266L;
        String string2 = string = bl2 ? "&nbsp;" : " ";
        if (rPsiElement instanceof RContainer || symbol != null && symbol.getType() == Type.ALIAS) {
            stringBuilder.append(" ");
            stringBuilder.append(RBundle.message("in")).append(string);
            String string3 = RContainerPresentationUtil.getLocation(rPsiElement);
            if (bl2) {
                RubyDocumentationMarkupUtil.appendCode(stringBuilder, string3);
            } else {
                stringBuilder.append(string3);
            }
        }
        for (RubyElementNameAndDescriptionProvider rubyElementNameAndDescriptionProvider : RubyElementNameAndDescriptionProvider.EXTENSION_POINT_NAME.getExtensionList()) {
            rubyElementNameAndDescriptionProvider.appendVisibilityAndLocation((PsiElement)rPsiElement, stringBuilder, bl2);
        }
    }

    private static void a(@NotNull Symbol symbol, StringBuilder stringBuilder, boolean bl2, @Nullable PsiElement psiElement) {
        long l2 = l ^ 0x5AE801C19C4CL;
        if (symbol == null) {
            RubyHelpUtil.a(34);
        }
        if (symbol.getType() == Type.CLASS) {
            Symbol symbol2;
            Symbol symbol3 = symbol2 = symbol instanceof ClassModuleSymbol ? ((ClassModuleSymbol)symbol).getSuperClassSymbol(psiElement) : RubyMotionUtil.getInstance().getMotionSuperclass(symbol, psiElement);
            if (symbol2 != null) {
                if (bl2) {
                    stringBuilder.append("<span class='grayed'>");
                }
                stringBuilder.append("&nbsp;&lt;&nbsp;");
                stringBuilder.append(RubyHelpUtil.createRefText(symbol2, RContainerPresentationUtil.getPresentableSymbolName(symbol2, symbol2.getPsiElement())));
                if (bl2) {
                    stringBuilder.append("</span>");
                }
            }
        }
    }

    private static void a(@Nullable RPsiElement rPsiElement, RPsiElement rPsiElement2, @Nullable Symbol symbol, StringBuilder stringBuilder) {
        long l2 = l ^ 0x61440D6290DDL;
        RType rType = null;
        if (RubyHelpUtil.a(rPsiElement)) {
            rType = RTypeUtil.getExpressionType((PsiElement)rPsiElement);
        }
        if (rType == null) {
            if (rPsiElement2 instanceof RMethod) {
                rType = RubyHelpUtil.a((RMethod)rPsiElement2);
            }
            if (rType == null && rPsiElement == null && RubyHelpUtil.a(rPsiElement2)) {
                rType = RTypeUtil.getExpressionType((PsiElement)rPsiElement2);
            }
        }
        if (rType == null && symbol instanceof TypedSymbol) {
            Context context = rPsiElement != null ? Context.getContext((PsiElement)rPsiElement) : null;
            context = context == null && rPsiElement2 != null ? Context.getContext((PsiElement)rPsiElement2) : context;
            RType rType2 = rType = context != null ? ((TypedSymbol)symbol).getType(context) : null;
        }
        if (RTypeUtil.isNotEmpty(rType)) {
            if (symbol instanceof CallableSymbol || rPsiElement2 instanceof RMethod) {
                stringBuilder.append(f);
                stringBuilder.append(RubyHelpUtil.a(rType, rPsiElement2));
            } else {
                stringBuilder.append(" (");
                stringBuilder.append(RubyHelpUtil.a(rType, rPsiElement2));
                stringBuilder.append(")");
            }
        }
    }

    private static void a(Symbol symbol, StringBuilder stringBuilder, boolean bl2) {
        Type type;
        long l2 = l ^ 0x5EFC46F2908L;
        if (symbol instanceof SingletonClassSymbol || symbol instanceof AnonymousClassModuleSymbol) {
            return;
        }
        Type type2 = type = symbol instanceof DelegateProducedSymbol ? Type.DELEGATE : symbol.getType();
        if (type == Type.INSTANCE_METHOD || type == Type.CLASS_METHOD) {
            boolean bl3 = "$$SINGLETON$$".equals(symbol.getFQNWithNesting().getCallerFQN().getShortName());
            stringBuilder.append(RBundle.message("ruby.doc.method")).append(' ').append(!bl3 ? "#" : "::");
        } else {
            String string = type.getPresentableName();
            if (string != null) {
                stringBuilder.append(string).append(' ');
            }
        }
    }

    private static boolean a(@Nullable RPsiElement rPsiElement) {
        return rPsiElement instanceof RIdentifier || rPsiElement instanceof RInstanceVariable || rPsiElement instanceof RClassVariable || rPsiElement instanceof RConstant;
    }

    static {
        l = com.jetbrains.python.psi.c.a(2564564701417696105L, -6646361623026231162L, MethodHandles.lookup().lookupClass()).a(230777616629005L);
        long l2 = l ^ 0x776F4C13AB76L;
        g = Logger.getInstance(RubyHelpUtil.class);
        a = Arrays.asList(c, h, b, j);
        d = Pattern.compile("^#\\s*(|:stopdoc:|\\w+:\\s*\\S+)\\s*(\\n|$)");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = l ^ 0x4D72C8890F25L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 12: 
            case 17: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 12: 
            case 17: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 5: 
            case 12: 
            case 17: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyHelpUtil";
                break;
            }
            case 6: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 10: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionText";
                break;
            }
            case 15: 
            case 20: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSymbol";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "section";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yardTags";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyHelpUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "linkinize";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeBrackets";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createHelpForSymbol";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "generateSections";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHelpByElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementKindInfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTypeText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "linkinize";
                break;
            }
            case 5: 
            case 12: 
            case 17: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendPresentableNameForContainer";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "formatMethodPresentableName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "formatDelegatedMethodPresentableName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "filterWrongDocumentation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionWithoutSymbol";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createHelpForSymbol";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "appendSymbolLocation";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationWithPartialDeclarations";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "renderSection";
                break;
            }
            case 24: 
            case 28: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "generateSections";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "appendPresentableName";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "appendSuperClassInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 12: 
            case 17: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

