/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.documentation;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDParser;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDTag;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDUtil;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.MethodNameFakePsiElement;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDParamTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDTypeTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.base.YARDSubMethodDirective;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.UsageAnalyzer;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.CommentDescriptor;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyDocumentationMarkupUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.VisibilityUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RArgumentListNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.RContainerBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.RHelpStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public class RubyCommentsUtil {
    private static final Pattern a;
    private static final long b;

    private RubyCommentsUtil() {
    }

    @NotNull
    public static List<PsiComment> getPsiComments(@NotNull PsiElement element) {
        Object object;
        if (element == null) {
            RubyCommentsUtil.a(0);
        }
        Object object2 = element;
        if (RubyPsiUtil.isDeclaration(element) && (element instanceof RConstant || element instanceof RGlobalVariable)) {
            object = RubyPsiUtil.getDeclaration(element);
            assert (object != null);
            object2 = object;
        } else if (element instanceof RIdentifier) {
            object2 = (PsiElement)ObjectUtils.chooseNotNull((Object)RubyCommentsUtil.b((RIdentifier)element), (Object)element);
        }
        object = RubyCommentsUtil.d(object2);
        if (!object.isEmpty()) {
            Object object3 = object;
            if (object3 == null) {
                RubyCommentsUtil.a(1);
            }
            return object3;
        }
        RPsiElement rPsiElement = (RPsiElement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)object2, RPsiElement.class);
        if (rPsiElement instanceof RIdentifier && VisibilityUtil.getVisibility(rPsiElement.getText()) != null) {
            object2 = rPsiElement;
        }
        List<PsiComment> list2 = RubyCommentsUtil.d(object2);
        if (list2 == null) {
            RubyCommentsUtil.a(2);
        }
        return list2;
    }

    @NotNull
    public static List<CommentDescriptor> collectCommentDescriptorsFromContainer(@Nullable RContainerBase container) {
        if (container == null) {
            List<CommentDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                RubyCommentsUtil.a(3);
            }
            return list2;
        }
        RBodyStatement rBodyStatement = container.getBody();
        while (rBodyStatement instanceof RBodyStatement) {
            rBodyStatement = rBodyStatement.getFirstChild();
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<PsiComment>();
        for (PsiElement psiElement : Arrays.asList(container, rBodyStatement)) {
            for (PsiElement psiElement2 = psiElement.getFirstChild(); psiElement2 != null; psiElement2 = psiElement2.getNextSibling()) {
                if (psiElement2 instanceof PsiComment) {
                    arrayList2.add((PsiComment)psiElement2);
                    continue;
                }
                if (arrayList2.isEmpty()) continue;
                if (psiElement2 instanceof PsiWhiteSpace && !RubyCommentsUtil.c(psiElement2)) {
                    arrayList.add(CommentDescriptor.withoutAnchor(arrayList2));
                    arrayList2 = new ArrayList();
                    continue;
                }
                if (psiElement2.getTextRange().isEmpty() || psiElement2 instanceof PsiWhiteSpace) continue;
                PsiElement psiElement3 = psiElement2;
                while (psiElement3 instanceof RCompoundStatement || psiElement3 instanceof RBodyStatement) {
                    psiElement3 = psiElement3.getFirstChild();
                }
                arrayList.add(new CommentDescriptor(arrayList2, psiElement3));
                arrayList2 = new ArrayList();
            }
            if (arrayList2.isEmpty()) continue;
            arrayList.add(CommentDescriptor.withoutAnchor(arrayList2));
        }
        List<CommentDescriptor> list3 = arrayList.isEmpty() ? Collections.emptyList() : arrayList;
        if (list3 == null) {
            RubyCommentsUtil.a(4);
        }
        return list3;
    }

    @Nullable
    private static PsiElement b(RIdentifier rIdentifier) {
        boolean bl2 = UsageAnalyzer.isMethodParameter(rIdentifier);
        boolean bl3 = UsageAnalyzer.isBlockParameter(rIdentifier) || UsageAnalyzer.isBlockCallLocalDeclaration(rIdentifier);
        boolean bl4 = UsageAnalyzer.isDeclaration((PsiElement)rIdentifier);
        if (bl2) {
            return null;
        }
        if (!bl3 && !bl4) {
            return null;
        }
        return RubyCommentsUtil.a(rIdentifier, bl2, bl3, bl4);
    }

    @Nullable
    public static String getPsiHelpWithoutLeadingSharps(@NotNull PsiElement element) {
        String string;
        if (element == null) {
            RubyCommentsUtil.a(5);
        }
        return (string = RubyCommentsUtil.getPsiHelp(element)) == null ? null : RubyDocumentationMarkupUtil.unsharpText(string);
    }

    @Nullable
    public static String getPsiHelp(@NotNull PsiElement element) {
        Object object;
        if (element == null) {
            RubyCommentsUtil.a(6);
        }
        if (!element.isValid()) {
            return null;
        }
        if (element instanceof StubBasedPsiElementBase && (object = ((StubBasedPsiElementBase)element).getGreenStub()) instanceof RHelpStub) {
            return ((RHelpStub)object).getHelp();
        }
        if (element instanceof RIdentifier && (object = RubyCommentsUtil.a((RIdentifier)element)) != null) {
            return object;
        }
        object = RubyCommentsUtil.getPsiComments(element);
        return RubyCommentsUtil.joinComments((List<? extends PsiComment>)object);
    }

    @Nullable
    public static String getPsiHelpWithoutYARD(@NotNull PsiElement element) {
        Object object;
        if (element == null) {
            RubyCommentsUtil.a(7);
        }
        if (!element.isValid()) {
            return null;
        }
        if (element instanceof RIdentifier) {
            object = RubyCommentsUtil.a((RIdentifier)element);
            if (object != null) {
                return object;
            }
        } else if (element instanceof MethodNameFakePsiElement) {
            YARDSubMethodDirective yARDSubMethodDirective = YARDUtil.recreateTagByFakeMethodName((MethodNameFakePsiElement)element);
            return yARDSubMethodDirective != null ? yARDSubMethodDirective.getDescription() : null;
        }
        object = RubyCommentsUtil.getPsiComments(element);
        List<YARDTag> list2 = YARDParser.parse((List<? extends PsiComment>)object);
        return RubyCommentsUtil.joinComments(YARDUtil.getCommentsWithoutYARD((List<PsiComment>)object, list2));
    }

    @Nullable
    public static String joinComments(@NotNull List<? extends PsiComment> list2) {
        if (list2 == null) {
            RubyCommentsUtil.a(8);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (PsiComment psiComment : list2) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(psiComment.getText());
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    @Nullable
    private static String a(RIdentifier rIdentifier) {
        boolean bl2 = UsageAnalyzer.isMethodParameter(rIdentifier);
        boolean bl3 = UsageAnalyzer.isBlockParameter(rIdentifier) || UsageAnalyzer.isBlockCallLocalDeclaration(rIdentifier);
        boolean bl4 = UsageAnalyzer.isDeclaration((PsiElement)rIdentifier);
        if (!(bl2 || bl3 || bl4)) {
            return null;
        }
        PsiElement psiElement = RubyCommentsUtil.a(rIdentifier, bl2, bl3, bl4);
        if (psiElement == null) {
            return null;
        }
        List<PsiComment> list2 = RubyCommentsUtil.getPsiComments(psiElement);
        String string = rIdentifier.getName();
        if (string == null) {
            return null;
        }
        for (YARDTag yARDTag : YARDParser.parse(list2)) {
            if (bl2 && yARDTag instanceof YARDParamTag && string.equals(((YARDParamTag)yARDTag).getName())) {
                return ((YARDParamTag)yARDTag).getDescription();
            }
            if (!bl3 && !bl4 || !(yARDTag instanceof YARDTypeTag) || !string.equals(((YARDTypeTag)yARDTag).getName())) continue;
            return ((YARDTypeTag)yARDTag).getDescription();
        }
        return null;
    }

    @Nullable
    private static PsiElement a(RIdentifier rIdentifier, boolean bl2, boolean bl3, boolean bl4) {
        long l2 = b ^ 0xDBC48D1B0ADL;
        if (bl2) {
            return PsiTreeUtil.getParentOfType((PsiElement)rIdentifier, RMethod.class);
        }
        if (bl3) {
            RArgumentList rArgumentList = RArgumentListNavigator.getByArgumentContents(rIdentifier);
            if (rArgumentList == null) {
                return null;
            }
            return PsiTreeUtil.prevVisibleLeaf((PsiElement)rArgumentList);
        }
        if (bl4) {
            return PsiTreeUtil.getParentOfType((PsiElement)rIdentifier, RAssignmentExpression.class);
        }
        throw new IllegalArgumentException("one of the three bools must be true!");
    }

    @NotNull
    private static PsiElement b(@NotNull PsiElement psiElement) {
        PsiElement psiElement2;
        if (psiElement == null) {
            RubyCommentsUtil.a(9);
        }
        while (psiElement.getPrevSibling() == null && ((psiElement2 = psiElement.getParent()) instanceof RCompoundStatement || psiElement2 instanceof RBodyStatement)) {
            psiElement = psiElement2;
        }
        PsiElement psiElement3 = psiElement;
        if (psiElement3 == null) {
            RubyCommentsUtil.a(10);
        }
        return psiElement3;
    }

    @NotNull
    private static List<PsiComment> d(@NotNull PsiElement psiElement) {
        PsiElement psiElement2;
        PsiComment psiComment;
        if (psiElement == null) {
            RubyCommentsUtil.a(11);
        }
        if ((psiComment = RubyCommentsUtil.getPrevComment(psiElement2 = RubyCommentsUtil.b(psiElement), RubyTokenTypes.tBLOCK_COMMENT)) != null) {
            List<PsiComment> list2 = Collections.singletonList(psiComment);
            if (list2 == null) {
                RubyCommentsUtil.a(12);
            }
            return list2;
        }
        LinkedList<PsiComment> linkedList = new LinkedList<PsiComment>();
        while ((psiElement2 = RubyCommentsUtil.getPrevComment(psiElement2, RubyTokenTypes.TLINE_COMMENT)) != null) {
            linkedList.addFirst((PsiComment)psiElement2);
        }
        LinkedList<PsiComment> linkedList2 = linkedList;
        if (linkedList2 == null) {
            RubyCommentsUtil.a(13);
        }
        return linkedList2;
    }

    @Nullable
    public static PsiComment getArrayElementComment(@NotNull PsiElement arrayElement) {
        if (arrayElement == null) {
            RubyCommentsUtil.a(14);
        }
        PsiElement psiElement = arrayElement.getNextSibling();
        while (!RubyCommentsUtil.a(psiElement)) {
            if (psiElement == null) {
                return null;
            }
            ASTNode aSTNode = psiElement.getNode();
            if (aSTNode == null) {
                return null;
            }
            if (psiElement instanceof PsiWhiteSpace || RubyTokenTypes.tCOMMA == aSTNode.getElementType()) {
                psiElement = psiElement.getNextSibling();
                continue;
            }
            return null;
        }
        return (PsiComment)psiElement;
    }

    @Nullable
    public static PsiComment getPrevComment(@NotNull PsiElement anchorElement, @NotNull IElementType commentType) {
        if (anchorElement == null) {
            RubyCommentsUtil.a(15);
        }
        if (commentType == null) {
            RubyCommentsUtil.a(16);
        }
        PsiElement psiElement = anchorElement.getPrevSibling();
        while (PsiUtilCore.getElementType((PsiElement)psiElement) != commentType) {
            if (RubyCommentsUtil.c(psiElement) || psiElement != null && psiElement.getLanguage() == Language.ANY) {
                psiElement = psiElement.getPrevSibling();
                continue;
            }
            return null;
        }
        return (PsiComment)psiElement;
    }

    private static boolean a(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return false;
        }
        ASTNode aSTNode = psiElement.getNode();
        return aSTNode != null && aSTNode.getElementType() == RubyTokenTypes.TLINE_COMMENT;
    }

    @NotNull
    public static TextRange getLineCommentsRange(PsiElement lineComment) {
        TextRange textRange = lineComment.getTextRange();
        int n2 = textRange.getStartOffset();
        int n3 = textRange.getEndOffset();
        PsiElement psiElement = lineComment;
        while (RubyCommentsUtil.c(psiElement = psiElement.getPrevSibling()) && PsiUtilCore.getElementType((PsiElement)(psiElement = psiElement.getPrevSibling())) == RubyTokenTypes.TLINE_COMMENT) {
            n2 = psiElement.getTextRange().getStartOffset();
        }
        psiElement = lineComment;
        while (true) {
            if ((psiElement = psiElement.getNextSibling()) != null) {
                ++n3;
            }
            if (!RubyCommentsUtil.c(psiElement)) break;
            n3 = psiElement.getTextRange().getEndOffset();
            if (PsiUtilCore.getElementType((PsiElement)(psiElement = psiElement.getNextSibling())) != RubyTokenTypes.TLINE_COMMENT) break;
            n3 = psiElement.getTextRange().getEndOffset();
        }
        TextRange textRange2 = new TextRange(n2, n3);
        if (textRange2 == null) {
            RubyCommentsUtil.a(17);
        }
        return textRange2;
    }

    private static boolean c(PsiElement psiElement) {
        return psiElement instanceof PsiWhiteSpace && a.matcher(psiElement.getText()).matches();
    }

    static {
        b = c.a(-6765429627724477105L, 2412828383827506860L, MethodHandles.lookup().lookupClass()).a(153255930579675L);
        long l2 = b ^ 0x41B3419C7E3L;
        a = Pattern.compile(" *\\n *");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x85ACF2F2E91L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 17: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyCommentsUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorElement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyCommentsUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiComments";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCommentDescriptorsFromContainer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareAnchor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiCommentsByAnchor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineCommentsRange";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPsiComments";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 17: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPsiHelpWithoutLeadingSharps";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPsiHelp";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPsiHelpWithoutYARD";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "joinComments";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "prepareAnchor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPsiCommentsByAnchor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getArrayElementComment";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPrevComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

