/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.interpret;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RPsiPolyVariantReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RQualifiedReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RNameUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;

public class RubyPsiInterpreter {
    private static final Logger c;
    private final Map<RIdentifier, PsiCallable> e;
    private final Map<String, PsiCallable> d;
    private final Collection<PsiElement> a;
    private final boolean b;
    private static final long f;

    public RubyPsiInterpreter() {
        this(false);
    }

    public RubyPsiInterpreter(boolean lightMode) {
        this(new HashSet<PsiElement>(), lightMode);
    }

    RubyPsiInterpreter(@NotNull Collection<PsiElement> callStack, boolean lightMode) {
        if (callStack == null) {
            RubyPsiInterpreter.a(0);
        }
        this.e = new HashMap<RIdentifier, PsiCallable>();
        this.d = new HashMap<String, PsiCallable>();
        this.a = callStack;
        this.b = lightMode;
    }

    public boolean isInLightMode() {
        return this.b;
    }

    public void interpret(@NotNull PsiElement element, final PsiCallable self) {
        if (element == null) {
            RubyPsiInterpreter.a(1);
        }
        if (this.a.contains(element)) {
            return;
        }
        this.a.add(element);
        element.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            @Override
            public void visitRBlockCall(RBlockCall blockCall) {
                RubyPsiInterpreter.this.visitRBlockCall(blockCall, self);
            }

            @Override
            public void visitRCall(RCall rCall) {
                RubyPsiInterpreter.this.visitRCall(rCall, self);
            }

            @Override
            public void visitRDotReference(RDotReference rDotReference) {
                RubyPsiInterpreter.this.visitRDotReference(rDotReference, self);
            }

            @Override
            public void visitRIdentifier(RIdentifier rIdentifier) {
                RubyPsiInterpreter.this.visitRIdentifier(rIdentifier, self);
            }
        });
    }

    public void interpretCallsTreePath(PsiElement element, final @Nullable PsiCallable self) {
        if (this.a.contains(element)) {
            return;
        }
        this.a.add(element);
        element.accept((PsiElementVisitor)new RubyElementVisitor(){

            public void visitElement(PsiElement element) {
                PsiElement psiElement = element.getParent();
                if (psiElement != null) {
                    psiElement.accept((PsiElementVisitor)this);
                }
            }

            @Override
            public void visitRCall(RCall rCall) {
                RubyPsiInterpreter.this.visitRCall(rCall, self);
                this.a((PsiElement)rCall);
            }

            @Override
            public void visitRBlockCall(RBlockCall blockCall) {
                RubyPsiInterpreter.this.visitRBlockCall(blockCall, self);
                this.a((PsiElement)blockCall);
            }

            @Override
            public void visitRDotReference(RDotReference rDotReference) {
                RubyPsiInterpreter.this.visitRDotReference(rDotReference, self);
                this.a((PsiElement)rDotReference);
            }

            @Override
            public void visitRIdentifier(RIdentifier rIdentifier) {
                RubyPsiInterpreter.this.visitRIdentifier(rIdentifier, self);
                this.a((PsiElement)rIdentifier);
            }

            private void a(PsiElement psiElement) {
                PsiElement psiElement2;
                if (psiElement != null && (psiElement2 = psiElement.getParent()) != null) {
                    this.visitElement(psiElement2);
                }
            }
        });
    }

    public void interpretBlock(RCodeBlock block, PsiCallable self, PsiCallable ... args) {
        RBlockArgumentList rBlockArgumentList = block.getBlockArguments();
        if (rBlockArgumentList != null) {
            List<RArgument> list2 = rBlockArgumentList.getArguments();
            for (int i10 = 0; i10 < list2.size() && i10 < args.length; ++i10) {
                this.e.put(list2.get(i10).getIdentifier(), args[i10]);
            }
        }
        this.interpret((PsiElement)block, self);
    }

    public void registerCallable(PsiCallable psiCallable, String ... names) {
        for (String string : names) {
            this.d.put(string, psiCallable);
        }
    }

    public void visitRCall(RCall rCall, PsiCallable self) {
        this.a(rCall.getPsiCommand(), rCall, null, self);
    }

    public void visitRBlockCall(RBlockCall blockCall, PsiCallable self) {
        RPossibleCall rPossibleCall = blockCall.getCall();
        if (rPossibleCall instanceof RCall) {
            this.a(((RCall)rPossibleCall).getPsiCommand(), (RCall)rPossibleCall, blockCall.getBlock(), self);
        } else {
            this.a((PsiElement)rPossibleCall, null, blockCall.getBlock(), self);
        }
    }

    public void visitRDotReference(RDotReference rDotReference, PsiCallable self) {
        this.a((PsiElement)rDotReference, null, null, self);
    }

    public void visitRIdentifier(RIdentifier rIdentifier, PsiCallable self) {
        this.a((PsiElement)rIdentifier, null, null, self);
    }

    private void a(PsiElement psiElement, @Nullable RCall rCall, @Nullable RCodeBlock rCodeBlock, PsiCallable psiCallable) {
        RefObject refObject = RubyPsiInterpreter.a(psiElement);
        if (!refObject.isValid()) {
            return;
        }
        PsiCallable psiCallable2 = this.a(refObject);
        if (psiCallable2 == null) {
            psiCallable2 = psiCallable;
        }
        if (psiCallable2 != null) {
            psiCallable2.processCall(new RCallArguments(this, psiCallable, psiElement, refObject.getCommand(), rCall == null ? Collections.emptyList() : rCall.getArguments(), rCodeBlock));
        }
    }

    @Nullable
    private PsiCallable a(@NotNull RefObject refObject) {
        Object object;
        Object object2;
        PsiElement psiElement;
        if (refObject == null) {
            RubyPsiInterpreter.a(2);
        }
        if ((psiElement = refObject.getRefObject()) instanceof RIdentifier) {
            object2 = (RIdentifier)psiElement;
            if (!this.isInLightMode()) {
                if (RBlockCallNavigator.getByCall((RPsiElement)object2) != null) {
                    return null;
                }
                object = object2.getScopeVariable();
                if (object != null) {
                    for (PsiElement psiElement2 : object.getDeclarations()) {
                        PsiCallable psiCallable = this.e.get(psiElement2);
                        if (psiCallable == null) continue;
                        return psiCallable;
                    }
                    return null;
                }
            } else {
                object = object2.getName();
                if (object != null) {
                    for (Map.Entry<RIdentifier, PsiCallable> entry : this.e.entrySet()) {
                        if (!StringUtil.equals((CharSequence)object, (CharSequence)entry.getKey().getName())) continue;
                        return entry.getValue();
                    }
                }
            }
        }
        if (!this.d.isEmpty()) {
            object2 = refObject.getReference();
            if (object2 == null) {
                return null;
            }
            if (!this.isInLightMode() && (object = this.a((RPsiPolyVariantReference)object2)) != null) {
                return object;
            }
            return this.d.get(RNameUtilCore.getPath(object2.getElement()).getFullPath());
        }
        return null;
    }

    @Nullable
    private PsiCallable a(RPsiPolyVariantReference rPsiPolyVariantReference) {
        Symbol symbol = ResolveUtil.resolveToSymbolWithCaching((PsiReference)rPsiPolyVariantReference);
        if (symbol != null) {
            FQN fQN = symbol.getFQNWithNesting();
            PsiCallable psiCallable = this.d.get(fQN.getFullPath());
            if (psiCallable == null && symbol.getType() == Type.ALIAS) {
                Symbol symbol2 = SymbolUtil.getMethodSymbolByAlias(symbol);
                fQN = symbol2 != null ? symbol2.getFQNWithNesting() : FQN.INVALID;
                psiCallable = this.d.get(fQN.getFullPath());
            }
            return psiCallable;
        }
        return null;
    }

    public RubyPsiInterpreter child() {
        return new RubyPsiInterpreter(this.a, this.b);
    }

    public static boolean isInResolvableCallScope(@NotNull PsiElement psiElement, @NotNull Set<String> acceptableCallFQNs, @Nullable Set<String> forbiddenCallFQNs) {
        if (psiElement == null) {
            RubyPsiInterpreter.a(3);
        }
        if (acceptableCallFQNs == null) {
            RubyPsiInterpreter.a(4);
        }
        return RubyPsiInterpreter.getResolvableCallScope(psiElement, acceptableCallFQNs, forbiddenCallFQNs) != null;
    }

    public static boolean isInCallScope(@NotNull PsiElement psiElement, @NotNull Set<String> acceptableCallNames, @Nullable Set<String> forbiddenCallNames) {
        if (psiElement == null) {
            RubyPsiInterpreter.a(5);
        }
        if (acceptableCallNames == null) {
            RubyPsiInterpreter.a(6);
        }
        return RubyPsiInterpreter.getCallScope(psiElement, acceptableCallNames, forbiddenCallNames) != null;
    }

    @Nullable
    public static RPossibleCall getResolvableCallScope(@NotNull PsiElement psiElement, @NotNull Set<String> acceptableCallFQNs, @Nullable Set<String> forbiddenCallFQNs) {
        RPsiElement rPsiElement;
        if (psiElement == null) {
            RubyPsiInterpreter.a(7);
        }
        if (acceptableCallFQNs == null) {
            RubyPsiInterpreter.a(8);
        }
        if ((rPsiElement = RubyPsiUtil.getCoveringRPsiElement(psiElement)) == null) {
            return null;
        }
        return RubyPsiInterpreter.a((PsiElement)rPsiElement, true, acceptableCallFQNs, forbiddenCallFQNs);
    }

    @Nullable
    public static RPossibleCall getCallScope(@NotNull PsiElement psiElement, @NotNull Set<String> acceptableCallNames, @Nullable Set<String> forbiddenCallNames) {
        RPsiElement rPsiElement;
        if (psiElement == null) {
            RubyPsiInterpreter.a(9);
        }
        if (acceptableCallNames == null) {
            RubyPsiInterpreter.a(10);
        }
        if ((rPsiElement = RubyPsiUtil.getCoveringRPsiElement(psiElement)) == null) {
            return null;
        }
        return RubyPsiInterpreter.a((PsiElement)rPsiElement, false, acceptableCallNames, forbiddenCallNames);
    }

    @Nullable
    private static RPossibleCall a(@NotNull PsiElement psiElement, boolean bl2, @NotNull Set<String> set, @Nullable Set<String> set2) {
        Object object;
        RPossibleCall rPossibleCall;
        long l2 = f ^ 0xAA370DF77ADL;
        if (psiElement == null) {
            RubyPsiInterpreter.a(11);
        }
        if (set == null) {
            RubyPsiInterpreter.a(12);
        }
        RPossibleCall rPossibleCall2 = rPossibleCall = psiElement instanceof RPossibleCall ? (RPossibleCall)psiElement : (RPossibleCall)PsiTreeUtil.getParentOfType((PsiElement)psiElement, RPossibleCall.class);
        if (rPossibleCall == null) {
            return null;
        }
        PsiElement psiElement2 = rPossibleCall.getPsiCommand();
        if (psiElement2 != null && rPossibleCall.isCall()) {
            if (bl2) {
                object = RubyPsiInterpreter.c(psiElement2);
                if (object == null) {
                    return null;
                }
                if (object instanceof RPsiPolyVariantReference) {
                    Symbol symbol = ResolveUtil.resolveToSymbolWithCaching((PsiReference)object);
                    if (symbol != null) {
                        String string = symbol.getFQNWithNesting().getFullPath().replace("::$$SINGLETON$$", "");
                        if (set.contains(string)) {
                            return rPossibleCall;
                        }
                        if (set2 != null && set2.contains(string)) {
                            return null;
                        }
                    }
                    c.info("unresolved reference in isResolvableCallScope(): " + psiElement2.getText());
                }
            } else {
                object = rPossibleCall.getCommand();
                if (set.contains(object)) {
                    return rPossibleCall;
                }
                if (set2 != null && set2.contains(object)) {
                    return null;
                }
            }
        }
        return (object = (RBlockCall)PsiTreeUtil.getParentOfType((PsiElement)rPossibleCall, RBlockCall.class)) != null ? RubyPsiInterpreter.a((PsiElement)object, bl2, set, set2) : null;
    }

    @Nullable
    public static RPossibleCall getSimpleCoveringCodeBlockScope(@NotNull PsiElement psiElement, @NotNull Set<String> acceptableCallNames, @Nullable Set<String> forbiddenCallNames) {
        RCodeBlock rCodeBlock;
        RBlockCall rBlockCall;
        if (psiElement == null) {
            RubyPsiInterpreter.a(13);
        }
        if (acceptableCallNames == null) {
            RubyPsiInterpreter.a(14);
        }
        RBlockCall rBlockCall2 = rBlockCall = (rCodeBlock = (RCodeBlock)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)psiElement, RCodeBlock.class)) != null ? rCodeBlock.getBlockCall() : null;
        if (rBlockCall == null) {
            return null;
        }
        String string = rBlockCall.getCommand();
        if (string != null) {
            if (acceptableCallNames.contains(string)) {
                return rBlockCall;
            }
            if (forbiddenCallNames != null && forbiddenCallNames.contains(string)) {
                return null;
            }
        }
        return RubyPsiInterpreter.getSimpleCoveringCodeBlockScope((PsiElement)rBlockCall, acceptableCallNames, forbiddenCallNames);
    }

    @NotNull
    private static RefObject a(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RubyPsiInterpreter.a(15);
        }
        if (psiElement instanceof RIdentifier) {
            RIdentRef rIdentRef = new RIdentRef((RIdentifier)psiElement);
            if (rIdentRef == null) {
                RubyPsiInterpreter.a(16);
            }
            return rIdentRef;
        }
        QualifiedRefObject qualifiedRefObject = new QualifiedRefObject(psiElement);
        if (qualifiedRefObject == null) {
            RubyPsiInterpreter.a(17);
        }
        return qualifiedRefObject;
    }

    private static PsiReference c(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RubyPsiInterpreter.a(18);
        }
        return (PsiReference)CachedValuesManager.getCachedValue((PsiElement)psiElement, () -> CachedValueProvider.Result.create((Object)(psiElement instanceof RPsiElement ? ((RPsiElement)psiElement).getReferenceEx(true) : psiElement.getReference()), (Object[])new Object[]{psiElement}));
    }

    static {
        f = com.jetbrains.python.psi.c.a(-1196628635208318609L, 8490332494536046389L, MethodHandles.lookup().lookupClass()).a(112891371280500L);
        c = Logger.getInstance(RubyPsiInterpreter.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = f ^ 0x112ED391B296L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 16: 
            case 17: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callStack";
                break;
            }
            case 1: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptableCallFQNs";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptableCallNames";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptableCallNamesOrFQNs";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiCommand";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/interpret/RubyPsiInterpreter";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/interpret/RubyPsiInterpreter";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createRefObject";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "interpret";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findCallable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInResolvableCallScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInCallScope";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getResolvableCallScope";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCallScope";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleCoveringCodeBlockScope";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createRefObject";
                break;
            }
            case 16: 
            case 17: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceFromPsiElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class QualifiedRefObject
    implements RefObject {
        private final PsiElement a;
        private final RQualifiedReference b;
        private static final long c = com.jetbrains.python.psi.c.a(6194445309287441427L, 5229163439105884529L, MethodHandles.lookup().lookupClass()).a(26988062876940L);

        QualifiedRefObject(@NotNull PsiElement psiCommand) {
            if (psiCommand == null) {
                QualifiedRefObject.a(0);
            }
            PsiReference psiReference = RubyPsiInterpreter.c(psiCommand);
            if (psiReference instanceof RQualifiedReference) {
                this.b = (RQualifiedReference)psiReference;
                this.a = ((RQualifiedReference)psiReference).getRefObject();
            } else {
                this.a = null;
                this.b = null;
            }
        }

        @Override
        public boolean isValid() {
            return this.b != null;
        }

        @Override
        @Nullable
        public PsiElement getRefObject() {
            return this.a;
        }

        @Override
        @Nullable
        public RQualifiedReference getReference() {
            return this.b;
        }

        @Override
        @NotNull
        public String getCommand() {
            long l2 = c ^ 0x6F5F902D2C7BL;
            if (!this.isValid()) {
                throw new IllegalStateException("Should not invoke getCommand on invalid ref");
            }
            String string = this.b.getRefValue().getText();
            if (string == null) {
                QualifiedRefObject.a(1);
            }
            return string;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x7B030E672D27L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiCommand";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/interpret/RubyPsiInterpreter$QualifiedRefObject";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/interpret/RubyPsiInterpreter$QualifiedRefObject";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommand";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class RIdentRef
    implements RefObject {
        private final RIdentifier a;
        private static final long b = com.jetbrains.python.psi.c.a(3781209265883222362L, -1050872114483757305L, MethodHandles.lookup().lookupClass()).a(2446661864713L);

        RIdentRef(@NotNull RIdentifier ident) {
            if (ident == null) {
                RIdentRef.a(0);
            }
            this.a = ident;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        @NotNull
        public PsiElement getRefObject() {
            RIdentifier rIdentifier = this.a;
            if (rIdentifier == null) {
                RIdentRef.a(1);
            }
            return rIdentifier;
        }

        @Override
        @Nullable
        public RPsiPolyVariantReference getReference() {
            PsiReference psiReference = this.a.getReference();
            return psiReference instanceof RPsiPolyVariantReference ? (RPsiPolyVariantReference)psiReference : null;
        }

        @Override
        @NotNull
        public String getCommand() {
            String string = this.a.getText();
            if (string == null) {
                RIdentRef.a(2);
            }
            return string;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = b ^ 0x22E636174D39L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ident";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/interpret/RubyPsiInterpreter$RIdentRef";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/interpret/RubyPsiInterpreter$RIdentRef";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRefObject";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommand";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface RefObject {
        public boolean isValid();

        @Nullable
        public PsiElement getRefObject();

        @Nullable
        public RPsiPolyVariantReference getReference();

        @NotNull
        public String getCommand();
    }
}

