/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.interpret;

import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.ConstantStringInferenceResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.StringValue;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.StringValueArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;

public final class RubyInterpretUtil {
    private static final long a = c.a(8507763763837738951L, 30555813564972177L, MethodHandles.lookup().lookupClass()).a(145238163263463L);

    private RubyInterpretUtil() {
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static String evaluateOptionValue(@NotNull RPossibleCall possibleCall, @Nullable String key) {
        if (possibleCall == null) {
            RubyInterpretUtil.a(0);
        }
        RPsiElement rPsiElement = RubyInterpretUtil.getOptionValueElement(possibleCall.getArguments(), key);
        return ConstantStringInferenceResult.getStringRepresentation((PsiElement)rPsiElement).getOnlyString();
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static List<String> evaluateOptionValues(@NotNull RPossibleCall call, @Nullable String key) {
        if (call == null) {
            RubyInterpretUtil.a(1);
        }
        return RubyInterpretUtil.evaluateOptionValues(call.getArguments(), key);
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static List<String> evaluateOptionValues(@NotNull List<? extends PsiElement> arguments, @Nullable String key) {
        RPsiElement rPsiElement;
        if (arguments == null) {
            RubyInterpretUtil.a(2);
        }
        if ((rPsiElement = RubyInterpretUtil.getOptionValueElement(arguments, key)) == null) {
            return null;
        }
        StringValue stringValue = ConstantStringInferenceResult.getStringRepresentation((PsiElement)rPsiElement);
        if (stringValue instanceof StringValueArray) {
            return ContainerUtil.mapNotNull(((StringValueArray)stringValue).getStringValueList(), StringValue::getOnlyString);
        }
        return ContainerUtil.createMaybeSingletonList((Object)stringValue.getOnlyString());
    }

    @Contract(value="null -> null")
    @Nullable
    public static String evaluateStringOrSymbolElement(@Nullable PsiElement element) {
        if (!(element instanceof RStringLiteral) && !(element instanceof RSymbol)) {
            return null;
        }
        return ConstantStringInferenceResult.getStringRepresentation(element).getOnlyString();
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static RAssoc getOptionAssocElement(@NotNull RPossibleCall possibleCall, @Nullable String key) {
        if (possibleCall == null) {
            RubyInterpretUtil.a(3);
        }
        return RubyInterpretUtil.getOptionAssocElement(possibleCall.getArguments(), key);
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static RAssoc getOptionAssocElement(@NotNull List<? extends PsiElement> arguments, @Nullable String key) {
        if (arguments == null) {
            RubyInterpretUtil.a(4);
        }
        return arguments.stream().map(psiElement -> (RAssoc)ObjectUtils.tryCast((Object)psiElement, RAssoc.class)).filter(Objects::nonNull).filter(rAssoc -> rAssoc.getKeyText().equals(key)).findFirst().orElse(null);
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static RPsiElement getOptionValueElement(@NotNull List<? extends PsiElement> arguments, @Nullable String key) {
        if (arguments == null) {
            RubyInterpretUtil.a(5);
        }
        return (RPsiElement)ObjectUtils.doIfNotNull((Object)RubyInterpretUtil.getOptionAssocElement(arguments, key), RAssoc::getValue);
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static List<? extends RPsiElement> getOptionValueElements(@NotNull RPossibleCall possibleCall, @Nullable String key) {
        RPsiElement rPsiElement;
        if (possibleCall == null) {
            RubyInterpretUtil.a(6);
        }
        if ((rPsiElement = RubyInterpretUtil.getOptionValueElement(possibleCall.getArguments(), key)) instanceof RArray) {
            return ((RArray)rPsiElement).getElements();
        }
        return (List)ObjectUtils.doIfNotNull((Object)rPsiElement, Collections::singletonList);
    }

    @Contract(value="null -> false")
    public static boolean isSimpleStringOrSymbolElement(@Nullable PsiElement element) {
        return element instanceof RStringLiteral && !((RStringLiteral)element).hasExpressionSubstitutions() || element instanceof RSymbol;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x11ADCE5A1C95L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleCall";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/interpret/RubyInterpretUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateOptionValue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateOptionValues";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getOptionAssocElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getOptionValueElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getOptionValueElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

