/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.scopes;

import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.console.RubyLanguageConsole;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ControlFlowHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.Scope;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeVariable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.TypeInferenceContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.UsageAnalyzer;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.WriteAccess;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.ruby19.BlockCallLocalVariableAccess;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.scopes.RubyScopesInspection;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyExpressionCodeFragment;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.InstructionGraphUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.instructions.ReadWriteInstruction;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.RContainerBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public class RubyScopesVisitor
extends RubyInspectionVisitor {
    private final LocalInspectionToolSession b;
    private static final long c = com.jetbrains.python.psi.c.a(-3226944980884080928L, 2495842027782860480L, MethodHandles.lookup().lookupClass()).a(247813481507797L);

    public RubyScopesVisitor(@NotNull ProblemsHolder holder, LocalInspectionToolSession session) {
        if (holder == null) {
            RubyScopesVisitor.d(0);
        }
        super(holder);
        this.b = session;
    }

    @Override
    public void visitRClass(RClass rClass) {
        this.a(rClass);
        super.visitRClass(rClass);
    }

    @Override
    public void visitRSingletonMethod(RSingletonMethod rsMethod) {
        this.a(rsMethod);
        super.visitRSingletonMethod(rsMethod);
    }

    @Override
    public void visitRMethod(RMethod rMethod) {
        this.a(rMethod);
        super.visitRMethod(rMethod);
    }

    @Override
    public void visitRCodeBlock(RCodeBlock codeBlock) {
        this.a(codeBlock);
        super.visitRCodeBlock(codeBlock);
    }

    @Override
    public void visitRModule(RModule rModule) {
        this.a(rModule);
        super.visitRModule(rModule);
    }

    @Override
    public void visitRFile(RFile rFile) {
        this.a(rFile);
        super.visitRFile(rFile);
    }

    @Override
    public void visitRIdentifier(RIdentifier rIdentifier) {
        Object object;
        long l2 = c ^ 0x78F2AED5428L;
        ProgressManager.checkCanceled();
        if (rIdentifier.getContainingFile() instanceof RubyExpressionCodeFragment || RubyLanguageConsole.isInLanguageConsole((PsiElement)rIdentifier)) {
            return;
        }
        ScopeHolder scopeHolder = ScopeUtil.findScopeHolder((PsiElement)rIdentifier);
        if (scopeHolder == null) {
            return;
        }
        Scope scope = scopeHolder.getScope();
        String string = rIdentifier.getName();
        if (string == null) {
            return;
        }
        this.a(scopeHolder);
        if (rIdentifier.isParameterDeclaration()) {
            object = UsageAnalyzer.createUsageAccess(rIdentifier);
            if (UsageAnalyzer.isParameterInScope(rIdentifier)) {
                boolean bl2 = object instanceof BlockCallLocalVariableAccess;
                boolean bl3 = false;
                ScopeVariable scopeVariable = scope.getDeclaredVariable((PsiElement)rIdentifier, string);
                ScopeVariable scopeVariable2 = scope.getOuterScopeVariables().get(string);
                if (scopeVariable != null) {
                    if (scopeVariable.getType() == Type.METHOD_PARAMETER) {
                        if (scopeVariable2 != null) {
                            if (!bl2) {
                                this.registerProblem((PsiElement)rIdentifier, RBundle.message("inspection.scopes.parameter.shadows.outer", string));
                            }
                            bl3 = true;
                        }
                    } else {
                        if (!bl2) {
                            this.registerProblem((PsiElement)rIdentifier, RBundle.message("inspection.scopes.parameter.shadows.outer", string));
                        }
                        bl3 = true;
                    }
                }
                if (bl2 && !bl3) {
                    this.registerProblem((PsiElement)rIdentifier, RBundle.message("inspection.scopes.redundant.block.local.variable", string));
                }
            }
        }
        object = rIdentifier.getScopeVariable();
        if (rIdentifier.isLocalVariable() && (object == null || !object.isSet())) {
            Ref ref = new Ref((Object)false);
            Instruction[] instructionArray = scopeHolder.getControlFlow().getInstructions();
            int n2 = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructionArray, (PsiElement)rIdentifier);
            if (n2 != -1) {
                ControlFlowUtil.iteratePrev((int)n2, (Instruction[])instructionArray, arg_0 -> RubyScopesVisitor.a(n2, string, scope, (ScopeVariable)object, ref, arg_0));
            }
            if (((Boolean)ref.get()).booleanValue()) {
                return;
            }
            this.registerProblem((PsiElement)rIdentifier, RBundle.message("inspection.scopes.uninitialized.local.variable", string));
        }
    }

    private void a(@NotNull ControlFlowHolder controlFlowHolder) {
        long l2 = c ^ 0x10EF315C9E8CL;
        if (controlFlowHolder == null) {
            RubyScopesVisitor.d(1);
        }
        if (TypeInferenceContext.isTooBigForTypeInference(InstructionGraphUtil.getInstructionGraph(controlFlowHolder))) {
            Set set = (Set)this.b.getUserData(RubyScopesInspection.TOO_BIG_CONTROL_FLOW_HOLDERS);
            assert (set != null) : "No too big control flow set found, please check that inspection " + ((Object)((Object)this)).getClass().getName() + " creates it in sessionStarted using createTooBigControlFlowHoldersSet()";
            if (set.contains(controlFlowHolder)) {
                return;
            }
            Object object = controlFlowHolder instanceof RContainerBase ? ((RContainerBase)controlFlowHolder).getNameElement() : controlFlowHolder.getNavigationElement();
            String string = controlFlowHolder instanceof RDoCodeBlock ? RBundle.message("inspection.scopes.doblock.too.big.for.type.inference") : RBundle.message("inspection.scopes.too.big.for.type.inference", controlFlowHolder.getName());
            object = object instanceof RDoCodeBlock ? object.getFirstChild() : object;
            this.registerProblem((PsiElement)object, string, ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
            set.add(controlFlowHolder);
        }
    }

    private static /* synthetic */ ControlFlowUtil.Operation a(int n2, String string, Scope scope, ScopeVariable scopeVariable, Ref ref, Instruction instruction) {
        ReadWriteInstruction readWriteInstruction;
        if (instruction.num() == n2) {
            return ControlFlowUtil.Operation.NEXT;
        }
        if (instruction instanceof ReadWriteInstruction && string.equals((readWriteInstruction = (ReadWriteInstruction)instruction).getName())) {
            if (scope.getDeclaredVariable(readWriteInstruction.getElement(), string) != scopeVariable) {
                return ControlFlowUtil.Operation.BREAK;
            }
            if (readWriteInstruction.getAccess() instanceof WriteAccess) {
                return ControlFlowUtil.Operation.CONTINUE;
            }
            ref.set((Object)true);
            return ControlFlowUtil.Operation.BREAK;
        }
        return ControlFlowUtil.Operation.NEXT;
    }

    private static /* synthetic */ void d(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = c ^ 0x2509E8F353F1L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/scopes/RubyScopesVisitor";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkControlFlowHolder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

