/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.rubocop;

import com.google.gson.Gson;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.python.psi.c;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopAutocorrectFix;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopLinterModel;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopOffenses;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.RContainerBase;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;

class RubocopResponse {
    private static final RubocopResponse b;
    private static final int c = 1024;
    private static final Logger a;
    @Nullable
    public Metadata metadata;
    @Nullable
    public List<File> files;
    @Nullable
    public Summary summary;
    @Nullable
    public String myErrorMessage;
    private static final long d;

    RubocopResponse() {
    }

    public boolean isSuccess() {
        return this.getErrorMessage() == null;
    }

    @Nullable
    public String getErrorMessage() {
        return this.myErrorMessage;
    }

    @Nullable
    public List<File> getFiles() {
        return this.files;
    }

    @NotNull
    private static RubocopResponse a(@NotNull String string) {
        if (string == null) {
            RubocopResponse.a(0);
        }
        RubocopResponse rubocopResponse = new RubocopResponse();
        rubocopResponse.myErrorMessage = string;
        RubocopResponse rubocopResponse2 = rubocopResponse;
        if (rubocopResponse2 == null) {
            RubocopResponse.a(1);
        }
        return rubocopResponse2;
    }

    @NotNull
    public static RubocopResponse computeWithArguments(@NotNull RubyGemExecutionContext context, @Nullable ProcessListener processListener) {
        RubocopResponse rubocopResponse;
        ProcessOutput processOutput;
        Object object;
        Object object2;
        long l2 = d ^ 0x474EEB0699EEL;
        if (context == null) {
            RubocopResponse.a(2);
        }
        try {
            object2 = ProgressManager.getInstance().getProgressIndicator();
            if (object2 instanceof ProgressWrapper) {
                if (!object2.isRunning()) {
                    object2.start();
                }
                object = new ExecutionModes.SameThreadMode(true);
            } else {
                object = new ExecutionModes.SameThreadMode(false);
            }
            if (processListener != null) {
                object.addProcessListener(processListener);
            }
            RunnerUtil.validateSDK(context.getRubySdk());
            processOutput = ((RubyGemExecutionContext)context.withExecutionMode((ExecutionMode)object)).executeScript();
        }
        catch (ExecutionException executionException) {
            a.warn("Rubocop execution error: ", (Throwable)executionException);
            RubocopResponse rubocopResponse2 = RubocopResponse.a(RBundle.message("inspection.rubocop.error.starting", executionException.getMessage()));
            if (rubocopResponse2 == null) {
                RubocopResponse.a(3);
            }
            return rubocopResponse2;
        }
        if (processOutput == null) {
            a.debug("Empty response");
            RubocopResponse rubocopResponse3 = b;
            if (rubocopResponse3 == null) {
                RubocopResponse.a(4);
            }
            return rubocopResponse3;
        }
        object2 = processOutput.getStderr();
        object = processOutput.getStdout();
        int n2 = processOutput.getExitCode();
        if (n2 != 1 && n2 != 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Rubocop returned exit code: ").append(n2).append("\n");
            if (StringUtil.isNotEmpty((String)object)) {
                stringBuilder.append("stdout:\n").append(StringUtil.trimLog((String)object, (int)1024)).append("\n");
            }
            if (StringUtil.isNotEmpty((String)object2)) {
                stringBuilder.append("stderr:\n").append(StringUtil.trimLog((String)object2, (int)1024)).append("\n");
            }
            RubocopResponse rubocopResponse4 = RubocopResponse.a(context.getProject(), RBundle.message("inspection.rubocop.error.code", n2), stringBuilder.toString());
            if (rubocopResponse4 == null) {
                RubocopResponse.a(5);
            }
            return rubocopResponse4;
        }
        if (StringUtil.isEmpty((String)object)) {
            if (StringUtil.isNotEmpty((String)object2)) {
                RubocopResponse rubocopResponse5 = RubocopResponse.a(context.getProject(), RBundle.message("inspection.rubocop.error.starting.no.details"), StringUtil.trimLog((String)object2, (int)1024));
                if (rubocopResponse5 == null) {
                    RubocopResponse.a(6);
                }
                return rubocopResponse5;
            }
            a.debug("Empty output");
            RubocopResponse rubocopResponse6 = b;
            if (rubocopResponse6 == null) {
                RubocopResponse.a(7);
            }
            return rubocopResponse6;
        }
        try {
            rubocopResponse = (RubocopResponse)new Gson().fromJson((String)object, RubocopResponse.class);
        }
        catch (Exception exception) {
            RubocopResponse rubocopResponse7 = RubocopResponse.a(context.getProject(), RBundle.message("inspection.rubocop.error.parsing"), StringUtil.trimLog((String)object, (int)1024));
            if (rubocopResponse7 == null) {
                RubocopResponse.a(9);
            }
            return rubocopResponse7;
        }
        if (rubocopResponse == null) {
            RubocopResponse.a(8);
        }
        return rubocopResponse;
    }

    private static RubocopResponse a(@Nullable Project project, @NotNull String string, @NotNull String string2) {
        long l2 = d ^ 0x163B8BD8A81EL;
        if (string == null) {
            RubocopResponse.a(10);
        }
        if (string2 == null) {
            RubocopResponse.a(11);
        }
        a.warn(string + "\n" + string2);
        if (project == null) {
            return RubocopResponse.a(string);
        }
        Notifications.Bus.notify((Notification)new Notification(RBundle.message("inspection.rubocop.error.starting.no.details"), string, "", NotificationType.ERROR).addAction(RubocopResponse.b(project, string, string2)).addAction(RubocopLinterModel.createDisableRubocopAction(project)), (Project)project);
        return b;
    }

    @NotNull
    private static AnAction b(final @NotNull Project project, final @NotNull String string, final @NotNull String string2) {
        long l2 = d ^ 0x542587FE9719L;
        if (project == null) {
            RubocopResponse.a(12);
        }
        if (string == null) {
            RubocopResponse.a(13);
        }
        if (string2 == null) {
            RubocopResponse.a(14);
        }
        AnAction anAction = new AnAction(RBundle.message("inspection.rubocop.details")){
            private static final long a = com.jetbrains.python.psi.c.a(-6295147906744581319L, -6677630110785816074L, MethodHandles.lookup().lookupClass()).a(121550060523446L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    1.a(0);
                }
                ExecutionHelper.showExceptions((Project)project, Collections.singletonList(new Exception(string2)), Collections.emptyList(), (String)string, null);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x1CDAB593F0C4L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopResponse$1", "actionPerformed"));
            }
        };
        if (anAction == null) {
            RubocopResponse.a(15);
        }
        return anAction;
    }

    static {
        d = com.jetbrains.python.psi.c.a(9151612173322164439L, 1655170667855752055L, MethodHandles.lookup().lookupClass()).a(72321977000096L);
        b = new RubocopResponse();
        a = Logger.getInstance(RubocopResponse.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0x36FE90663A7BL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopResponse";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopResponse";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorResponse";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeWithArguments";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createDetailsAction";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createErrorResponse";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeWithArguments";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showErrorAndGetResult";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createDetailsAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Location {
        public int line;
        public int column;
        public int length;
        private static final long a = com.jetbrains.python.psi.c.a(2054893991372143354L, 1136231268599630872L, MethodHandles.lookup().lookupClass()).a(194324623074095L);

        Location() {
        }

        @Nullable
        public TextRange getRangeInDocument(@NotNull Document document) {
            if (document == null) {
                Location.a(0);
            }
            if (this.line == 0 || document.getLineCount() < this.line || this.length == 0 || this.column == 0) {
                return null;
            }
            int n2 = document.getLineStartOffset(this.line - 1);
            return TextRange.from((int)(n2 + this.column - 1), (int)this.length);
        }

        public String toString() {
            long l2 = a ^ 0x5F6157490BBDL;
            return "Location{line=" + this.line + ", column=" + this.column + ", length=" + this.length + '}';
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x62A00A7B9F35L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopResponse$Location", "getRangeInDocument"));
        }
    }

    static class Offense {
        private static final Map<String, HighlightSeverity> a;
        private static final Set<String> b;
        @Nullable
        public String severity;
        @Nullable
        public String message;
        @Nullable
        public String cop_name;
        @Nullable
        public Boolean corrected;
        @Nullable
        public Location location;
        private static final long c;

        Offense() {
        }

        public String toString() {
            long l2 = c ^ 0x46364EAACE53L;
            return "Offense{severity='" + this.severity + '\'' + ", message='" + this.message + '\'' + ", cop_name='" + this.cop_name + '\'' + ", corrected=" + this.corrected + ", location=" + this.location + '}';
        }

        @Nullable
        public String getDepartmentName() {
            int n2;
            int n3 = n2 = this.cop_name == null ? -1 : this.cop_name.indexOf(47);
            if (n2 == -1) {
                return null;
            }
            return this.cop_name.substring(0, n2);
        }

        @Nullable
        public String getCopName() {
            int n2;
            int n3 = n2 = this.cop_name == null ? -1 : this.cop_name.indexOf(47);
            if (n2 == -1) {
                return null;
            }
            return this.cop_name.substring(n2 + 1);
        }

        @Nullable
        public String getCopFullName() {
            return this.cop_name;
        }

        private void a(@NotNull PsiFile psiFile, @NotNull AnnotationHolder annotationHolder, @NotNull Map<String, RubocopAutocorrectFix> map2) {
            long l2 = c ^ 0x720EC86E7F64L;
            if (psiFile == null) {
                Offense.a(0);
            }
            if (annotationHolder == null) {
                Offense.a(1);
            }
            if (map2 == null) {
                Offense.a(2);
            }
            if (this.location == null || StringUtil.isEmpty((String)this.message)) {
                return;
            }
            Project project = psiFile.getProject();
            if (project.isDisposed()) {
                return;
            }
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
            if (document == null) {
                return;
            }
            TextRange textRange = this.location.getRangeInDocument(document);
            if (textRange == null || textRange.isEmpty()) {
                return;
            }
            Annotation annotation = annotationHolder.createAnnotation(this.getAnnotationSeverity(), this.a(psiFile, textRange), "RuboCop: " + StringUtil.trimStart((String)this.message, (String)(this.cop_name + ": ")) + " [" + this.cop_name + "]");
            this.a(map2).forEach(rubocopAutocorrectFix -> annotation.registerFix((IntentionAction)rubocopAutocorrectFix));
        }

        @NotNull
        private List<RubocopAutocorrectFix> a(@NotNull Map<String, RubocopAutocorrectFix> map2) {
            String string;
            if (map2 == null) {
                Offense.a(3);
            }
            if (!RubocopOffenses.CORRECTABLE_OFFENSES.contains(string = this.getCopFullName())) {
                List<RubocopAutocorrectFix> list2 = Collections.emptyList();
                if (list2 == null) {
                    Offense.a(4);
                }
                return list2;
            }
            List<RubocopAutocorrectFix> list3 = Arrays.asList(map2.get(this.getDepartmentName()), map2.get(string), map2.get(""));
            if (list3 == null) {
                Offense.a(5);
            }
            return list3;
        }

        @NotNull
        public HighlightSeverity getAnnotationSeverity() {
            HighlightSeverity highlightSeverity = a.get(this.severity);
            HighlightSeverity highlightSeverity2 = highlightSeverity == null ? HighlightSeverity.ERROR : highlightSeverity;
            if (highlightSeverity2 == null) {
                Offense.a(6);
            }
            return highlightSeverity2;
        }

        private TextRange a(@NotNull PsiFile psiFile, @NotNull TextRange textRange) {
            if (psiFile == null) {
                Offense.a(7);
            }
            if (textRange == null) {
                Offense.a(8);
            }
            if (!b.contains(this.cop_name)) {
                return textRange;
            }
            int n2 = textRange.getStartOffset();
            PsiElement psiElement = psiFile.getViewProvider().findElementAt(n2, (Language)RubyLanguage.INSTANCE);
            if (psiElement == null) {
                return textRange;
            }
            PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiNamedElement.class);
            if (psiElement2 == null || psiElement2.getTextRange().getStartOffset() != n2) {
                return psiElement.getTextRange();
            }
            RPsiElement rPsiElement = null;
            if (psiElement2 instanceof RContainerBase) {
                rPsiElement = ((RContainerBase)psiElement2).getNameElement();
            }
            return rPsiElement == null ? psiElement.getTextRange() : rPsiElement.getTextRange();
        }

        static {
            c = com.jetbrains.python.psi.c.a(-3250131863260489838L, 7232853957031792981L, MethodHandles.lookup().lookupClass()).a(45515953193121L);
            long l2 = c ^ 0x4B6142E4CD38L;
            a = new THashMap();
            b = new THashSet(Arrays.asList("Metrics/MethodLength", "Metrics/ModuleLength", "Metrics/ClassLength", "Metrics/BlockLength", "Metrics/AbcSize", "Metrics/CyclomaticComplexity", "Metrics/PerceivedComplexity"));
            a.put("refactor", HighlightSeverity.WEAK_WARNING);
            a.put("convention", HighlightSeverity.WEAK_WARNING);
            a.put("warning", HighlightSeverity.WARNING);
            a.put("error", HighlightSeverity.ERROR);
            a.put("fatal", HighlightSeverity.ERROR);
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x1DAD189903ABL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "quickFixesHolder";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopResponse$Offense";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRange";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopResponse$Offense";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuickFixes";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotationSeverity";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "annotateOffense";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getQuickFixes";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustRangeInDocument";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class File {
        @Nullable
        public String path;
        @Nullable
        public List<Offense> offenses;
        private static final long a = com.jetbrains.python.psi.c.a(-542163295914905639L, 2380217598015523048L, MethodHandles.lookup().lookupClass()).a(739577989493L);

        File() {
        }

        public void annotateOffenses(@NotNull PsiFile psiFile, @NotNull AnnotationHolder holder, @NotNull RubyGemExecutionContext executionContext) {
            if (psiFile == null) {
                File.a(0);
            }
            if (holder == null) {
                File.a(1);
            }
            if (executionContext == null) {
                File.a(2);
            }
            if (this.offenses == null || this.offenses.isEmpty()) {
                return;
            }
            Map map2 = FactoryMap.create(string -> new RubocopAutocorrectFix(executionContext, (String)string));
            for (Offense offense : this.offenses) {
                offense.a(psiFile, holder, map2);
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x21D7FB5C7E2AL;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "holder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "executionContext";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopResponse$File";
            objectArray[2] = "annotateOffenses";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class Summary {
        public int offense_count;
        public int target_file_count;
        public int inspected_file_count;

        Summary() {
        }
    }

    static class Metadata {
        @Nullable
        public String rubocop_version;
        @Nullable
        public String ruby_engine;
        @Nullable
        public String ruby_version;
        @Nullable
        public String ruby_patchlevel;
        @Nullable
        public String ruby_platform;

        Metadata() {
        }
    }
}

