/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.naming;

import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.UsageAnalyzer;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyRenameFix;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.ConventionInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.i;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;

public class RubyGlobalVariableNamingConventionInspection
extends ConventionInspection {
    private static final int c = 1;
    private static final int b = 30;
    private static final long d = com.jetbrains.python.psi.c.a(-751313246282535375L, 4311151023154088352L, MethodHandles.lookup().lookupClass()).a(265660529666423L);

    @Override
    protected String getDefaultRegex() {
        return TextUtil.IDENTIFIER_LOWERCASE_PATTERN.pattern();
    }

    @Override
    protected String getMotionDefaultRegex() {
        long l2 = d ^ 0x48DE5ECA5797L;
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 1;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 30;
    }

    @Override
    protected RubyFix buildFix(PsiElement location) {
        return new RubyRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = d ^ 0x33C0EB3ADBC3L;
        if ("Global variable naming convention" == null) {
            RubyGlobalVariableNamingConventionInspection.d(0);
        }
        return "Global variable naming convention";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        long l2 = d ^ 0x1FB6E5CD2DF3L;
        String string = (String)args[0];
        if (string.length() < this.getMinLength()) {
            if ("Global variable name '#ref' is too short" == null) {
                RubyGlobalVariableNamingConventionInspection.d(1);
            }
            return "Global variable name '#ref' is too short";
        }
        if (string.length() > this.getMaxLength()) {
            if ("Global variable name '#ref' is too long" == null) {
                RubyGlobalVariableNamingConventionInspection.d(2);
            }
            return "Global variable name '#ref' is too long";
        }
        String string2 = "Global variable name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
        if (string2 == null) {
            RubyGlobalVariableNamingConventionInspection.d(3);
        }
        return string2;
    }

    @Override
    public RubyInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor(null);
    }

    private static /* synthetic */ void d(int n2) {
        Object[] objectArray;
        long l2 = d ^ 0x1A06A1166112L;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyGlobalVariableNamingConventionInspection";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NamingConventionsVisitor
    extends RubyInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitRGlobalVariable(RGlobalVariable globalVariable) {
            if (!UsageAnalyzer.isDeclaration((PsiElement)globalVariable)) {
                return;
            }
            String string = globalVariable.getName().substring(1);
            if (RubyGlobalVariableNamingConventionInspection.this.isValid(string, (PsiElement)globalVariable)) {
                return;
            }
            this.registerGlobalVariableError(globalVariable, string);
        }

        /* synthetic */ NamingConventionsVisitor(i x1) {
            this();
        }
    }
}

