/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.ArgMapping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.SymbolResolveResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.CallableSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;

public abstract class MethodCallInspectionVisitorBase
extends RubyInspectionVisitor {
    private static final long e = c.a(3620212834660838541L, -2969137640984013378L, MethodHandles.lookup().lookupClass()).a(165978221995230L);

    public MethodCallInspectionVisitorBase(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            MethodCallInspectionVisitorBase.d(0);
        }
        super(holder);
    }

    @Override
    public void visitRCall(@NotNull RCall call) {
        if (call == null) {
            MethodCallInspectionVisitorBase.d(1);
        }
        this.a(call, call.getPsiCommand(), call.getArguments());
    }

    @Override
    public void visitRPseudoConstant(RPseudoConstant rPseudoConstant) {
        RCall rCall;
        RContainer rContainer;
        if (RubyTokenTypes.kSUPER.toString().equals(rPseudoConstant.getText()) && (rContainer = rPseudoConstant.getParentContainer()) instanceof RMethod && (rCall = RCallNavigator.getByCommand((PsiElement)rPseudoConstant)) == null) {
            Symbol symbol = ResolveUtil.resolveToSymbolWithCaching(rPseudoConstant.getReference());
            Symbol symbol2 = SymbolUtil.getSymbolByContainer(rContainer);
            if (!(symbol instanceof CallableSymbol) || !(symbol2 instanceof CallableSymbol)) {
                return;
            }
            List<ArgumentInfo> list2 = ((CallableSymbol)symbol2).getArgumentInfos();
            List<ArgumentInfo> list3 = ((CallableSymbol)symbol).getArgumentInfos();
            if (list2 == null || list3 == null) {
                return;
            }
            PsiElement psiElement = symbol.getPsiElement();
            if (!(psiElement instanceof RMethod)) {
                return;
            }
            Map<ArgumentInfo, ArgMapping.MappingRange> map2 = ArgMapping.getSuper(list3, list2);
            if (map2 == null) {
                return;
            }
            this.processCall((CallableSymbol)symbol, rPseudoConstant, ((RMethod)rContainer).getArguments(), map2);
        }
    }

    @Override
    public void visitRIdentifier(RIdentifier rIdentifier) {
        if (RCallNavigator.getByCommand((PsiElement)rIdentifier) != null || RReferenceNavigator.getReferenceByLeftPart((PsiElement)rIdentifier) != null || RReferenceNavigator.getReferenceByRightPart((PsiElement)rIdentifier) != null) {
            return;
        }
        if (rIdentifier.isParameterDeclaration() || rIdentifier.isLocalVariable()) {
            return;
        }
        this.a(rIdentifier, (PsiElement)rIdentifier, Collections.emptyList());
    }

    @Override
    public void visitRReference(RReference rReference) {
        RPsiElement rPsiElement;
        if (RCallNavigator.getByCommand((PsiElement)rReference) != null) {
            return;
        }
        RAssignmentExpression rAssignmentExpression = RAssignmentExpressionNavigator.getAssignmentByLeftPart((PsiElement)rReference);
        List<RPsiElement> list2 = Collections.emptyList();
        if (rAssignmentExpression != null && (rPsiElement = rAssignmentExpression.getValue()) != null) {
            list2 = Collections.singletonList(rPsiElement);
        }
        this.a(rReference, (PsiElement)rReference, list2);
    }

    private void a(RPsiElement rPsiElement, PsiElement psiElement, List<RPsiElement> list2) {
        PsiReference psiReference = psiElement.getReference();
        if (psiReference == null) {
            return;
        }
        Symbol symbol = ResolveUtil.resolveToSymbolWithCaching(psiReference);
        if (symbol != null && symbol.getType() == Type.ALIAS) {
            symbol = SymbolUtil.getMethodSymbolByAlias(symbol);
        }
        if (!(symbol instanceof CallableSymbol)) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ResolveUtil.addVariants(arrayList, symbol, true, psiElement);
        if (arrayList.size() != 1) {
            return;
        }
        PsiElement psiElement2 = ((SymbolResolveResult)arrayList.get(0)).getElement();
        if (psiElement2 == null) {
            return;
        }
        List<ArgumentInfo> list3 = ((CallableSymbol)symbol).getArgumentInfos();
        if (list3 == null) {
            return;
        }
        Map<ArgumentInfo, ArgMapping.MappingRange> map2 = ArgMapping.get(list3, list2);
        if (map2 == null) {
            return;
        }
        this.processCall((CallableSymbol)symbol, rPsiElement, list2, map2);
    }

    protected abstract void processCall(CallableSymbol var1, RPsiElement var2, @NotNull List<? extends RPsiElement> var3, @NotNull Map<ArgumentInfo, ArgMapping.MappingRange> var4);

    private static /* synthetic */ void d(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = e ^ 0x18BF848863B3L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/MethodCallInspectionVisitorBase";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

