/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebuggerSupportUtils;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyDebugValueFactory;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.model.RubyVariable;

public final class ProcessedGlobalsCollector {
    private static final Logger b;
    private final Set<String> d;
    private final List<String> a;
    private final XSourcePosition e;
    private Project c;
    private static final long f;

    public ProcessedGlobalsCollector(@NotNull Project project, @Nullable XSourcePosition position) {
        if (project == null) {
            ProcessedGlobalsCollector.a(0);
        }
        this.d = Sets.newHashSet();
        this.a = Lists.newArrayList();
        this.c = null;
        this.e = position;
        ApplicationManager.getApplication().runReadAction(() -> {
            if (position == null) {
                return;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(position.getFile());
            if (psiFile == null) {
                return;
            }
            PsiElement psiElement = psiFile.findElementAt(position.getOffset());
            if (psiElement == null) {
                return;
            }
            RContainer rContainer = RubyPsiUtil.getParentContainer(psiElement);
            if (rContainer == null) {
                return;
            }
            RubyDebuggerSupportUtils.collectFieldsMentionedInContext(rContainer, this.a);
            RubyDebuggerSupportUtils.collectConstantsMentionedInContext(rContainer, this.a);
            RubyDebuggerSupportUtils.collectContextInfoFromProviders(rContainer, position, this.a);
            this.d.addAll(RubyDebuggerSupportUtils.addGlobalsMentionedInContext(rContainer, this.a));
            this.c = rContainer.getProject();
        });
    }

    public Set<String> getProcessedGlobals() {
        return this.d;
    }

    public void addVariableNodes(@NotNull XCompositeNode node, @NotNull RubyStackFrame frame) {
        long l2 = f ^ 0x5C032AFDC129L;
        if (node == null) {
            ProcessedGlobalsCollector.a(1);
        }
        if (frame == null) {
            ProcessedGlobalsCollector.a(2);
        }
        for (String string : this.a) {
            try {
                RubyVariable rubyVariable = frame.getFrame().inspectExpression(string);
                if (rubyVariable == null) continue;
                if (ProcessedGlobalsCollector.a(string, rubyVariable)) {
                    if (!b.isDebugEnabled()) continue;
                    b.debug("\"" + string + "\" looks like a class name (" + rubyVariable + ")");
                    continue;
                }
                node.addChildren(XValueChildrenList.singleton((String)string, (XValue)RubyDebugValueFactory.create(this.c, this.e, frame, string, rubyVariable, true)), false);
            }
            catch (RubyDebuggerException rubyDebuggerException) {}
        }
    }

    private static boolean a(String string, RubyVariable rubyVariable) {
        long l2 = f ^ 0x73FCA39396B2L;
        if (!TextUtil.isClassOrModuleFqn(string)) {
            return false;
        }
        String string2 = rubyVariable.getValue().getReferenceTypeName();
        return "Class".equals(string2) || "Module".equals(string2);
    }

    static {
        f = com.jetbrains.python.psi.c.a(-1167452272068810493L, -2468516397891393881L, MethodHandles.lookup().lookupClass()).a(276234590598329L);
        b = Logger.getInstance(ProcessedGlobalsCollector.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = f ^ 0x416069FD036AL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/ProcessedGlobalsCollector";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addVariableNodes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

