/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Chunk;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.python.psi.c;
import gnu.trove.TObjectIntHashMap;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.ImplicitRequireProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RequiresIndexExtension;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.graph.CondensedRequirementGraph;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.graph.RequirementGraph;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.LoadPathUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.RubyProcessedFilesMap;
import org.jetbrains.plugins.ruby.ruby.lang.AbstractRubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RTopLevelContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RequireInfo;

public class FileRequireCache
implements Disposable {
    public static final String FEATURE_TOGGLE_KEY = "ruby.disable.require.processing";
    private static final Logger g;
    private final ConcurrentMap<TObjectIntHashMap<VirtualFile>, Map<String, Collection<VirtualFile>>> f;
    private final ConcurrentMap<String, Set<VirtualFile>> b;
    private final SimpleModificationTracker c;
    private final Map<Integer, CondensedRequirementGraph> d;
    private final Map<Integer, RequirementGraph> e;
    private final Map<VirtualFile, List<RequireInfo>> a;
    private static final long h;

    public static FileRequireCache getInstance(Project project) {
        return (FileRequireCache)ServiceManager.getService((Project)project, FileRequireCache.class);
    }

    public FileRequireCache(final Project project) {
        long l2 = h ^ 0x61D2786D9D16L;
        this.f = ContainerUtil.createConcurrentWeakMap();
        this.b = ContainerUtil.newConcurrentMap();
        this.c = new SimpleModificationTracker();
        this.d = ContainerUtil.createConcurrentSoftValueMap();
        this.e = ContainerUtil.createConcurrentSoftValueMap();
        this.a = new HashMap<VirtualFile, List<RequireInfo>>();
        if (Registry.is((String)FEATURE_TOGGLE_KEY, (boolean)true)) {
            return;
        }
        VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(){
            private static final long a = com.jetbrains.python.psi.c.a(-5772279032918150734L, 633688069798510246L, MethodHandles.lookup().lookupClass()).a(129295327704946L);

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.a(0);
                }
                if (FileRequireCache.a(project, event.getFile())) {
                    FileRequireCache.this.clearCache(true);
                }
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.a(1);
                }
                if (FileRequireCache.a(project, event.getFile())) {
                    FileRequireCache.this.clearCache(true);
                }
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    1.a(2);
                }
                if (FileRequireCache.a(project, event.getOldParent()) || FileRequireCache.a(project, event.getFile())) {
                    FileRequireCache.this.clearCache(true);
                }
            }

            public void fileCopied(@NotNull VirtualFileCopyEvent event) {
                if (event == null) {
                    1.a(3);
                }
                if (FileRequireCache.a(project, event.getFile())) {
                    FileRequireCache.this.clearCache(true);
                }
            }

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                long l2 = a ^ 0x3260929936F7L;
                if (event == null) {
                    1.a(4);
                }
                if ("name".equals(event.getPropertyName()) && FileRequireCache.a(project, event.getFile())) {
                    FileRequireCache.this.clearCache(true);
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x6FB14C7FC39AL;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/FileRequireCache$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileMoved";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCopied";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "propertyChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this);
        messageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
            private static final long a = com.jetbrains.python.psi.c.a(-1023049656200827534L, 2905812571413351437L, MethodHandles.lookup().lookupClass()).a(244927116237179L);

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    2.a(0);
                }
                FileRequireCache.this.clearCache(true);
                FileRequireCache.this.b.clear();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0xE69D65D54BFL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/FileRequireCache$2", "rootsChanged"));
            }
        });
        messageBusConnection.subscribe(RequiresIndexExtension.RequireSetChangedListener.TOPIC, (Object)new RequiresIndexExtension.RequireSetChangedListener(){
            private static final long a = com.jetbrains.python.psi.c.a(502322107409566083L, 7218918259758715953L, MethodHandles.lookup().lookupClass()).a(119544692341898L);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySetMaybeChanged(@NotNull VirtualFile virtualFile, @NotNull List<RequireInfo> newRequires) {
                if (virtualFile == null) {
                    3.a(0);
                }
                if (newRequires == null) {
                    3.a(1);
                }
                if (!FileRequireCache.a(project, virtualFile)) {
                    return;
                }
                if (FileRequireCache.this.e.isEmpty()) {
                    FileRequireCache.this.clearCache(false);
                    return;
                }
                Map map2 = FileRequireCache.this.a;
                synchronized (map2) {
                    FileRequireCache.this.a.put(virtualFile, newRequires);
                }
                for (Integer n2 : FileRequireCache.this.d.keySet()) {
                    if (FileRequireCache.this.e.get(n2) != null) continue;
                    FileRequireCache.this.clearCache(false);
                    break;
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x435031F13D30L;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "virtualFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "newRequires";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/FileRequireCache$3";
                objectArray[2] = "notifySetMaybeChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private Set<VirtualFile> a(@NotNull RTopLevelContainer rTopLevelContainer, boolean bl2, boolean bl3) {
        if (rTopLevelContainer == null) {
            FileRequireCache.a(0);
        }
        Collection<VirtualFile> collection = rTopLevelContainer.getLoadPath();
        Project project = rTopLevelContainer.getProject();
        CondensedRequirementGraph condensedRequirementGraph = this.a(project, collection);
        LinkedHashSet<VirtualFile> linkedHashSet = new LinkedHashSet<VirtualFile>(condensedRequirementGraph.getAnswer(RubyPsiUtil.getVirtualFileFromElement((PsiElement)rTopLevelContainer)));
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)rTopLevelContainer);
        if (bl3 && module2 != null) {
            for (ImplicitRequireProvider implicitRequireProvider : ImplicitRequireProvider.EP_NAME.getExtensionList()) {
                linkedHashSet.addAll(implicitRequireProvider.getImplicitRequires(module2, rTopLevelContainer.getContainingFile()));
            }
        }
        if (bl2) {
            Sdk sdk = LoadPathUtil.findSdkForBuiltInSymbol(rTopLevelContainer.getContainingFile());
            linkedHashSet.addAll(FileRequireCache.getInstance(project).a(project, sdk));
        }
        return linkedHashSet;
    }

    private static boolean a(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            FileRequireCache.a(1);
        }
        if (virtualFile == null) {
            FileRequireCache.a(2);
        }
        return virtualFile.isDirectory() || RequiresIndexExtension.getProcessedScope(project).accept(virtualFile) && virtualFile.getFileType() instanceof AbstractRubyFileType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a() {
        ArrayList arrayList = new ArrayList();
        Map<VirtualFile, List<RequireInfo>> map2 = this.a;
        synchronized (map2) {
            this.a.forEach((virtualFile, list2) -> arrayList.add(Pair.create((Object)virtualFile, (Object)list2)));
            this.a.clear();
        }
        for (RequirementGraph requirementGraph : this.e.values()) {
            arrayList.forEach(pair -> {
                if (requirementGraph.invalidateOutEdges((VirtualFile)pair.first, (List)pair.second)) {
                    this.clearCache(false);
                }
            });
        }
    }

    @NotNull
    private CondensedRequirementGraph a(@NotNull Project project, @NotNull Collection<VirtualFile> collection) {
        if (project == null) {
            FileRequireCache.a(3);
        }
        if (collection == null) {
            FileRequireCache.a(4);
        }
        int n2 = collection.hashCode();
        CondensedRequirementGraph condensedRequirementGraph = this.d.computeIfAbsent(n2, n4 -> {
            RequirementGraph requirementGraph = this.e.computeIfAbsent(n2, n2 -> new RequirementGraph(project, collection));
            return new CondensedRequirementGraph((Graph<Chunk<VirtualFile>>)GraphAlgorithms.getInstance().computeSCCGraph((Graph)requirementGraph));
        });
        if (condensedRequirementGraph == null) {
            FileRequireCache.a(5);
        }
        return condensedRequirementGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(boolean clearRawGraphs) {
        long l2 = h ^ 0x3CF85838CF30L;
        g.debug("Clearing all caches");
        this.f.clear();
        this.c.incModificationCount();
        this.d.clear();
        if (clearRawGraphs) {
            this.e.clear();
            Map<VirtualFile, List<RequireInfo>> map2 = this.a;
            synchronized (map2) {
                this.a.clear();
            }
        }
    }

    @NotNull
    public Collection<VirtualFile> findFilesUnderLoadPath(TObjectIntHashMap<VirtualFile> loadPath, String name, Computable<Collection<VirtualFile>> computable) {
        Collection collection;
        long l2 = h ^ 0x5564CD24C99DL;
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        ConcurrentMap concurrentMap2 = this.f.putIfAbsent(loadPath, concurrentMap);
        if (concurrentMap2 == null) {
            if (g.isDebugEnabled()) {
                g.debug("Cache miss for " + loadPath);
            }
            concurrentMap2 = concurrentMap;
        }
        if ((collection = concurrentMap2.get(name)) == null) {
            collection = (Collection)computable.compute();
            concurrentMap2.put(name, collection);
        }
        Collection collection2 = collection;
        if (collection2 == null) {
            FileRequireCache.a(6);
        }
        return collection2;
    }

    public RubyProcessedFilesMap getProcessedFilesMap(@NotNull RTopLevelContainer invocationPoint) {
        if (invocationPoint == null) {
            FileRequireCache.a(7);
        }
        this.a();
        return (RubyProcessedFilesMap)((Object)CachedValuesManager.getCachedValue((PsiElement)invocationPoint, () -> {
            long l2 = h ^ 0x7BCE9E4FC4C3L;
            VirtualFile virtualFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)invocationPoint);
            if (g.isDebugEnabled()) {
                g.debug("Calculating processed files for " + (virtualFile != null ? virtualFile.getPath() : null));
            }
            return new CachedValueProvider.Result((Object)new RubyProcessedFilesMap(this.a(invocationPoint, true, true)), new Object[]{this.c});
        }));
    }

    @NotNull
    private Set<VirtualFile> a(@NotNull Project project, @Nullable Sdk sdk) {
        if (project == null) {
            FileRequireCache.a(8);
        }
        if (sdk == null) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                FileRequireCache.a(9);
            }
            return set;
        }
        String string = sdk.getHomePath();
        if (StringUtil.isEmptyOrSpaces((String)string)) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                FileRequireCache.a(10);
            }
            return set;
        }
        Set set = (Set)this.b.get(string);
        if (set == null) {
            VirtualFile virtualFile = LoadPathUtil.getBuiltinFile(sdk);
            if (virtualFile != null) {
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                set = psiFile != null ? this.a((RFile)psiFile, false, false) : Collections.emptySet();
                this.b.put(string, set);
            } else {
                set = Collections.emptySet();
            }
        }
        Set set2 = set;
        if (set2 == null) {
            FileRequireCache.a(11);
        }
        return set2;
    }

    public void dispose() {
    }

    static {
        h = com.jetbrains.python.psi.c.a(8201732681462789328L, 7899652069229609679L, MethodHandles.lookup().lookupClass()).a(64549917675073L);
        g = Logger.getInstance(FileRequireCache.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = h ^ 0x7865B47F6D26L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2start";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadPath";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/FileRequireCache";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocationPoint";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/FileRequireCache";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraph";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesUnderLoadPath";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltinProcessedFiles";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProcessedFiles";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isRelatedFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getGraph";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProcessedFilesMap";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinProcessedFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

