/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.run.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.rails.ExternalRailsSettings;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public class RailsRunConfigurationUtil {
    private static final long a = c.a(-2479143662348683383L, -3154857883361241803L, MethodHandles.lookup().lookupClass()).a(246675846608513L);

    private RailsRunConfigurationUtil() {
    }

    public static void inspectRailsSDK(AbstractRubyRunConfiguration conf, boolean isExecution) throws Exception {
        long l2 = a ^ 0x1527DD66D1ADL;
        RunConfigurationUtil.inspectSDK(conf, isExecution);
        Module module2 = conf.getModule();
        if (!RailsUtil.hasRailsSupportInSDKOrModule(conf.getSdk(), module2)) {
            RunConfigurationUtil.throwExecutionOrRuntimeException(RBundle.message("sdk.error.no.rails.found"), isExecution);
        }
    }

    public static void inspectJrubyServerGem(RailsServerRunConfiguration conf, boolean isExecution) throws Exception {
        Module module2;
        long l2 = a ^ 0x7DA8D0FCB19DL;
        String string = conf.getServerType();
        String string2 = ExternalRailsSettings.getServerGemTitle(string);
        Sdk sdk = conf.getSdk();
        if (!JRubySdkUtil.isJRubySDK(sdk)) {
            RunConfigurationUtil.throwExecutionOrRuntimeException(RBundle.message("sdk.error.jruby.jdk.type.incorrect", string2), isExecution);
        }
        if (!GemUtil.isGemExecutableRubyScriptExists(module2 = conf.getModule(), sdk, string, string)) {
            RunConfigurationUtil.throwExecutionOrRuntimeException(RBundle.message("sdk.error.no.server.gem.found", string2), isExecution);
        }
    }

    public static void inspectNotJrubyServerGem(RailsServerRunConfiguration conf, boolean isExecution) throws Exception {
        long l2 = a ^ 0x2ACBF52309B0L;
        String string = conf.getServerType();
        if (!(conf.isDefault() || conf.getServerType().equalsIgnoreCase("webrick") || conf.isZeusServer())) {
            boolean bl2;
            boolean bl3 = false;
            Module module2 = conf.getModule();
            boolean bl4 = bl2 = module2 != null && RailsUtil.isRails3OrNewerApplication(module2);
            if (bl2) {
                GemInfo gemInfo = GemSearchUtil.findGem(module2, StringUtil.toLowerCase((String)string));
                bl3 = gemInfo != null && gemInfo.isValid();
            } else {
                Sdk sdk = conf.getSdk();
                if (sdk != null) {
                    GemInfo gemInfo = GemSearchUtil.findGem(module2, sdk, StringUtil.toLowerCase((String)string));
                    boolean bl5 = bl3 = gemInfo != null && gemInfo.isValid();
                }
            }
            if (!bl3) {
                RunConfigurationUtil.throwExecutionOrRuntimeException(bl2 ? RBundle.message("sdk.error.no.server.gem.found.rails3", string) : RBundle.message("sdk.error.no.server.gem.found", string), isExecution);
            }
        }
    }

    public static boolean isRails30Server(String executionScriptPath) {
        long l2 = a ^ 0x400F158FE118L;
        return FileUtil.toSystemIndependentName((String)executionScriptPath).endsWith("script/rails") || FileUtil.toSystemIndependentName((String)executionScriptPath).endsWith("bin/rails");
    }
}

