/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.nameConventions;

import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public class HelpersConventions {
    @NonNls
    public static final String ACTION_VIEW = "action_view";
    @NonNls
    public static final String HELPER = "Helper";
    private static final long a = c.a(1494037326814778790L, -3802654455791898854L, MethodHandles.lookup().lookupClass()).a(211990794556836L);

    public static boolean isHelperFile(@NotNull PsiFile file, @Nullable Module module2) {
        RFile rFile;
        if (file == null) {
            HelpersConventions.a(0);
        }
        return (rFile = (RFile)file.getViewProvider().getPsi((Language)RubyLanguage.INSTANCE)) != null && HelpersConventions.isHelperFile(file, module2, RContainerUtil.getTopLevelModules(rFile));
    }

    public static boolean isHelperFile(@NotNull PsiFile rFile, @Nullable Module module2, @NotNull List<? extends RModule> modules) {
        long l2 = a ^ 0x61952C82F7B7L;
        if (rFile == null) {
            HelpersConventions.a(1);
        }
        if (modules == null) {
            HelpersConventions.a(2);
        }
        if (module2 == null) {
            return false;
        }
        VirtualFile virtualFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)rFile);
        if (virtualFile == null) {
            return false;
        }
        String string = virtualFile.getUrl();
        String string2 = FileUtilRt.getNameWithoutExtension((String)rFile.getName());
        if (!string2.endsWith("_helper")) {
            return false;
        }
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2);
        assert (standardRailsPaths != null);
        String string3 = standardRailsPaths.getHelpersRootURL();
        if (!string.startsWith(string3)) {
            return false;
        }
        for (RModule rModule : modules) {
            if (!HelpersConventions.isHelperModule(rModule, module2)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getHelperNameByModule(@Nullable RModule rModule) {
        if (rModule == null) {
            return null;
        }
        return HelpersConventions.getHelperNameByModuleName(rModule.getName());
    }

    @Nullable
    public static String getHelperNameByModuleName(@Nullable String moduleName) {
        long l2 = a ^ 0x62D241A70946L;
        if (moduleName == null) {
            return "";
        }
        String string = NamingConventions.toUnderscoreCase(moduleName);
        if (!string.endsWith("_helper")) {
            return "";
        }
        return string.substring(0, string.length() - "_helper".length());
    }

    @Nullable
    public static String getHelperNameByFileName(@NotNull String fileName) {
        String string;
        long l2 = a ^ 0x4472A84A236DL;
        if (fileName == null) {
            HelpersConventions.a(3);
        }
        if (!(string = FileUtilRt.getNameWithoutExtension((String)fileName)).endsWith("_helper")) {
            return null;
        }
        return string.substring(0, string.length() - "_helper".length());
    }

    public static boolean isHelperModule(@Nullable RModule rModule, @NotNull Module module2) {
        String string4;
        if (module2 == null) {
            HelpersConventions.a(4);
        }
        if (!RailsFacetUtil.hasRailsSupport(module2)) {
            return false;
        }
        String string2 = HelpersConventions.getHelperNameByModule(rModule);
        if (StringUtil.isEmpty((String)string2)) {
            return false;
        }
        assert (rModule != null);
        FQN fQN = rModule.getFQNWithNesting();
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2);
        assert (standardRailsPaths != null);
        String string3 = standardRailsPaths.getHelpersRootURL();
        StringBuilder stringBuilder = new StringBuilder(string3);
        for (String string4 : fQN.asList()) {
            stringBuilder.append('/');
            stringBuilder.append(NamingConventions.toUnderscoreCase(string4));
        }
        stringBuilder.append('.').append(RubyFileType.RUBY.getDefaultExtension());
        VirtualFile virtualFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)rModule);
        assert (virtualFile != null);
        string4 = virtualFile.getPath();
        String string5 = VfsUtilCore.urlToPath((String)stringBuilder.toString());
        return string5.equals(string4);
    }

    @NotNull
    public static String getHelperFileNameByHelperModuleName(@Nullable String helperModuleName) {
        String string = HelpersConventions.getHelperNameByModuleName(helperModuleName);
        String string2 = HelpersConventions.a(string);
        if (string2 == null) {
            HelpersConventions.a(5);
        }
        return string2;
    }

    private static String a(String string) {
        if (string == null) {
            return "";
        }
        return HelpersConventions.getHelperFileNameWithoutExtensionByHelperName(string) + '.' + RubyFileType.RUBY.getDefaultExtension();
    }

    public static String getHelperFileNameWithoutExtensionByHelperName(String helperName) {
        long l2 = a ^ 0x2779BF56CCC2L;
        return helperName + "_helper";
    }

    @NotNull
    public static String getHelperModuleNameByHelperName(@Nullable String name) {
        long l2 = a ^ 0x2F6D1CFA5CEEL;
        StringBuilder stringBuilder = new StringBuilder(NamingConventions.toCamelCase(name));
        stringBuilder.append(HELPER);
        String string = stringBuilder.toString();
        if (string == null) {
            HelpersConventions.a(6);
        }
        return string;
    }

    @Nullable
    public static String getRelativePathOfHelperFolder(@Nullable String fileUrl, @NotNull Module module2) {
        if (module2 == null) {
            HelpersConventions.a(7);
        }
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module2);
        assert (standardRailsPaths != null);
        String string = standardRailsPaths.getHelpersRootURL();
        if (fileUrl == null) {
            return null;
        }
        return VirtualFileUtil.getRelativePath(fileUrl, string);
    }

    @Nullable
    public static String getHelperQualifiedName(String helperParentDirUrl, String helpersRootUrl, String fileName) {
        String string = HelpersConventions.getHelperNameByFileName(fileName);
        if (string == null) {
            return null;
        }
        String string2 = VirtualFileUtil.getRelativePath(helperParentDirUrl, helpersRootUrl);
        if (StringUtil.isEmpty((String)string2)) {
            return string;
        }
        return string2 + "/" + string;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x3CE77AC2986FL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/nameConventions/HelpersConventions";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/nameConventions/HelpersConventions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelperFileNameByHelperModuleName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelperModuleNameByHelperName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isHelperFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHelperNameByFileName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isHelperModule";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePathOfHelperFolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

