/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.gems;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import gnu.trove.THashSet;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.module.ModuleGemProvider;
import org.jetbrains.plugins.ruby.rails.gems.FrozenGemInfo;

public abstract class DirectoryGemsProvider
implements ModuleGemProvider {
    private final Map<VirtualFile, Collection<GemInfo>> a = Collections.synchronizedMap(new HashMap());
    private static final long f = c.a(1491303186204061405L, 2424318241200859980L, MethodHandles.lookup().lookupClass()).a(89906954676813L);

    @Override
    @NotNull
    public List<GemInfo> getGemsList(@NotNull Module module2) {
        if (module2 == null) {
            DirectoryGemsProvider.b(0);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (module2.isDisposed()) {
            List<GemInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                DirectoryGemsProvider.b(1);
            }
            return list2;
        }
        List<GemInfo> list3 = this.getGemsDirectories(module2).stream().flatMap(virtualFile -> this.getDirectoryGems(module2, (VirtualFile)virtualFile).stream()).collect(Collectors.toList());
        if (list3 == null) {
            DirectoryGemsProvider.b(2);
        }
        return list3;
    }

    public boolean isUnderDependenciesRoot(@NotNull VirtualFile virtualFile, @NotNull Module module2) {
        if (virtualFile == null) {
            DirectoryGemsProvider.b(3);
        }
        if (module2 == null) {
            DirectoryGemsProvider.b(4);
        }
        for (VirtualFile virtualFile2 : this.getGemsDirectories(module2)) {
            if (virtualFile2 == null || !VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<GemInfo> getDirectoryGems(@NotNull Module module2, @Nullable VirtualFile gemDirectory) {
        if (module2 == null) {
            DirectoryGemsProvider.b(5);
        }
        Collection<GemInfo> collection = gemDirectory == null ? Collections.emptyList() : this.a.computeIfAbsent(gemDirectory, virtualFile -> this.a((VirtualFile)virtualFile, this.getDefaultGemVersion(module2)));
        if (collection == null) {
            DirectoryGemsProvider.b(6);
        }
        return collection;
    }

    @NotNull
    public Set<VirtualFile> invalidateCaches(@Nullable VirtualFile file) {
        if (file == null) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                DirectoryGemsProvider.b(7);
            }
            return set;
        }
        THashSet tHashSet = new THashSet();
        for (Object object : this.a.keySet().toArray()) {
            VirtualFile virtualFile = (VirtualFile)object;
            if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)file, (boolean)false)) continue;
            this.a.remove(virtualFile);
            tHashSet.add(virtualFile);
        }
        THashSet tHashSet2 = tHashSet;
        if (tHashSet2 == null) {
            DirectoryGemsProvider.b(8);
        }
        return tHashSet2;
    }

    @NotNull
    protected abstract List<VirtualFile> getGemsDirectories(@NotNull Module var1);

    @Nullable
    protected abstract String getGemName(@NotNull VirtualFile var1);

    protected boolean isIgnored(@NotNull VirtualFile gemDirectory) {
        if (gemDirectory == null) {
            DirectoryGemsProvider.b(9);
        }
        return false;
    }

    @Nullable
    protected String getGemVersion(@NotNull VirtualFile gemDirectory) {
        if (gemDirectory == null) {
            DirectoryGemsProvider.b(10);
        }
        return null;
    }

    protected boolean isGitGem(@NotNull VirtualFile gemDirectory) {
        if (gemDirectory == null) {
            DirectoryGemsProvider.b(11);
        }
        return false;
    }

    @Nullable
    protected String getGemRef(@NotNull VirtualFile gemDirectory) {
        if (gemDirectory == null) {
            DirectoryGemsProvider.b(12);
        }
        return null;
    }

    @Nullable
    protected String getDefaultGemVersion(@Nullable Module module2) {
        return null;
    }

    private Collection<GemInfo> a(@NotNull VirtualFile virtualFile, @Nullable String string) {
        if (virtualFile == null) {
            DirectoryGemsProvider.b(13);
        }
        HashSet<GemInfo> hashSet = new HashSet<GemInfo>();
        for (VirtualFile virtualFile2 : virtualFile.getChildren()) {
            ContainerUtil.addIfNotNull(hashSet, (Object)this.createDirectoryGem(virtualFile2, string));
        }
        return hashSet;
    }

    @Nullable
    protected GemInfo createDirectoryGem(@NotNull VirtualFile gemDirectory, @Nullable String defaultGemVersion) {
        if (gemDirectory == null) {
            DirectoryGemsProvider.b(14);
        }
        if (!gemDirectory.isDirectory() || FileTypeManager.getInstance().isFileIgnored(gemDirectory) || this.isIgnored(gemDirectory)) {
            return null;
        }
        String string = this.getGemName(gemDirectory);
        String string2 = this.getGemVersion(gemDirectory);
        boolean bl2 = this.isGitGem(gemDirectory);
        String string3 = this.getGemRef(gemDirectory);
        return string == null ? null : new FrozenGemInfo(string, string2 != null ? string2 : defaultGemVersion, gemDirectory.getUrl(), bl2, string3);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = f ^ 0x6CA92E5FC589L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/gems/DirectoryGemsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemDirectory";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsRoot";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/gems/DirectoryGemsProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsList";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryGems";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "invalidateCaches";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGemsList";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUnderDependenciesRoot";
                break;
            }
            case 5: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoryGems";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getGemVersion";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isGitGem";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getGemRef";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryGem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

