/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.BaseRailsFacetConfiguration;
import org.jetbrains.plugins.ruby.rails.facet.configuration.BaseRailsFacetConfigurationLowLevel;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.rails.facet.versions.BaseRailsFacet;
import org.jetbrains.plugins.ruby.rails.facet.versions.RailsFacetType;

public class RailsFacetUtil {
    private static final Logger a;
    private static final long b;

    private RailsFacetUtil() {
    }

    @Contract(value="null -> false")
    public static boolean hasRailsSupport(@Nullable Module module2) {
        return BaseRailsFacet.getInstance(module2) != null;
    }

    @Nullable
    public static String getRailsAppHomeDirPath(@NotNull Module module2) {
        BaseRailsFacetConfiguration baseRailsFacetConfiguration;
        if (module2 == null) {
            RailsFacetUtil.a(0);
        }
        return (baseRailsFacetConfiguration = RailsFacetUtil.getRailsFacetConfiguration(module2)) != null ? baseRailsFacetConfiguration.getRailsApplicationRootPath() : null;
    }

    @Nullable
    public static String getRailsAppHomeDirUrl(@NotNull Module module2) {
        BaseRailsFacetConfiguration baseRailsFacetConfiguration;
        if (module2 == null) {
            RailsFacetUtil.a(1);
        }
        return (baseRailsFacetConfiguration = RailsFacetUtil.getRailsFacetConfiguration(module2)) != null ? baseRailsFacetConfiguration.getRailsApplicationRootUrl() : null;
    }

    @Nullable
    public static StandardRailsPaths getRailsAppPaths(@NotNull Module module2) {
        BaseRailsFacet baseRailsFacet;
        if (module2 == null) {
            RailsFacetUtil.a(2);
        }
        if ((baseRailsFacet = BaseRailsFacet.getInstance(module2)) == null) {
            return null;
        }
        return ((BaseRailsFacetConfiguration)baseRailsFacet.getConfiguration()).getPaths();
    }

    @Nullable
    public static String getRailsAppHomeDirPathUrl(@NotNull Module module2) {
        BaseRailsFacetConfiguration baseRailsFacetConfiguration;
        if (module2 == null) {
            RailsFacetUtil.a(3);
        }
        return (baseRailsFacetConfiguration = RailsFacetUtil.getRailsFacetConfiguration(module2)) != null ? baseRailsFacetConfiguration.getRailsApplicationRootUrl() : null;
    }

    @Nullable
    public static VirtualFile getRailsAppHomeDir(@NotNull Module module2) {
        String string;
        if (module2 == null) {
            RailsFacetUtil.a(4);
        }
        if ((string = RailsFacetUtil.getRailsAppHomeDirUrl(module2)) == null) {
            return null;
        }
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public static BaseRailsFacetConfiguration getRailsFacetConfiguration(@NotNull Module module2) {
        BaseRailsFacet baseRailsFacet;
        if (module2 == null) {
            RailsFacetUtil.a(5);
        }
        if ((baseRailsFacet = BaseRailsFacet.getInstance(module2)) != null) {
            return (BaseRailsFacetConfiguration)baseRailsFacet.getConfiguration();
        }
        return null;
    }

    public static void refreshRailsAppHomeContent(Module module2) {
        long l2 = b ^ 0x7873016660A9L;
        String string = RailsFacetUtil.getRailsAppHomeDirPath(module2);
        if (string != null) {
            try {
                TransactionGuard.getInstance().submitTransactionAndWait(() -> {
                    VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(string);
                    if (virtualFile != null) {
                        virtualFile.refresh(false, true);
                    }
                });
            }
            catch (Exception exception) {
                a.error("Cannot refresh Rails home content; " + exception.getMessage());
            }
        } else {
            a.warn("Refresh rails application's home directory for unexistent folder. Module [" + module2.getName() + "], has rails support = " + RailsFacetUtil.hasRailsSupport(module2), new Throwable().fillInStackTrace());
        }
    }

    public static BaseRailsFacet configureRailsFacet(VirtualFile baseDir, Module module2) {
        BaseRailsFacet baseRailsFacet = BaseRailsFacet.getInstance(module2);
        if (baseRailsFacet != null) {
            return baseRailsFacet;
        }
        FacetManager facetManager = FacetManager.getInstance((Module)module2);
        ModifiableFacetModel modifiableFacetModel = facetManager.createModifiableModel();
        RailsFacetType railsFacetType = RailsFacetType.getInstance();
        BaseRailsFacetConfiguration baseRailsFacetConfiguration = (BaseRailsFacetConfiguration)ProjectFacetManager.getInstance((Project)module2.getProject()).createDefaultConfiguration((FacetType)railsFacetType);
        ((BaseRailsFacetConfigurationLowLevel)baseRailsFacetConfiguration).setRailsApplicationRootPath(baseDir.getPath());
        BaseRailsFacet baseRailsFacet2 = (BaseRailsFacet)facetManager.createFacet((FacetType)railsFacetType, railsFacetType.getDefaultFacetName(), (FacetConfiguration)baseRailsFacetConfiguration, null);
        modifiableFacetModel.addFacet((Facet)baseRailsFacet2);
        WriteAction.runAndWait(() -> modifiableFacetModel.commit());
        RailsUtil.createRailsRunConfiguration(module2);
        return baseRailsFacet2;
    }

    static {
        b = c.a(-6018040586124918769L, 6447619857662639326L, MethodHandles.lookup().lookupClass()).a(80230447052572L);
        a = Logger.getInstance(RailsFacetUtil.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = b ^ 0xF0B515D4AE9L;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "module";
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/facet/RailsFacetUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getRailsAppHomeDirPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getRailsAppHomeDirUrl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getRailsAppPaths";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getRailsAppHomeDirPathUrl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getRailsAppHomeDir";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getRailsFacetConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

