/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.RailsIcons;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.rails.migrations.MigrationField;
import org.jetbrains.plugins.ruby.rails.migrations.MigrationParser;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDependency;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;

public class MigrationFieldRefParam
extends ParamDefBase {
    protected ParamDependency<PsiElement> modelClassRefDependency;
    protected ParamDependency<PsiElement> tableNameDependency;
    private static final long d = c.a(3026404358969435581L, -361627508330491817L, MethodHandles.lookup().lookupClass()).a(112936772522449L);

    public MigrationFieldRefParam(@Nullable ParamDependency<PsiElement> modelClassRefDependency, @Nullable ParamDependency<PsiElement> tableNameDependency) {
        this.modelClassRefDependency = modelClassRefDependency;
        this.tableNameDependency = tableNameDependency;
    }

    public MigrationFieldRefParam(ParamDependency<PsiElement> modelClassRefDependency) {
        this(modelClassRefDependency, null);
    }

    @Override
    public void processAllVariants(@NotNull ParamContext context, @NotNull Consumer<LookupElement> elementsConsumer) {
        Collection<MigrationField> collection;
        long l2 = d ^ 0x2FE20C5F851EL;
        if (context == null) {
            MigrationFieldRefParam.c(0);
        }
        if (elementsConsumer == null) {
            MigrationFieldRefParam.c(1);
        }
        if ((collection = this.getFields(context)) == null) {
            return;
        }
        for (MigrationField migrationField : collection) {
            if ("id".equals(migrationField.getName())) continue;
            elementsConsumer.consume((Object)MigrationFieldRefParam.createTypedLookupItem(context, migrationField.getName(), migrationField.getDataType(), LookupItemType.Symbol, RailsIcons.EXPLICIT_ICON_DB_FIELD));
        }
    }

    @Override
    @Nullable
    public PsiElement resolveReference(@NotNull ParamContext context) {
        if (context == null) {
            MigrationFieldRefParam.c(2);
        }
        String string = MigrationFieldRefParam.elementText(context);
        Collection<MigrationField> collection = this.getFields(context);
        if (collection == null) {
            return null;
        }
        for (MigrationField migrationField : collection) {
            List<PsiElement> list2;
            if (!string.equals(migrationField.getName()) || (list2 = migrationField.getDeclarations()).isEmpty()) continue;
            return list2.get(list2.size() - 1);
        }
        return null;
    }

    @Override
    public InspectionResult warningInspection(ParamContext context, RPsiElement element) {
        String string;
        long l2 = d ^ 0x764FD7D128D5L;
        String string2 = this.determineTableName(context);
        if (string2 == null) {
            string = RBundle.message("inspection.paramdef.migration.warning.undefined.db", this.getTargetClassName(context), ParamDef.getTextPresentationForPsiElement(element));
        } else {
            Collection<MigrationField> collection = this.getFields(context);
            String string3 = "";
            if (collection != null && !collection.isEmpty()) {
                String string4;
                Iterator<MigrationField> iterator = collection.iterator();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i10 = 0; i10 < 3 && iterator.hasNext(); ++i10) {
                    string4 = iterator.next().getName();
                    if (string4 == null || "id".equals(StringUtil.toLowerCase((String)string4))) continue;
                    arrayList.add(string4);
                }
                string4 = null;
                if (!arrayList.isEmpty()) {
                    String string5 = (String)arrayList.get(0);
                    if (string5 != null) {
                        string4 = ":" + string5;
                        if (arrayList.size() != 1 && arrayList.get(1) != null) {
                            string4 = string4 + " or :" + (String)arrayList.get(1);
                        }
                    }
                    if (string4 != null) {
                        string3 = " " + RBundle.message("inspection.paramdef.warning.eg.singular", string4);
                    }
                }
            }
            string = RBundle.message("inspection.paramdef.migration.warning", string2, ParamDef.getTextPresentationForPsiElement(element), string3);
        }
        return InspectionResult.createWarningResult((PsiElement)element, string);
    }

    @Override
    protected boolean inspectionEnabledFor(ParamContext context) {
        Module module2 = context.getModule();
        if (module2 == null) {
            return false;
        }
        MigrationParser migrationParser = MigrationParser.getInstance(module2);
        String string = this.determineTableName(context);
        if (this.tableNameDependency != null && !migrationParser.containsTable(string)) {
            return false;
        }
        if (this.modelClassRefDependency != null && !migrationParser.containsTable(string)) {
            return false;
        }
        return super.inspectionEnabledFor(context);
    }

    @Nullable
    protected Collection<MigrationField> getFields(ParamContext context) {
        Module module2 = context.getModule();
        if (module2 == null) {
            return null;
        }
        String string = this.determineTableName(context);
        return string != null ? MigrationParser.getInstance(module2).getFieldsByTableName(string) : null;
    }

    @Nullable
    protected String determineTableName(ParamContext context) {
        if (this.tableNameDependency != null) {
            Module module2 = context.getModule();
            if (module2 == null) {
                return null;
            }
            PsiElement psiElement = this.tableNameDependency.getValue(context);
            return psiElement != null ? RubyPsiUtil.getElementText(psiElement) : null;
        }
        String string = this.getTargetClassName(context);
        ActiveRecordModel activeRecordModel = ActiveRecordModel.fromModelName(context.getModule(), string);
        return activeRecordModel != null ? activeRecordModel.getTableName() : null;
    }

    @Nullable
    protected String getTargetClassName(ParamContext context) {
        Object object;
        if (this.modelClassRefDependency != null) {
            PsiElement psiElement = this.modelClassRefDependency.getValue(context);
            return psiElement instanceof RPsiElement ? ((RPsiElement)psiElement).getName() : null;
        }
        RCall rCall = context.getCall();
        Object object2 = rCall.getPsiCommand();
        PsiElement psiElement = null;
        RPsiElement rPsiElement = null;
        while (object2 instanceof RDotReference) {
            rPsiElement = ((RDotReference)object2).getReceiver();
            object2 = rPsiElement;
        }
        if (rPsiElement != null) {
            object = rPsiElement.getReference();
            PsiElement psiElement2 = psiElement = object != null ? object.resolve() : null;
        }
        if (psiElement == null) {
            psiElement = PsiTreeUtil.getParentOfType((PsiElement)rCall, RClass.class);
        }
        if (!(psiElement instanceof RClass)) {
            return null;
        }
        object = SymbolUtil.getSymbolByContainer((RClass)psiElement);
        return object == null ? null : object.getFQNWithNesting().getFullPath();
    }

    private static /* synthetic */ void c(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = d ^ 0x723A5D9B59CCL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/MigrationFieldRefParam";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

