/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rack.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.RunnerMediator;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.browsers.JavaScriptDebuggerStarter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.TimeoutUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rack.RackUtil;
import org.jetbrains.plugins.ruby.rack.run.RackRunConfiguration;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline.TorqueBoxServerRunCommandLineGenerator;
import org.jetbrains.plugins.ruby.ruby.run.PortForwarding;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyConsoleFilterProvider;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public class RackRunCommandLineState
extends RubyAbstractCommandLineState {
    @NonNls
    private static final String h = "ruby.rack.runner";
    private static final long i = c.a(1949001813246816928L, -4615049524422160424L, MethodHandles.lookup().lookupClass()).a(20900945561187L);

    public RackRunCommandLineState(RackRunConfiguration config, ExecutionEnvironment env) {
        super(config, env, false);
    }

    @Override
    public RackRunConfiguration getConfig() {
        return (RackRunConfiguration)super.getConfig();
    }

    @Override
    protected RubyCommandLineData createRunCommandLine() throws ExecutionException {
        RackRunConfiguration rackRunConfiguration = this.getConfig();
        String string = this.getRunnerId();
        return RackRunCommandLineState.createCommandLine(rackRunConfiguration, string);
    }

    @Override
    public Pair<RubyCommandLineData, ProcessHandler> createCommandLineAndProcessHandler() throws ExecutionException {
        Pair<RubyCommandLineData, ProcessHandler> pair = super.createCommandLineAndProcessHandler();
        ProcessHandler processHandler = (ProcessHandler)pair.getSecond();
        final String string = this.getConfig().getBrowserUrl();
        if (string != null) {
            final Ref ref = new Ref((Object)false);
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
                private static final long a = c.a(-2163833042486675819L, 7717400760457654314L, MethodHandles.lookup().lookupClass()).a(104660082026110L);

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.a(0);
                    }
                    if (outputType == null) {
                        1.a(1);
                    }
                    if (((Boolean)ref.get()).booleanValue()) {
                        return;
                    }
                    ref.set((Object)true);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        long l2 = a ^ 0x4F901FBEE020L;
                        TimeoutUtil.sleep((long)5000L);
                        if (RackRunCommandLineState.this.isInRubyDebugMode() && RackRunCommandLineState.this.getConfig().isLaunchJavascriptDebugger() && JavaScriptDebuggerStarter.Util.start((RunConfiguration)RackRunCommandLineState.this.getConfig(), (String)("http://" + RackRunCommandLineState.this.getConfig().getHost() + ':' + RackRunCommandLineState.this.getConfig().getPort() + '/'))) {
                            return;
                        }
                        BrowserUtil.browse((String)string);
                    });
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    long l2 = a ^ 0x52BB2823D8A7L;
                    Object[] objectArray2 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/ruby/rack/run/RackRunCommandLineState$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        return pair;
    }

    @Override
    public List<Filter> createConsoleMessageFilters() {
        List<Filter> list2 = super.createConsoleMessageFilters();
        RackRunConfiguration rackRunConfiguration = this.getConfig();
        Project project = rackRunConfiguration.getProject();
        String string = VfsUtil.getParentDir((String)rackRunConfiguration.getRackScriptPath());
        Sdk sdk = rackRunConfiguration.getSdk();
        for (RubyConsoleFilterProvider rubyConsoleFilterProvider : (RubyConsoleFilterProvider[])RubyConsoleFilterProvider.EP_NAME.getExtensions()) {
            Filter filter = rubyConsoleFilterProvider.createFilter(project, string, sdk);
            if (filter == null) continue;
            list2.add(filter);
        }
        return list2;
    }

    public static RubyCommandLineData createCommandLine(@NotNull RackRunConfiguration config, String runnerId) throws ExecutionException {
        long l2 = i ^ 0xAF45C1745C2L;
        if (config == null) {
            RackRunCommandLineState.b(0);
        }
        RubyCommandLineData rubyCommandLineData = RackRunCommandLineState.createDefaultCommandLine(config, runnerId);
        Sdk sdk = config.getSdk();
        Module module2 = config.getModule();
        if (module2 != null && sdk != null) {
            if (config.getServer().equals(RackUtil.RackServers.TORQUEBOX.getServerName())) {
                TorqueBoxServerRunCommandLineGenerator.doDeploy(config, config.getServer(), "");
                String string = config.getGemScriptPath();
                assert (string != null);
                RubyCommandLine rubyCommandLine = rubyCommandLineData.getCommandLine();
                RubySdkAdditionalData rubySdkAdditionalData = RubySdkUtil.getRubySdkAdditionalData(sdk);
                ParamsGroup paramsGroup = RackRunCommandLineState.addExecutionScriptGroup(h, rubyCommandLineData, rubyCommandLine, rubySdkAdditionalData.getRunnerMappings(config), rubySdkAdditionalData.getSdkSystemAccessor(), string);
                RackRunCommandLineState.addParams(paramsGroup, "run");
            } else {
                String string = RackUtil.findRackupExecutablePath(module2, sdk);
                if (string != null) {
                    RubyCommandLine rubyCommandLine = rubyCommandLineData.getCommandLine();
                    RubySdkAdditionalData rubySdkAdditionalData = RubySdkUtil.getRubySdkAdditionalData(sdk);
                    ParamsGroup paramsGroup = RackRunCommandLineState.addExecutionScriptGroup(h, rubyCommandLineData, rubyCommandLine, rubySdkAdditionalData.getRunnerMappings(config), rubySdkAdditionalData.getSdkSystemAccessor(), string);
                    RackUtil.RackServers[] rackServersArray = RackUtil.RackServers.values();
                    String string2 = config.getServer();
                    if (!string2.equals(RackUtil.RackServers.DEFAULT.getServerName())) {
                        for (Object object : rackServersArray) {
                            if (!object.getServerName().equals(string2)) continue;
                            RackRunCommandLineState.a(paramsGroup, "-s", object.getCommandOption());
                        }
                    }
                    RackRunCommandLineState.a(paramsGroup, "-o", config.getHost());
                    RackRunCommandLineState.a(paramsGroup, "-p", config.getPort());
                    int n2 = Integer.valueOf(config.getPort());
                    RunConfigurationUtil.addPortForwarding(rubyCommandLineData, PortForwarding.remoteToLocal(config.getHost(), n2, n2));
                    Map map2 = config.getEnvs();
                    for (Object object : map2.keySet()) {
                        if (!((String)object).equals("RACK_ENV")) continue;
                        RackRunCommandLineState.a(paramsGroup, "-E", (String)map2.get(object));
                    }
                    String string3 = config.getRackupConfig();
                    if (!string3.isEmpty()) {
                        paramsGroup.addParameter(string3);
                    }
                }
            }
        }
        return rubyCommandLineData;
    }

    private static void a(ParamsGroup paramsGroup, String string, String string2) {
        if (!string2.isEmpty()) {
            paramsGroup.addParametersString(string);
            paramsGroup.addParameter(string2);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2019.1")
    public static ProcessHandler createProcessWithCtrlBreakHandling(GeneralCommandLine commandLine) throws ExecutionException {
        assert (commandLine instanceof RubyCommandLine);
        return RackRunCommandLineState.createProcessWithCtrlBreakHandling((RubyCommandLine)commandLine);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2019.1")
    public static ProcessHandler createProcessWithCtrlBreakHandling(RubyCommandLine commandLine) throws ExecutionException {
        return RunnerMediator.getInstance().createProcess((GeneralCommandLine)commandLine.withPty(false));
    }

    private static /* synthetic */ void b(int n2) {
        long l2 = i ^ 0x3F50829446D9L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/plugins/ruby/rack/run/RackRunCommandLineState", "createCommandLine"));
    }
}

