/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.inspection.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.i18n.dictionary.I18nDictionary;
import org.jetbrains.plugins.ruby.i18n.inspection.quickfixes.I18nCreatePropertyDialog;
import org.jetbrains.plugins.ruby.i18n.locales.LocaleEntry;
import org.jetbrains.plugins.ruby.i18n.references.I18nResolveResult;
import org.jetbrains.plugins.ruby.i18n.references.I18nTranslateReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class I18nCreatePropertyQuickFix
implements LocalQuickFix {
    private static final Logger a;
    public static final Key<Trinity<String, String, String>> TEST_VALUES;
    private static final long b;

    @NotNull
    public String getName() {
        long l2 = b ^ 0x5BD32A040534L;
        String string = RBundle.message("inspection.rails.i18n.create.property");
        if (string == null) {
            I18nCreatePropertyQuickFix.a(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        long l2 = b ^ 0x6837F4FD6AD6L;
        String string = RBundle.message("inspection.group.rails.name");
        if (string == null) {
            I18nCreatePropertyQuickFix.a(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement psiElement;
        Trinity trinity;
        if (project == null) {
            I18nCreatePropertyQuickFix.a(2);
        }
        if (descriptor2 == null) {
            I18nCreatePropertyQuickFix.a(3);
        }
        if ((trinity = (Trinity)(psiElement = descriptor2.getPsiElement()).getContainingFile().getUserData(TEST_VALUES)) != null) {
            this.applyFix(project, psiElement, (String)trinity.first, (String)trinity.second, (String)trinity.third);
        } else {
            this.applyFix(project, psiElement, null, null, null);
        }
    }

    public void applyFix(@NotNull Project project, @NotNull PsiElement element, @Nullable String locale, @Nullable String key, @Nullable String value) {
        Map map2;
        String string;
        RCall rCall;
        long l2 = b ^ 0x6DD65743F9B4L;
        if (project == null) {
            I18nCreatePropertyQuickFix.a(4);
        }
        if (element == null) {
            I18nCreatePropertyQuickFix.a(5);
        }
        if ((rCall = RubyPsiUtil.getCoveringRCall(element)) == null) {
            return;
        }
        I18nTranslateReference i18nTranslateReference2 = Arrays.stream(rCall.getReferences()).map(psiReference -> (I18nTranslateReference)ObjectUtils.tryCast((Object)psiReference, I18nTranslateReference.class)).filter(Objects::nonNull).filter(i18nTranslateReference -> i18nTranslateReference.getReferenceContent().equals(element)).findFirst().orElse(null);
        if (i18nTranslateReference2 == null) {
            return;
        }
        I18nDictionary i18nDictionary = i18nTranslateReference2.getDictionary();
        ArrayList<LocaleEntry> arrayList = new ArrayList<LocaleEntry>(i18nDictionary.getAllLocaleEntries());
        for (ResolveResult resolveResult : i18nTranslateReference2.multiResolve(false)) {
            String string2 = ((I18nResolveResult)resolveResult).getLocaleEntry().getLocale();
            arrayList.removeIf(localeEntry -> localeEntry.getLocale().equals(string2));
        }
        if (arrayList.isEmpty()) {
            return;
        }
        if (key == null || value == null || locale == null) {
            Map<String, LocaleEntry> map3 = I18nCreatePropertyDialog.createPresentationToLocaleEntries(arrayList);
            I18nCreatePropertyDialog i18nCreatePropertyDialog = new I18nCreatePropertyDialog(element.getProject(), i18nDictionary, map3, i18nTranslateReference2.getFullKeys(), null, null);
            if (!i18nCreatePropertyDialog.showAndGet()) {
                return;
            }
            string = i18nCreatePropertyDialog.getPropertyKey();
            map2 = ContainerUtil.map2Map(i18nCreatePropertyDialog.getLocaleTranslations().entrySet(), entry -> new Pair(map3.get(entry.getKey()), entry.getValue()));
        } else {
            if (!i18nDictionary.getLocalesByKey(key).isEmpty()) assert (i18nTranslateReference2.getFullKeys().contains(key)) : "Key " + key + " is not a key under caret: " + i18nTranslateReference2.getFullKeys();
            string = key;
            LocaleEntry localeEntry2 = i18nDictionary.getLocaleEntriesByLocale(locale).iterator().next();
            if (!arrayList.contains(localeEntry2)) {
                return;
            }
            map2 = Collections.singletonMap(localeEntry2, value);
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)RBundle.message("inspection.rails.i18n.create.property"), null, () -> map2.forEach((localeEntry, string2) -> localeEntry.createI18nRecord(string, (String)string2)), (PsiFile[])new PsiFile[0]);
    }

    public boolean startInWriteAction() {
        return false;
    }

    static {
        b = c.a(1458802863803782657L, -4847872407301410142L, MethodHandles.lookup().lookupClass()).a(231492791739611L);
        long l2 = b ^ 0x37DF8CF7B176L;
        a = Logger.getInstance(I18nCreatePropertyQuickFix.class);
        TEST_VALUES = Key.create((String)"RAILS_I18N_CREATE_PROPERTY_TEST_VALUES");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x46AA2558429CL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/inspection/quickfixes/I18nCreatePropertyQuickFix";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/inspection/quickfixes/I18nCreatePropertyQuickFix";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

