/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.inspection;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.i18n.I18nTranslateCallType;
import org.jetbrains.plugins.ruby.i18n.dictionary.I18nDictionary;
import org.jetbrains.plugins.ruby.i18n.inspection.quickfixes.I18nCreatePropertyQuickFix;
import org.jetbrains.plugins.ruby.i18n.locales.LocaleEntry;
import org.jetbrains.plugins.ruby.i18n.references.I18nTranslateReference;
import org.jetbrains.plugins.ruby.i18n.rename.I18nKeyRenameProcessor;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class I18nKeyInspectionVisitor
extends RubyInspectionVisitor {
    private static final long b = c.a(4312114950716562597L, -9031635514945394154L, MethodHandles.lookup().lookupClass()).a(218063972156306L);

    public I18nKeyInspectionVisitor(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            I18nKeyInspectionVisitor.d(0);
        }
        super(holder);
    }

    @Override
    public void visitRCall(RCall rCall) {
        long l2 = b ^ 0x76D5C391A06FL;
        if (!(rCall.getCallType() instanceof I18nTranslateCallType)) {
            return;
        }
        List<RPsiElement> list2 = rCall.getArguments();
        if (list2.isEmpty()) {
            this.registerProblem((PsiElement)rCall, RBundle.message("inspection.rails.i18n.translate.call.wrong.arguments"));
            return;
        }
        I18nDictionary i18nDictionary = I18nDictionary.forElement((PsiElement)rCall);
        if (i18nDictionary == null) {
            return;
        }
        Collection<LocaleEntry> collection = i18nDictionary.getAllLocaleEntries();
        for (PsiReference psiReference : rCall.getReferences()) {
            I18nTranslateReference i18nTranslateReference = (I18nTranslateReference)ObjectUtils.tryCast((Object)psiReference, I18nTranslateReference.class);
            if (i18nTranslateReference == null) continue;
            String string2 = i18nTranslateReference.getCanonicalText();
            if (!I18nKeyRenameProcessor.isValidKeyName(string2)) {
                this.registerProblem(i18nTranslateReference.getReferenceContent(), RBundle.message("inspection.rails.i18n.wrong.key.format", string2));
                continue;
            }
            ResolveResult[] resolveResultArray = i18nTranslateReference.multiResolve(false);
            if (resolveResultArray.length == 0) {
                if (collection.isEmpty()) {
                    this.registerProblem(i18nTranslateReference.getReferenceContent(), RBundle.message("inspection.rails.i18n.key.not.found", string2));
                    continue;
                }
                this.registerProblem(i18nTranslateReference.getReferenceContent(), RBundle.message("inspection.rails.i18n.key.not.found", string2), new I18nCreatePropertyQuickFix());
                continue;
            }
            HashSet hashSet = new HashSet();
            i18nTranslateReference.getFullKeys().forEach(string -> hashSet.addAll(i18nDictionary.getLocalesByKey((String)string)));
            if (i18nDictionary.getAllLocales().size() <= hashSet.size()) continue;
            this.registerProblem(i18nTranslateReference.getReferenceContent(), RBundle.message("inspection.rails.i18n.key.not.defined", string2), ProblemHighlightType.WEAK_WARNING, new I18nCreatePropertyQuickFix());
        }
    }

    private static /* synthetic */ void d(int n2) {
        long l2 = b ^ 0x66F57212D4DDL;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/ruby/i18n/inspection/I18nKeyInspectionVisitor", "<init>"));
    }
}

