/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.i18n.I18nProvider;
import org.jetbrains.plugins.ruby.i18n.I18nTranslateCallType;
import org.jetbrains.plugins.ruby.i18n.dictionary.I18nDictionary;
import org.jetbrains.plugins.ruby.i18n.folding.I18nFoldingSettings;
import org.jetbrains.plugins.ruby.i18n.folding.RubyI18nFoldingLocaleSettings;
import org.jetbrains.plugins.ruby.i18n.locales.LocaleEntry;
import org.jetbrains.plugins.ruby.i18n.references.I18nResolveResult;
import org.jetbrains.plugins.ruby.i18n.references.I18nTranslateReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;

public class I18nFoldingBuilder
extends FoldingBuilderEx {
    private static final Key<String> a;
    private static final long b;

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            I18nFoldingBuilder.a(0);
        }
        if (document == null) {
            I18nFoldingBuilder.a(1);
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)root);
        final I18nDictionary i18nDictionary = I18nDictionary.forModule(module2);
        if (!I18nProvider.isI18nSupportEnabled(module2) || i18nDictionary == null) {
            if (FoldingDescriptor.EMPTY == null) {
                I18nFoldingBuilder.a(2);
            }
            return FoldingDescriptor.EMPTY;
        }
        final RubyI18nFoldingLocaleSettings rubyI18nFoldingLocaleSettings = RubyI18nFoldingLocaleSettings.getInstance(root.getProject());
        final String string = I18nFoldingBuilder.a(module2, rubyI18nFoldingLocaleSettings);
        final ArrayList arrayList = new ArrayList();
        RubyRecursiveElementVisitor rubyRecursiveElementVisitor = new RubyRecursiveElementVisitor(){

            @Override
            public void visitRCall(RCall rCall) {
                if (!(rCall.getCallType() instanceof I18nTranslateCallType)) {
                    super.visitRCall(rCall);
                    return;
                }
                for (PsiReference psiReference : rCall.getReferences()) {
                    String string2;
                    I18nTranslateReference i18nTranslateReference = (I18nTranslateReference)psiReference;
                    PsiElement psiElement = (PsiElement)ObjectUtils.doIfNotNull((Object)I18nFoldingBuilder.a(i18nTranslateReference, string), ResolveResult::getElement);
                    if (psiElement == null || StringUtil.isEmptyOrSpaces((String)(string2 = I18nProvider.forElement(psiElement).getTranslation(psiElement)))) continue;
                    rCall.putUserData(a, StringUtil.shortenTextWithEllipsis((String)string2, (int)50, (int)0, (boolean)true));
                    arrayList.add(I18nFoldingBuilder.a(rCall, new Object[]{rubyI18nFoldingLocaleSettings, psiElement.getContainingFile()}));
                    return;
                }
                String string3 = I18nTranslateCallType.getDefaultTranslationOption(rCall);
                if (StringUtil.isEmptyOrSpaces((String)string3)) {
                    return;
                }
                rCall.putUserData(a, StringUtil.shortenTextWithEllipsis((String)string3, (int)50, (int)0, (boolean)true));
                HashSet hashSet = ContainerUtil.newHashSet((Object[])new Object[]{rubyI18nFoldingLocaleSettings});
                i18nDictionary.getLocaleEntriesByLocale(string).stream().map(LocaleEntry::getPsiFile).forEach(hashSet::add);
                arrayList.add(I18nFoldingBuilder.a(rCall, hashSet.toArray()));
            }
        };
        root.accept((PsiElementVisitor)rubyRecursiveElementVisitor);
        FoldingDescriptor[] foldingDescriptorArray = arrayList.toArray(FoldingDescriptor.EMPTY);
        if (foldingDescriptorArray == null) {
            I18nFoldingBuilder.a(3);
        }
        return foldingDescriptorArray;
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            I18nFoldingBuilder.a(4);
        }
        return "\"" + (String)node.getPsi().getUserData(a) + "\"";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            I18nFoldingBuilder.a(5);
        }
        return I18nFoldingSettings.getInstance().isCollapseI18nMessages();
    }

    @NotNull
    private static FoldingDescriptor a(@NotNull RCall rCall, Object ... objectArray) {
        if (rCall == null) {
            I18nFoldingBuilder.a(6);
        }
        if (objectArray == null) {
            I18nFoldingBuilder.a(7);
        }
        FoldingDescriptor foldingDescriptor = new FoldingDescriptor(rCall.getNode(), rCall.getTextRange(), null, ContainerUtil.set((Object[])objectArray));
        foldingDescriptor.setCanBeRemovedWhenCollapsed(true);
        FoldingDescriptor foldingDescriptor2 = foldingDescriptor;
        if (foldingDescriptor2 == null) {
            I18nFoldingBuilder.a(8);
        }
        return foldingDescriptor2;
    }

    @NotNull
    private static String a(@NotNull Module module2, @NotNull RubyI18nFoldingLocaleSettings rubyI18nFoldingLocaleSettings) {
        String string;
        Collection<LocaleEntry> collection;
        List list2;
        if (module2 == null) {
            I18nFoldingBuilder.a(9);
        }
        if (rubyI18nFoldingLocaleSettings == null) {
            I18nFoldingBuilder.a(10);
        }
        if (!(list2 = ContainerUtil.mapNotNull(collection = I18nProvider.getAllLocaleEntries(module2), LocaleEntry::getLocale)).contains(string = rubyI18nFoldingLocaleSettings.getLocale()) && !list2.isEmpty()) {
            string = (String)list2.get(0);
        }
        String string2 = string;
        if (string2 == null) {
            I18nFoldingBuilder.a(11);
        }
        return string2;
    }

    @Nullable
    private static ResolveResult a(@NotNull I18nTranslateReference i18nTranslateReference, @NotNull String string) {
        if (i18nTranslateReference == null) {
            I18nFoldingBuilder.a(12);
        }
        if (string == null) {
            I18nFoldingBuilder.a(13);
        }
        Object[] objectArray = i18nTranslateReference.multiResolve(false);
        return (ResolveResult)ContainerUtil.find((Object[])objectArray, resolveResult -> ((I18nResolveResult)((Object)resolveResult)).getLocaleEntry().getLocale().equals(string));
    }

    static {
        b = c.a(-8720271826042562747L, 3020204250337355560L, MethodHandles.lookup().lookupClass()).a(18923896044084L);
        long l2 = b ^ 0x68508A6E5D0AL;
        a = Key.create((String)"RAILS_I18N_VALUE");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x6C3156778F74L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/folding/I18nFoldingBuilder";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "translateRef";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/folding/I18nFoldingBuilder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFoldingDescriptor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocale";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFoldingDescriptor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLocale";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findResolveResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

