/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.Function;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public class GemSearchUtil {
    private static final Logger a;
    private static final long b;

    private GemSearchUtil() {
    }

    public static boolean hasSameNameAndVersion(String gemName, @Nullable String gemVersion, GemInfo gem) {
        return Comparing.strEqual((String)gemName, (String)gem.getName()) && (gemVersion == null || Comparing.strEqual((String)gemVersion, (String)gem.getVersion()));
    }

    @Nullable
    public static GemInfo findGemEx(@NotNull Module module2, @NotNull String gemName) {
        if (module2 == null) {
            GemSearchUtil.a(0);
        }
        if (gemName == null) {
            GemSearchUtil.a(1);
        }
        return GemSearchUtil.findGemEx(module2, gemName, null);
    }

    @Nullable
    public static GemInfo findGemEx(@NotNull Module module2, @NotNull String gemName, @Nullable String gemVersion) {
        Set<GemInfo> set;
        GemInfo gemInfo;
        if (module2 == null) {
            GemSearchUtil.a(2);
        }
        if (gemName == null) {
            GemSearchUtil.a(3);
        }
        if ((gemInfo = GemSearchUtil.findGem(set = GemManager.getAllGems(module2), gemName, gemVersion)) != null) {
            return gemInfo;
        }
        if (BundlerUtil.hasGemfile(module2)) {
            return null;
        }
        return GemSearchUtil.findGem(module2, RModuleUtil.getInstance().findRubySdkForModule(module2), gemName, gemVersion);
    }

    @Nullable
    public static GemInfo findGem(@NotNull Module module2, @NotNull String gemName) {
        if (module2 == null) {
            GemSearchUtil.a(4);
        }
        if (gemName == null) {
            GemSearchUtil.a(5);
        }
        return GemSearchUtil.findGem(module2, gemName, null);
    }

    @Nullable
    public static GemInfo findGem(@NotNull Module module2, @NotNull String gemName, @Nullable String gemVersion) {
        if (module2 == null) {
            GemSearchUtil.a(6);
        }
        if (gemName == null) {
            GemSearchUtil.a(7);
        }
        Set<GemInfo> set = GemManager.getAllGems(module2);
        return GemSearchUtil.findGem(set, gemName, gemVersion);
    }

    @Nullable
    public static GemInfo findGemByRequirement(@Nullable Module module2, @Nullable Sdk sdk, @NotNull String gemName, @Nullable String gemRequirement) {
        if (gemName == null) {
            GemSearchUtil.a(8);
        }
        if (gemRequirement == null) {
            return GemSearchUtil.findGem(module2, sdk, gemName);
        }
        GemDependency gemDependency = GemDependency.create(gemName, gemRequirement);
        assert (gemDependency != null);
        return GemSearchUtil.findGem(module2, sdk, gemDependency);
    }

    @Nullable
    public static GemInfo findGem(Collection<? extends GemInfo> gems, String gemName, @Nullable String gemVersion) {
        return GemSearchUtil.findGem(gems, (Function<? super GemInfo, Boolean>)((Function)gemInfo -> gemInfo != null && GemSearchUtil.hasSameNameAndVersion(gemName, gemVersion, gemInfo) && gemInfo.isValid()));
    }

    @Nullable
    public static GemInfo findGem(Collection<? extends GemInfo> gems, GemDependency dependency) {
        return GemSearchUtil.findGem(gems, (Function<? super GemInfo, Boolean>)((Function)gemInfo -> dependency.isSatisfied((GemInfo)gemInfo)));
    }

    @Nullable
    public static GemInfo findGem(@Nullable Module module2, @Nullable Sdk sdk, @NonNls @NotNull String gemName) {
        if (gemName == null) {
            GemSearchUtil.a(9);
        }
        return GemSearchUtil.findGem(module2, sdk, gemName, null);
    }

    @Nullable
    public static GemInfo findGem(@Nullable Module module2, @Nullable Sdk sdk, @NonNls @NotNull String gemName, @NonNls @Nullable String gemVersion) {
        long l2 = b ^ 0x754BF7723723L;
        if (gemName == null) {
            GemSearchUtil.a(10);
        }
        Collection<GemInfo> collection = GemManager.getInstance().getAllGems(sdk, module2);
        if (a.isDebugEnabled()) {
            a.debug("Searching for gem: gemName=" + gemName + "; gemVersion=" + gemVersion + "; module=" + module2 + "; gemVersion=" + sdk + "; allGems=" + collection);
        }
        return GemSearchUtil.findGem(collection, gemName, gemVersion);
    }

    @Nullable
    public static GemInfo findGem(Collection<? extends GemInfo> gems, Function<? super GemInfo, Boolean> condition) {
        String string = null;
        GemInfo gemInfo = null;
        for (GemInfo gemInfo2 : gems) {
            String string2 = gemInfo2.getVersion();
            if (!((Boolean)condition.fun((Object)gemInfo2)).booleanValue() || VersionComparatorUtil.compare(string, (String)string2) >= 0) continue;
            gemInfo = gemInfo2;
            string = string2;
        }
        return gemInfo;
    }

    @Nullable
    public static GemInfo findGem(@Nullable Module module2, @Nullable Sdk rubySdk, @NotNull GemDependency dependency) {
        if (dependency == null) {
            GemSearchUtil.a(11);
        }
        return GemSearchUtil.findGem(GemManager.getInstance().getAllGems(rubySdk, module2), dependency);
    }

    @Nullable
    public static GemInfo findGem(@Nullable Module module2, @NotNull GemDependency dependency) {
        if (dependency == null) {
            GemSearchUtil.a(12);
        }
        return module2 != null ? GemSearchUtil.findGem(GemManager.getAllGems(module2), dependency) : null;
    }

    static {
        b = c.a(8898426062165751474L, -4772484908873119322L, MethodHandles.lookup().lookupClass()).a(275503605850688L);
        a = Logger.getInstance(GemSearchUtil.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = b ^ 0x3E23F2ED668FL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/gem/util/GemSearchUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findGemEx";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "findGem";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findGemByRequirement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

