/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.util;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.python.psi.c;
import gnu.trove.THashMap;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.cli.RMInspectionToolLaunchSettings;
import org.jetbrains.plugins.ruby.gem.GemCallTypeProvider;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemInstallUtil;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfig;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfigService;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfigServiceImpl;
import org.jetbrains.plugins.ruby.gem.bundler.BundleExecSettings;
import org.jetbrains.plugins.ruby.gem.detector.GemDetector;
import org.jetbrains.plugins.ruby.gem.gem.GemCompatibilityUtil;
import org.jetbrains.plugins.ruby.gem.module.GemRequirementsChangeWatcher;
import org.jetbrains.plugins.ruby.gem.ui.GemUiUtil;
import org.jetbrains.plugins.ruby.gem.util.GemEnvironment;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.motion.RubyMotionUtil;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsUtil;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebugMode;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelPusher;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.run.CmdlinePreprocessor;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.LocalRubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.utils.OSUtil;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.ShimsBasedVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public class BundlerUtil {
    public static final String GEMS = "gems";
    public static final String BUNDLER = "bundler";
    public static final String BUNDLE = "bundle";
    private static final String j = "bundle.bat";
    private static final String g = "bundle.cmd";
    private static final String m = "Gemfile";
    public static final String BUNDLE_FOLDER = ".bundle";
    public static final String BUNDLER_FOLDER = ".bundler";
    private static final String f = "gems.rb";
    private static final String l = "gems.locked";
    private static final String[] i;
    public static final String RBUNDLER_SETUP = "-rbundler/setup";
    public static final String BUNDLER_HTTP_PROXY_ENV_VAR = "HTTP_PROXY";
    private static final Logger a;
    private static final String b = ".lock";
    @Deprecated
    private static final String k = "Gemfile.lock";
    private static final String d = "/bundler/gems";
    private static final String e = "/";
    private static final String h = "group";
    @NonNls
    private static final String c = "test/unit/ui/teamcity/loadpath_patch.rb";
    private static final long n;

    private BundlerUtil() {
    }

    public static void addBundlerBinPaths(Module module2, List<String> binaryScriptsLookupFolders) {
        if (module2 == null || module2.isDisposed()) {
            return;
        }
        BundlerUtil.a(BundlerUtil.getBundlerGemsDirFromConfig(module2), binaryScriptsLookupFolders);
        for (VirtualFile virtualFile : RModuleUtil.getContentRoots(module2)) {
            BundlerUtil.a(virtualFile, binaryScriptsLookupFolders);
        }
    }

    public static void openGemFileInEditor(@NotNull Project project, @NotNull String rootPath) {
        long l2 = n ^ 0x786F8BA40724L;
        if (project == null) {
            BundlerUtil.a(0);
        }
        if (rootPath == null) {
            BundlerUtil.a(1);
        }
        GeneratorsUtil.openFileInEditor(project, new File(rootPath, m).exists() ? m : f, rootPath);
    }

    private static void a(@Nullable VirtualFile virtualFile, @NotNull List<String> list2) {
        long l2 = n ^ 0x5F8CB04643D8L;
        if (list2 == null) {
            BundlerUtil.a(2);
        }
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile.findChild("bin");
        if (virtualFile2 != null) {
            list2.add(virtualFile2.getPath());
        }
    }

    public static boolean installBundler(@Nullable Module module2, @Nullable Sdk sdk) {
        long l2 = n ^ 0x3A29F48ACDE8L;
        if (sdk == null && (sdk = RModuleUtil.getInstance().findRubySdkForModule(module2)) == null) {
            return false;
        }
        THashMap tHashMap = new THashMap();
        GemInstallUtil.installGemsDependencies(sdk, module2, GemCompatibilityUtil.createDependency(sdk, BUNDLER), true, false, (Map<GemDependency, String>)tHashMap);
        if (!tHashMap.isEmpty()) {
            GemUiUtil.showInstallErrors(module2, (Map<GemDependency, String>)tHashMap);
            return false;
        }
        return true;
    }

    public static boolean hasGemfile(@Nullable Module module2) {
        return BundlerUtil.getGemfile(module2) != null;
    }

    @Nullable
    public static RFile getGemfilePsiFile(@Nullable Module module2) {
        return (RFile)ReadAction.compute(() -> {
            if (module2 == null || module2.isDisposed()) {
                return null;
            }
            VirtualFile virtualFile = BundlerUtil.getGemfile(module2);
            if (virtualFile == null) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)module2.getProject()).findFile(virtualFile);
            return psiFile instanceof RFile ? (RFile)psiFile : null;
        });
    }

    @Nullable
    public static VirtualFile getGemfile(@Nullable Module module2) {
        return (VirtualFile)ReadAction.compute(() -> {
            VirtualFile virtualFile;
            if (RMInspectionToolLaunchSettings.getInstance().isActivated()) {
                return BundlerUtil.a();
            }
            BundleConfig bundleConfig = BundleConfigServiceImpl.getInstance().getConfig(module2);
            if (bundleConfig != null && (virtualFile = bundleConfig.getBundleGemfileVirtualFile()) != null) {
                return virtualFile;
            }
            return RModuleUtil.findFileInModuleRoot(module2, false, true, i);
        });
    }

    @Nullable
    public static VirtualFile getGemfile(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            BundlerUtil.a(3);
        }
        if (root == null) {
            BundlerUtil.a(4);
        }
        if (!root.isValid() || !root.isDirectory()) {
            return null;
        }
        for (String string : i) {
            VirtualFile virtualFile = root.findChild(string);
            if (virtualFile == null || ProjectFileIndex.getInstance((Project)project).isExcluded(virtualFile)) continue;
            return virtualFile;
        }
        return null;
    }

    @Nullable
    public static VirtualFile getGemfileLock(@Nullable Module module2) {
        return (VirtualFile)ReadAction.compute(() -> BundlerUtil.a(module2, false));
    }

    @Nullable
    public static VirtualFile getGemfileLockWithRefresh(@Nullable Module module2) {
        return BundlerUtil.a(module2, true);
    }

    @Nullable
    private static VirtualFile a(@Nullable Module module2, boolean bl2) {
        if (RMInspectionToolLaunchSettings.getInstance().isActivated()) {
            return BundlerUtil.b();
        }
        VirtualFile virtualFile = BundlerUtil.getGemfile(module2);
        if (virtualFile == null) {
            return null;
        }
        return RModuleUtil.findFileInModuleRoot(module2, bl2, true, BundlerUtil.a(virtualFile));
    }

    @NotNull
    private static String a(@NotNull VirtualFile virtualFile) {
        long l2 = n ^ 0x2CAFFE66E298L;
        if (virtualFile == null) {
            BundlerUtil.a(5);
        }
        String string = f.equalsIgnoreCase(virtualFile.getName()) ? l : virtualFile.getName() + b;
        if (string == null) {
            BundlerUtil.a(6);
        }
        return string;
    }

    @Nullable
    private static VirtualFile b() {
        VirtualFile virtualFile = BundlerUtil.a();
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile.getParent();
        return virtualFile2 == null || !virtualFile2.isValid() ? null : virtualFile2.findChild(BundlerUtil.a(virtualFile));
    }

    public static boolean isGemfile(@Nullable PsiFileSystemItem psiFileSystemItem) {
        return psiFileSystemItem != null && BundlerUtil.isGemfile(psiFileSystemItem.getProject(), psiFileSystemItem.getVirtualFile());
    }

    @Deprecated
    @Contract(value="null -> false")
    public static boolean isGemfile(@Nullable VirtualFile virtualFile) {
        return virtualFile != null && !virtualFile.isDirectory() && (BundlerUtil.isGemfileName(virtualFile.getName()) || BundleConfigService.getInstance().isGemFile(virtualFile));
    }

    @Contract(value="_, null -> false")
    public static boolean isGemfile(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            BundlerUtil.a(7);
        }
        return BundlerUtil.isGemfile(virtualFile) && !ProjectFileIndex.getInstance((Project)project).isExcluded(virtualFile);
    }

    public static boolean isGemfileName(@Nullable String fileName) {
        long l2 = n ^ 0x30D28F884AE1L;
        return fileName != null && (m.equalsIgnoreCase(fileName) || f.equalsIgnoreCase(fileName));
    }

    public static boolean isGemfileLockName(@Nullable String fileName) {
        long l2 = n ^ 0x31860EFE3835L;
        return fileName != null && (k.equalsIgnoreCase(fileName) || l.equalsIgnoreCase(fileName));
    }

    public static boolean isBundlerCall(RCall rCall) {
        long l2 = n ^ 0x20E5A751EEEEL;
        for (PsiReference psiReference : rCall.getPsiCommand().getReferences()) {
            PsiElement psiElement = psiReference.resolve();
            if (!(psiElement instanceof RMethod)) continue;
            RContainer rContainer = ((RMethod)psiElement).getParentContainer();
            rContainer = rContainer != null ? rContainer.getParentContainer() : null;
            return rContainer != null && BUNDLER.equalsIgnoreCase(rContainer.getName());
        }
        return false;
    }

    @Nullable
    public static VirtualFile getGitGemSpec(VirtualFile gemDir) {
        long l2 = n ^ 0x6F9BDAE69CCEL;
        if (gemDir == null) {
            return null;
        }
        for (VirtualFile virtualFile : gemDir.getChildren()) {
            String string = virtualFile.getName();
            if (!string.endsWith(".gemspec") || string.startsWith(".")) continue;
            return virtualFile;
        }
        return null;
    }

    public static void addBundlerPaths(Sdk sdk, Set<String> result) {
        String string2;
        long l2 = n ^ 0x6D42EF7E0DFL;
        for (String string2 : ArrayUtilRt.toStringArray(result)) {
            result.add(string2.replaceAll("/gems$", d));
        }
        String string3 = SystemProperties.getUserHome();
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)string3));
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile.findChild(BUNDLER_FOLDER);
        if (virtualFile2 == null) {
            virtualFile2 = virtualFile.findChild(BUNDLE_FOLDER);
        }
        if (virtualFile2 == null) {
            return;
        }
        string2 = virtualFile2.findChild(BundlerUtil.getSdkTypeStr(sdk));
        if (string2 == null || !string2.isDirectory()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(string2.getUrl());
        stringBuilder.append(e).append(BundlerUtil.getGemSdkVersion(sdk));
        result.add(stringBuilder.toString() + e + GEMS);
        stringBuilder.append(e).append(BUNDLER);
        stringBuilder.append(e).append(GEMS);
        result.add(stringBuilder.toString());
    }

    @NotNull
    public static String getGemSdkVersion(@Nullable Sdk sdk) {
        long l2 = n ^ 0x29A735E07A5EL;
        if (RubySdkUtil.isRuby27(sdk)) {
            if ("2.7.0" == null) {
                BundlerUtil.a(8);
            }
            return "2.7.0";
        }
        if (RubySdkUtil.isRuby26(sdk)) {
            if ("2.6.0" == null) {
                BundlerUtil.a(9);
            }
            return "2.6.0";
        }
        if (RubySdkUtil.isRuby25(sdk)) {
            if ("2.5.0" == null) {
                BundlerUtil.a(10);
            }
            return "2.5.0";
        }
        if (RubySdkUtil.isRuby24(sdk)) {
            if ("2.4.0" == null) {
                BundlerUtil.a(11);
            }
            return "2.4.0";
        }
        if (RubySdkUtil.isRuby23(sdk)) {
            if ("2.3.0" == null) {
                BundlerUtil.a(12);
            }
            return "2.3.0";
        }
        if (RubySdkUtil.isRuby22(sdk)) {
            if ("2.2.0" == null) {
                BundlerUtil.a(13);
            }
            return "2.2.0";
        }
        if (RubySdkUtil.isRuby21(sdk)) {
            if ("2.1.0" == null) {
                BundlerUtil.a(14);
            }
            return "2.1.0";
        }
        if (RubySdkUtil.isRuby20(sdk)) {
            if ("2.0.0" == null) {
                BundlerUtil.a(15);
            }
            return "2.0.0";
        }
        if (RubySdkUtil.isRuby19(sdk)) {
            String string = JRubySdkUtil.isJRubySDK(sdk) ? "1.9" : "1.9.1";
            if (string == null) {
                BundlerUtil.a(16);
            }
            return string;
        }
        if ("1.8" == null) {
            BundlerUtil.a(17);
        }
        return "1.8";
    }

    @NotNull
    public static String getSdkTypeStr(@Nullable Sdk sdk) {
        long l2 = n ^ 0x4858C80F8B22L;
        String string = JRubySdkUtil.isJRubySDK(sdk) ? "jruby" : "ruby";
        if (string == null) {
            BundlerUtil.a(18);
        }
        return string;
    }

    @Nullable
    public static VirtualFile getBundlerGemsDirFromConfig(@Nullable Module module2) {
        return (VirtualFile)ReadAction.compute(() -> {
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module2);
            VirtualFile virtualFile = BundlerUtil.a(sdk, BundleConfigServiceImpl.getInstance().getConfig(module2));
            return virtualFile == null ? BundlerUtil.a(sdk, BundleConfigServiceImpl.getInstance().getUserConfig(module2)) : virtualFile;
        });
    }

    @Nullable
    private static VirtualFile a(@Nullable Sdk sdk, @Nullable BundleConfig bundleConfig) {
        return (VirtualFile)ObjectUtils.doIfNotNull((Object)(bundleConfig == null ? null : bundleConfig.getBundlePathVirtualFile()), virtualFile -> BundlerUtil.a(sdk, virtualFile.getPath()));
    }

    @Nullable
    public static GemInfo getBundlerGem(@Nullable Sdk sdk, @Nullable Module module2, boolean execution) {
        GemInfo gemInfo;
        long l2 = n ^ 0x3370B4F8698L;
        if (execution) {
            GemDependency gemDependency = GemDependency.create(BUNDLER, ">= 0.9");
            assert (gemDependency != null);
            gemInfo = GemSearchUtil.findGem(module2, gemDependency);
            gemInfo = gemInfo == null ? GemSearchUtil.findGem(module2, sdk, gemDependency) : gemInfo;
        } else {
            gemInfo = module2 != null ? GemSearchUtil.findGem(module2, BUNDLER) : null;
            gemInfo = gemInfo == null ? GemSearchUtil.findGem(module2, sdk, BUNDLER) : gemInfo;
        }
        return gemInfo;
    }

    public static void patchBundleExecCommandLine(@NotNull Sdk sdk, @Nullable Module module2, @NotNull GeneralCommandLine cmdLine) {
        String string;
        String string2;
        long l2 = n ^ 0x48E3F8D54BA7L;
        if (sdk == null) {
            BundlerUtil.a(19);
        }
        if (cmdLine == null) {
            BundlerUtil.a(20);
        }
        if ((string2 = (String)cmdLine.getEnvironment().get("RUBYOPT")) != null) {
            string = string2.replace(RBUNDLER_SETUP, "");
            if (string.isEmpty()) {
                cmdLine.getEnvironment().remove("RUBYOPT");
            } else {
                cmdLine.withEnvironment("RUBYOPT", string);
            }
        }
        if ((string = RbenvGemsetManager.getShimsCommandPath(BUNDLE)) == null) {
            string = BundlerUtil.getBundlerScriptPath(sdk, module2);
        }
        if (string != null) {
            String string3 = cmdLine.getExePath();
            cmdLine.withExePath(RubyVersionManagerHandler.notNullFrom(sdk).getAdjustedGemScriptPathForExecution(string));
            ParametersList parametersList = cmdLine.getParametersList();
            parametersList.addAt(0, "exec");
            int n2 = string3.lastIndexOf(Platform.current().fileSeparator);
            String string4 = n2 == -1 ? string3 : string3.substring(n2 + 1);
            parametersList.addAt(1, string4);
        }
    }

    @Nullable
    public static String getBundlerExecutableScriptPath(@Nullable Sdk sdk, @Nullable Module module2) {
        String string = BundlerUtil.a(sdk, module2);
        if (string == null) {
            return null;
        }
        return BundlerUtil.a(sdk, module2, string);
    }

    @Nullable
    public static String getBundlerScriptPath(@Nullable Sdk sdk, @Nullable Module module2) {
        long l2 = n ^ 0x653FE3F795BBL;
        return BundlerUtil.a(sdk, module2, BUNDLE);
    }

    @Nullable
    private static String a(@Nullable Sdk sdk, @Nullable Module module2, @NotNull String string) {
        long l2 = n ^ 0x20B18E59D872L;
        if (string == null) {
            BundlerUtil.a(21);
        }
        String string2 = RubyGemExecutionContext.getScriptPath(sdk, module2, BUNDLER, string);
        if (sdk == null && module2 != null) {
            sdk = RModuleUtil.getInstance().findRubySdkForModule(module2);
        }
        return sdk == null || string2 == null ? string2 : RubySdkUtil.getDefaultPathMappings(sdk, module2).convertToRemote(string2);
    }

    @Nullable
    private static String a(@Nullable Sdk sdk, @Nullable Module module2) {
        long l2 = n ^ 0x7E23A3DDA124L;
        Sdk sdk2 = RubySdkUtil.getEffectiveSdk(sdk, module2);
        if (sdk2 == null) {
            a.warn("No bundler script name detected for " + sdk + "; " + module2);
            return null;
        }
        if (!RubySdkSystemAccessor.notNullFrom(sdk2).isWindows()) {
            return BUNDLE;
        }
        return RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk2).isLessThan(LanguageLevel.RUBY26) ? j : g;
    }

    private static void a(@Nullable Sdk sdk, @Nullable Module module2, @NotNull GeneralCommandLine generalCommandLine, @NotNull String string, boolean bl2, boolean bl3) {
        Object object;
        String string2;
        String string3;
        Object object2;
        RubySdkSystemAccessor rubySdkSystemAccessor;
        RubySdkAdditionalData rubySdkAdditionalData;
        VirtualFile virtualFile;
        Map map2;
        long l2 = n ^ 0x2B437884B3A7L;
        if (generalCommandLine == null) {
            BundlerUtil.a(22);
        }
        if (string == null) {
            BundlerUtil.a(23);
        }
        if ((map2 = generalCommandLine.getEnvironment()).isEmpty()) {
            return;
        }
        GemInfo gemInfo = BundlerUtil.getBundlerGem(sdk, bl3 ? null : module2, true);
        VirtualFile virtualFile2 = gemInfo != null ? gemInfo.getLibFolder() : null;
        VirtualFile virtualFile3 = virtualFile = gemInfo != null ? gemInfo.getFile() : null;
        assert (virtualFile != null && virtualFile.isValid()) : "[ Bundler: " + gemInfo + "; File: " + virtualFile + "; Lib: " + virtualFile2 + "; ]";
        RubyRunner rubyRunner = BundlerUtil.a(sdk, module2, generalCommandLine);
        if (sdk != null) {
            rubySdkAdditionalData = RubySdkUtil.getRubySdkAdditionalData(sdk);
            rubySdkSystemAccessor = rubySdkAdditionalData.getSdkSystemAccessor();
        } else {
            rubySdkSystemAccessor = LocalRubySdkSystemAccessor.getInstance();
        }
        rubySdkAdditionalData = rubyRunner.addDefaultMappings(null);
        map2.put("BUNDLE_BIN_PATH", rubySdkAdditionalData.convertToRemote(virtualFile.getPath() + "/bin"));
        VirtualFile virtualFile4 = BundlerUtil.getBundlerGemsDirFromConfig(module2);
        if (virtualFile4 == null) {
            virtualFile4 = BundlerUtil.getDefaultBundleDir(sdk);
        }
        if (virtualFile4 != null) {
            object2 = FileUtil.toSystemDependentName((String)virtualFile4.getPath()) + File.separator + "bin";
            string3 = OSUtil.getPathEnvVariableName();
            string2 = OSUtil.prependToPathEnvVariable((String)map2.get(string3), (String)object2);
            map2.put(string3, string2);
        }
        object2 = BundlerUtil.getGemfile(module2);
        assert (object2 != null);
        map2.put("BUNDLE_GEMFILE", rubySdkAdditionalData.convertToRemote(object2.getPath()));
        string3 = (String)map2.get("RUBYLIB");
        if (virtualFile2 != null) {
            string3 = OSUtil.prependToRUBYLIBEnvVariable(rubySdkSystemAccessor, string3, rubySdkAdditionalData.convertToRemote(virtualFile2.getPath()));
            map2.put("RUBYLIB", string3);
        }
        string2 = "";
        if (RubyAbstractCommandLineState.isInRubyDebugMode(string) && !RubyMotionUtil.getInstance().isRubyMotionModule(module2) && sdk != null) {
            try {
                object = RubyAbstractCommandLineState.selectDebugGemHelper(sdk, module2, RubyDebugMode.NORMAL_MODE);
                if (object.needsDebugPreLoader()) {
                    String string4 = RubyUtil.getScriptFullPath("rb/gems");
                    assert (string4 != null);
                    string3 = OSUtil.prependToRUBYLIBEnvVariable(rubySdkSystemAccessor, string3, rubySdkAdditionalData.convertToRemote(string4));
                    map2.put("RUBYLIB", string3);
                    string2 = string2 + "-rdebug_preloader.rb ";
                }
            }
            catch (ExecutionException executionException) {
                a.error((Throwable)executionException);
            }
        }
        string2 = string2 + RBUNDLER_SETUP;
        if (bl2) {
            string2 = string2 + " -rtest/unit/ui/teamcity/loadpath_patch.rb";
        }
        if (!StringUtil.isEmpty((String)(object = (String)map2.get("RUBYOPT")))) {
            string2 = string2 + " " + (String)object;
        }
        map2.put("RUBYOPT", string2);
    }

    public static void addBundlerEnvironment(@NotNull Map<String, String> env, @NotNull Sdk sdk, @Nullable Module module2, @Nullable VirtualFile gemFile) {
        long l2 = n ^ 0x5D0C263782B8L;
        if (env == null) {
            BundlerUtil.a(24);
        }
        if (sdk == null) {
            BundlerUtil.a(25);
        }
        if (gemFile == null) {
            return;
        }
        RubyRunner rubyRunner = RunnerUtil.getRunner(sdk, module2);
        env.put("BUNDLE_GEMFILE", rubyRunner.addDefaultMappings(null).convertToRemote(gemFile.getPath()));
    }

    @NotNull
    private static RubyRunner a(Sdk sdk, Module module2, GeneralCommandLine generalCommandLine) {
        if (generalCommandLine instanceof RubyCommandLine) {
            RubyRunner rubyRunner = ((RubyCommandLine)generalCommandLine).getRunner();
            if (rubyRunner == null) {
                BundlerUtil.a(26);
            }
            return rubyRunner;
        }
        if (sdk != null) {
            RubySdkAdditionalData rubySdkAdditionalData = RubySdkUtil.getRubySdkAdditionalData(sdk);
            RubyRunner rubyRunner = rubySdkAdditionalData.getRunner(module2);
            if (rubyRunner == null) {
                BundlerUtil.a(27);
            }
            return rubyRunner;
        }
        RubyLocalRunner rubyLocalRunner = RubyLocalRunner.getRunner(module2);
        if (rubyLocalRunner == null) {
            BundlerUtil.a(28);
        }
        return rubyLocalRunner;
    }

    @NotNull
    public static List<String> getIgnoredGroupsFromConfig(Module module2) {
        BundleConfig bundleConfig = BundleConfigServiceImpl.getInstance().getConfig(module2);
        List<String> list2 = BundlerUtil.a(bundleConfig);
        List<String> list3 = list2.isEmpty() ? BundlerUtil.a(BundleConfigServiceImpl.getInstance().getUserConfig(module2)) : list2;
        if (list3 == null) {
            BundlerUtil.a(29);
        }
        return list3;
    }

    @NotNull
    private static List<String> a(@Nullable BundleConfig bundleConfig) {
        List list2 = (List)ObjectUtils.notNull((Object)ObjectUtils.doIfNotNull((Object)bundleConfig, BundleConfig::getBundleWithout), Collections.emptyList());
        if (list2 == null) {
            BundlerUtil.a(30);
        }
        return list2;
    }

    @Nullable
    public static String addRVMBundleUrl(@NotNull Sdk sdk) {
        String string;
        long l2 = n ^ 0x37491B09C6E4L;
        if (sdk == null) {
            BundlerUtil.a(31);
        }
        if ((string = RVMSupportUtil.determineMainGemRootPath(sdk)) == null) {
            return null;
        }
        return VirtualFileUtil.constructLocalUrl(string) + d;
    }

    public static boolean isFakeRVMBundlerGemRootUrl(@NotNull String gemsRootUrl) {
        long l2 = n ^ 0x27EF45A8FAEFL;
        if (gemsRootUrl == null) {
            BundlerUtil.a(32);
        }
        return gemsRootUrl.endsWith(d);
    }

    @Nullable
    public static VirtualFile getDefaultBundleDir(@Nullable Sdk sdk) {
        long l2 = n ^ 0x83ABFEFEB7AL;
        String string = SystemProperties.getUserHome() + e;
        VirtualFile virtualFile = BundlerUtil.a(sdk, string + BUNDLER_FOLDER);
        if (virtualFile == null) {
            virtualFile = BundlerUtil.a(sdk, string + BUNDLE_FOLDER);
        }
        return virtualFile;
    }

    @Nullable
    private static VirtualFile a(@Nullable Sdk sdk, @NotNull String string) {
        if (string == null) {
            BundlerUtil.a(33);
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(e).append(BundlerUtil.getSdkTypeStr(sdk));
        stringBuilder.append(e).append(BundlerUtil.getGemSdkVersion(sdk));
        return VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)stringBuilder.toString()));
    }

    public static boolean isNewBundler(GemInfo gem) {
        long l2 = n ^ 0x7D37BE59CA64L;
        return gem != null && !"bundler08".equals(gem.getName()) && VersionComparatorUtil.compare((String)gem.getVersion(), (String)"0.9") >= 0;
    }

    public static boolean isBundlerRuntimeEmulationEnabled(@NotNull Module module2) {
        GemInfo gemInfo;
        long l2 = n ^ 0x778ECA0EC5B8L;
        if (module2 == null) {
            BundlerUtil.a(34);
        }
        return (gemInfo = GemSearchUtil.findGem(module2, BUNDLER)) != null && gemInfo.isValid() && BundlerUtil.hasGemfile(module2) && BundlerUtil.getGemfileLock(module2) != null;
    }

    public static void enableBundleEmulationIfNeeded(@Nullable Module module2, @NotNull AbstractRubyRunConfiguration<? extends AbstractRubyRunConfiguration> conf) {
        if (conf == null) {
            BundlerUtil.a(35);
        }
        if (module2 != null && BundlerUtil.isBundlerRuntimeEmulationEnabled(module2)) {
            BundleExecSettings.putTo(conf, BundleExecSettings.createSettings(true));
        }
    }

    @Nullable
    private static VirtualFile a() {
        String string = RMInspectionToolLaunchSettings.getInstance().getGemFilePath();
        return LocalFileSystem.getInstance().findFileByPath(string);
    }

    public static boolean isGemMentioned(@NotNull RFile environmentConfigFile, @NotNull Sdk sdk, @NotNull String gemName) {
        if (environmentConfigFile == null) {
            BundlerUtil.a(36);
        }
        if (sdk == null) {
            BundlerUtil.a(37);
        }
        if (gemName == null) {
            BundlerUtil.a(38);
        }
        GemDetector gemDetector = GemRequirementsChangeWatcher.getDetector(environmentConfigFile);
        assert (gemDetector != null);
        Set<GemDependency> set = gemDetector.detect(environmentConfigFile.getProject(), sdk, environmentConfigFile.getVirtualFile());
        for (GemDependency gemDependency : set) {
            if (!gemDependency.getName().equals(gemName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Set<GemEnvironment> getGemEnvironments(Module module2) {
        long l2 = n ^ 0x6AB21579E78AL;
        HashSet<GemEnvironment> hashSet = new HashSet<GemEnvironment>();
        RFile rFile = BundlerUtil.getGemfilePsiFile(module2);
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)rFile, RCall.class);
        if (!collection.isEmpty()) {
            for (RCall rCall : collection) {
                PsiElement psiElement;
                RPsiElement rPsiElement;
                String string = rCall.getCommand();
                if (!h.equals(string) || (rPsiElement = rCall.getArguments().get(0)) == null) continue;
                String string2 = rPsiElement.getName();
                ArrayList<String> arrayList = new ArrayList<String>();
                if (string2 != null && (psiElement = rCall.getParent()) instanceof RDoBlockCall) {
                    RPsiElement rPsiElement2 = ((RDoBlockCall)psiElement).getLoopBody();
                    Collection collection2 = PsiTreeUtil.findChildrenOfType((PsiElement)rPsiElement2, RCall.class);
                    for (RCall rCall2 : collection2) {
                        List<RPsiElement> list2;
                        RPsiElement rPsiElement3;
                        String string3;
                        if (!GemCallTypeProvider.GEM_CALL.equals(rCall2.getCallType()) || (string3 = (rPsiElement3 = (list2 = rCall2.getArguments()).get(0)) instanceof RStringLiteral ? ((RStringLiteral)rPsiElement3).getContent() : rPsiElement3.getName()) == null) continue;
                        arrayList.add(string3);
                    }
                }
                hashSet.add(new GemEnvironment(string2, arrayList));
            }
        }
        HashSet<GemEnvironment> hashSet2 = hashSet;
        if (hashSet2 == null) {
            BundlerUtil.a(39);
        }
        return hashSet2;
    }

    public static boolean isBundlerDir(@Nullable VirtualFile dir) {
        long l2 = n ^ 0x42AC23DA0EFL;
        return dir != null && dir.isDirectory() && (BUNDLE_FOLDER.equals(dir.getName()) || BUNDLER_FOLDER.equals(dir.getName()));
    }

    @NotNull
    public static CmdlinePreprocessor getBundlerPreprocessor(@Nullable Sdk sdk, @Nullable Module module2) {
        long l2 = n ^ 0x334E6A662398L;
        CmdlinePreprocessor cmdlinePreprocessor = BundlerUtil.getBundlerPreprocessor(sdk, module2, "RubyProgramRunner", false, false);
        if (cmdlinePreprocessor == null) {
            BundlerUtil.a(40);
        }
        return cmdlinePreprocessor;
    }

    private static boolean b(@Nullable Sdk sdk, @Nullable Module module2) {
        RubySdkSystemAccessor rubySdkSystemAccessor = RubySdkSystemAccessor.from(RubySdkUtil.getEffectiveSdk(sdk, module2));
        return rubySdkSystemAccessor != null ? rubySdkSystemAccessor.isWindows() : SystemInfo.isWindows;
    }

    @NotNull
    public static CmdlinePreprocessor getBundlerPreprocessor(final @Nullable Sdk sdk, final @Nullable Module module2, final @NotNull String runnerId, final boolean patchForTests, final boolean useAlternativeSdk) {
        if (runnerId == null) {
            BundlerUtil.a(41);
        }
        CmdlinePreprocessor cmdlinePreprocessor = new CmdlinePreprocessor(){
            private static final long a = com.jetbrains.python.psi.c.a(-6030217629968706094L, -6480104952139214302L, MethodHandles.lookup().lookupClass()).a(73142945467089L);

            @Override
            public void preprocess(@NotNull GeneralCommandLine cmdline) {
                long l2 = a ^ 0x5C05179D24D6L;
                if (cmdline == null) {
                    1.a(0);
                }
                if (module2 == null || !BundlerUtil.isBundlerRuntimeEmulationEnabled(module2)) {
                    return;
                }
                if (Experiments.isFeatureEnabled((String)"ruby.force.explicit.bundle.exec")) {
                    String string;
                    String string2 = cmdline.getExePath();
                    Path path = ShimsBasedVersionManagerHandler.shimsPathFor(sdk, module2);
                    if (path != null) {
                        cmdline.withExePath(path.resolve(BundlerUtil.BUNDLE).toString());
                    } else {
                        string = BundlerUtil.getBundlerExecutableScriptPath(sdk, module2);
                        if (string == null) {
                            a.warn("Could not find bundler executable for the " + sdk + "; " + module2);
                            return;
                        }
                        cmdline.withExePath(string);
                    }
                    string = cmdline.getParametersList();
                    string.addAt(0, "exec");
                    string.addAt(1, string2);
                } else {
                    ReadAction.run(() -> {
                        BundlerUtil.a(sdk, module2, cmdline, runnerId, patchForTests, useAlternativeSdk);
                        if (RbenvGemsetManager.isRbenvSdk(sdk) && !RubyRemoteInterpreterManager.getInstance().isRemoteSdk(sdk)) {
                            BundlerUtil.patchBundleExecCommandLine(sdk, module2, cmdline);
                        }
                    });
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x60E24A3DF775L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmdline", "org/jetbrains/plugins/ruby/gem/util/BundlerUtil$1", "preprocess"));
            }
        };
        if (cmdlinePreprocessor == null) {
            BundlerUtil.a(42);
        }
        return cmdlinePreprocessor;
    }

    public static void processGemFilesOnEdt(@NotNull Project project, @NotNull Consumer<Collection<VirtualFile>> processor2) {
        if (project == null) {
            BundlerUtil.a(43);
        }
        if (processor2 == null) {
            BundlerUtil.a(44);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ReadAction.nonBlocking(() -> {
            long l2 = n ^ 0x7FE6654C964AL;
            Collection collection = FilenameIndex.getVirtualFilesByName((Project)project, (String)m, (boolean)true, (GlobalSearchScope)ProjectScope.getContentScope((Project)project));
            collection.addAll(FilenameIndex.getVirtualFilesByName((Project)project, (String)f, (boolean)true, (GlobalSearchScope)ProjectScope.getContentScope((Project)project)));
            return collection;
        }).expireWith((Disposable)project).finishOnUiThread(ModalityState.current(), processor2).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    public static void waitForPromises() {
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
    }

    @Nullable
    public static String getLockFilePath(@NotNull Module module2) {
        VirtualFile virtualFile;
        if (module2 == null) {
            BundlerUtil.a(45);
        }
        if ((virtualFile = BundlerUtil.getGemfileLock(module2)) != null) {
            return virtualFile.getPath();
        }
        VirtualFile virtualFile2 = BundlerUtil.getGemfile(module2);
        if (virtualFile2 != null) {
            return new File(virtualFile2.getParent().getPath(), BundlerUtil.a(virtualFile2)).getAbsolutePath();
        }
        return null;
    }

    static {
        n = com.jetbrains.python.psi.c.a(4375308245300153585L, 1951068822706135433L, MethodHandles.lookup().lookupClass()).a(201033346098024L);
        long l2 = n ^ 0x395980ADB350L;
        i = new String[]{m, f};
        a = Logger.getInstance(BundlerUtil.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = n ^ 0x5E18F85F6817L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 39: 
            case 40: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 39: 
            case 40: 
            case 42: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemfile";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 39: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/util/BundlerUtil";
                break;
            }
            case 19: 
            case 25: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundlerScriptName";
                break;
            }
            case 23: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsRootUrl";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundlePath";
                break;
            }
            case 34: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentConfigFile";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/util/BundlerUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLockFileName";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemSdkVersion";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkTypeStr";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunner";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredGroupsFromConfig";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetGroups";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemEnvironments";
                break;
            }
            case 40: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundlerPreprocessor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "openGemFileInEditor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addBinIfExists";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getGemfile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLockFileName";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 39: 
            case 40: 
            case 42: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isGemfile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "patchBundleExecCommandLine";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getBundlerScriptPath";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addBundlerEnvironment";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addRVMBundleUrl";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isFakeRVMBundlerGemRootUrl";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findGemFolderForSdk";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isBundlerRuntimeEmulationEnabled";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "enableBundleEmulationIfNeeded";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isGemMentioned";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getBundlerPreprocessor";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processGemFilesOnEdt";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getLockFilePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 39: 
            case 40: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

