/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemCallTypeProvider;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.GemReference;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGemInfrastructure;
import org.jetbrains.plugins.ruby.gem.inspection.quickfixes.InstallGemQuickFix;
import org.jetbrains.plugins.ruby.gem.inspection.quickfixes.RemoveRequirementQuickFix;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RModifierStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurator;

public class GemReferenceVisitor
extends RubyInspectionVisitor {
    private boolean b;
    private boolean c = false;
    private static final long d = com.jetbrains.python.psi.c.a(-6967293321462966817L, -5690346355877490010L, MethodHandles.lookup().lookupClass()).a(86997297424812L);

    public GemReferenceVisitor(ProblemsHolder holder) {
        super(holder);
    }

    @Override
    protected void registerProblem(PsiElement element, String message) {
        super.registerProblem(element, message, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[0]);
    }

    @Override
    public void visitRCall(RCall rCall) {
        this.inspectElement(this, (PsiElement)rCall, false);
    }

    @Override
    public void visitRDStringLiteral(@NotNull RStringLiteral rDStringLiteral) {
        if (rDStringLiteral == null) {
            GemReferenceVisitor.d(0);
        }
        this.inspectElement(this, (PsiElement)rDStringLiteral, rDStringLiteral.hasExpressionSubstitutions());
    }

    @Override
    public void visitRConstant(RConstant constant) {
        GemDependency gemDependency;
        long l2 = d ^ 0x2E171972B907L;
        ProgressManager.checkCanceled();
        if (!"RAILS_GEM_VERSION".equals(constant.getText())) {
            return;
        }
        RAssignmentExpression rAssignmentExpression = RAssignmentExpressionNavigator.getAssignmentByLeftPart((PsiElement)constant);
        if (rAssignmentExpression == null) {
            return;
        }
        RPsiElement rPsiElement = rAssignmentExpression.getValue();
        String string = rPsiElement instanceof RStringLiteral ? TextUtil.removeQuoting(rPsiElement.getText()) : null;
        GemDependency gemDependency2 = gemDependency = string != null ? GemDependency.create("rails", string) : null;
        if (gemDependency == null) {
            return;
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)constant);
        if (module2 != null && RailsFacetUtil.hasRailsSupport(module2) && GemSearchUtil.findGem(GemManager.getAllGems(module2), gemDependency) == null) {
            GemReferenceVisitor.createWarning(this, (PsiElement)rAssignmentExpression, "rails", gemDependency);
        }
    }

    public void inspectElement(RubyInspectionVisitor visitor2, PsiElement psiElement, boolean isDynamicallyGeneratedValue) {
        GemDependency gemDependency;
        GemReference gemReference = GemReferenceVisitor.findGemReference(psiElement);
        if (gemReference == null || isDynamicallyGeneratedValue || gemReference.hasDynamicSubstitutions() || ModuleUtilCore.findModuleForPsiElement((PsiElement)gemReference.getElement()) == null) {
            return;
        }
        this.a(psiElement);
        PsiElement psiElement2 = gemReference.resolve();
        GemDependency gemDependency2 = gemDependency = psiElement2 == null ? gemReference.getDependency(this.b) : null;
        if (gemDependency != null) {
            String string = gemReference.getGemName();
            GemReferenceVisitor.createWarning(visitor2, psiElement, string, gemDependency);
        }
    }

    protected static void createWarning(RubyInspectionVisitor visitor2, PsiElement psiElement, String gemName, GemDependency requirement) {
        Sdk sdk;
        long l2 = d ^ 0x929CE110783L;
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        VirtualFile virtualFile = BundlerUtil.getGemfile(module2);
        if (virtualFile != null && !virtualFile.equals(PsiUtilCore.getVirtualFile((PsiElement)psiElement))) {
            return;
        }
        Sdk sdk2 = sdk = module2 != null ? RModuleUtil.getInstance().findRubySdkForModule(module2) : null;
        if (!requirement.canBeSatisfied()) {
            visitor2.registerProblem(psiElement, StringUtil.capitalize((String)RBundle.message("gems.inspection.requirement.not.satisfiable", gemName)), new RemoveRequirementQuickFix());
            return;
        }
        if (sdk != null) {
            if (!requirement.isSupportedBySdk(sdk)) {
                if (psiElement.getParent() instanceof RModifierStatement || requirement.getPlatforms() != null) {
                    return;
                }
                visitor2.registerProblem(psiElement, StringUtil.capitalize((String)RBundle.message("gems.inspection.gem.not.supported.by.sdk", gemName, sdk.getName())), new LocalQuickFix[0]);
                return;
            }
            GemInfo gemInfo = GemSearchUtil.findGem(module2, sdk, requirement);
            if (gemInfo != null) {
                return;
            }
            GemInfo gemInfo2 = GemSearchUtil.findGem(module2, sdk, gemName);
            String string = gemInfo2 == null ? RBundle.message("gems.inspection.gem.not.available", gemName, sdk.getName()) : RBundle.message("gems.inspection.gem.with.requirements.not.available", gemName, sdk.getName());
            ArrayList<LocalQuickFix> arrayList = new ArrayList<LocalQuickFix>();
            if (virtualFile != null) {
                arrayList.addAll(RubySdkConfigurator.from(sdk.getSdkAdditionalData()).getBundleInstallQuickFixes(sdk, module2));
            }
            boolean bl2 = requirement.isFromPath() | requirement.isGit();
            if (virtualFile == null && !bl2) {
                arrayList.add(new InstallGemQuickFix(sdk, module2, requirement));
            }
            if (!arrayList.isEmpty()) {
                visitor2.registerProblem(psiElement, StringUtil.capitalize((String)string), arrayList.toArray(LocalQuickFix.EMPTY_ARRAY));
            } else {
                visitor2.registerProblem(psiElement, StringUtil.capitalize((String)RBundle.message("gems.inspection.git.dependency.not.allowed")), new LocalQuickFix[0]);
            }
        } else {
            visitor2.registerProblem(psiElement, StringUtil.capitalize((String)RBundle.message("gems.inspection.gem.no.sdk", gemName)), new LocalQuickFix[0]);
        }
    }

    @Nullable
    public static GemReference findGemReference(PsiElement psiElement) {
        PsiReference[] psiReferenceArray;
        ProgressManager.checkCanceled();
        RCall rCall = RubyPsiUtil.getCoveringRCall(psiElement);
        if (rCall == null || rCall.getCallType() != GemCallTypeProvider.GEM_CALL) {
            return null;
        }
        for (PsiReference psiReference : psiReferenceArray = psiElement.getReferences()) {
            if (!(psiReference instanceof GemReference)) continue;
            return (GemReference)psiReference;
        }
        return null;
    }

    private void a(PsiElement psiElement) {
        if (this.c) {
            return;
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        VirtualFile virtualFile = BundlerUtil.getGemfile(module2);
        if (virtualFile != null && virtualFile.equals(psiElement.getContainingFile().getVirtualFile())) {
            Boolean bl2 = module2 != null ? Boolean.valueOf(BundlerGemInfrastructure.hasMissingGems(virtualFile)) : null;
            this.b = bl2 != null && bl2 != false;
        }
        this.c = true;
    }

    private static /* synthetic */ void d(int n2) {
        long l2 = d ^ 0x6D4E3BC4A421L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rDStringLiteral", "org/jetbrains/plugins/ruby/gem/inspection/GemReferenceVisitor", "visitRDStringLiteral"));
    }
}

