/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.detector;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.GemSpecParser;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.GemsDataKeys;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGitLockReader;
import org.jetbrains.plugins.ruby.gem.detector.GemDetector;
import org.jetbrains.plugins.ruby.gem.detector.ImplicitRequireGemProvider;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.AbstractRubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RFileUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class RubyGemDetector
implements GemDetector {
    private static final Logger c;
    @NonNls
    private static final String a = "gem";
    @NonNls
    private static final String j = "gemspec";
    @NonNls
    private static final String e = "path";
    @NonNls
    private static final String g = "group";
    @NonNls
    private static final String b = "run";
    @NonNls
    private static final String h = "env";
    @NonNls
    private static final String d = "platform";
    @NonNls
    private static final String f = "platforms";
    private static final Set<String> i;
    private static final long k;

    @Override
    @NotNull
    public Set<GemDependency> detect(@NotNull Project project, @Nullable Sdk sdk, @Nullable VirtualFile file) {
        if (project == null) {
            RubyGemDetector.a(0);
        }
        if (file == null || !(file.getFileType() instanceof AbstractRubyFileType)) {
            Set<GemDependency> set = Collections.emptySet();
            if (set == null) {
                RubyGemDetector.a(1);
            }
            return set;
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        RubyPsiInterpreter rubyPsiInterpreter = new RubyPsiInterpreter(true);
        ApplicationManager.getApplication().runReadAction(() -> {
            long l2 = k ^ 0x7EECAB391F4CL;
            if (project.isDisposed() || !file.isValid()) {
                return;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile == null) {
                return;
            }
            List<String> list2 = RubyGemDetector.a(psiFile);
            rubyPsiInterpreter.interpret((PsiElement)psiFile, new DetectorCallable(linkedHashMap, sdk, list2));
            for (ImplicitRequireGemProvider implicitRequireGemProvider : ImplicitRequireGemProvider.EP_NAME.getExtensionList()) {
                linkedHashMap.putAll(implicitRequireGemProvider.getImplicitDependency((RFile)psiFile));
            }
            if (!linkedHashMap.containsKey("bundler") && BundlerUtil.isGemfile(project, file)) {
                linkedHashMap.put("bundler", GemDependency.any("bundler"));
            }
        });
        HashSet<GemDependency> hashSet = new HashSet<GemDependency>(linkedHashMap.values());
        if (hashSet == null) {
            RubyGemDetector.a(2);
        }
        return hashSet;
    }

    @NotNull
    private static List<String> a(PsiFile psiFile) {
        Module module2;
        List<String> list2 = BundlerUtil.isGemfile((PsiFileSystemItem)psiFile) ? ((module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile)) != null ? BundlerUtil.getIgnoredGroupsFromConfig(module2) : Collections.emptyList()) : Collections.emptyList();
        List<String> list3 = list2;
        if (list3 == null) {
            RubyGemDetector.a(3);
        }
        return list3;
    }

    @Nullable
    private static GemDependency a(String string, List<? extends RPsiElement> list2, List<String> list3, List<String> list4, String string2, boolean bl2, @NotNull List<String> list5) {
        Module module2;
        if (list5 == null) {
            RubyGemDetector.a(4);
        }
        if ((module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)list2.get(0)))) == null || RubyGemDetector.a(list4, list5)) {
            return null;
        }
        BundlerGitLockReader bundlerGitLockReader = BundlerGitLockReader.getInstance(module2);
        GemDependency gemDependency = bundlerGitLockReader.getDependency(string);
        if (bundlerGitLockReader.isLocked() && BundlerUtil.isGemfile((PsiFileSystemItem)list2.get(0).getContainingFile()) && (!bl2 || gemDependency != null)) {
            return gemDependency;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i10 = 1; i10 < list2.size(); ++i10) {
            RPsiElement rPsiElement = list2.get(i10);
            if (!(rPsiElement instanceof RStringLiteral)) continue;
            arrayList.add(TextUtil.removeQuoting(rPsiElement.getText()));
        }
        return GemDependency.create(string, RubyGemDetector.a(arrayList), string2, null, false, null, true, string2 != null, RubyGemDetector.a(list3));
    }

    private static boolean a(List<String> list2, List<String> list3) {
        if (list2 == null) {
            return false;
        }
        return list3.containsAll(list2);
    }

    @Nullable
    private static GemDependency a(List<? extends RPsiElement> list2, int n2, String string, List<String> list3, List<String> list4, String string2, boolean bl2, @NotNull List<String> list5) {
        Module module2;
        long l2 = k ^ 0x5CE659472DEL;
        if (list5 == null) {
            RubyGemDetector.a(5);
        }
        if ((module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)list2.get(0)))) == null) {
            return null;
        }
        BundlerGitLockReader bundlerGitLockReader = BundlerGitLockReader.getInstance(module2);
        GemDependency gemDependency = bundlerGitLockReader.getDependency(string);
        if (!bl2 && bundlerGitLockReader.isLocked() && gemDependency == null && BundlerUtil.isGemfile((PsiFileSystemItem)list2.get(0).getContainingFile())) {
            return null;
        }
        String string3 = gemDependency != null ? gemDependency.getVersionString() : null;
        String string4 = null;
        Object object = null;
        boolean bl3 = gemDependency != null && gemDependency.isGit();
        boolean bl4 = false;
        boolean bl5 = true;
        String string5 = gemDependency != null ? gemDependency.getRef() : null;
        for (int i10 = 1; i10 < n2; ++i10) {
            Object object2;
            String string6;
            RPsiElement rPsiElement = list2.get(i10);
            if (!(rPsiElement instanceof RAssoc)) continue;
            RAssoc rAssoc = (RAssoc)rPsiElement;
            RPsiElement rPsiElement2 = rAssoc.getKey();
            RPsiElement rPsiElement3 = rAssoc.getValue();
            if (rPsiElement2 == null || rPsiElement3 == null) continue;
            String string7 = string6 = rPsiElement2 instanceof RSymbol ? ((RSymbol)rPsiElement2).getValue() : rPsiElement2.getText();
            if ("version".equals(string6)) {
                string3 = gemDependency != null ? gemDependency.getVersionString() : rPsiElement3.getText();
                continue;
            }
            if ("source".equals(string6)) {
                string4 = rPsiElement3.getText();
                continue;
            }
            if (e.equals(string6)) {
                object2 = rAssoc.getContainingFile();
                VirtualFile virtualFile = object2.getVirtualFile();
                String string8 = TextUtil.trimTrailingSlashes(RFileUtil.evaluateRequirement(virtualFile, (PsiElement)rPsiElement3));
                if (string8.isEmpty()) {
                    string8 = string2;
                }
                string4 = string8.isEmpty() && gemDependency != null ? gemDependency.getUrl() : GemUtil.getGemUrlFromPath(string8, virtualFile.getParent());
                bl4 = true;
                continue;
            }
            if ("lib".equals(string6) || "require".equals(string6) || "require_as".equals(string6)) {
                object2 = rPsiElement3.getText();
                if ("false".equals(object2)) {
                    bl5 = false;
                    continue;
                }
                if ("true".equals(object2)) continue;
                object = object2;
                continue;
            }
            if ("git".equals(string6) || "github".equals(string6)) {
                bl3 = true;
                continue;
            }
            if ("ref".equals(string6) || "branch".equals(string6) || "tag".equals(string6)) {
                if (string5 != null) continue;
                string5 = rPsiElement3.getText();
                continue;
            }
            if (d.equals(string6) || f.equals(string6)) {
                list3 = RubyGemDetector.a(rPsiElement3);
                continue;
            }
            if (!g.equals(string6) && !"groups".equals(string6)) continue;
            list4 = RubyGemDetector.a(rPsiElement3);
        }
        if (RubyGemDetector.a(list4, list5)) {
            return null;
        }
        if (string3 == null) {
            return GemDependency.any(string, TextUtil.removeQuoting(string4), TextUtil.removeQuoting(object), bl3, TextUtil.removeQuoting(string5), bl5, bl4, RubyGemDetector.a(list3));
        }
        return GemDependency.create(string, new String[]{TextUtil.removeQuoting(string3)}, TextUtil.removeQuoting(string4), TextUtil.removeQuoting(object), bl3, TextUtil.removeQuoting(string5), bl5, bl4, RubyGemDetector.a(list3));
    }

    private static List<String> a(RPsiElement rPsiElement) {
        if (rPsiElement instanceof RArray) {
            return ContainerUtil.mapNotNull(((RArray)rPsiElement).getElements(), RubyPsiUtil::getElementText);
        }
        return ContainerUtil.createMaybeSingletonList((Object)RubyPsiUtil.getElementText((PsiElement)rPsiElement));
    }

    @Nullable
    public static GemDependency buildRequirement(@NotNull RPossibleCall possibleCall, boolean canIgnoreLocker, @Nullable List<String> ignoredGroups) {
        List<RPsiElement> list2;
        if (possibleCall == null) {
            RubyGemDetector.a(6);
        }
        if ((list2 = possibleCall.getArguments()).isEmpty()) {
            return null;
        }
        String string = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)list2.get(0));
        if (StringUtil.isEmpty((String)string) || !GemUtil.NAME_PATTERN.matcher(string).matches()) {
            return null;
        }
        if (ignoredGroups == null) {
            PsiFile psiFile = possibleCall.getContainingFile();
            ignoredGroups = RubyGemDetector.a(psiFile);
        }
        boolean bl2 = false;
        for (RPsiElement object2 : list2) {
            bl2 |= object2 instanceof RAssoc;
        }
        List<String> list3 = RubyGemDetector.b(possibleCall);
        List<String> list4 = RubyGemDetector.a(possibleCall);
        String string2 = RubyGemDetector.c(possibleCall);
        if (bl2) {
            return RubyGemDetector.a(list2, list2.size(), string, list3, list4, string2 != null ? string2 : "", canIgnoreLocker, ignoredGroups);
        }
        return RubyGemDetector.a(string, list2, list3, list4, string2, canIgnoreLocker, ignoredGroups);
    }

    @Nullable
    private static List<String> a(RPossibleCall rPossibleCall, String string, String string2) {
        RBlockCall rBlockCall = RBlockCallNavigator.getByCall(rPossibleCall);
        while (rBlockCall != null) {
            RCall rCall;
            if (rPossibleCall instanceof RCall && (string.equals((rCall = (RCall)rPossibleCall).getCommand()) || string2.equals(rCall.getCommand()))) {
                return ContainerUtil.mapNotNull(rCall.getArguments(), RubyPsiUtil::getElementText);
            }
            rBlockCall = (RBlockCall)PsiTreeUtil.getParentOfType((PsiElement)rBlockCall, RBlockCall.class, (boolean)true);
        }
        return null;
    }

    @Nullable
    private static List<String> b(RPossibleCall rPossibleCall) {
        long l2 = k ^ 0x2FB918633820L;
        return RubyGemDetector.a(rPossibleCall, d, f);
    }

    @Nullable
    private static List<String> a(RPossibleCall rPossibleCall) {
        long l2 = k ^ 0x1877F43DCC7FL;
        return RubyGemDetector.a(rPossibleCall, g, g);
    }

    @Nullable
    private static String c(RPossibleCall rPossibleCall) {
        long l2 = k ^ 0x6839C92EB89AL;
        List<String> list2 = RubyGemDetector.a(rPossibleCall, e, e);
        return list2 != null && list2.size() == 1 ? list2.get(0) : null;
    }

    @Override
    public boolean accepts(@NotNull VirtualFile providerCandidate) {
        if (providerCandidate == null) {
            RubyGemDetector.a(7);
        }
        return providerCandidate.getFileType() instanceof AbstractRubyFileType;
    }

    @Contract(value="null -> null; !null -> !null")
    private static String[] a(@Nullable List<String> list3) {
        return (String[])ObjectUtils.doIfNotNull(list3, list2 -> ArrayUtilRt.toStringArray((Collection)list2));
    }

    static {
        k = com.jetbrains.python.psi.c.a(5508520688444761481L, -5046718751212094435L, MethodHandles.lookup().lookupClass()).a(193254540411823L);
        long l2 = k ^ 0x189E8F938815L;
        c = Logger.getInstance(RubyGemDetector.class);
        i = new HashSet<String>(Arrays.asList(g, b, h, d, f, e));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = k ^ 0x62E892C24083L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/detector/RubyGemDetector";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredGroups";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleCall";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerCandidate";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/detector/RubyGemDetector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredGroups";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildRequirement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildRailsRequirement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "accepts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class DetectorCallable
    implements PsiCallable {
        private final Map<String, GemDependency> b;
        private final Sdk c;
        private final List<String> a;
        private static final long d = com.jetbrains.python.psi.c.a(-189680624616885151L, -9062576595964932443L, MethodHandles.lookup().lookupClass()).a(81472857569522L);

        public DetectorCallable(Map<String, GemDependency> deps, @Nullable Sdk sdk, List<String> ignoredGroups) {
            this.b = deps;
            this.c = sdk;
            this.a = ignoredGroups;
        }

        @Override
        public void processCall(RCallArguments arguments) {
            long l2 = d ^ 0x7BDD805B2DA0L;
            String string = arguments.getCommand();
            if (arguments.hasBlock() && i.contains(string)) {
                arguments.interpretBlockWithGivenSelf(this, new PsiCallable[0]);
                return;
            }
            if (RubyGemDetector.a.equals(string)) {
                GemDependency gemDependency = null;
                PsiElement psiElement = arguments.getRCallElement();
                if (psiElement instanceof RPossibleCall) {
                    gemDependency = RubyGemDetector.buildRequirement((RPossibleCall)psiElement, false, this.a);
                }
                if (gemDependency == null) {
                    return;
                }
                if (!gemDependency.isSupportedBySdk(this.c)) {
                    return;
                }
                c.debug("Detected requirement : " + gemDependency);
                this.b.put(gemDependency.getName(), gemDependency);
            } else if (RubyGemDetector.j.equals(string)) {
                this.b(arguments);
            } else if ("require".equals(string)) {
                this.a(arguments);
            }
        }

        private void a(RCallArguments rCallArguments) {
            String string;
            long l2 = d ^ 0x2DDB18E0863DL;
            PsiElement psiElement = rCallArguments.getRCallElement();
            VirtualFile virtualFile = psiElement.getContainingFile().getVirtualFile();
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
            if (virtualFile == null || BundlerUtil.isGemfile(psiElement.getProject(), virtualFile) || module2 == null) {
                return;
            }
            String string2 = string = psiElement instanceof RCall ? RFileUtil.evaluateRequirePath(virtualFile, (RCall)psiElement) : null;
            if (string == null) {
                return;
            }
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module2);
            Collection<GemInfo> collection = GemManager.getInstance().getAllGems(sdk, module2);
            for (GemInfo gemInfo : collection) {
                VirtualFile virtualFile2 = gemInfo.getLibFolder();
                if (virtualFile2 == null || !virtualFile2.isValid()) continue;
                VirtualFile virtualFile3 = virtualFile2.findFileByRelativePath(string + RFileUtil.RB_FILE_SUFFIX);
                if (virtualFile3 != null && !virtualFile3.isDirectory()) {
                    this.b.put(gemInfo.getName(), GemDependency.any(gemInfo.getName()));
                    return;
                }
                virtualFile3 = virtualFile2.findFileByRelativePath(string);
                if (virtualFile3 != null && !virtualFile3.isDirectory()) {
                    this.b.put(gemInfo.getName(), GemDependency.any(gemInfo.getName()));
                    return;
                }
                virtualFile3 = virtualFile2.findFileByRelativePath(string + ".so");
                if (virtualFile3 == null || virtualFile3.isDirectory()) continue;
                this.b.put(gemInfo.getName(), GemDependency.any(gemInfo.getName()));
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        private void b(RCallArguments rCallArguments) {
            VirtualFile virtualFile;
            long l2 = d ^ 0x54F7C08A13EBL;
            PsiElement psiElement = rCallArguments.getCallElement();
            VirtualFile virtualFile2 = psiElement.getContainingFile().getVirtualFile();
            VirtualFile virtualFile3 = virtualFile = virtualFile2 != null ? virtualFile2.getParent() : null;
            if (virtualFile != null) {
                Object object;
                RPsiElement rPsiElement;
                RPsiElement rPsiElement2;
                Object object2;
                List<RPsiElement> list2 = rCallArguments.getArguments();
                String string = null;
                String string2 = null;
                if (list2.size() > 0) {
                    for (RPsiElement object32 : list2) {
                        if (!(object32 instanceof RAssoc)) continue;
                        object2 = (RAssoc)object32;
                        rPsiElement2 = object2.getKey();
                        rPsiElement = object2.getValue();
                        if (rPsiElement2 == null || rPsiElement == null) continue;
                        object = rPsiElement2.getText();
                        if (":name".equals(object)) {
                            string = rPsiElement.getText();
                            continue;
                        }
                        if (!":path".equals(object)) continue;
                        string2 = rPsiElement.getText();
                    }
                }
                Object object4 = virtualFile;
                if (string2 != null) {
                    void var11_13;
                    VirtualFile virtualFile4 = virtualFile.findFileByRelativePath(string2);
                    if (virtualFile4 == null) {
                        VirtualFile virtualFile5 = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl(string2));
                    }
                    if (var11_13 != null) {
                        object4 = var11_13;
                    }
                }
                VirtualFile virtualFile6 = string == null ? GemUtil.getSpecFile((VirtualFile)object4) : object4.findChild(string + ".gemspec");
                object2 = GemSpecParser.getInstance().getGemSpec(virtualFile, virtualFile6, true);
                rPsiElement2 = object2 != null ? (Set)GemsDataKeys.DEPENDENCIES.getData((DataContext)object2) : null;
                rPsiElement = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
                if (rPsiElement2 != null && rPsiElement != null) {
                    object = rPsiElement2.iterator();
                    while (object.hasNext()) {
                        GemDependency gemDependency = (GemDependency)object.next();
                        if (gemDependency == null || !gemDependency.isSupportedBySdk(this.c)) continue;
                        GemDependency gemDependency2 = BundlerGitLockReader.getInstance((Module)rPsiElement).getDependency(string);
                        gemDependency = gemDependency2 != null ? gemDependency2 : gemDependency;
                        c.debug("Detected requirement from gemspec: " + gemDependency);
                        this.b.put(gemDependency.getName(), gemDependency);
                    }
                }
            }
        }
    }
}

