/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.psi.c;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyScriptExecutionContext;
import org.jetbrains.plugins.ruby.ruby.run.context.RubySdkAwareExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.ShimsBasedVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public class RubyGemExecutionContext
extends RubySdkAwareExecutionContext<RubyGemExecutionContext> {
    private static final Logger v;
    private static final List<String> w;
    private static final String p = "#!";
    private static final String q = "/System/Library/Frameworks/Ruby.framework";
    private static final String s = "/usr/bin";
    private static final String u = "bin";
    @NotNull
    private final String t;
    @Nullable
    private String o;
    @Nullable
    private String r;
    private static final long x;

    public RubyGemExecutionContext(@NotNull RubyGemExecutionContext source) {
        if (source == null) {
            RubyGemExecutionContext.c(0);
        }
        super(source);
        this.t = source.t;
        this.o = source.o;
        this.r = source.r;
    }

    public RubyGemExecutionContext(@NotNull Module module2, @NotNull String gemName) {
        if (module2 == null) {
            RubyGemExecutionContext.c(1);
        }
        if (gemName == null) {
            RubyGemExecutionContext.c(2);
        }
        super(module2);
        this.t = RubyGemExecutionContext.a(gemName);
    }

    public RubyGemExecutionContext(@NotNull Sdk sdk, @NotNull String gemName) {
        if (sdk == null) {
            RubyGemExecutionContext.c(3);
        }
        if (gemName == null) {
            RubyGemExecutionContext.c(4);
        }
        super(sdk);
        this.t = RubyGemExecutionContext.a(gemName);
    }

    @NotNull
    private static String a(@NotNull String string) {
        long l2 = x ^ 0x698A48B7FA95L;
        if (string == null) {
            RubyGemExecutionContext.c(5);
        }
        if (StringUtil.isEmpty((String)string)) {
            throw new IllegalArgumentException("Gem name can not be empty");
        }
        String string2 = string;
        if (string2 == null) {
            RubyGemExecutionContext.c(6);
        }
        return string2;
    }

    @NotNull
    public String getGemName() {
        String string = this.t;
        if (string == null) {
            RubyGemExecutionContext.c(7);
        }
        return string;
    }

    @NotNull
    public String getGemScriptName() {
        String string = this.o != null ? this.o : this.t;
        if (string == null) {
            RubyGemExecutionContext.c(8);
        }
        return string;
    }

    @Nullable
    public String getGemVersion() {
        return this.r;
    }

    @NotNull
    public RubyGemExecutionContext withGemScriptName(@Nullable String gemScriptName) {
        this.o = gemScriptName;
        RubyGemExecutionContext rubyGemExecutionContext = this;
        if (rubyGemExecutionContext == null) {
            RubyGemExecutionContext.c(9);
        }
        return rubyGemExecutionContext;
    }

    @NotNull
    public RubyGemExecutionContext withGemVersion(@Nullable String gemVersion) {
        this.r = gemVersion;
        RubyGemExecutionContext rubyGemExecutionContext = this;
        if (rubyGemExecutionContext == null) {
            RubyGemExecutionContext.c(10);
        }
        return rubyGemExecutionContext;
    }

    @Nullable
    public String getScriptPath() {
        VirtualFile virtualFile;
        String string;
        String string22;
        String string3;
        Object object;
        Pair<String, String> pair;
        long l2 = x ^ 0x1B60B925EBFCL;
        Sdk sdk = this.getRubySdk();
        Module module2 = this.getModule();
        String string4 = this.getGemScriptName();
        String string5 = this.getGemName();
        String string6 = this.getGemVersion();
        v.debug("Discovering script path for ", new Object[]{this, "; sdk=", sdk, "; module=", module2});
        ArrayList<String> arrayList = new ArrayList<String>(4);
        ReadAction.run(() -> BundlerUtil.addBundlerBinPaths(module2, arrayList));
        v.debug("Bundler bin paths: ", new Object[]{arrayList});
        if (RVMSupportUtil.isRVMInterpreter(sdk)) {
            v.debug("Rvm sdk processing");
            pair = RVMSupportUtil.determineMainAndGlobalGemPaths(sdk);
            if (pair != null) {
                object = (String)pair.first;
                if (object != null) {
                    arrayList.add((String)object + "/bin");
                }
                if ((string3 = (String)pair.second) != null) {
                    arrayList.add(string3 + "/bin");
                }
            }
            v.debug("Rvm ends with ", new Object[]{arrayList});
        }
        pair = RubySdkUtil.getGemsBinFolderPath(sdk);
        arrayList.add((String)pair);
        v.debug("Added gem env bin folder: ", new Object[]{pair});
        object = RubyRunner.notNullFrom(sdk);
        string3 = RubySdkAdditionalData.getInterpreterDir(sdk);
        String string7 = object.addDefaultMappings(null).convertToLocal(string3);
        arrayList.add(string7);
        v.debug("Added interpreter dir ", new Object[]{string3, " as ", string7});
        for (String string22 : arrayList) {
            v.debug("Looking for ", new Object[]{string4, " in ", string22});
            string = GemUtil.findExecutableRubyScriptPath(string4, string22);
            if (string == null) continue;
            v.debug("Found ", new Object[]{string});
            return string;
        }
        v.debug("Not found in bin directories");
        Iterator iterator = module2 != null ? GemSearchUtil.findGemEx(module2, string5, string6) : null;
        iterator = iterator == null ? GemSearchUtil.findGem(module2, sdk, string5, string6) : iterator;
        v.debug("Target gem is: ", new Object[]{iterator});
        if (iterator == null || !((GemInfo)((Object)iterator)).isValid()) {
            v.debug("Null or invalid");
            return null;
        }
        string22 = ((GemInfo)((Object)iterator)).getFile();
        assert (string22 != null);
        v.debug("Gem dir is ", new Object[]{string22});
        string = string22.getParent().getParent().findChild(u);
        v.debug("Gem bin dir is ", new Object[]{string});
        String string8 = GemUtil.findScriptInBinDir(string4, (VirtualFile)string);
        if (string8 != null) {
            v.debug("Found ", new Object[]{string8});
            return string8;
        }
        if (SystemInfo.isMac && pair.startsWith(q)) {
            v.debug("Checking macOs bundler ruby");
            virtualFile = LocalFileSystem.getInstance().findFileByPath(s);
            String string9 = GemUtil.findScriptInBinDir(string4, virtualFile);
            if (string9 != null) {
                v.debug("Macos bundled ruby gems bin dir: ", new Object[]{string9});
                return string9;
            }
            v.debug("No bundled ruby gems bin dir");
        }
        if ((virtualFile = string22.findChild(u)) != null) {
            v.debug("Got bin dir inside gem itself: ", new Object[]{virtualFile});
            return GemUtil.findScriptInBinDir(string4, virtualFile);
        }
        v.debug("No bin directory in the gem itself");
        v.debug("Nothing found");
        return null;
    }

    @Nullable
    public String[] getScriptExecutionCommands() throws ExecutionException {
        long l2 = x ^ 0xC1D0CBCEBD0L;
        try {
            Sdk sdk = this.getRubySdk();
            RunnerUtil.validateSDK(sdk);
            String string = this.getScriptPath();
            if (string != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                RubyVersionManagerHandler rubyVersionManagerHandler = RubyVersionManagerHandler.notNullFrom(sdk);
                if (!ShimsBasedVersionManagerHandler.is(rubyVersionManagerHandler)) {
                    arrayList.add(RubySdkAdditionalData.getInterpreterPathFor(sdk));
                }
                PathMappingSettings pathMappingSettings = RubySdkAdditionalData.notNullFrom(sdk).getRunner(this.getModule()).addDefaultMappings(null);
                arrayList.add(pathMappingSettings.convertToRemote(rubyVersionManagerHandler.getAdjustedGemScriptPathForExecution(string)));
                return ArrayUtilRt.toStringArray(arrayList);
            }
            String string2 = RBundle.message("execution.error.no.executable.cmd.for.gem.name", this.getGemName(), this.getGemScriptName());
            throw new ExecutionException(string2);
        }
        catch (ExecutionException executionException) {
            RunnerUtil.showExecutionErrorDialog(executionException);
            return null;
        }
    }

    @Nullable
    public ProcessOutput executeScript() throws ExecutionException {
        RubyScriptExecutionContext rubyScriptExecutionContext;
        long l2 = x ^ 0x4E24BDBDA870L;
        if (this.hasModule() && !"bundler".equals(this.t)) {
            this.withCommandLinePreprocessor(BundlerUtil.getBundlerPreprocessor(this.getRubySdk(), this.getModule()));
        }
        return (rubyScriptExecutionContext = RubyScriptExecutionContext.create(this)) == null ? null : rubyScriptExecutionContext.executeScript();
    }

    public static RubyGemExecutionContext create(@NotNull Sdk sdk, @NotNull String gemName) {
        if (sdk == null) {
            RubyGemExecutionContext.c(11);
        }
        if (gemName == null) {
            RubyGemExecutionContext.c(12);
        }
        return new RubyGemExecutionContext(sdk, gemName);
    }

    public String toString() {
        long l2 = x ^ 0x19115D2BDA71L;
        return "RubyGemExecutionContext{myGemName='" + this.t + '\'' + ", myGemScriptName='" + this.o + '\'' + ", myGemVersion='" + this.r + '\'' + '}';
    }

    @Nullable
    public static String getScriptPath(@Nullable Sdk sdk, @Nullable Module module2, @NotNull String gemName) {
        if (gemName == null) {
            RubyGemExecutionContext.c(13);
        }
        return RubyGemExecutionContext.getScriptPath(sdk, module2, gemName, null);
    }

    @Nullable
    public static RubyGemExecutionContext tryCreate(@Nullable Sdk sdk, @Nullable Module module2, @NotNull String gemName) {
        long l2 = x ^ 0x597B2CA5238AL;
        if (gemName == null) {
            RubyGemExecutionContext.c(14);
        }
        if (module2 != null && GemSearchUtil.findGem(module2, gemName) != null) {
            v.debug("Found gem in module context ", new Object[]{gemName, " module ", module2});
            return (RubyGemExecutionContext)ReadAction.compute(() -> RubySdkUtil.isRubySDK(sdk) || RModuleUtil.getInstance().findRubySdkForModule(module2) != null ? new RubyGemExecutionContext(module2, gemName) : null);
        }
        if (sdk != null && GemSearchUtil.findGem(null, sdk, gemName) != null) {
            v.debug("Found gem in sdk context ", new Object[]{gemName, " sdk ", sdk});
            RubyGemExecutionContext rubyGemExecutionContext = new RubyGemExecutionContext(sdk, gemName);
            return module2 == null ? rubyGemExecutionContext : (RubyGemExecutionContext)rubyGemExecutionContext.withProject(module2.getProject());
        }
        v.debug("Could not find a ", new Object[]{gemName, " in the context of ", sdk, " and ", module2});
        return null;
    }

    private static boolean b(@NotNull String string) {
        block7: {
            VirtualFile virtualFile;
            long l2 = x ^ 0x1F3F3487FE5DL;
            if (string == null) {
                RubyGemExecutionContext.c(15);
            }
            if (SystemInfo.isUnix && (virtualFile = LocalFileSystem.getInstance().findFileByPath(string)) != null) {
                try {
                    String string2 = VfsUtilCore.loadText((VirtualFile)virtualFile);
                    String string3 = string2.substring(0, Math.min(300, string2.length()));
                    String[] stringArray = StringUtil.splitByLines((String)string3.trim());
                    if (stringArray.length <= 0) break block7;
                    for (String string4 : stringArray) {
                        if (StringUtil.isEmpty((String)string4)) continue;
                        if (string4.trim().startsWith(p)) {
                            for (String string5 : w) {
                                if (!string4.endsWith("/" + string5) && !string4.endsWith("/env " + string5)) continue;
                                return true;
                            }
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Nullable
    public static String getScriptPath(@Nullable Sdk sdk, @Nullable Module module2, @NotNull String gemName, @Nullable String gemScriptName) {
        long l2 = x ^ 0x28AC9EC6D8BAL;
        if (gemName == null) {
            RubyGemExecutionContext.c(16);
        }
        v.debug("Looking for a script: gemName=", new Object[]{gemName, "; gemScriptName=", gemScriptName, "; sdk=", sdk, "; module=", module2});
        RubyGemExecutionContext rubyGemExecutionContext = RubyGemExecutionContext.tryCreate(sdk, module2, gemName);
        v.debug("Created context: ", new Object[]{rubyGemExecutionContext});
        return rubyGemExecutionContext == null ? null : rubyGemExecutionContext.withGemScriptName(gemScriptName).getScriptPath();
    }

    @Override
    @NotNull
    protected RubyGemExecutionContext self() {
        RubyGemExecutionContext rubyGemExecutionContext = this;
        if (rubyGemExecutionContext == null) {
            RubyGemExecutionContext.c(17);
        }
        return rubyGemExecutionContext;
    }

    static {
        x = c.a(5130172312788168769L, 6319006060401851853L, MethodHandles.lookup().lookupClass()).a(205280893646975L);
        long l2 = x ^ 0x464F0CE344FL;
        v = Logger.getInstance(RubyGemExecutionContext.class);
        w = Arrays.asList("bash", "sh", "zsh");
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = x ^ 0x20B09F00C0CL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/RubyGemExecutionContext";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptPath";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/RubyGemExecutionContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "validateGemName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemScriptName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withGemScriptName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withGemVersion";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "self";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateGemName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 13: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getScriptPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryCreate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isBashScript";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

